/*
 * Decompiled with CFR 0.152.
 */
package processing.sound;

import com.jsyn.ports.UnitOutputPort;
import com.jsyn.unitgen.TwoInDualOut;
import com.jsyn.unitgen.UnitFilter;
import com.jsyn.unitgen.UnitGenerator;
import java.util.HashSet;
import java.util.Set;
import processing.core.PApplet;
import processing.sound.Engine;
import processing.sound.SoundObject;

public abstract class Effect<EffectType extends UnitFilter> {
    protected Set<SoundObject> inputs = new HashSet<SoundObject>();
    protected EffectType left;
    protected EffectType right;
    protected UnitOutputPort output;

    protected Effect(PApplet pApplet) {
        Engine.getEngine(pApplet);
        this.left = this.newInstance();
        this.right = this.newInstance();
        TwoInDualOut twoInDualOut = new TwoInDualOut();
        twoInDualOut.inputA.connect(((UnitFilter)this.left).output);
        twoInDualOut.inputB.connect(((UnitFilter)this.right).output);
        this.output = twoInDualOut.output;
    }

    protected abstract EffectType newInstance();

    public boolean isProcessing() {
        return !this.inputs.isEmpty();
    }

    public void process(SoundObject soundObject) {
        if (this.inputs.add(soundObject)) {
            soundObject.setEffect(this);
        } else {
            Engine.printWarning("the effect is already processing this sound source");
        }
    }

    public void stop() {
        if (this.inputs.isEmpty()) {
            Engine.printWarning("this effect is not currently processing any signals.");
        } else {
            for (SoundObject soundObject : this.inputs) {
                soundObject.removeEffect(this);
            }
            this.inputs.clear();
            Engine.getEngine().remove((UnitGenerator)this.left);
            Engine.getEngine().remove((UnitGenerator)this.right);
        }
    }
}

