/*
 * Decompiled with CFR 0.152.
 */
package processing.sound;

import android.media.AudioAttributes;
import android.media.AudioFormat;
import android.media.AudioTrack;
import com.jsyn.devices.AudioDeviceInputStream;
import com.jsyn.devices.AudioDeviceManager;
import com.jsyn.devices.AudioDeviceOutputStream;
import java.util.ArrayList;

class JSynAndroidAudioDeviceManager
implements AudioDeviceManager {
    ArrayList<DeviceInfo> deviceRecords = new ArrayList();
    private double suggestedOutputLatency = 0.1;
    private double suggestedInputLatency = 0.1;
    private int defaultInputDeviceID = 0;
    private int defaultOutputDeviceID = 0;

    public JSynAndroidAudioDeviceManager() {
        DeviceInfo deviceInfo = new DeviceInfo();
        deviceInfo.name = "Android Audio";
        deviceInfo.maxInputs = 0;
        deviceInfo.maxOutputs = 2;
        this.deviceRecords.add(deviceInfo);
    }

    public String getName() {
        return "JSyn Android Audio for Processing";
    }

    public AudioDeviceOutputStream createOutputStream(int n, int n2, int n3) {
        return new AndroidAudioOutputStream(n, n2, n3);
    }

    public AudioDeviceInputStream createInputStream(int n, int n2, int n3) {
        return new AndroidAudioInputStream(n, n2, n3);
    }

    public double getDefaultHighInputLatency(int n) {
        return 0.3;
    }

    public double getDefaultHighOutputLatency(int n) {
        return 0.3;
    }

    public int getDefaultInputDeviceID() {
        return this.defaultInputDeviceID;
    }

    public int getDefaultOutputDeviceID() {
        return this.defaultOutputDeviceID;
    }

    public double getDefaultLowInputLatency(int n) {
        return 0.1;
    }

    public double getDefaultLowOutputLatency(int n) {
        return 0.1;
    }

    public int getDeviceCount() {
        return this.deviceRecords.size();
    }

    public String getDeviceName(int n) {
        return this.deviceRecords.get((int)n).name;
    }

    public int getMaxInputChannels(int n) {
        return this.deviceRecords.get((int)n).maxInputs;
    }

    public int getMaxOutputChannels(int n) {
        return this.deviceRecords.get((int)n).maxOutputs;
    }

    public int setSuggestedOutputLatency(double d) {
        this.suggestedOutputLatency = d;
        return 0;
    }

    public int setSuggestedInputLatency(double d) {
        this.suggestedInputLatency = d;
        return 0;
    }

    private class AndroidAudioInputStream
    extends AndroidAudioStream
    implements AudioDeviceInputStream {
        public AndroidAudioInputStream(int n, int n2, int n3) {
            super(n, n2, n3);
        }

        public void start() {
        }

        public double read() {
            double[] dArray = new double[1];
            this.read(dArray, 0, 1);
            return dArray[0];
        }

        public int read(double[] dArray) {
            return this.read(dArray, 0, dArray.length);
        }

        public int read(double[] dArray, int n, int n2) {
            return 0;
        }

        public void stop() {
        }

        public int available() {
            return 0;
        }

        public void close() {
        }
    }

    private class AndroidAudioOutputStream
    extends AndroidAudioStream
    implements AudioDeviceOutputStream {
        public AndroidAudioOutputStream(int n, int n2, int n3) {
            super(n, n2, n3);
        }

        public void start() {
            this.minBufferSize = AudioTrack.getMinBufferSize((int)this.frameRate, (int)12, (int)2);
            this.bufferSize = 3 * (this.minBufferSize / 2) & 0xFFFFFFFC;
            this.audioTrack = new AudioTrack.Builder().setAudioAttributes(new AudioAttributes.Builder().setUsage(1).setContentType(2).build()).setAudioFormat(new AudioFormat.Builder().setChannelMask(12).setEncoding(2).setSampleRate(this.frameRate).build()).setBufferSizeInBytes(this.bufferSize).setTransferMode(1).build();
            this.audioTrack.play();
        }

        public void write(double d) {
            double[] dArray = new double[]{d};
            this.write(dArray, 0, 1);
        }

        public void write(double[] dArray) {
            this.write(dArray, 0, dArray.length);
        }

        public void write(double[] dArray, int n, int n2) {
            if (this.shortBuffer == null || this.shortBuffer.length < n2) {
                this.shortBuffer = new short[n2];
            }
            for (int i = 0; i < n2; ++i) {
                int n3 = (int)(32767.0 * dArray[i + n]);
                if (n3 > Short.MAX_VALUE) {
                    n3 = Short.MAX_VALUE;
                } else if (n3 < Short.MIN_VALUE) {
                    n3 = Short.MIN_VALUE;
                }
                this.shortBuffer[i] = (short)n3;
            }
            this.audioTrack.write(this.shortBuffer, 0, n2);
        }

        public void stop() {
            this.audioTrack.stop();
            this.audioTrack.release();
        }

        public void close() {
        }
    }

    private class AndroidAudioStream {
        short[] shortBuffer;
        int frameRate;
        int samplesPerFrame;
        AudioTrack audioTrack;
        int minBufferSize;
        int bufferSize;

        public AndroidAudioStream(int n, int n2, int n3) {
            this.frameRate = n2;
            this.samplesPerFrame = n3;
        }

        public double getLatency() {
            int n = this.bufferSize / this.samplesPerFrame;
            return (double)n / (double)this.frameRate;
        }
    }

    class DeviceInfo {
        String name;
        int maxInputs;
        int maxOutputs;

        DeviceInfo() {
        }

        public String toString() {
            return "AudioDevice: " + this.name + ", max in = " + this.maxInputs + ", max out = " + this.maxOutputs;
        }
    }
}

