/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.midi;

import com.jsyn.midi.MessageParser;
import com.jsyn.util.MultiChannelSynthesizer;

public class MidiSynthesizer
extends MessageParser {
    private MultiChannelSynthesizer multiSynth;

    public MidiSynthesizer(MultiChannelSynthesizer multiChannelSynthesizer) {
        this.multiSynth = multiChannelSynthesizer;
    }

    @Override
    public void controlChange(int n, int n2, int n3) {
        double d = (double)n3 * 0.007874015748031496;
        switch (n2) {
            case 1: {
                double d2 = 0.1 * d;
                System.out.println("vibratoDepth = " + d2);
                this.multiSynth.setVibratoDepth(n, d2);
                break;
            }
            case 74: {
                this.multiSynth.setTimbre(n, d);
                break;
            }
            case 7: {
                this.multiSynth.setVolume(n, d);
                break;
            }
            case 10: {
                this.multiSynth.setPan(n, d * 2.0 - 1.0);
            }
        }
    }

    @Override
    public void registeredParameter(int n, int n2, int n3) {
        switch (n2) {
            case 0: {
                int n4 = n3 >> 7;
                int n5 = n3 & 0x7F;
                double d = (double)n4 + (double)n5 * 0.01;
                this.multiSynth.setBendRange(n, d);
                break;
            }
        }
    }

    @Override
    public void programChange(int n, int n2) {
        this.multiSynth.programChange(n, n2);
    }

    @Override
    public void channelPressure(int n, int n2) {
        double d = (double)n2 * 0.007874015748031496;
        this.multiSynth.setPressure(n, d);
    }

    @Override
    public void noteOff(int n, int n2, int n3) {
        this.multiSynth.noteOff(n, n2, n3);
    }

    @Override
    public void noteOn(int n, int n2, int n3) {
        this.multiSynth.noteOn(n, n2, n3);
    }

    @Override
    public void pitchBend(int n, int n2) {
        double d = (double)(n2 - 8192) * 1.220703125E-4;
        this.multiSynth.setPitchBend(n, d);
    }

    public void onReceive(byte[] byArray, int n, int n2) {
        this.parse(byArray);
    }
}

