/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.data.SpectralWindow;
import com.jsyn.data.SpectralWindowFactory;
import com.jsyn.ports.UnitInputPort;
import com.jsyn.ports.UnitOutputPort;
import com.jsyn.ports.UnitSpectralInputPort;
import com.jsyn.ports.UnitSpectralOutputPort;
import com.jsyn.unitgen.Circuit;
import com.jsyn.unitgen.PassThrough;
import com.jsyn.unitgen.SpectralFFT;
import com.jsyn.unitgen.SpectralIFFT;
import com.jsyn.unitgen.UnitSink;
import com.jsyn.unitgen.UnitSource;

public class SpectralFilter
extends Circuit
implements UnitSink,
UnitSource {
    public UnitInputPort input;
    public UnitOutputPort output;
    private SpectralFFT[] ffts;
    private SpectralIFFT[] iffts;
    private PassThrough inlet = new PassThrough();
    private PassThrough sum;

    public SpectralFilter() {
        this(2, 9);
    }

    public SpectralFilter(int n, int n2) {
        this.add(this.inlet);
        this.sum = new PassThrough();
        this.add(this.sum);
        this.ffts = new SpectralFFT[n];
        this.iffts = new SpectralIFFT[n];
        int n3 = (1 << n2) / n;
        for (int i = 0; i < n; ++i) {
            this.ffts[i] = new SpectralFFT(n2);
            this.add(this.ffts[i]);
            this.inlet.output.connect(this.ffts[i].input);
            this.ffts[i].setOffset(i * n3);
            this.iffts[i] = new SpectralIFFT();
            this.add(this.iffts[i]);
            this.iffts[i].output.connect(this.sum.input);
        }
        this.setWindow(SpectralWindowFactory.getHammingWindow(n2));
        this.input = this.inlet.input;
        this.addPort(this.input);
        this.output = this.sum.output;
        this.addPort(this.output);
    }

    public SpectralWindow getWindow() {
        return this.ffts[0].getWindow();
    }

    public void setWindow(SpectralWindow spectralWindow) {
        for (int i = 0; i < this.ffts.length; ++i) {
            this.ffts[i].setWindow(spectralWindow);
            this.iffts[i].setWindow(spectralWindow);
        }
    }

    @Override
    public UnitOutputPort getOutput() {
        return this.output;
    }

    @Override
    public UnitInputPort getInput() {
        return this.input;
    }

    public UnitSpectralOutputPort getSpectralOutput(int n) {
        return this.ffts[n].output;
    }

    public UnitSpectralInputPort getSpectralInput(int n) {
        return this.iffts[n].input;
    }
}

