/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.util;

import com.jsyn.Synthesizer;
import com.jsyn.ports.UnitInputPort;
import com.jsyn.util.AudioStreamReader;
import com.jsyn.util.StreamingThread;
import com.jsyn.util.TransportListener;
import com.jsyn.util.TransportModel;
import com.jsyn.util.WaveFileWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public class WaveRecorder {
    private AudioStreamReader reader;
    private WaveFileWriter writer;
    private StreamingThread thread;
    private Synthesizer synth;
    private TransportModel transportModel = new TransportModel();
    private double maxRecordingTime;

    public WaveRecorder(Synthesizer synthesizer, File file) throws FileNotFoundException {
        this(synthesizer, file, 2, 16);
    }

    public WaveRecorder(Synthesizer synthesizer, File file, int n) throws FileNotFoundException {
        this(synthesizer, file, n, 16);
    }

    public WaveRecorder(Synthesizer synthesizer, File file, int n, int n2) throws FileNotFoundException {
        this.synth = synthesizer;
        this.reader = new AudioStreamReader(synthesizer, n);
        this.writer = new WaveFileWriter(file);
        this.writer.setFrameRate(synthesizer.getFrameRate());
        this.writer.setSamplesPerFrame(n);
        this.writer.setBitsPerSample(n2);
    }

    public UnitInputPort getInput() {
        return this.reader.getInput();
    }

    public void start() {
        this.stop();
        this.thread = new StreamingThread(this.reader, this.writer);
        this.thread.setTransportModel(this.transportModel);
        this.thread.setSamplesPerFrame(this.writer.getSamplesPerFrame());
        this.updateMaxRecordingTime();
        this.thread.start();
    }

    public void stop() {
        if (this.thread != null) {
            this.thread.requestStop();
            try {
                this.thread.join(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.thread = null;
        }
    }

    public void close() throws IOException {
        this.stop();
        if (this.writer != null) {
            this.writer.close();
            this.writer = null;
        }
        if (this.reader != null) {
            this.reader.close();
            for (int i = 0; i < this.reader.getInput().getNumParts(); ++i) {
                this.reader.getInput().disconnectAll(i);
            }
            this.reader = null;
        }
    }

    public void addTransportListener(TransportListener transportListener) {
        this.transportModel.addTransportListener(transportListener);
    }

    public void removeTransportListener(TransportListener transportListener) {
        this.transportModel.removeTransportListener(transportListener);
    }

    public void setMaxRecordingTime(double d) {
        this.maxRecordingTime = d;
        this.updateMaxRecordingTime();
    }

    private void updateMaxRecordingTime() {
        StreamingThread streamingThread = this.thread;
        if (streamingThread != null) {
            long l = (long)(this.maxRecordingTime * (double)this.synth.getFrameRate());
            streamingThread.setMaxFrames(l);
        }
    }
}

