/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.util.soundfile;

import com.jsyn.data.FloatSample;
import com.jsyn.data.SampleMarker;
import com.jsyn.util.soundfile.ChunkHandler;
import com.jsyn.util.soundfile.IFFParser;
import java.io.IOException;
import java.util.HashMap;

abstract class AudioFileParser
implements ChunkHandler {
    IFFParser parser;
    protected byte[] byteData;
    boolean ifLoadData = true;
    long dataPosition;
    protected int bitsPerSample;
    protected int bytesPerFrame;
    protected int bytesPerSample;
    protected HashMap<Integer, SampleMarker> cueMap = new HashMap();
    protected short samplesPerFrame;
    protected double frameRate;
    protected int numFrames;
    protected double originalPitch = 60.0;
    protected int sustainBegin = -1;
    protected int sustainEnd = -1;

    public long getDataPosition() {
        return this.dataPosition;
    }

    public synchronized long getNumBytesRead() {
        IFFParser iFFParser = this.parser;
        if (iFFParser != null) {
            return iFFParser.getOffset();
        }
        return 0L;
    }

    public synchronized long getFileSize() {
        IFFParser iFFParser = this.parser;
        if (iFFParser != null) {
            return iFFParser.getFileSize();
        }
        return 0L;
    }

    protected SampleMarker findOrCreateCuePoint(int n) {
        SampleMarker sampleMarker = this.cueMap.get(n);
        if (sampleMarker == null) {
            sampleMarker = new SampleMarker();
            this.cueMap.put(n, sampleMarker);
        }
        return sampleMarker;
    }

    public FloatSample load(IFFParser iFFParser) throws IOException {
        this.parser = iFFParser;
        iFFParser.parseAfterHead(this);
        return this.finish();
    }

    abstract FloatSample finish() throws IOException;

    FloatSample makeSample(float[] fArray) throws IOException {
        FloatSample floatSample = new FloatSample(fArray, (int)this.samplesPerFrame);
        floatSample.setChannelsPerFrame(this.samplesPerFrame);
        floatSample.setFrameRate(this.frameRate);
        floatSample.setPitch(this.originalPitch);
        if (this.sustainBegin >= 0) {
            floatSample.setSustainBegin(this.sustainBegin);
            floatSample.setSustainEnd(this.sustainEnd);
        }
        for (SampleMarker sampleMarker : this.cueMap.values()) {
            floatSample.addMarker(sampleMarker);
        }
        if (floatSample.getMarkerCount() >= 2) {
            floatSample.setSustainBegin(floatSample.getMarker((int)0).position);
            floatSample.setSustainEnd(floatSample.getMarker((int)1).position);
        }
        return floatSample;
    }

    protected String parseString(IFFParser iFFParser, int n) throws IOException {
        byte[] byArray = new byte[n];
        iFFParser.read(byArray);
        return new String(byArray);
    }
}

