/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.math;

public class FourierMath {
    private static final int MAX_SIZE_LOG_2 = 16;
    static BitReverseTable[] reverseTables = new BitReverseTable[16];
    static DoubleSineTable[] sineTables = new DoubleSineTable[16];
    static FloatSineTable[] floatSineTables = new FloatSineTable[16];

    private static double[] getDoubleSineTable(int n) {
        DoubleSineTable doubleSineTable = sineTables[n];
        if (doubleSineTable == null) {
            FourierMath.sineTables[n] = doubleSineTable = new DoubleSineTable(n);
        }
        return doubleSineTable.sineValues;
    }

    private static float[] getFloatSineTable(int n) {
        FloatSineTable floatSineTable = floatSineTables[n];
        if (floatSineTable == null) {
            FourierMath.floatSineTables[n] = floatSineTable = new FloatSineTable(n);
        }
        return floatSineTable.sineValues;
    }

    private static int[] getReverseTable(int n) {
        BitReverseTable bitReverseTable = reverseTables[n];
        if (bitReverseTable == null) {
            FourierMath.reverseTables[n] = bitReverseTable = new BitReverseTable(n);
        }
        return bitReverseTable.reversedBits;
    }

    public static void calculateMagnitudes(double[] dArray, double[] dArray2, double[] dArray3) {
        for (int i = 0; i < dArray3.length; ++i) {
            dArray3[i] = Math.sqrt(dArray[i] * dArray[i] + dArray2[i] * dArray2[i]);
        }
    }

    public static void calculateMagnitudes(float[] fArray, float[] fArray2, float[] fArray3) {
        for (int i = 0; i < fArray3.length; ++i) {
            fArray3[i] = (float)Math.sqrt(fArray[i] * fArray[i] + fArray2[i] * fArray2[i]);
        }
    }

    public static void transform(int n, int n2, double[] dArray, double[] dArray2) {
        int n3;
        int n4;
        double d = n > 0 ? 2.0 / (double)n2 : 0.5;
        int n5 = FourierMath.numBits(n2);
        int[] nArray = FourierMath.getReverseTable(n5);
        double[] dArray3 = FourierMath.getDoubleSineTable(n5);
        int n6 = n2 - 1;
        int n7 = n2 / 4;
        for (n4 = 0; n4 < n2; ++n4) {
            n3 = nArray[n4];
            if (n3 < n4) continue;
            double d2 = dArray[n3] * d;
            double d3 = dArray2[n3] * d;
            dArray[n3] = dArray[n4] * d;
            dArray2[n3] = dArray2[n4] * d;
            dArray[n4] = d2;
            dArray2[n4] = d3;
        }
        int n8 = n * n2;
        int n9 = 1;
        int n10 = 2 * n9;
        while (n9 < n2) {
            int n11 = 0;
            int n12 = n8 / (2 * n9);
            for (int i = 0; i < n9; ++i) {
                double d4 = dArray3[n11 + n7 & n6];
                double d5 = dArray3[n11];
                for (n4 = i; n4 < n2; n4 += n10) {
                    n3 = n4 + n9;
                    double d6 = d4 * dArray[n3] - d5 * dArray2[n3];
                    double d7 = d4 * dArray2[n3] + d5 * dArray[n3];
                    dArray[n3] = dArray[n4] - d6;
                    dArray2[n3] = dArray2[n4] - d7;
                    int n13 = n4;
                    dArray[n13] = dArray[n13] + d6;
                    int n14 = n4;
                    dArray2[n14] = dArray2[n14] + d7;
                }
                n11 = n11 + n12 & n6;
            }
            n9 = n10;
            n9 = n10;
            n10 = 2 * n9;
        }
    }

    public static void transform(int n, int n2, float[] fArray, float[] fArray2) {
        int n3;
        int n4;
        float f = n > 0 ? 2.0f / (float)n2 : 0.5f;
        int n5 = FourierMath.numBits(n2);
        int[] nArray = FourierMath.getReverseTable(n5);
        float[] fArray3 = FourierMath.getFloatSineTable(n5);
        int n6 = n2 - 1;
        int n7 = n2 / 4;
        for (n4 = 0; n4 < n2; ++n4) {
            n3 = nArray[n4];
            if (n3 < n4) continue;
            float f2 = fArray[n3] * f;
            float f3 = fArray2[n3] * f;
            fArray[n3] = fArray[n4] * f;
            fArray2[n3] = fArray2[n4] * f;
            fArray[n4] = f2;
            fArray2[n4] = f3;
        }
        int n8 = n * n2;
        int n9 = 1;
        int n10 = 2 * n9;
        while (n9 < n2) {
            int n11 = 0;
            int n12 = n8 / (2 * n9);
            for (int i = 0; i < n9; ++i) {
                float f4 = fArray3[n11 + n7 & n6];
                float f5 = fArray3[n11];
                for (n4 = i; n4 < n2; n4 += n10) {
                    n3 = n4 + n9;
                    float f6 = f4 * fArray[n3] - f5 * fArray2[n3];
                    float f7 = f4 * fArray2[n3] + f5 * fArray[n3];
                    fArray[n3] = fArray[n4] - f6;
                    fArray2[n3] = fArray2[n4] - f7;
                    int n13 = n4;
                    fArray[n13] = fArray[n13] + f6;
                    int n14 = n4;
                    fArray2[n14] = fArray2[n14] + f7;
                }
                n11 = n11 + n12 & n6;
            }
            n9 = n10;
            n9 = n10;
            n10 = 2 * n9;
        }
    }

    public static int numBits(int n) {
        assert ((n & n - 1) == 0);
        int n2 = -1;
        while (n > 0) {
            n >>= 1;
            ++n2;
        }
        return n2;
    }

    public static void fft(int n, double[] dArray, double[] dArray2) {
        FourierMath.transform(1, n, dArray, dArray2);
    }

    public static void ifft(int n, double[] dArray, double[] dArray2) {
        FourierMath.transform(-1, n, dArray, dArray2);
    }

    private static class BitReverseTable {
        int[] reversedBits;

        BitReverseTable(int n) {
            this.reversedBits = new int[1 << n];
            for (int i = 0; i < this.reversedBits.length; ++i) {
                this.reversedBits[i] = BitReverseTable.reverseBits(i, n);
            }
        }

        static int reverseBits(int n, int n2) {
            int n3 = 0;
            for (int i = 0; i < n2; ++i) {
                n3 = n3 << 1 | n & 1;
                n >>= 1;
            }
            return n3;
        }
    }

    private static class FloatSineTable {
        float[] sineValues;

        FloatSineTable(int n) {
            int n2 = 1 << n;
            this.sineValues = new float[1 << n];
            for (int i = 0; i < n2; ++i) {
                this.sineValues[i] = (float)Math.sin((double)i * Math.PI * 2.0 / (double)n2);
            }
        }
    }

    private static class DoubleSineTable {
        double[] sineValues;

        DoubleSineTable(int n) {
            int n2 = 1 << n;
            this.sineValues = new double[1 << n];
            for (int i = 0; i < n2; ++i) {
                this.sineValues[i] = Math.sin((double)i * Math.PI * 2.0 / (double)n2);
            }
        }
    }
}

