/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.acerola3d.a3;

import java.io.Serializable;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.ExponentialFog;
import javax.media.j3d.Fog;
import javax.media.j3d.LinearFog;
import javax.media.j3d.Node;
import javax.vecmath.Point3d;
import jp.sourceforge.acerola3d.a3.A3FogType;
import jp.sourceforge.acerola3d.a3.A3InitData;
import jp.sourceforge.acerola3d.a3.A3Object;
import jp.sourceforge.acerola3d.a3.A3UpdateData;

public class A3Fog
extends A3Object {
    static BoundingSphere bs = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
    Fog fog;

    public A3Fog() {
        super(new A3InitData("jp.sourceforge.acerola3d.a3.A3Fog"));
        A3InitData d = new A3InitData("jp.sourceforge.acerola3d.a3.A3Fog");
        d.set(new Serializable[]{A3FogType.EXPONENTIAL, Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f)});
        this.realConstructor(d);
    }

    public A3Fog(A3FogType t) {
        super(new A3InitData("jp.sourceforge.acerola3d.a3.A3Fog"));
        A3InitData d = new A3InitData("jp.sourceforge.acerola3d.a3.A3Fog");
        if (t == A3FogType.EXPONENTIAL) {
            d.set(new Serializable[]{t, Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f)});
        } else if (t == A3FogType.LINEAR) {
            d.set(new Serializable[]{t, Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Double.valueOf(0.0), Double.valueOf(100.0)});
        }
        this.realConstructor(d);
    }

    public A3Fog(A3InitData d) {
        super(d);
        this.realConstructor(d);
    }

    void realConstructor(A3InitData d) {
        A3FogType t = (A3FogType)((Object)d.get(0));
        if (t == A3FogType.EXPONENTIAL) {
            float r = d.getFloat(1);
            float g = d.getFloat(2);
            float b = d.getFloat(3);
            float dis = d.getFloat(4);
            this.fog = new ExponentialFog(r, g, b, dis);
            this.fog.setCapability(15);
            this.fog.setCapability(17);
        } else if (t == A3FogType.LINEAR) {
            float r = d.getFloat(1);
            float g = d.getFloat(2);
            float b = d.getFloat(3);
            double ft = d.getDouble(4);
            double bk = d.getDouble(5);
            this.fog = new LinearFog(r, g, b, ft, bk);
            this.fog.setCapability(15);
            this.fog.setCapability(17);
        }
        this.fog.setInfluencingBounds((Bounds)bs);
        this.setNode((Node)this.fog);
    }

    @Override
    public void update(A3UpdateData d) {
        super.update(d);
        float r = d.getFloat(0);
        float g = d.getFloat(1);
        float b = d.getFloat(2);
        this.fog.setColor(r, g, b);
        if (this.fog instanceof ExponentialFog) {
            float dis = d.getFloat(3);
            ((ExponentialFog)this.fog).setDensity(dis);
        } else if (this.fog instanceof LinearFog) {
            double ft = d.getDouble(3);
            double bk = d.getDouble(4);
            ((LinearFog)this.fog).setFrontDistance(ft);
            ((LinearFog)this.fog).setBackDistance(bk);
        }
    }

    public void setColor(float r, float g, float b) {
        this.fog.setColor(r, g, b);
    }

    public void setDensity(float d) {
        ((ExponentialFog)this.fog).setDensity(d);
    }

    public void setFrontDistance(double d) {
        ((LinearFog)this.fog).setFrontDistance(d);
    }

    public void setBackDistance(double d) {
        ((LinearFog)this.fog).setBackDistance(d);
    }
}

