/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.acerola3d.a3;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.JFrame;
import javax.vecmath.Point3d;
import javax.vecmath.Quat4d;
import javax.vecmath.Vector3d;
import jp.sourceforge.acerola3d.a3.A3CanvasInterface;
import jp.sourceforge.acerola3d.a3.A3Controller;
import jp.sourceforge.acerola3d.a3.A3Listener;
import jp.sourceforge.acerola3d.a3.A3Object;
import jp.sourceforge.acerola3d.a3.JA3Canvas;

public class JA3Window
extends JFrame {
    private static final long serialVersionUID = 1L;
    JA3Canvas canvas;

    public JA3Window(int w, int h) {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                JA3Window.this.dispose();
                System.exit(0);
            }
        });
        this.canvas = JA3Canvas.createJA3Canvas(w, h);
        this.getContentPane().add((Component)((Object)this.canvas));
        this.pack();
        this.setVisible(true);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                System.out.println("invokeLater");
                JA3Window.this.canvas.requestFocusInWindow();
            }
        });
    }

    public JA3Canvas getJA3Canvas() {
        return this.canvas;
    }

    public void add(A3Object a) {
        this.canvas.add(a);
    }

    public void del(A3Object a) {
        this.canvas.del(a);
    }

    public void delAll() {
        this.canvas.delAll();
    }

    public void setBackground(A3Object a) {
        this.canvas.setBackground(a);
    }

    public void delBackground() {
        this.canvas.delBackground();
    }

    public void setAvatar(A3Object a) {
        this.canvas.setAvatar(a);
    }

    public void addA3Listener(A3Listener l) {
        this.canvas.addA3Listener(l);
    }

    public void removeA3Listener(A3Listener l) {
        this.canvas.removeA3Listener(l);
    }

    public void setDefaultCameraLoc(double x, double y, double z) {
        this.canvas.setDefaultCameraLoc(x, y, z);
    }

    public void setDefaultCameraLoc(Vector3d loc) {
        this.canvas.setDefaultCameraLoc(loc);
    }

    public void setDefaultCameraQuat(double x, double y, double z, double w) {
        this.canvas.setDefaultCameraQuat(x, y, z, w);
    }

    public void setDefaultCameraQuat(Quat4d quat) {
        this.canvas.setDefaultCameraQuat(quat);
    }

    public void setDefaultCameraRot(double x, double y, double z) {
        this.canvas.setDefaultCameraRot(x, y, z);
    }

    public void setDefaultCameraRot(Vector3d rot) {
        this.canvas.setDefaultCameraRot(rot);
    }

    public void setDefaultCameraScale(double s) {
        this.canvas.setDefaultCameraScale(s);
    }

    public void resetCamera() {
        this.canvas.resetCamera();
    }

    public void setCameraLoc(double x, double y, double z) {
        this.canvas.setCameraLoc(x, y, z);
    }

    public void setCameraLoc(Vector3d loc) {
        this.canvas.setCameraLoc(loc);
    }

    public void setCameraLocImmediately(double x, double y, double z) {
        this.canvas.setCameraLocImmediately(x, y, z);
    }

    public void setCameraLocImmediately(Vector3d loc) {
        this.canvas.setCameraLocImmediately(loc);
    }

    public Vector3d getCameraLoc() {
        return this.canvas.getCameraLoc();
    }

    public void setCameraQuat(double x, double y, double z, double w) {
        this.canvas.setCameraQuat(x, y, z, w);
    }

    public void setCameraQuat(Quat4d quat) {
        this.canvas.setCameraQuat(quat);
    }

    public void setCameraQuatImmediately(double x, double y, double z, double w) {
        this.canvas.setCameraQuatImmediately(x, y, z, w);
    }

    public void setCameraQuatImmediately(Quat4d quat) {
        this.canvas.setCameraQuatImmediately(quat);
    }

    public Quat4d getCameraQuat() {
        return this.canvas.getCameraQuat();
    }

    public void setCameraRot(double x, double y, double z) {
        this.canvas.setCameraRot(x, y, z);
    }

    public void setCameraRot(Vector3d rot) {
        this.canvas.setCameraRot(rot);
    }

    public void setCameraRotImmediately(double x, double y, double z) {
        this.canvas.setCameraRotImmediately(x, y, z);
    }

    public void setCameraRotImmediately(Vector3d rot) {
        this.canvas.setCameraRotImmediately(rot);
    }

    public void setCameraScale(double s) {
        this.canvas.setCameraScale(s);
    }

    public void setCameraScaleImmediately(double s) {
        this.canvas.setCameraScaleImmediately(s);
    }

    public void setHeadLightEnable(boolean b) {
        this.canvas.setHeadLightEnable(b);
    }

    public void setNavigationMode(A3CanvasInterface.NaviMode m) {
        this.canvas.setNavigationMode(m);
    }

    public void setNavigationSpeed(double s) {
        this.canvas.setNavigationSpeed(s);
    }

    public double getNavigationSpeed() {
        return this.canvas.getNavigationSpeed();
    }

    public void setA3Controller(A3Controller c) {
        this.canvas.setA3Controller(c);
    }

    public Point3d canvasToVirtualCS(int x, int y) {
        return this.canvas.canvasToVirtualCS(x, y);
    }

    public Point3d canvasToVirtualCS(int x, int y, double dis) {
        return this.canvas.canvasToVirtualCS(x, y, dis);
    }

    public Point3d canvasToPhysicalCS(int x, int y) {
        return this.canvas.canvasToPhysicalCS(x, y);
    }

    public Point3d canvasToPhysicalCS(int x, int y, double dis) {
        return this.canvas.canvasToPhysicalCS(x, y, dis);
    }

    public Vector3d physicalCSToVirtualCS(Vector3d v) {
        return this.canvas.physicalCSToVirtualCS(v);
    }

    public Point virtualCSToCanvas(Point3d p) {
        return this.canvas.virtualCSToCanvas(p);
    }

    public Vector3d virtualCSToPhysicalCS(Vector3d v) {
        return this.canvas.virtualCSToPhysicalCS(v);
    }

    public Vector3d getCameraUnitVecX() {
        return this.canvas.getCameraUnitVecX();
    }

    public Vector3d getCameraUnitVecY() {
        return this.canvas.getCameraUnitVecY();
    }

    public Vector3d getCameraUnitVecZ() {
        return this.canvas.getCameraUnitVecZ();
    }

    public A3Object pickA3(int x, int y) {
        return this.canvas.pickA3(x, y);
    }

    public void saveImage(File file) throws IOException {
        this.canvas.saveImage(file);
    }
}

