import jp.sourceforge.acerola3d.a3.*;
import java.awt.event.*;

public class A3ControllerTest extends KeyAdapter {
    A3Window window;
    public A3ControllerTest() throws Exception {
        window = new A3Window(300,300);
        window.setCameraLocImmediately(0.0,0.0,5.0);
        Action3D a3_1 = Action3D.load("x-res:///axis.a3");
        window.add(a3_1);
        Action3D a3_2 = Action3D.load("x-res:///axis.a3");
        a3_2.setLoc(1.0,1.0,0.0);
        window.add(a3_2);
        window.addKeyListener(this);
        System.out.println("Press [n|w|e|f|d|s|c] key to change NaviMode.");
    }
    public void keyTyped(KeyEvent e) {
        System.out.println("'"+e.getKeyChar()+"' pressed.");
        if (e.getKeyChar()=='n')
            window.setNavigationMode(A3CanvasInterface.NaviMode.NONE);
        else if (e.getKeyChar()=='w')
            window.setNavigationMode(A3CanvasInterface.NaviMode.WALK);
        else if (e.getKeyChar()=='e')
            window.setNavigationMode(A3CanvasInterface.NaviMode.EXAMINE);
        else if (e.getKeyChar()=='f')
            window.setNavigationMode(A3CanvasInterface.NaviMode.FLY);
        else if (e.getKeyChar()=='d')
            window.setNavigationMode(A3CanvasInterface.NaviMode.EDIT);
        else if (e.getKeyChar()=='s')
            window.setNavigationMode(A3CanvasInterface.NaviMode.SIMPLE);
        else if (e.getKeyChar()=='c')
            window.setNavigationMode(A3CanvasInterface.NaviMode.CHASE);
    }
    public static void main(String args[]) throws Exception {
        new A3ControllerTest();
    }
}
