package jp.sourceforge.acerola3d.a3;

import java.util.*;
import javax.media.j3d.*;
import javax.vecmath.*;

class A3Behavior extends Behavior {
    static Vector3d vFront = new Vector3d(0.0,0.0,1.0);
    static Vector3d vTop = new Vector3d(0.0,1.0,0.0);
    static long elapsedTime = 100l;
    A3Object a3 = null;
    A3BranchGroup topGroup;
    TransformGroup transGroup;
    Transform3D t;
    A3VirtualUniverse universe = null;
    boolean isInterpolate = false;
    boolean autoDirectionControl = false;
    double nextS = 1.0;
    Quat4d nextQ = new Quat4d(0.0,0.0,0.0,1.0);
    Vector3d nextV = new Vector3d();
    double nowS = 1.0;
    Quat4d nowQ = new Quat4d(0.0,0.0,0.0,1.0);
    Vector3d nowV = new Vector3d();
    boolean needRecalc = true;
    
    A3Behavior(A3Object a) {
        a3 = a;
        topGroup = new A3BranchGroup();
        topGroup.setA3(a3);
        t = new Transform3D();
        transGroup = new TransformGroup(t);
        transGroup.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
        transGroup.addChild(this);
        topGroup.addChild(transGroup);
    }
    void setA3VirtualUniverse(A3VirtualUniverse u) {
        universe = u;
    }
    void setNode(Node n) {
        transGroup.addChild(n);
    }
    void init() {
        t.set(nowQ,nowV,nowS);
        transGroup.setTransform(t);
    }
    public void initialize() {
        WakeupOnElapsedTime w = new WakeupOnElapsedTime(elapsedTime);
        wakeupOn(w);
    }
    @SuppressWarnings("unchecked")
    public void processStimulus(Enumeration criteria) {
        if (universe==null) {
            WakeupOnElapsedTime w = new WakeupOnElapsedTime(elapsedTime);
            wakeupOn(w);
        } else {
            WakeupOnBehaviorPost w = null;
            w = new WakeupOnBehaviorPost(universe.getTimerBehavior(),1);
            wakeupOn(w);
        }

        if (needRecalc==false)
            return;
        nowS = nowS + 0.2*(nextS - nowS);
        if (autoDirectionControl) {
            autoQuatControl();
        } else {
            nowQ.normalize();
            nowQ.interpolate(nextQ,0.2);
            nowQ.normalize();
        }
        nowV.interpolate(nextV,0.2);
        t.set(nowQ,nowV,nowS);
        transGroup.setTransform(t);
        if (!isInterpolate) {
            needRecalc = false;
        }
    }
    void autoQuatControl() {
        // もうちょっと最適化できないかな
        Vector3d dv = new Vector3d(); 
        dv.sub(nextV,nowV);
        double ls = dv.lengthSquared();
        if (ls>0.001) {
            double d = dv.dot(vTop);
            Vector3d vTmp1 = new Vector3d(vTop);
            vTmp1.scale(d);
            Vector3d vTmp2 = new Vector3d(dv);
            vTmp2.sub(vTmp1);
            if (vTmp2.length()<0.00001) {
                vTmp1.cross(vFront,vTop);
                AxisAngle4d angle = new AxisAngle4d(vTmp1.x,vTmp1.y,vTmp1.z,Math.PI/2.0);
                nowQ.set(angle);
            } else {
                AxisAngle4d an = null;
                vTmp2.normalize();
                d = Math.acos(0.999999*vTmp2.dot(vFront));
                vTmp1.cross(vTmp2,vFront);
                if (vTmp1.lengthSquared()<0.0001) {
                    vTmp1.set(vTop);
                }
                an = new AxisAngle4d(vTmp1.x,vTmp1.y,vTmp1.z,-d);
                nowQ.set(an);
                
                dv.normalize();
                d = Math.acos(0.999999*dv.dot(vTmp2));
                vTmp1.cross(dv,vTmp2);
                if (vTmp1.lengthSquared()<0.0001) {
                    vTmp1.set(vFront);
                }
                an = new AxisAngle4d(vTmp1.x,vTmp1.y,vTmp1.z,-d);
                Quat4d qTmp = new Quat4d();
                qTmp.set(an);
                //nowQ.mul(qTmp);
                nowQ.mul(qTmp,nowQ);
            }
        }        
    }
    void setEnableBehavior(boolean b) {
        isInterpolate = b;
    }
    void setAutoDirectionControl(boolean b) {
        autoDirectionControl = b;
    }
    void move(Vector3d v, Quat4d q, double s) {
        if (isInterpolate) {
            nextS = s;
            nextV.set(v);
            nextQ.set(q);
            nextQ.normalize();
        } else {
            nowS = s;
            nowV.set(v);
            nowQ.set(q);
            nextS = s;
            nextV.set(v);
            nextQ.set(q);
        }
        needRecalc = true;
    }
    void moveImmediately(Vector3d v, Quat4d q, double s) {
        nowS = s;
        nowV.set(v);
        nowQ.set(q);
        nextS = s;
        nextV.set(v);
        nextQ.set(q);
        t.set(nowQ,nowV,nowS);
        transGroup.setTransform(t);
//        needRecalc = true;
    }
    void setLoc(Vector3d v) {
        if (isInterpolate) {
            nextV.set(v);
        } else {
            nowV.set(v);
            nextV.set(v);
        }
        needRecalc = true;
    }
    void setLocImmediately(Vector3d v) {
        nowV.set(v);
        nextV.set(v);
        t.set(nowQ,nowV,nowS);
        transGroup.setTransform(t);
//        needRecalc = true;
    }
    Vector3d getLoc() {
        return new Vector3d(nowV);
    }
    void setQuat(Quat4d q) {
        if (isInterpolate) {
            nextQ.set(q);
        } else {
            nowQ.set(q);
            nextQ.set(q);
        }
        needRecalc = true;
    }
    void setQuatImmediately(Quat4d q) {
        nowQ.set(q);
        nextQ.set(q);
        t.set(nowQ,nowV,nowS);
        transGroup.setTransform(t);
//        needRecalc = true;
    }
    Quat4d getQuat() {
        return new Quat4d(nowQ);
    }
    void setScale(double s) {
        if (isInterpolate) {
            nextS = s;
        } else {
            nowS = s;
            nextS = s;
        }
        needRecalc = true;
    }
    void setScaleImmediately(double s) {
        nowS = s;
        nextS = s;
        t.set(nowQ,nowV,nowS);
        transGroup.setTransform(t);
//        needRecalc = true;
    }
    double getScale() {
        return nowS;
    }
    double getSpeed() {
        if (isInterpolate) {
            Vector3d tmpV = new Vector3d();
            tmpV.sub(nextV,nowV);
            double d = tmpV.length();
            double t;
            if (universe!=null) {
                t = TimerBehavior.elapsedTime/1000.0;
            } else {
                t = elapsedTime/1000.0;
            }
            return d/t;
        } else {
            return 0.0;
        }
    }
}
