package jp.sourceforge.acerola3d.a3;

import javax.vecmath.*;

/**
 * A3CanvasやA3Windowなどに登録されたアバターを
 * 追跡するようにカメラを自動制御するコントローラです。
 * A3CanvasやA3WindowなどのsetA3Controllerメソッドで
 * 有効化します。
 */
public class ChaseController extends A3Controller implements Runnable {
    Thread t;
    volatile boolean stopRequest = false;
    Quat4d q;
    Vector3d v;
    double s;

    /**
     * アバタ後方5メートルから追跡するように
     * カメラを自動制御するコントローラを生成
     * します。
     */
    public ChaseController() {
        q = new Quat4d(0.0,1.0,0.0,0.0);
        v = new Vector3d(0.0,0.0,-5.0);
        s = 1.0;
    }
    /**
     * アバタを追跡するようにカメラを自動制御する
     * コントローラを生成します。引数はアバタの
     * 座標系をカメラの座標系へ写像するアフィン変換。
     * このコンストラクタは特定の回転を持つ変換を
     * 指定すると正常に動作しないことがあるので
     * Deprecatedとします。
     */
    @Deprecated
    public ChaseController(Matrix4d mc) {
        q = new Quat4d();
        v = new Vector3d();
        mc.get(q);
        mc.get(v);
        s = mc.getScale();
    }
    /**
     * アバタを追跡するようにカメラを自動制御する
     * コントローラを生成します。引数はアバタの
     * 座標系をカメラの座標系へ変換するための回転と
     * 平行移動と拡大率。
     */
    public ChaseController(Quat4d q,Vector3d v,double s) {
        this.q = new Quat4d(q);
        this.v = new Vector3d(v);
        this.s = s;
    }

    /**
     * 初期化処理をします。Acerola3Dパッケージの内部で
     * 使用されるメソッドなので直接呼び出さないで下さい。
     */
    public void init() {
        stopRequest = false;
        t = new Thread(this);
        t.start();
    }

    /**
     * 終了処理をします。Acerola3Dパッケージの内部で
     * 使用されるメソッドなので直接呼び出さないで下さい。
     */
    public void stop() {
        stopRequest = true;
    }

    /**
     * 処理をします。Acerola3Dパッケージの内部で
     * 使用されるメソッドなので直接呼び出さないで下さい。
     */
    public void run() {
        while (!stopRequest) {
            A3Object avatar = a3canvas.getAvatar();
            if (avatar==null) {
                try{Thread.sleep(100);}catch(Exception e){;}
                continue;
            }
            Quat4d aq = avatar.getQuat();
            Vector3d av = avatar.getLoc();
            double as = avatar.getScale();

            Quat4d cq = new Quat4d();
            cq.mul(aq,q);
            Matrix4d mTmp = new Matrix4d();
            //mTmp.setIdentity();
            mTmp.set(aq);
            Vector3d cv = new Vector3d();
            mTmp.transform(v,cv);
            cv.add(av);
            double cs = s*as;

            //a3canvas.setCameraLocImmediately(cv);
            //a3canvas.setCameraQuatImmediately(cq);
            //a3canvas.setCameraScaleImmediately(cs);
            a3canvas.setCameraLoc(cv);
            a3canvas.setCameraQuat(cq);
            a3canvas.setCameraScale(cs);
            try{Thread.sleep(100);}catch(Exception e){;}
        }
    }
}
