/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.acerola3d.a3;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import jp.sourceforge.acerola3d.a3.A3CanvasInterface;
import jp.sourceforge.acerola3d.a3.A3Object;
import jp.sourceforge.acerola3d.a3.Component2D;

class A3Balloon
implements Component2D {
    A3Object a3;
    String description = "none";
    double offsetX;
    double offsetY;
    double offsetZ;
    int width;
    int height;

    A3Balloon(String s, A3Object a3) {
        this.description = s;
        this.a3 = a3;
    }

    @Override
    public void paint(Graphics2D g, A3CanvasInterface canvas) {
        Vector3d v = this.a3.getLoc();
        Vector3d vv = new Vector3d(this.offsetX, this.offsetY, this.offsetZ);
        vv.scale(this.a3.getScale());
        Vector3d p3d = new Vector3d(v.x + vv.x, v.y + vv.y, v.z + vv.z);
        Point p = null;
        p = !this.a3.lockedA3 ? canvas.virtualCSToCanvas(new Point3d((Tuple3d)p3d)) : canvas.physicalCSToCanvas(new Point3d((Tuple3d)p3d));
        int i0 = this.description.length();
        int i1 = i0 / 10;
        int i2 = i0 % 10;
        String[] desc = new String[i1 + (i2 == 0 ? 0 : 1)];
        for (int i = 0; i < desc.length; ++i) {
            int j0 = i * 10;
            int j1 = i * 10 + 10;
            j1 = j1 > this.description.length() ? this.description.length() : j1;
            desc[i] = this.description.substring(j0, j1);
        }
        FontMetrics fm = g.getFontMetrics();
        this.width = fm.stringWidth("ww") * 10 + 60;
        this.height = fm.getHeight() * desc.length + 60;
        this.width = this.width < 50 ? 50 : this.width;
        this.height = this.height < 50 ? 50 : this.height;
        int[] x = new int[]{p.x + 0, p.x + 10, p.x + 10};
        int[] y = new int[]{p.y + 0, p.y + 5, p.y - 5};
        g.setColor(Color.white);
        g.fillPolygon(x, y, 3);
        g.fillRect(p.x + 10, p.y - this.height / 2 + 10, this.width - 60, this.height - 20);
        g.fillRect(p.x + 20, p.y - this.height / 2 + 0, this.width - 80, this.height);
        g.fillOval(p.x + 10, p.y - this.height / 2 + 0, 20, 20);
        g.fillOval(p.x + this.width - 70, p.y - this.height / 2 + 0, 20, 20);
        g.fillOval(p.x + 10, p.y + this.height / 2 - 20, 20, 20);
        g.fillOval(p.x + this.width - 70, p.y + this.height / 2 - 20, 20, 20);
        g.setColor(Color.black);
        for (int i = 0; i < desc.length; ++i) {
            g.drawString(desc[i], p.x + 30, p.y + i * fm.getHeight() - this.height / 2 + 20);
        }
    }

    public void setString(String s) {
        this.description = s;
    }

    public void setOffset(double x, double y, double z) {
        this.offsetX = x;
        this.offsetY = y;
        this.offsetZ = z;
    }
}

