/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.acerola3d.a3;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import jp.sourceforge.acerola3d.a3.A3CanvasInterface;
import jp.sourceforge.acerola3d.a3.A3Object;
import jp.sourceforge.acerola3d.a3.Component2D;

class A3Label
implements Component2D {
    A3Object a3;
    String label = "none";
    double offsetX;
    double offsetY;
    double offsetZ;
    int width = 0;
    int height = 0;

    A3Label(String s, A3Object a3) {
        this.label = s;
        this.a3 = a3;
    }

    @Override
    public void paint(Graphics2D g, A3CanvasInterface canvas) {
        Vector3d v = this.a3.getLoc();
        Vector3d vv = new Vector3d(this.offsetX, this.offsetY, this.offsetZ);
        vv.scale(this.a3.getScale());
        Vector3d p3d = new Vector3d(v.x + vv.x, v.y + vv.y, v.z + vv.z);
        Point p = null;
        p = !this.a3.lockedA3 ? canvas.virtualCSToCanvas(new Point3d((Tuple3d)p3d)) : canvas.physicalCSToCanvas(new Point3d((Tuple3d)p3d));
        if (this.width == 0 || this.height == 0) {
            FontMetrics fm = g.getFontMetrics();
            this.width = fm.stringWidth(this.label) + 4;
            this.height = fm.getHeight() + 2;
        }
        g.setColor(Color.WHITE);
        g.drawString(this.label, p.x - this.width / 2, p.y + this.height / 2);
    }

    public void setString(String s) {
        this.label = s;
    }

    public void setOffset(double x, double y, double z) {
        this.offsetX = x;
        this.offsetY = y;
        this.offsetZ = z;
    }
}

