/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.acerola3d.a3;

import com.sun.j3d.audioengines.javasound.JavaSoundMixer;
import java.awt.Point;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import javax.media.j3d.AudioDevice;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.Light;
import javax.media.j3d.Locale;
import javax.media.j3d.Node;
import javax.media.j3d.PhysicalBody;
import javax.media.j3d.PhysicalEnvironment;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.View;
import javax.media.j3d.ViewPlatform;
import javax.media.j3d.VirtualUniverse;
import javax.vecmath.Point3d;
import javax.vecmath.Quat4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import jp.sourceforge.acerola3d.a3.A3Canvas;
import jp.sourceforge.acerola3d.a3.A3CanvasInterface;
import jp.sourceforge.acerola3d.a3.A3Controller;
import jp.sourceforge.acerola3d.a3.A3Listener;
import jp.sourceforge.acerola3d.a3.A3Object;
import jp.sourceforge.acerola3d.a3.CameraBehavior;
import jp.sourceforge.acerola3d.a3.Component2D;
import jp.sourceforge.acerola3d.a3.JA3Canvas;
import jp.sourceforge.acerola3d.a3.PickingBehavior;
import jp.sourceforge.acerola3d.a3.Scene;
import jp.sourceforge.acerola3d.a3.TimerBehavior;
import org.jdesktop.j3d.audioengines.joal.JOALMixer;

class A3VirtualUniverse
extends VirtualUniverse {
    A3CanvasInterface canvas = null;
    Canvas3D canvas3d = null;
    Locale locale;
    View view;
    BranchGroup rootGroup;
    TransformGroup tGroup;
    Transform3D transform;
    BranchGroup vpGroup;
    ViewPlatform vp;
    HashMap<Integer, Scene> scenes = new HashMap();
    Scene scene;
    TimerBehavior timerBehavior;
    PickingBehavior pickingBehavior;
    CameraBehavior cameraBehavior;
    Light headLight;

    A3VirtualUniverse(A3CanvasInterface c) {
        this.canvas = c;
        if (this.canvas instanceof A3Canvas) {
            this.init((Canvas3D)c);
        } else if (this.canvas instanceof JA3Canvas) {
            this.init(((JA3Canvas)this.canvas).getOffscreenCanvas3D());
        }
    }

    void init(Canvas3D c3d) {
        this.canvas3d = c3d;
        this.locale = new Locale((VirtualUniverse)this);
        PhysicalBody body = new PhysicalBody();
        PhysicalEnvironment environment = new PhysicalEnvironment();
        this.view = new View();
        this.view.addCanvas3D(this.canvas3d);
        this.view.setPhysicalBody(body);
        this.view.setPhysicalEnvironment(environment);
        this.view.setFrontClipDistance(0.1);
        this.view.setBackClipDistance(100.0);
        this.view.setUserHeadToVworldEnable(true);
        this.vpGroup = new BranchGroup();
        this.tGroup = new TransformGroup();
        this.tGroup.setCapability(18);
        this.tGroup.setCapability(17);
        this.tGroup.setCapability(14);
        this.tGroup.setCapability(13);
        this.vpGroup.addChild((Node)this.tGroup);
        this.transform = new Transform3D();
        this.tGroup.setTransform(this.transform);
        this.timerBehavior = new TimerBehavior();
        BoundingSphere bs = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), Double.MAX_VALUE);
        this.timerBehavior.setSchedulingBounds((Bounds)bs);
        this.tGroup.addChild((Node)this.timerBehavior);
        this.vp = new ViewPlatform();
        this.tGroup.addChild((Node)this.vp);
        this.headLight = new DirectionalLight();
        this.headLight.setCapability(13);
        this.headLight.setInfluencingBounds((Bounds)new BoundingSphere(new Point3d(0.0, 0.0, 0.0), Double.MAX_VALUE));
        this.headLight.setEnable(true);
        this.tGroup.addChild((Node)this.headLight);
        this.view.attachViewPlatform(this.vp);
        this.pickingBehavior = new PickingBehavior(this, this.view, this.tGroup, this.locale);
        this.vpGroup.addChild((Node)this.pickingBehavior);
        BoundingSphere sb = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), Double.MAX_VALUE);
        this.pickingBehavior.setSchedulingBounds((Bounds)sb);
        this.cameraBehavior = new CameraBehavior(this);
        this.vpGroup.addChild((Node)this.cameraBehavior);
        this.cameraBehavior.setSchedulingBounds((Bounds)sb);
        this.rootGroup = new BranchGroup();
        this.rootGroup.setCapability(14);
        this.rootGroup.setCapability(13);
        this.rootGroup.addChild((Node)this.vpGroup);
        this.locale.addBranchGraph(this.rootGroup);
        JOALMixer mixer = null;
        String mixerClassName = System.getProperty("j3d.audiodevice");
        System.out.println(mixerClassName);
        if (mixerClassName != null) {
            try {
                Class<?> c = Class.forName(mixerClassName);
                Class<AudioDevice> mixerClass = c.asSubclass(AudioDevice.class);
                Constructor<AudioDevice> constructor = mixerClass.getConstructor(PhysicalEnvironment.class);
                mixer = constructor.newInstance(environment);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (mixer == null) {
            try {
                mixer = new JOALMixer(environment);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (mixer == null) {
            try {
                mixer = new JavaSoundMixer(environment);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (mixer == null) {
            System.out.println("null AudioDevice!");
        } else {
            System.out.println(mixer.getClass().getName());
            environment.setAudioDevice((AudioDevice)mixer);
            mixer.initialize();
        }
        this.scene = new Scene(this, 0);
        this.scenes.put(0, this.scene);
        this.scene.activate();
    }

    TimerBehavior getTimerBehavior() {
        return this.timerBehavior;
    }

    void prepareVirtualUniverse() {
    }

    public void add(A3Object a) {
        this.scene.add(a);
    }

    public void del(A3Object a) {
        this.scene.del(a);
    }

    public void delAll() {
        this.scene.delAll();
    }

    public void setBackground(A3Object a) {
        this.scene.setBackground(a);
    }

    public void delBackground() {
        this.scene.delBackground();
    }

    public void setAvatar(A3Object a) {
        this.scene.setAvatar(a);
    }

    public A3Object getAvatar() {
        return this.scene.getAvatar();
    }

    public void addA3Listener(A3Listener l) {
        this.pickingBehavior.addA3Listener(l);
    }

    public void removeA3Listener(A3Listener l) {
        this.pickingBehavior.removeA3Listener(l);
    }

    public void setDefaultCameraLoc(double x, double y, double z) {
        this.scene.setDefaultCameraLoc(x, y, z);
    }

    public void setDefaultCameraLoc(Vector3d loc) {
        this.scene.setDefaultCameraLoc(loc);
    }

    public void setDefaultCameraQuat(double x, double ay, double z, double w) {
        this.scene.setDefaultCameraQuat(x, ay, z, w);
    }

    public void setDefaultCameraQuat(Quat4d quat) {
        this.scene.setDefaultCameraQuat(quat);
    }

    public void setDefaultCameraRot(double x, double y, double z) {
        this.scene.setDefaultCameraRot(x, y, z);
    }

    public void setDefaultCameraRot(Vector3d rot) {
        this.scene.setDefaultCameraRot(rot);
    }

    public void setDefaultCameraScale(double s) {
        this.scene.setDefaultCameraScale(s);
    }

    public void resetCamera() {
        this.scene.resetCamera();
    }

    public void setCameraLoc(double x, double y, double z) {
        this.scene.setCameraLoc(x, y, z);
    }

    public void setCameraLoc(Vector3d loc) {
        this.scene.setCameraLoc(loc);
    }

    public void setCameraLocImmediately(double x, double y, double z) {
        this.scene.setCameraLocImmediately(x, y, z);
    }

    public void setCameraLocImmediately(Vector3d loc) {
        this.scene.setCameraLocImmediately(loc);
    }

    public Vector3d getCameraLoc() {
        return this.scene.getCameraLoc();
    }

    public void setCameraQuat(double x, double y, double z, double w) {
        this.scene.setCameraQuat(x, y, z, w);
    }

    public void setCameraQuat(Quat4d quat) {
        this.scene.setCameraQuat(quat);
    }

    public void setCameraQuatImmediately(double x, double y, double z, double w) {
        this.scene.setCameraQuatImmediately(x, y, z, w);
    }

    public void setCameraQuatImmediately(Quat4d quat) {
        this.scene.setCameraQuatImmediately(quat);
    }

    public Quat4d getCameraQuat() {
        return this.scene.getCameraQuat();
    }

    public void setCameraRot(double x, double y, double z) {
        this.scene.setCameraRot(x, y, z);
    }

    public void setCameraRot(Vector3d rot) {
        this.scene.setCameraRot(rot);
    }

    public void setCameraRotImmediately(double x, double y, double z) {
        this.scene.setCameraRotImmediately(x, y, z);
    }

    public void setCameraRotImmediately(Vector3d rot) {
        this.scene.setCameraRotImmediately(rot);
    }

    public void setCameraScale(double s) {
        this.scene.setCameraScale(s);
    }

    public void setCameraScaleImmediately(double s) {
        this.scene.setCameraScaleImmediately(s);
    }

    public double getCameraScale() {
        return this.scene.getCameraScale();
    }

    public void setHeadLightEnable(boolean b) {
        this.headLight.setEnable(b);
    }

    public void setNavigationMode(A3CanvasInterface.NaviMode m) {
        this.scene.setNavigationMode(m);
    }

    public void setNavigationSpeed(double s) {
        this.scene.setNavigationSpeed(s);
    }

    public double getNavigationSpeed() {
        return this.scene.getNavigationSpeed();
    }

    public void setA3Controller(A3Controller c) {
        this.scene.setA3Controller(c);
    }

    public Point3d canvasToVirtualCS(int x, int y) {
        return this.pickingBehavior.canvasToVirtualCS(x, y);
    }

    public Point3d canvasToVirtualCS(int x, int y, double dis) {
        return this.pickingBehavior.canvasToVirtualCS(x, y, dis);
    }

    public Point3d canvasToPhysicalCS(int x, int y) {
        return this.pickingBehavior.canvasToPhysicalCS(x, y);
    }

    public Point3d canvasToPhysicalCS(int x, int y, double dis) {
        return this.pickingBehavior.canvasToPhysicalCS(x, y, dis);
    }

    public Vector3d physicalCSToVirtualCS(Vector3d v) {
        Point3d p = this.pickingBehavior.physicalCSToVirtualCS(new Point3d((Tuple3d)v));
        return new Vector3d((Tuple3d)p);
    }

    public Point physicalCSToCanvas(Point3d p) {
        return this.pickingBehavior.physicalCSToCanvas(p);
    }

    public Point virtualCSToCanvas(Point3d p) {
        return this.pickingBehavior.virtualCSToCanvas(p);
    }

    public Vector3d virtualCSToPhysicalCS(Vector3d v) {
        Point3d p = this.pickingBehavior.virtualCSToPhysicalCS(new Point3d((Tuple3d)v));
        return new Vector3d((Tuple3d)p);
    }

    public Vector3d getCameraUnitVecX() {
        return this.physicalCSToVirtualCS(new Vector3d(1.0, 0.0, 0.0));
    }

    public Vector3d getCameraUnitVecY() {
        return this.physicalCSToVirtualCS(new Vector3d(0.0, 1.0, 0.0));
    }

    public Vector3d getCameraUnitVecZ() {
        return this.physicalCSToVirtualCS(new Vector3d(0.0, 0.0, 1.0));
    }

    public A3Object pickA3(int x, int y) {
        return this.pickingBehavior.pickA3(x, y);
    }

    public void prepareScene(int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            s = new Scene(this, scene);
            this.scenes.put(scene, s);
        }
    }

    public void changeActiveScene(int s) {
        Scene newScene = this.scenes.get(s);
        if (newScene == null) {
            throw new IllegalArgumentException();
        }
        this.scene.deactivate();
        this.scene = newScene;
        this.transform.set(this.scene.cameraNowQ, this.scene.cameraNowV, this.scene.cameraNowS);
        this.tGroup.setTransform(this.transform);
        this.scene.activate();
    }

    public void add(A3Object a, int s) {
        Scene tmpScene = this.scenes.get(s);
        if (tmpScene == null) {
            throw new IllegalArgumentException();
        }
        tmpScene.add(a);
    }

    public void del(A3Object a, int s) {
        Scene tmpScene = this.scenes.get(s);
        if (tmpScene == null) {
            throw new IllegalArgumentException();
        }
        tmpScene.del(a);
    }

    public void setDefaultCameraLoc(double x, double y, double z, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.setDefaultCameraLoc(x, y, z);
    }

    public void setDefaultCameraLoc(Vector3d loc, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.setDefaultCameraLoc(loc);
    }

    public void setDefaultCameraQuat(double x, double y, double z, double w, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.setDefaultCameraQuat(x, y, z, w);
    }

    public void setDefaultCameraQuat(Quat4d quat, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.setDefaultCameraQuat(quat);
    }

    public void setDefaultCameraRot(double x, double y, double z, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.setDefaultCameraRot(x, y, z);
    }

    public void setDefaultCameraRot(Vector3d rot, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.setDefaultCameraRot(rot);
    }

    public void setDefaultCameraScale(double s, int scene) {
        Scene sTmp = this.scenes.get(scene);
        if (sTmp == null) {
            throw new IllegalArgumentException();
        }
        sTmp.setDefaultCameraScale(s);
    }

    public void resetCamera(int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.resetCamera();
    }

    public void setCameraLoc(double x, double y, double z, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.setCameraLoc(x, y, z);
    }

    public void setCameraLoc(Vector3d loc, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.setCameraLoc(loc);
    }

    public void setCameraLocImmediately(double x, double y, double z, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.setCameraLocImmediately(x, y, z);
    }

    public void setCameraLocImmediately(Vector3d loc, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.setCameraLocImmediately(loc);
    }

    public Vector3d getCameraLoc(int scene) {
        Scene s = this.scenes.get(scene);
        if (s != null) {
            return s.getCameraLoc();
        }
        throw new IllegalArgumentException();
    }

    public void setCameraQuat(double x, double y, double z, double w, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.setCameraQuat(x, y, z, w);
    }

    public void setCameraQuat(Quat4d quat, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.setCameraQuat(quat);
    }

    public void setCameraQuatImmediately(double x, double y, double z, double w, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.setCameraQuatImmediately(x, y, z, w);
    }

    public void setCameraQuatImmediately(Quat4d quat, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.setCameraQuatImmediately(quat);
    }

    public Quat4d getCameraQuat(int scene) {
        Scene s = this.scenes.get(scene);
        if (s != null) {
            return s.getCameraQuat();
        }
        throw new IllegalArgumentException();
    }

    public void setCameraRot(double x, double y, double z, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.setCameraRot(x, y, z);
    }

    public void setCameraRot(Vector3d rot, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.setCameraRot(rot);
    }

    public void setCameraRotImmediately(double x, double y, double z, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.setCameraRotImmediately(x, y, z);
    }

    public void setCameraRotImmediately(Vector3d rot, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.setCameraRotImmediately(rot);
    }

    public void setCameraScale(double s, int scene) {
        Scene sTmp = this.scenes.get(scene);
        if (sTmp == null) {
            throw new IllegalArgumentException();
        }
        sTmp.setCameraScale(s);
    }

    public void setCameraScaleImmediately(double s, int scene) {
        Scene sTmp = this.scenes.get(scene);
        if (sTmp == null) {
            throw new IllegalArgumentException();
        }
        sTmp.setCameraScaleImmediately(s);
    }

    public double getCameraScale(int scene) {
        Scene s = this.scenes.get(scene);
        if (s != null) {
            return s.getCameraScale();
        }
        throw new IllegalArgumentException();
    }

    public void setNavigationMode(A3CanvasInterface.NaviMode m, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.setNavigationMode(m);
    }

    public void setNavigationSpeed(double s, int scene) {
        Scene sTmp = this.scenes.get(scene);
        if (sTmp == null) {
            throw new IllegalArgumentException();
        }
        sTmp.setNavigationSpeed(s);
    }

    public double getNavigationSpeed(int scene) {
        Scene s = this.scenes.get(scene);
        if (s != null) {
            return s.getNavigationSpeed();
        }
        throw new IllegalArgumentException();
    }

    public void setA3Controller(A3Controller c, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.setA3Controller(c);
    }

    public void setBackground(A3Object a, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.setBackground(a);
    }

    public void delBackground(int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.delBackground();
    }

    public void setAvatar(A3Object a, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.setAvatar(a);
    }

    public A3Object getAvatar(int scene) {
        Scene s = this.scenes.get(scene);
        if (s != null) {
            return s.getAvatar();
        }
        throw new IllegalArgumentException();
    }

    public void add(Component2D c) {
        this.scene.add(c);
    }

    public void del(Component2D c) {
        this.scene.del(c);
    }

    public void add(Component2D c, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.add(c);
    }

    public void del(Component2D c, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.del(c);
    }

    ArrayList<Component2D> getComponents2D() {
        return this.scene.getComponents2D();
    }

    void addLockedA3(A3Object a) {
        this.scene.addLockedA3(a);
    }

    void delLockedA3(A3Object a) {
        this.scene.delLockedA3(a);
    }

    void delAllLockedA3() {
        this.scene.delAllLockedA3();
    }

    void addLockedA3(A3Object a, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.addLockedA3(a);
    }

    void delLockedA3(A3Object a, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.delLockedA3(a);
    }

    void delAllLockedA3(int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.delAllLockedA3();
    }
}

