/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.acerola3d.a3;

import javax.vecmath.Matrix4d;
import javax.vecmath.Quat4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import jp.sourceforge.acerola3d.a3.A3Controller;
import jp.sourceforge.acerola3d.a3.A3Object;

public class ChaseController
extends A3Controller
implements Runnable {
    Thread t;
    volatile boolean stopRequest = false;
    Quat4d q;
    Vector3d v;
    double s;

    public ChaseController() {
        this.q = new Quat4d(0.0, 1.0, 0.0, 0.0);
        this.v = new Vector3d(0.0, 0.0, -5.0);
        this.s = 1.0;
    }

    @Deprecated
    public ChaseController(Matrix4d mc) {
        this.q = new Quat4d();
        this.v = new Vector3d();
        mc.get(this.q);
        mc.get(this.v);
        this.s = mc.getScale();
    }

    public ChaseController(Quat4d q, Vector3d v, double s) {
        this.q = new Quat4d(q);
        this.v = new Vector3d(v);
        this.s = s;
    }

    @Override
    public void init() {
        this.stopRequest = false;
        this.t = new Thread(this);
        this.t.start();
    }

    @Override
    public void stop() {
        this.stopRequest = true;
    }

    @Override
    public void run() {
        while (!this.stopRequest) {
            A3Object avatar = this.a3canvas.getAvatar();
            if (avatar == null) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception e) {}
                continue;
            }
            Quat4d aq = avatar.getQuat();
            Vector3d av = avatar.getLoc();
            double as = avatar.getScale();
            Quat4d cq = new Quat4d();
            cq.mul(aq, this.q);
            Matrix4d mTmp = new Matrix4d();
            mTmp.set(aq);
            Vector3d cv = new Vector3d();
            mTmp.transform(this.v, cv);
            cv.add((Tuple3d)av);
            double cs = this.s * as;
            this.a3canvas.setCameraLoc(cv);
            this.a3canvas.setCameraQuat(cq);
            this.a3canvas.setCameraScale(cs);
            try {
                Thread.sleep(100L);
            }
            catch (Exception e) {}
        }
    }
}

