package jp.sourceforge.acerola3d.a3;

import java.awt.Graphics2D;

/**
 * A3CanvasInterfaceに通常の2D描画の機能を追加するための
 * オブジェクトです。このクラスのpaint()メソッドを
 * 実装したオブジェクトをJA3WindowやA3Screenにaddすることで
 * 3D描画の上に2Dグラフィックを表示させることができます。
 */
public abstract class Component2D {
    protected double z = 0.0;
    /**
     * 描画のためのメソッドです。
     */
    public abstract void paint(Graphics2D g,A3CanvasInterface canvas);
    /**
     * ソート前にソートの順番を計算するための物理座標のZ値を計算するために
     * 呼び出されるメソッドです。
     */
    public void calPhysicalZ(A3CanvasInterface canvas) {
        ;
    }
}
