package jp.sourceforge.acerola3d.a3;

import java.util.*;
import javax.media.j3d.*;
import javax.vecmath.*;
import java.awt.*;
import java.awt.event.*;

class PickingBehavior extends Behavior {
    A3VirtualUniverse virtualUniverse;
    View view;
    TransformGroup vptg;
    Transform3D vpt = new Transform3D();
    javax.media.j3d.Locale locale;
    ArrayList<A3Listener> listeners;

    public PickingBehavior(A3VirtualUniverse vu,View v,TransformGroup tg,
                           javax.media.j3d.Locale l) {
        virtualUniverse = vu;
        view = v;
        vptg = tg;
        locale = l;
        listeners = new ArrayList<A3Listener>();
    }

    public void addA3Listener(A3Listener l) {
        synchronized (listeners) {
            if (!listeners.contains(l))
                listeners.add(l);
        }
    }
    public void removeA3Listener(A3Listener l) {
        synchronized (listeners) {
            listeners.remove(l);
        }
    }

    public void initialize() {
        WakeupOnAWTEvent w = new WakeupOnAWTEvent(MouseEvent.MOUSE_PRESSED);
        wakeupOn(w);
    }

    @SuppressWarnings("unchecked")
    public void processStimulus(Enumeration criteria) {
        while (criteria.hasMoreElements()) {
            WakeupCriterion w = (WakeupCriterion)criteria.nextElement();
//            WakeupOnAWTEvent w = (WakeupOnAWTEvent)
            if (w instanceof WakeupOnAWTEvent) {            
                AWTEvent e[] = ((WakeupOnAWTEvent)w).getAWTEvent();
                for (int i=0;i<e.length;i++) {
                    if (e[i].getID()==MouseEvent.MOUSE_PRESSED)
                        processMousePressed((MouseEvent)e[i]);
                    else if (e[i].getID()==MouseEvent.MOUSE_DRAGGED)
                        processMouseDragged((MouseEvent)e[i]);
                    else if (e[i].getID()==MouseEvent.MOUSE_RELEASED)
                        processMouseReleased((MouseEvent)e[i]);
                }
            } else if (w instanceof WakeupOnElapsedTime) {
                wakeupOnElapsedTime((WakeupOnElapsedTime)w);
            }
        }
    }

    int mouseX;
    int mouseY;
    A3Object currentA3;
    void processMousePressed(MouseEvent me) {
//        System.out.println("gaha:mousePressed");

        mouseX = me.getX();
        mouseY = me.getY();

        currentA3 = pickA3(me.getX(),me.getY());

        A3Event a3Event = new A3Event();
        a3Event.setMouseEvent(me);
        a3Event.setA3Object(currentA3);
        ArrayList<A3Listener> ls = null;
        synchronized (listeners) {
            ls = new ArrayList<A3Listener>(listeners);
        }
        for (A3Listener l : ls) {
            l.mousePressed(a3Event);
        }

        WakeupOnAWTEvent ws[] = new WakeupOnAWTEvent[2];
        ws[0] = new WakeupOnAWTEvent(MouseEvent.MOUSE_DRAGGED);
        ws[1] = new WakeupOnAWTEvent(MouseEvent.MOUSE_RELEASED);
        WakeupOr w = new WakeupOr(ws);
        wakeupOn(w);
    }

    void processMouseDragged(MouseEvent me) {
//        System.out.println("gaha:mouseDragged");

        A3Event a3Event = new A3Event();
        a3Event.setMouseEvent(me);
        a3Event.setA3Object(currentA3);
        ArrayList<A3Listener> ls = null;
        synchronized (listeners) {
            ls = new ArrayList<A3Listener>(listeners);
        }
        for (A3Listener l : ls) {
            l.mouseDragged(a3Event);
        }
        
        WakeupOnAWTEvent ws[] = new WakeupOnAWTEvent[2];
        ws[0] = new WakeupOnAWTEvent(MouseEvent.MOUSE_DRAGGED);
        ws[1] = new WakeupOnAWTEvent(MouseEvent.MOUSE_RELEASED);
        WakeupOr w = new WakeupOr(ws);
        wakeupOn(w);
    }
    void processMouseReleased(MouseEvent me) {
//        System.out.println("gaha:mouseReleased");


        A3Event a3Event = new A3Event();
        a3Event.setMouseEvent(me);
        a3Event.setA3Object(currentA3);            // 下とどっちがいいか？
        A3Object a3 = pickA3(me.getX(),me.getY()); //
//      a3Event.setA3Object(a3);                   // 上とどっちがいいか？
        ArrayList<A3Listener> ls = null;
        synchronized (listeners) {
            ls = new ArrayList<A3Listener>(listeners);
        }
        for (A3Listener l : ls) {
            l.mouseReleased(a3Event);
        }

        //int xx = me.getX()-mouseX;
        //int yy = me.getY()-mouseY;
        //if (xx*xx+yy*yy<18) {          // +
        //    processMouseClicked(me);   // | 下とどっちがいいか？
        //    return;                    // |
        //}                              // +
        if (a3 == currentA3) {         // +
            processMouseClicked(me);     // | 上とどっちがいいか？
            return;                    // |
        }                              // +

        WakeupOnAWTEvent w = new WakeupOnAWTEvent(MouseEvent.MOUSE_PRESSED);
        wakeupOn(w);
    }

    int doubleClickMaxTime = 400; // ダブルクリックと見なす最大時間(ms)
    long clickedTime;
    void processMouseClicked(MouseEvent me) {
        if (System.currentTimeMillis()-clickedTime < doubleClickMaxTime) {
            clickedTime = 0;
            processMouseDoubleClicked(me);
            return;
        }

        meTmp = me;
        clickedTime = System.currentTimeMillis();
        WakeupCriterion ws[] = new WakeupCriterion[2];
        ws[0] = new WakeupOnAWTEvent(MouseEvent.MOUSE_PRESSED);
        ws[1] = new WakeupOnElapsedTime(doubleClickMaxTime);
        WakeupOr w = new WakeupOr(ws);
        wakeupOn(w);
    }
    MouseEvent meTmp;
    void wakeupOnElapsedTime(WakeupOnElapsedTime w) {
        A3Event a3Event = new A3Event();
        a3Event.setA3Object(currentA3);
        a3Event.setMouseEvent(meTmp);
        ArrayList<A3Listener> ls = null;
        synchronized (listeners) {
            ls = new ArrayList<A3Listener>(listeners);
        }
        for (A3Listener l : ls) {
            l.mouseClicked(a3Event);
        }
        WakeupOnAWTEvent ww = new WakeupOnAWTEvent(MouseEvent.MOUSE_PRESSED);
        wakeupOn(ww);
    }
    void processMouseDoubleClicked(MouseEvent me) {
        A3Event a3Event = new A3Event();
        a3Event.setA3Object(currentA3);
        a3Event.setMouseEvent(me);
        ArrayList<A3Listener> ls = null;
        synchronized (listeners) {
            ls = new ArrayList<A3Listener>(listeners);
        }
        for (A3Listener l : ls) {
            l.mouseDoubleClicked(a3Event);
        }
        WakeupOnAWTEvent ww = new WakeupOnAWTEvent(MouseEvent.MOUSE_PRESSED);
        wakeupOn(ww);
    }

    // 座標計算とピッキング
    Point3d canvasToVirtualCS(int x,int y,double dis) {
        Point3d point = canvasToPhysicalCS(x,y,dis);
        physicalCSToVirtualCS(point);
        return point;
    }
    Point3d canvasToVirtualCS(int x,int y) {
        if (virtualUniverse.scene.avatar==null)
            return null;
        if (virtualUniverse.scene.cameraNowV==null)
            return null;
        Vector3d v1 = virtualUniverse.scene.avatar.getLoc();
        Vector3d v2 = virtualUniverse.scene.cameraNowV;
        Vector3d v = new Vector3d();
        v.sub(v1,v2);
        //return canvasToVirtualCS(x,y,v.length());
        Point3d p = virtualCSToPhysicalCS(new Point3d(v));
        return canvasToVirtualCS(x,y,p.z);
    }
    Point virtualCSToCanvas(Point3d p) {
        Point3d point = virtualCSToPhysicalCS(p);
        return physicalCSToCanvas(point);
    }

    Point3d canvasToPhysicalCS(int x,int y,double dis) {
        int dw = virtualUniverse.canvas3d.getWidth();
        int dh = virtualUniverse.canvas3d.getHeight();
        double ww = virtualUniverse.canvas3d.getPhysicalWidth();
        double hh = virtualUniverse.canvas3d.getPhysicalHeight();
        double tt = view.getFieldOfView();//スクリーンの左右の画角

        // dx,dy,dz:スクリーン上での座標(物理座標系で)
        double dx =  ((double)x)*ww/((double)dw)-ww/2.0;
        double dy = -((double)y)*hh/((double)dh)+hh/2.0;
        double dz = -ww/2.0/Math.tan(tt/2.0);

        double s = dis/(-dz);
        return new Point3d(s*dx,s*dy,s*dz);
    }
    Point3d canvasToPhysicalCS(int x,int y) {
        Vector3d v1 = virtualUniverse.scene.avatar.getLoc();
        Vector3d v2 = virtualUniverse.scene.cameraNowV;
        Vector3d v = new Vector3d();
        v.sub(v1,v2);
        //return canvasToPhysicalCS(x,y,v.length());
        Point3d p = virtualCSToPhysicalCS(new Point3d(v));
        return canvasToPhysicalCS(x,y,p.z);
    }
    Point physicalCSToCanvas(Point3d p) {
        int dw = virtualUniverse.canvas3d.getWidth();
        int dh = virtualUniverse.canvas3d.getHeight();
        double ww = virtualUniverse.canvas3d.getPhysicalWidth();
        //double ww = canvas.getWidth();
        double hh = virtualUniverse.canvas3d.getPhysicalHeight();
        //double hh = canvas.getHeight();

        double tt = view.getFieldOfView();
        tt = ww/2.0/Math.tan(tt/2.0); // 視点とスクリーンの距離
        double zz = -p.z;

        Point ret = new Point();
        ret.x = (int)( p.x*(dw/((double)ww))/(zz/tt))+dw/2;
        ret.y = (int)(-p.y*(dh/((double)hh))/(zz/tt))+dh/2;
        return ret;
    }

    Point3d physicalCSToVirtualCS(Point3d p) {
        vptg.getTransform(vpt);
        vpt.transform(p);
        return p;
    }
    /* Vector3dで計算させると期待どうりにならないことが判明
    Vector3d physicalCSToVirtualCS(Vector3d v) {
        vptg.getTransform(vpt);
        vpt.transform(v);
        return v;
    }*/
    Point3d virtualCSToPhysicalCS(Point3d p) {
        vptg.getTransform(vpt);
        vpt.invert();
        vpt.transform(p);
        return p;
    }
    /* Vector3dで計算させると期待どうりにならないことが判明
    Vector3d virtualCSToPhysicalCS(Vector3d v) {
        vptg.getTransform(vpt);
        vpt.invert();
        vpt.transform(v);
        return v;
    }*/

    A3Object pickA3(int x,int y) {
        Vector3d v = new Vector3d(canvasToVirtualCS(x,y,1.0));
        Point3d p = new Point3d(virtualUniverse.scene.cameraNowV);
        v.sub(p);
        PickRay pr = new PickRay(p,v);
        //SceneGraphPath sgp = locale.pickClosest(pr);
        SceneGraphPath sgp[] = locale.pickAllSorted(pr);

        if (sgp==null) {
            return null;
        }

        for (int i=0;i<sgp.length;i++) {
            for (int j=0;j<sgp[i].nodeCount();j++) {
                Node n = sgp[i].getNode(j);
                if (n instanceof A3BranchGroup) {
                    A3BranchGroup ebn = (A3BranchGroup)n;
                    if (ebn.getA3()!=virtualUniverse.scene.background)
                        if (ebn.getA3().pickable==true)
                            return ebn.getA3();
                }
            }
        }

        return null;
    }
}
