import jp.sourceforge.acerola3d.a3.*;
import jp.sourceforge.acerola3d.A23;
import java.awt.event.*;
import javax.vecmath.*;

//Z軸が上になる座標系に設定している場合でも大丈夫かのテスト
public class ChaseControllerTest4 implements Runnable, KeyListener {
    Action3D avatar;
    double theta; //アバタのZ軸周りの回転
    volatile int keyCode;
    public ChaseControllerTest4() throws Exception {
        A23.setDefaultUpperDirection(A3Object.UpperDirection.Z);//**ポイント**
        A3Window w = new A3Window(300,300);
        w.getA3Canvas().addKeyListener(this);
        Action3D a3 = Action3D.load("x-res:///axis.a3");
        w.add(a3);
        avatar = Action3D.load("x-res:///vesma9.a3");
        w.setAvatar(avatar);
        w.add(avatar);
        //Quat4d q = new Quat4d(0.0,-0.5,-0.866,0.0);
        //Vector3d v = new Vector3d(0.0,5.2,3.0);
        //ChaseController c = new ChaseController(q,v,1.0);
        Vector3d lookAt = new Vector3d(0.0,0.0,0.0);
        Vector3d camera = new Vector3d(0.0,5.2,3.0);
        Vector3d up = new Vector3d(0.0,0.0,1.0);
        ChaseController c = new ChaseController(lookAt,camera,up,1.0);
        w.setA3Controller(c);
        Thread t = new Thread(this);
        t.start();
    }
    public void run() {
        while (true) {
            if (keyCode==KeyEvent.VK_UP) {
                Vector3d dv = new Vector3d(-Math.sin(-theta),-Math.cos(-theta),0.0);
                dv.add(avatar.getLoc());
                avatar.setLoc(dv);
            } else if (keyCode==KeyEvent.VK_DOWN) {
                Vector3d dv = new Vector3d(Math.sin(-theta),Math.cos(-theta),0.0);
                dv.add(avatar.getLoc());
                avatar.setLoc(dv);
            } else if (keyCode==KeyEvent.VK_RIGHT) {
                theta = theta - 0.1;
                avatar.setRot(0.0,0.0,theta);
            } else if (keyCode==KeyEvent.VK_LEFT) {
                theta = theta + 0.1;
                avatar.setRot(0.0,0.0,theta);
            }
            try{Thread.sleep(100);}catch(Exception e){;}
        }
    }
    public void keyTyped(KeyEvent e) {;}
    public void keyPressed(KeyEvent e) {keyCode = e.getKeyCode();}
    public void keyReleased(KeyEvent e) {keyCode=0;}
    public static void main(String args[]) throws Exception {
        new ChaseControllerTest4();
    }
}
