import jp.sourceforge.acerola3d.a3.*;

import java.awt.event.*;

public class NaviSpeed extends KeyAdapter {
    A3Window window;
    public NaviSpeed() throws Exception {
        window = new A3Window(300,300);
        window.addKeyListener(this);
        window.setCameraLocImmediately(0.0,0.0,3.0);
        Action3D a3 = new Action3D("x-res:///measure.a3");
        a3.setRot(1.0,0.0,0.0);
        window.add(a3);
        System.out.println("Press [n|w|e|f|d|s|c] key to change NaviMode.");
        System.out.println("Press [1|2|3] key to change NaviSpeed.");
        System.out.println("NaviSpeed 1: 0.1m/s");
        System.out.println("NaviSpeed 2: 1m/s");
        System.out.println("NaviSpeed 3: 10m/s");
    }
    public void keyTyped(KeyEvent e) {
        System.out.println("'"+e.getKeyChar()+"' pressed.");
        if (e.getKeyChar()=='n')
            window.setNavigationMode(A3CanvasInterface.NaviMode.NONE);
        else if (e.getKeyChar()=='w')
            window.setNavigationMode(A3CanvasInterface.NaviMode.WALK);
        else if (e.getKeyChar()=='e')
            window.setNavigationMode(A3CanvasInterface.NaviMode.EXAMINE);
        else if (e.getKeyChar()=='f')
            window.setNavigationMode(A3CanvasInterface.NaviMode.FLY);
        else if (e.getKeyChar()=='d')
            window.setNavigationMode(A3CanvasInterface.NaviMode.EDIT);
        else if (e.getKeyChar()=='s')
            window.setNavigationMode(A3CanvasInterface.NaviMode.SIMPLE);
        else if (e.getKeyChar()=='c')
            window.setNavigationMode(A3CanvasInterface.NaviMode.CHASE);
        else if (e.getKeyChar()=='1')
            window.setNavigationSpeed(0.1);
        else if (e.getKeyChar()=='2')
            window.setNavigationSpeed(1.0);
        else if (e.getKeyChar()=='3')
            window.setNavigationSpeed(10.0);
    }
    public static void main(String args[]) throws Exception {
        new NaviSpeed();
    }
}
