package jp.sourceforge.acerola3d.a3;

import javax.vecmath.*;

/**
 * A3CanvasやA3Windowなどに登録されたアバターを
 * 追跡するようにカメラを自動制御するコントローラです。
 * A3CanvasやA3WindowなどのsetA3Controllerメソッドで
 * 有効化します。
 */
public class ChaseController extends A3Controller implements Runnable {
    Thread t;
    volatile boolean stopRequest = false;
    Quat4d q;
    Vector3d v;
    double s;

    /**
     * アバタ後方5メートルから追跡するように
     * カメラを自動制御するコントローラを生成
     * します。A23.setDefaultUpperDirection()などで
     * Z軸が上になる座標系に設定している場合は正常に機能しない
     * ので他のコンストラクタを使って下さい。
     */
    public ChaseController() {
        q = new Quat4d(0.0,1.0,0.0,0.0);
        v = new Vector3d(0.0,0.0,-5.0);
        s = 1.0;
    }
    /**
     * アバタを追跡するようにカメラを自動制御する
     * コントローラを生成します。引数はアバタの
     * 座標系をカメラの座標系へ写像するアフィン変換。
     * このコンストラクタは特定の回転を持つ変換を
     * 指定すると正常に動作しないことがあるので
     * Deprecatedとします。
     */
    @Deprecated
    public ChaseController(Matrix4d mc) {
        q = new Quat4d();
        v = new Vector3d();
        mc.get(q);
        mc.get(v);
        s = mc.getScale();
    }
    /**
     * アバタを追跡するようにカメラを自動制御する
     * コントローラを生成します。引数はアバタの
     * 座標系をカメラの座標系へ変換するための回転と
     * 平行移動と拡大率。
     */
    public ChaseController(Quat4d q,Vector3d v,double s) {
        this.q = new Quat4d(q);
        this.v = new Vector3d(v);
        this.s = s;
    }

    /**
     * アバタを追跡するようにカメラを自動制御する
     * コントローラを生成します。引数は、アバタを原点とする座標系で、
     * 注視点とカメラの位置と上方向ベクトルと拡大率。
     */
    public ChaseController(Vector3d lookAt,Vector3d camera,Vector3d up,double s) {
        Vector3d upperVector = new Vector3d(up);
        upperVector.normalize();
        Vector3d front = new Vector3d();
        front.sub(lookAt,camera);
        front.normalize();
        //特定のカメラの向きでm.get(quat)が
        //うまくいかない。なんでなのかわからない。
        //なので、強引だけど以下のif文を入れて対応。
        if (Math.abs(front.x)<0.0001) {
            front.x = 0.0001;
            front.normalize();
        }
        double d = front.dot(upperVector);
        Vector3d vTmp = new Vector3d(front);
        vTmp.scale(d);
        Vector3d top = new Vector3d(upperVector);
        top.sub(vTmp);
        top.normalize();
        Vector3d right = new Vector3d();
        right.cross(front,top);
        Matrix4d m = new Matrix4d();
        m.m00 = right.x; m.m01 = top.x; m.m02 = -front.x;
        m.m10 = right.y; m.m11 = top.y; m.m12 = -front.y;
        m.m20 = right.z; m.m21 = top.z; m.m22 = -front.z;
        Quat4d quat = new Quat4d();
        m.get(quat);
        System.out.println(quat);
        System.out.println(front);
        this.q = quat;
        this.v = new Vector3d(camera);
        this.s = s;
    }

    /**
     * 初期化処理をします。Acerola3Dパッケージの内部で
     * 使用されるメソッドなので直接呼び出さないで下さい。
     */
    public void init() {
        stopRequest = false;
        t = new Thread(this);
        t.start();
    }

    /**
     * 終了処理をします。Acerola3Dパッケージの内部で
     * 使用されるメソッドなので直接呼び出さないで下さい。
     */
    public void stop() {
        stopRequest = true;
    }

    /**
     * 処理をします。Acerola3Dパッケージの内部で
     * 使用されるメソッドなので直接呼び出さないで下さい。
     */
    public void run() {
        while (!stopRequest) {
            A3Object avatar = a3canvas.getAvatar();
            if (avatar==null) {
                try{Thread.sleep(100);}catch(Exception e){;}
                continue;
            }
            Quat4d aq = avatar.getQuat();
            Vector3d av = avatar.getLoc();
            double as = avatar.getScale();

            Quat4d cq = new Quat4d();
            cq.mul(aq,q);
            Matrix4d mTmp = new Matrix4d();
            //mTmp.setIdentity();
            mTmp.set(aq);
            Vector3d cv = new Vector3d();
            mTmp.transform(v,cv);
            cv.add(av);
            double cs = s*as;

            //a3canvas.setCameraLocImmediately(cv);
            //a3canvas.setCameraQuatImmediately(cq);
            //a3canvas.setCameraScaleImmediately(cs);
            a3canvas.setCameraLoc(cv);
            a3canvas.setCameraQuat(cq);
            a3canvas.setCameraScale(cs);
            try{Thread.sleep(100);}catch(Exception e){;}
        }
    }
}
