/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.acerola3d.a3;

import java.util.Enumeration;
import javax.media.j3d.Behavior;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupOnBehaviorPost;
import javax.media.j3d.WakeupOnElapsedTime;
import javax.vecmath.Matrix4d;
import javax.vecmath.Quat4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple4d;
import javax.vecmath.Vector3d;
import jp.sourceforge.acerola3d.a3.A3BranchGroup;
import jp.sourceforge.acerola3d.a3.A3Object;
import jp.sourceforge.acerola3d.a3.A3VirtualUniverse;
import jp.sourceforge.acerola3d.a3.TimerBehavior;

class A3Behavior
extends Behavior {
    static long elapsedTime = 100L;
    A3Object a3 = null;
    A3BranchGroup topGroup;
    TransformGroup transGroup;
    Transform3D t;
    A3VirtualUniverse universe = null;
    boolean isInterpolate = false;
    boolean autoDirectionControl = false;
    double nextS = 1.0;
    Quat4d nextQ = new Quat4d(0.0, 0.0, 0.0, 1.0);
    Vector3d nextV = new Vector3d();
    double nowS = 1.0;
    Quat4d nowQ = new Quat4d(0.0, 0.0, 0.0, 1.0);
    Vector3d nowV = new Vector3d();
    boolean needRecalc = true;
    Vector3d nowTrans = new Vector3d();
    Quat4d tmpQ = new Quat4d();
    static Quat4d tmpQQ = new Quat4d(1.0 * Math.sin(0.7853981633974483), 0.0, 0.0, Math.cos(0.7853981633974483));

    A3Behavior(A3Object a) {
        this.a3 = a;
        this.topGroup = new A3BranchGroup();
        this.topGroup.setA3(this.a3);
        this.t = new Transform3D();
        this.transGroup = new TransformGroup(this.t);
        this.transGroup.setCapability(18);
        this.transGroup.addChild((Node)this);
        this.topGroup.addChild((Node)this.transGroup);
    }

    void setA3VirtualUniverse(A3VirtualUniverse u) {
        this.universe = u;
    }

    void setNode(Node n) {
        this.transGroup.addChild(n);
    }

    void init() {
        if (this.universe != null) {
            if (this.universe.scene.upperDirection == A3Object.UpperDirection.Z) {
                this.tmpQ.mul(this.nowQ, tmpQQ);
            } else {
                this.tmpQ.set((Tuple4d)this.nowQ);
            }
        } else {
            this.tmpQ.set((Tuple4d)this.nowQ);
        }
        this.t.set(this.tmpQ, this.nowV, this.nowS);
        this.transGroup.setTransform(this.t);
    }

    public void initialize() {
        WakeupOnElapsedTime w = new WakeupOnElapsedTime(elapsedTime);
        this.wakeupOn((WakeupCondition)w);
    }

    public void processStimulus(Enumeration criteria) {
        if (this.universe == null) {
            WakeupOnElapsedTime w = new WakeupOnElapsedTime(elapsedTime);
            this.wakeupOn((WakeupCondition)w);
        } else {
            WakeupOnBehaviorPost w = null;
            w = new WakeupOnBehaviorPost((Behavior)this.universe.getTimerBehavior(), 1);
            this.wakeupOn((WakeupCondition)w);
        }
        if (!this.needRecalc) {
            return;
        }
        this.nowTrans.sub((Tuple3d)this.nextV, (Tuple3d)this.nowV);
        this.nowTrans.scale(0.2);
        this.nowV.add((Tuple3d)this.nowTrans);
        if (this.autoDirectionControl) {
            this.autoQuatControl();
        } else {
            this.nowQ.normalize();
            this.nowQ.interpolate(this.nextQ, 0.2);
            this.nowQ.normalize();
        }
        this.nowS += 0.2 * (this.nextS - this.nowS);
        if (this.universe != null) {
            if (this.universe.scene.upperDirection == A3Object.UpperDirection.Z) {
                this.tmpQ.mul(this.nowQ, tmpQQ);
            } else {
                this.tmpQ.set((Tuple4d)this.nowQ);
            }
        } else {
            this.tmpQ.set((Tuple4d)this.nowQ);
        }
        this.t.set(this.tmpQ, this.nowV, this.nowS);
        this.transGroup.setTransform(this.t);
        if (!this.isInterpolate) {
            this.needRecalc = false;
        }
    }

    void autoQuatControl() {
        if (this.universe != null && this.universe.scene.upperDirection == A3Object.UpperDirection.Z) {
            this.autoQuatControlZ();
            return;
        }
        this.autoQuatControlY();
    }

    void autoQuatControlY() {
        Vector3d dv = new Vector3d();
        dv.sub((Tuple3d)this.nextV, (Tuple3d)this.nowV);
        if (dv.length() > this.universe.scene.cameraNowS / 1000.0) {
            Vector3d upperVector = new Vector3d(this.a3.upperVector);
            upperVector.normalize();
            Vector3d newFront = new Vector3d(dv);
            newFront.normalize();
            if (Math.abs(newFront.x) < 1.0E-4 && newFront.z < 0.0) {
                newFront.x = 1.0E-4;
                newFront.normalize();
            }
            double d = newFront.dot(upperVector);
            Vector3d vTmp = new Vector3d(newFront);
            vTmp.scale(d);
            Vector3d newTop = new Vector3d(upperVector);
            newTop.sub((Tuple3d)vTmp);
            if (newTop.lengthSquared() < 1.0E-5) {
                newFront.set(0.0, 0.0, 1.0);
                newTop.set(0.0, 1.0, 0.0);
            } else {
                newTop.normalize();
            }
            Vector3d newRight = new Vector3d();
            newRight.cross(newFront, newTop);
            Matrix4d m = new Matrix4d();
            m.m00 = -newRight.x;
            m.m01 = newTop.x;
            m.m02 = newFront.x;
            m.m10 = -newRight.y;
            m.m11 = newTop.y;
            m.m12 = newFront.y;
            m.m20 = -newRight.z;
            m.m21 = newTop.z;
            m.m22 = newFront.z;
            m.get(this.nowQ);
        }
    }

    void autoQuatControlZ() {
        Vector3d dv = new Vector3d();
        dv.sub((Tuple3d)this.nextV, (Tuple3d)this.nowV);
        if (dv.length() > this.universe.scene.cameraNowS / 1000.0) {
            Vector3d upperVector = new Vector3d(this.a3.upperVector);
            upperVector.normalize();
            Vector3d newFront = new Vector3d(dv);
            newFront.normalize();
            if (Math.abs(newFront.x) < 1.0E-4 && newFront.y > 0.0) {
                newFront.x = 1.0E-4;
                newFront.normalize();
            }
            double d = newFront.dot(upperVector);
            Vector3d vTmp = new Vector3d(newFront);
            vTmp.scale(d);
            Vector3d newTop = new Vector3d(upperVector);
            newTop.sub((Tuple3d)vTmp);
            if (newTop.lengthSquared() < 1.0E-5) {
                newFront.set(0.0, -1.0, 0.0);
                newTop.set(0.0, 0.0, 1.0);
            } else {
                newTop.normalize();
            }
            Vector3d newRight = new Vector3d();
            newRight.cross(newFront, newTop);
            Matrix4d m = new Matrix4d();
            m.m00 = -newRight.x;
            m.m01 = -newFront.x;
            m.m02 = newTop.x;
            m.m10 = -newRight.y;
            m.m11 = -newFront.y;
            m.m12 = newTop.y;
            m.m20 = -newRight.z;
            m.m21 = -newFront.z;
            m.m22 = newTop.z;
            m.get(this.nowQ);
        }
    }

    void setEnableBehavior(boolean b) {
        this.isInterpolate = b;
    }

    void setAutoDirectionControl(boolean b) {
        this.autoDirectionControl = b;
    }

    void move(Vector3d v, Quat4d q, double s) {
        if (this.isInterpolate) {
            this.nextS = s;
            this.nextV.set((Tuple3d)v);
            this.nextQ.set((Tuple4d)q);
            this.nextQ.normalize();
        } else {
            this.nowS = s;
            this.nowV.set((Tuple3d)v);
            this.nowQ.set((Tuple4d)q);
            this.nextS = s;
            this.nextV.set((Tuple3d)v);
            this.nextQ.set((Tuple4d)q);
        }
        this.needRecalc = true;
    }

    void moveImmediately(Vector3d v, Quat4d q, double s) {
        this.nowS = s;
        this.nowV.set((Tuple3d)v);
        this.nowQ.set((Tuple4d)q);
        this.nextS = s;
        this.nextV.set((Tuple3d)v);
        this.nextQ.set((Tuple4d)q);
        if (this.universe != null) {
            if (this.universe.scene.upperDirection == A3Object.UpperDirection.Z) {
                this.tmpQ.mul(this.nowQ, tmpQQ);
            } else {
                this.tmpQ.set((Tuple4d)this.nowQ);
            }
        } else {
            this.tmpQ.set((Tuple4d)this.nowQ);
        }
        this.t.set(this.tmpQ, this.nowV, this.nowS);
        this.transGroup.setTransform(this.t);
    }

    void setLoc(Vector3d v) {
        if (this.isInterpolate) {
            this.nextV.set((Tuple3d)v);
        } else {
            this.nowV.set((Tuple3d)v);
            this.nextV.set((Tuple3d)v);
        }
        this.needRecalc = true;
    }

    void setLocImmediately(Vector3d v) {
        this.nowV.set((Tuple3d)v);
        this.nextV.set((Tuple3d)v);
        if (this.universe != null) {
            if (this.universe.scene.upperDirection == A3Object.UpperDirection.Z) {
                this.tmpQ.mul(this.nowQ, tmpQQ);
            } else {
                this.tmpQ.set((Tuple4d)this.nowQ);
            }
        } else {
            this.tmpQ.set((Tuple4d)this.nowQ);
        }
        this.t.set(this.tmpQ, this.nowV, this.nowS);
        this.transGroup.setTransform(this.t);
    }

    Vector3d getLoc() {
        return new Vector3d(this.nowV);
    }

    void setQuat(Quat4d q) {
        if (this.isInterpolate) {
            this.nextQ.set((Tuple4d)q);
        } else {
            this.nowQ.set((Tuple4d)q);
            this.nextQ.set((Tuple4d)q);
        }
        this.needRecalc = true;
    }

    void setQuatImmediately(Quat4d q) {
        this.nowQ.set((Tuple4d)q);
        this.nextQ.set((Tuple4d)q);
        if (this.universe != null) {
            if (this.universe.scene.upperDirection == A3Object.UpperDirection.Z) {
                this.tmpQ.mul(this.nowQ, tmpQQ);
            } else {
                this.tmpQ.set((Tuple4d)this.nowQ);
            }
        } else {
            this.tmpQ.set((Tuple4d)this.nowQ);
        }
        this.t.set(this.tmpQ, this.nowV, this.nowS);
        this.transGroup.setTransform(this.t);
    }

    Quat4d getQuat() {
        return new Quat4d(this.nowQ);
    }

    void setScale(double s) {
        if (this.isInterpolate) {
            this.nextS = s;
        } else {
            this.nowS = s;
            this.nextS = s;
        }
        this.needRecalc = true;
    }

    void setScaleImmediately(double s) {
        this.nowS = s;
        this.nextS = s;
        if (this.universe != null) {
            if (this.universe.scene.upperDirection == A3Object.UpperDirection.Z) {
                this.tmpQ.mul(this.nowQ, tmpQQ);
            } else {
                this.tmpQ.set((Tuple4d)this.nowQ);
            }
        } else {
            this.tmpQ.set((Tuple4d)this.nowQ);
        }
        this.t.set(this.tmpQ, this.nowV, this.nowS);
        this.transGroup.setTransform(this.t);
    }

    double getScale() {
        return this.nowS;
    }

    double getSpeed() {
        if (this.isInterpolate) {
            if (this.universe != null) {
                return this.nowTrans.length() / ((double)TimerBehavior.elapsedTime / 1000.0);
            }
            return this.nowTrans.length() / ((double)elapsedTime / 1000.0);
        }
        return 0.0;
    }
}

