/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.acerola3d.a3;

import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.vecmath.Point3d;
import javax.vecmath.Quat4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import jp.sourceforge.acerola3d.a3.A3Balloon;
import jp.sourceforge.acerola3d.a3.A3Behavior;
import jp.sourceforge.acerola3d.a3.A3BranchGroup;
import jp.sourceforge.acerola3d.a3.A3InitData;
import jp.sourceforge.acerola3d.a3.A3Label;
import jp.sourceforge.acerola3d.a3.A3Selected;
import jp.sourceforge.acerola3d.a3.A3UpdateData;
import jp.sourceforge.acerola3d.a3.Scene;

public abstract class A3Object {
    static BoundingSphere bs = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), Double.MAX_VALUE);
    A3Behavior behavior = null;
    Scene scene = null;
    A3Label label = null;
    A3Balloon balloon = null;
    A3Selected selected = null;
    boolean isSelected = false;
    Object userData = null;
    boolean lockedA3 = false;
    boolean pickable = true;
    Vector3d upperVector = new Vector3d(0.0, 1.0, 0.0);

    public A3Object(A3InitData d) {
        this.behavior = new A3Behavior(this);
        this.behavior.setSchedulingBounds((Bounds)bs);
        this.setEnableBehavior(d.getEnableBehavior());
        this.setAutoDirectionControl(d.getAutoDirectionControl());
        if (d.loc != null) {
            this.setLocImmediately(d.loc);
        }
        if (d.quat != null) {
            this.setQuatImmediately(d.quat);
        }
        this.setScaleImmediately(d.scale);
        if (d.label != null) {
            this.setLabel(d.label);
        }
        if (d.balloon != null) {
            this.setBalloon(d.balloon);
        }
        this.upperVector = d.upperVector;
        this.pickable = d.pickable;
    }

    protected void init() {
        this.behavior.init();
    }

    public final void setEnableBehavior(boolean b) {
        this.behavior.setEnableBehavior(b);
    }

    public final void setAutoDirectionControl(boolean b) {
        this.behavior.setAutoDirectionControl(b);
    }

    public void setUpperVector(Vector3d v) {
        this.upperVector.set((Tuple3d)v);
    }

    public Vector3d getUpperVector() {
        return new Vector3d(this.upperVector);
    }

    protected void setNode(Node n) {
        this.behavior.setNode(n);
    }

    public Node getNode() {
        return this.behavior.topGroup;
    }

    public void update(A3UpdateData d) {
        if (d.loc != null) {
            this.setLoc(d.loc);
        }
        if (d.quat != null) {
            this.setQuat(d.quat);
        }
        this.setScale(d.scale);
        this.setLabel(d.label);
        this.setBalloon(d.balloon);
    }

    void setScene(Scene s) {
        this.scene = s;
        this.behavior.setA3VirtualUniverse(s.universe);
        if (this.scene == null) {
            return;
        }
        if (this.label != null) {
            this.scene.add(this.label);
        }
        if (this.balloon != null) {
            this.scene.add(this.balloon);
        }
        if (this.selected != null) {
            this.scene.add(this.selected);
        }
    }

    final A3BranchGroup getA3BranchGroup() {
        return this.behavior.topGroup;
    }

    public final void move(Vector3d v, Quat4d q, double s) {
        this.behavior.move(v, q, s);
    }

    public final void move(Vector3d loc, Vector3d rot, double scale) {
        this.move(loc, this.rot2quat(rot), scale);
    }

    public final void moveImmediately(Vector3d v, Quat4d q, double s) {
        this.behavior.moveImmediately(v, q, s);
    }

    public final void moveImmediately(Vector3d loc, Vector3d rot, double scale) {
        this.moveImmediately(loc, this.rot2quat(rot), scale);
    }

    public final void setLoc(Vector3d v) {
        this.behavior.setLoc(v);
    }

    public final void setLoc(double x, double y, double z) {
        this.setLoc(new Vector3d(x, y, z));
    }

    public final void setLocImmediately(Vector3d v) {
        this.behavior.setLocImmediately(v);
    }

    public final void setLocImmediately(double x, double y, double z) {
        this.setLocImmediately(new Vector3d(x, y, z));
    }

    public final Vector3d getLoc() {
        return this.behavior.getLoc();
    }

    public final void setQuat(Quat4d q) {
        this.behavior.setQuat(q);
    }

    public final void setQuat(double x, double y, double z, double w) {
        this.setQuat(new Quat4d(x, y, z, w));
    }

    public final void setQuatImmediately(Quat4d q) {
        this.behavior.setQuatImmediately(q);
    }

    public final void setQuatImmediately(double x, double y, double z, double w) {
        this.setQuatImmediately(new Quat4d(x, y, z, w));
    }

    public final Quat4d getQuat() {
        return this.behavior.getQuat();
    }

    public final void setRot(Vector3d rot) {
        this.setQuat(this.rot2quat(rot));
    }

    public final void setRot(double x, double y, double z) {
        this.setQuat(this.rot2quat(x, y, z));
    }

    public final void setRotImmediately(Vector3d rot) {
        this.setQuatImmediately(this.rot2quat(rot));
    }

    public final void setRotImmediately(double x, double y, double z) {
        this.setQuatImmediately(this.rot2quat(x, y, z));
    }

    public final Vector3d getRot() {
        return null;
    }

    public final void setScale(double s) {
        this.behavior.setScale(s);
    }

    public final void setScaleImmediately(double s) {
        this.behavior.setScaleImmediately(s);
    }

    public final double getScale() {
        return this.behavior.getScale();
    }

    Quat4d rot2quat(double x, double y, double z) {
        Transform3D t0 = new Transform3D();
        Transform3D t1 = new Transform3D();
        t1.rotX(x);
        t0.mul(t1);
        t1.rotY(y);
        t0.mul(t1);
        t1.rotZ(z);
        t0.mul(t1);
        Quat4d q = new Quat4d();
        t0.get(q);
        return q;
    }

    Quat4d rot2quat(Vector3d rot) {
        return this.rot2quat(rot.x, rot.y, rot.z);
    }

    public void dispose() {
        if (this.scene != null) {
            if (this.label != null) {
                this.scene.del(this.label);
            }
            if (this.balloon != null) {
                this.scene.del(this.balloon);
            }
            if (this.selected != null) {
                this.scene.del(this.selected);
            }
        }
    }

    public void setLabel(String l) {
        if (this.label == null) {
            this.label = new A3Label(l, this);
        }
        if (l != null) {
            this.label.setString(l);
            if (this.scene != null) {
                this.scene.add(this.label);
            }
        } else if (this.scene != null) {
            this.scene.del(this.label);
        }
    }

    public void setLabelLoc(double x, double y) {
        if (this.label == null) {
            this.label = new A3Label("", this);
        }
        this.label.setOffset(x, y);
    }

    public void setBalloon(String s) {
        if (this.balloon == null) {
            this.balloon = new A3Balloon(s, this);
        }
        if (s != null) {
            this.balloon.setString(s);
            if (this.scene != null) {
                this.scene.add(this.balloon);
            }
        } else if (this.scene != null) {
            this.scene.del(this.balloon);
        }
    }

    public void setBalloonLoc(BalloonDir d, double x, double y) {
        if (this.balloon == null) {
            this.balloon = new A3Balloon("", this);
        }
        this.balloon.setOffset(d, x, y);
    }

    public void setBalloonDir(BalloonDir d) {
        if (this.balloon == null) {
            this.balloon = new A3Balloon("", this);
        }
        this.balloon.setDir(d);
    }

    public final void setSelected(boolean b) {
        this.isSelected = b;
        if (this.selected == null) {
            this.selected = new A3Selected(this);
        }
        if (b) {
            if (this.scene != null) {
                this.scene.add(this.selected);
            }
        } else if (this.scene != null) {
            this.scene.del(this.selected);
        }
    }

    public final boolean isSelected() {
        return this.isSelected;
    }

    public final void setUserData(Object o) {
        this.userData = o;
    }

    public final Object getUserData() {
        return this.userData;
    }

    public final double getSpeed() {
        return this.behavior.getSpeed();
    }

    public void setPickable(boolean b) {
        this.pickable = b;
    }

    public boolean getPickable() {
        return this.pickable;
    }

    public static enum BalloonDir {
        RIGHT,
        LEFT,
        TOP,
        BOTTOM;

    }

    public static enum UpperDirection {
        Y,
        Z;

    }
}

