/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.acerola3d.a3;

import com.sun.j3d.loaders.Scene;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.StringTokenizer;
import javax.media.j3d.Background;
import javax.media.j3d.BackgroundSound;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.ConeSound;
import javax.media.j3d.Fog;
import javax.media.j3d.Group;
import javax.media.j3d.Link;
import javax.media.j3d.MediaContainer;
import javax.media.j3d.Node;
import javax.media.j3d.PointSound;
import javax.media.j3d.SharedGroup;
import javax.media.j3d.Sound;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Point2f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3d;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import jp.sourceforge.acerola3d.a3.A3Object;
import jp.sourceforge.acerola3d.a3.Action3D;
import jp.sourceforge.acerola3d.a3.ActionBehavior;
import jp.sourceforge.acerola3d.a3.Motion;
import jp.sourceforge.acerola3d.a3.bvh.BVH;
import jp.sourceforge.acerola3d.a3.catalog.A;
import jp.sourceforge.acerola3d.a3.catalog.A3;
import jp.sourceforge.acerola3d.a3.catalog.P;
import jp.sourceforge.acerola3d.a3.catalog.Profile;
import jp.sourceforge.acerola3d.a3.catalog.S;
import jp.sourceforge.acerola3d.a3.catalog.SoundType;
import jp.sourceforge.acerola3d.a3.catalog.Tag;
import jp.sourceforge.acerola3d.a3.catalog.Thumbnail;
import org.jdesktop.j3d.loaders.vrml97.VrmlLoader;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;

class Action3DData {
    static VrmlLoader loader = null;
    static boolean isInitialized = false;
    URL url;
    String comment;
    int haltActionNo = 0;
    int walkActionNo = 0;
    int runActionNo = 0;
    double minWalkSpeed = 0.1;
    double minRunSpeed = 1.0;
    boolean autoActionControl = false;
    String rdf;
    String[] tags;
    String[] profiles;
    String[] thumbnails;
    String html;
    Action[] actions;
    String[] actionNames;
    HashMap<String, ShapeAndBF> shapes;
    HashMap<String, Motion> motions;
    HashMap<String, MediaContainer> sounds;
    BranchGroup allActionBranchGroup;
    static BoundingSphere bounding = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), Double.MAX_VALUE);

    static void initAction3DData() {
        if (isInitialized) {
            return;
        }
        try {
            loader = new VrmlLoader();
        }
        catch (Exception e) {
            System.out.println("Action3DData.initAction3DData(). gaha!");
            e.printStackTrace();
        }
        isInitialized = true;
    }

    Action3DData() {
    }

    Action3DData(String urlString) throws Exception {
        this.url = new URL(urlString);
        this.init(this.url);
    }

    Action3DData(URL url) throws Exception {
        this.init(url);
    }

    void init(URL url) throws Exception {
        this.url = url;
        AccessController.doPrivilegedWithCombiner(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    Action3DData.this.loadCatalog();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return null;
            }
        });
        this.loadAllShapes();
        this.loadAllMotions();
        this.loadAllSounds();
    }

    public Action3DData copy() {
        Action3DData ret = new Action3DData();
        ret.url = this.url;
        ret.comment = this.comment;
        ret.actionNames = (String[])this.actionNames.clone();
        ret.haltActionNo = this.haltActionNo;
        ret.walkActionNo = this.walkActionNo;
        ret.runActionNo = this.runActionNo;
        ret.minWalkSpeed = this.minWalkSpeed;
        ret.minRunSpeed = this.minRunSpeed;
        ret.autoActionControl = this.autoActionControl;
        ret.rdf = this.rdf;
        ret.tags = (String[])this.tags.clone();
        ret.profiles = (String[])this.profiles.clone();
        ret.thumbnails = (String[])this.thumbnails.clone();
        ret.html = this.html;
        ret.actions = new Action[this.actions.length];
        for (int i = 0; i < this.actions.length; ++i) {
            ret.actions[i] = this.actions[i].copy();
        }
        ret.shapes = new HashMap<String, ShapeAndBF>(this.shapes);
        ret.motions = new HashMap<String, Motion>(this.motions);
        ret.sounds = new HashMap<String, MediaContainer>(this.sounds);
        return ret;
    }

    void loadCatalog() throws Exception {
        this.loadCatalog_NEW();
    }

    void loadCatalog_NEW() throws Exception {
        File f;
        JAXBContext jc = JAXBContext.newInstance((String)"jp.sourceforge.acerola3d.a3.catalog");
        Unmarshaller u = jc.createUnmarshaller();
        A3 a3 = null;
        try {
            URL cURL = null;
            cURL = this.url.getProtocol().equals("file") ? ((f = new File(this.url.toURI())).isDirectory() ? new URL(this.url.toString() + "/CATALOG.XML") : new URL("x-rzip:" + this.url.toString() + "!/CATALOG.XML")) : new URL("x-rzip:" + this.url.toString() + "!/CATALOG.XML");
            a3 = (A3)u.unmarshal(cURL.openStream());
        }
        catch (Exception e) {
            File file;
            e.printStackTrace();
            URL cURL = null;
            cURL = this.url.getProtocol().equals("file") ? ((file = new File(this.url.toURI())).isDirectory() ? new URL(this.url.toString() + "/catalog.xml") : new URL("x-rzip:" + this.url.toString() + "!/catalog.xml")) : new URL("x-rzip:" + this.url.toString() + "!/catalog.xml");
            a3 = (A3)u.unmarshal(cURL.openStream());
        }
        this.haltActionNo = a3.getHaltActionNo().intValue();
        this.walkActionNo = a3.getWalkActionNo().intValue();
        this.runActionNo = a3.getRunActionNo().intValue();
        this.minWalkSpeed = a3.getMinWalkSpeed();
        this.minRunSpeed = a3.getMinRunSpeed();
        this.comment = a3.getC();
        this.actions = new Action[a3.getA().size()];
        this.actionNames = new String[a3.getA().size()];
        this.rdf = this.domSerialize(a3.getAny());
        this.tags = new String[a3.getTag().size()];
        int i = 0;
        for (Tag tag : a3.getTag()) {
            this.tags[i++] = tag.getName();
        }
        this.profiles = new String[a3.getProfile().size()];
        i = 0;
        for (Profile profile : a3.getProfile()) {
            this.profiles[i++] = profile.getUri();
        }
        this.thumbnails = new String[a3.getThumbnail().size()];
        i = 0;
        for (Thumbnail thumbnail : a3.getThumbnail()) {
            if (this.url.getProtocol().equals("file")) {
                File f3 = new File(this.url.toURI());
                if (f3.isDirectory()) {
                    this.thumbnails[i++] = this.url.toString() + "/" + thumbnail.getSrc();
                    continue;
                }
                this.thumbnails[i++] = "x-rzip:" + this.url.toString() + "!/" + thumbnail.getSrc();
                continue;
            }
            this.thumbnails[i++] = "x-rzip:" + this.url.toString() + "!/" + thumbnail.getSrc();
        }
        if (a3.getHtmlfile() != null) {
            this.html = this.url.getProtocol().equals("file") ? ((f = new File(this.url.toURI())).isDirectory() ? this.url.toString() + "/" + a3.getHtmlfile().getSrc() : "x-rzip:" + this.url.toString() + "!/" + a3.getHtmlfile().getSrc()) : "x-rzip:" + this.url.toString() + "!/" + a3.getHtmlfile().getSrc();
        }
        i = 0;
        for (A a : a3.getA()) {
            Action a2 = new Action();
            a2.actionNo = i;
            a2.actionName = a.getAn();
            this.actions[i] = a2;
            this.actionNames[i] = a2.actionName;
            a2.loopFlag = a.isLoop();
            a2.bvhFile = a.getBvh();
            a2.scale = a.getScale();
            a2.rotationXYZ = this.makeDouble3(a.getRot());
            a2.offsetXYZ = this.makeDouble3(a.getOffset());
            a2.pHash = new HashMap();
            a2.segno = a.getSegno();
            a2.dalsegno = a.getDalsegno();
            a2.rightBalloonOffset = this.makeDouble2(a.getRightBalloonOffset());
            a2.leftBalloonOffset = this.makeDouble2(a.getLeftBalloonOffset());
            a2.topBalloonOffset = this.makeDouble2(a.getTopBalloonOffset());
            a2.bottomBalloonOffset = this.makeDouble2(a.getBottomBalloonOffset());
            a2.labelOffset = this.makeDouble2(a.getLabelOffset());
            for (P pNode : a.getP()) {
                Part p = new Part();
                String partName = pNode.getName().trim();
                p.fileName = pNode.getWrl().trim();
                p.scale = pNode.getScale();
                p.offsetXYZ = this.makeDouble3(pNode.getOffset());
                p.rotationXYZ = this.makeDouble3(pNode.getRot());
                a2.pHash.put(partName, p);
            }
            S s = a.getS();
            if (s != null) {
                a2.soundFile = s.getFile();
                a2.soundLoop = s.isLoop();
                if (s.getType() == SoundType.POINT_SOUND) {
                    a2.soundType = "PointSound";
                } else if (s.getType() == SoundType.BACKGROUND_SOUND) {
                    a2.soundType = "BackgroundSound";
                } else if (s.getType() == SoundType.CONE_SOUND) {
                    a2.soundType = "ConeSound";
                }
                a2.soundGain = (float)s.getGain();
                a2.soundOffsetXYZ = this.makeFloat3(s.getOffset());
                a2.soundDirectionXYZ = this.makeFloat3(s.getDirection());
                a2.soundContinue = s.isContinue();
            }
            ++i;
        }
    }

    double[] makeDouble3(String s) {
        if (s.equals("0.0 0.0 0.0")) {
            return null;
        }
        double[] ret = new double[3];
        StringTokenizer st = new StringTokenizer(s);
        int i = 0;
        while (st.hasMoreTokens()) {
            ret[i] = Double.parseDouble(st.nextToken());
            ++i;
        }
        return ret;
    }

    double[] makeDouble2(String s) {
        double[] ret = new double[2];
        StringTokenizer st = new StringTokenizer(s);
        int i = 0;
        while (st.hasMoreTokens()) {
            ret[i] = Double.parseDouble(st.nextToken());
            ++i;
        }
        return ret;
    }

    float[] makeFloat3(String s) {
        float[] ret = new float[3];
        StringTokenizer st = new StringTokenizer(s);
        int i = 0;
        while (st.hasMoreTokens()) {
            ret[i] = Float.parseFloat(st.nextToken());
            ++i;
        }
        return ret;
    }

    String domSerialize(Element e) {
        try {
            DOMImplementationRegistry dir = DOMImplementationRegistry.newInstance();
            DOMImplementation di = dir.getDOMImplementation("LS 3.0");
            DOMImplementationLS dils = (DOMImplementationLS)((Object)di);
            LSOutput output = dils.createLSOutput();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            output.setByteStream(baos);
            output.setEncoding("UTF-8");
            LSSerializer serializer = dils.createLSSerializer();
            serializer.write(e, output);
            return baos.toString("UTF-8");
        }
        catch (Exception e1) {
            e1.printStackTrace();
            return "";
        }
    }

    void loadCatalog_OLD() throws Exception {
        org.w3c.dom.Node[] cc;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document d = null;
        try {
            File f;
            String cURL = null;
            cURL = this.url.getProtocol().equals("file") ? ((f = new File(this.url.toURI())).isDirectory() ? this.url.toString() + "/CATALOG.XML" : "x-rzip:" + this.url.toString() + "!/CATALOG.XML") : "x-rzip:" + this.url.toString() + "!/CATALOG.XML";
            d = db.parse(cURL);
        }
        catch (Exception e) {
            File f;
            String cURL = null;
            cURL = this.url.getProtocol().equals("file") ? ((f = new File(this.url.toURI())).isDirectory() ? this.url.toString() + "/catalog.xml" : "x-rzip:" + this.url.toString() + "!/catalog.xml") : "x-rzip:" + this.url.toString() + "!/catalog.xml";
            d = db.parse(cURL);
        }
        org.w3c.dom.Node[] a3 = Action3DData.xpath("/a3", d);
        NamedNodeMap nnm = a3[0].getAttributes();
        Attr attr = (Attr)nnm.getNamedItem("haltActionNo");
        if (attr != null) {
            this.haltActionNo = Integer.parseInt(attr.getValue().trim());
        }
        if ((attr = (Attr)nnm.getNamedItem("walkActionNo")) != null) {
            this.walkActionNo = Integer.parseInt(attr.getValue().trim());
        }
        if ((attr = (Attr)nnm.getNamedItem("runActionNo")) != null) {
            this.runActionNo = Integer.parseInt(attr.getValue().trim());
        }
        if ((attr = (Attr)nnm.getNamedItem("minWalkSpeed")) != null) {
            this.minWalkSpeed = Double.parseDouble(attr.getValue().trim());
        }
        if ((attr = (Attr)nnm.getNamedItem("minRunSpeed")) != null) {
            this.minRunSpeed = Double.parseDouble(attr.getValue().trim());
        }
        if ((attr = (Attr)nnm.getNamedItem("autoActionControl")) != null) {
            this.autoActionControl = Boolean.parseBoolean(attr.getValue().trim());
        }
        this.comment = (cc = Action3DData.xpath("/a3/c/text()", d)).length != 0 ? ((Text)cc[0]).getData() : "";
        org.w3c.dom.Node[] a_nodes = Action3DData.xpath("/a3/a", d);
        this.actions = new Action[a_nodes.length];
        this.actionNames = new String[a_nodes.length];
        for (int i = 0; i < a_nodes.length; ++i) {
            int ii;
            StringTokenizer st;
            Action a = new Action();
            a.actionNo = i;
            nnm = a_nodes[i].getAttributes();
            attr = (Attr)nnm.getNamedItem("an");
            a.actionName = attr.getValue().trim();
            this.actions[i] = a;
            this.actionNames[i] = a.actionName;
            attr = (Attr)nnm.getNamedItem("loop");
            if (attr != null) {
                Boolean bbb = Boolean.valueOf(attr.getValue());
                a.loopFlag = bbb;
            } else {
                a.loopFlag = false;
            }
            attr = (Attr)nnm.getNamedItem("bvh");
            a.bvhFile = attr.getValue().trim();
            attr = (Attr)nnm.getNamedItem("scale");
            a.scale = attr != null ? Double.parseDouble(attr.getValue()) : 1.0;
            attr = (Attr)nnm.getNamedItem("rot");
            if (attr != null) {
                a.rotationXYZ = new double[3];
                st = new StringTokenizer(attr.getValue());
                ii = 0;
                while (st.hasMoreTokens()) {
                    a.rotationXYZ[ii] = Double.parseDouble(st.nextToken());
                    ++ii;
                }
            }
            if ((attr = (Attr)nnm.getNamedItem("offset")) != null) {
                a.offsetXYZ = new double[3];
                st = new StringTokenizer(attr.getValue());
                ii = 0;
                while (st.hasMoreTokens()) {
                    a.offsetXYZ[ii] = Double.parseDouble(st.nextToken());
                    ++ii;
                }
            }
            a.pHash = new HashMap();
            org.w3c.dom.Node[] p_nodes = Action3DData.xpath("/a3/a[position()=" + (i + 1) + "]/p", d);
            for (int j = 0; j < p_nodes.length; ++j) {
                int ii2;
                StringTokenizer st2;
                Part p = new Part();
                nnm = p_nodes[j].getAttributes();
                attr = (Attr)nnm.getNamedItem("name");
                String partName = attr.getValue().trim();
                attr = (Attr)nnm.getNamedItem("wrl");
                p.fileName = attr.getValue().trim();
                attr = (Attr)nnm.getNamedItem("scale");
                if (attr != null) {
                    p.scale = Double.parseDouble(attr.getValue().trim());
                }
                if ((attr = (Attr)nnm.getNamedItem("offset")) != null) {
                    p.offsetXYZ = new double[3];
                    st2 = new StringTokenizer(attr.getValue());
                    ii2 = 0;
                    while (st2.hasMoreTokens()) {
                        p.offsetXYZ[ii2] = Double.parseDouble(st2.nextToken());
                        ++ii2;
                    }
                }
                if ((attr = (Attr)nnm.getNamedItem("rot")) != null) {
                    p.rotationXYZ = new double[3];
                    st2 = new StringTokenizer(attr.getValue());
                    ii2 = 0;
                    while (st2.hasMoreTokens()) {
                        p.rotationXYZ[ii2] = Double.parseDouble(st2.nextToken());
                        ++ii2;
                    }
                }
                a.pHash.put(partName, p);
            }
            org.w3c.dom.Node[] s_nodes = Action3DData.xpath("/a3/a[position()=" + (i + 1) + "]/s", d);
            if (s_nodes == null || s_nodes.length == 0) continue;
            nnm = s_nodes[0].getAttributes();
            attr = (Attr)nnm.getNamedItem("file");
            a.soundFile = attr.getValue().trim();
            attr = (Attr)nnm.getNamedItem("loop");
            if (attr != null) {
                a.soundLoop = Boolean.parseBoolean(attr.getValue().trim());
            }
            if ((attr = (Attr)nnm.getNamedItem("type")) != null) {
                a.soundType = attr.getValue().trim();
            }
            if ((attr = (Attr)nnm.getNamedItem("gain")) != null) {
                a.soundGain = Float.parseFloat(attr.getValue().trim());
            }
            if ((attr = (Attr)nnm.getNamedItem("offset")) == null) continue;
            StringTokenizer st3 = new StringTokenizer(attr.getValue());
            int ii3 = 0;
            while (st3.hasMoreTokens()) {
                a.soundOffsetXYZ[ii3] = Float.parseFloat(st3.nextToken());
                ++ii3;
            }
        }
    }

    static org.w3c.dom.Node[] xpath(String query, Document doc) {
        try {
            XPathFactory factory = XPathFactory.newInstance();
            XPath xpath = factory.newXPath();
            XPathExpression expr = xpath.compile(query);
            NodeList nl = (NodeList)expr.evaluate(doc, XPathConstants.NODESET);
            org.w3c.dom.Node[] ret = new org.w3c.dom.Node[nl.getLength()];
            for (int i = 0; i < nl.getLength(); ++i) {
                ret[i] = nl.item(i);
            }
            return ret;
        }
        catch (XPathExpressionException e) {
            return null;
        }
    }

    void loadAllShapes() throws Exception {
        HashSet<Part> s = new HashSet<Part>();
        for (int i = 0; i < this.actions.length; ++i) {
            s.addAll(this.actions[i].pHash.values());
        }
        this.shapes = new HashMap();
        for (Part p : s) {
            File f;
            URL wrlURL = null;
            wrlURL = this.url.getProtocol().equals("file") ? ((f = new File(this.url.toURI())).isDirectory() ? new URL(this.url.toString() + "/" + p.fileName) : new URL("x-rzip:" + this.url.toString() + "!/" + p.fileName)) : new URL("x-rzip:" + this.url.toString() + "!/" + p.fileName);
            ShapeAndBF shapeAndBF = new ShapeAndBF();
            shapeAndBF.sg = new SharedGroup();
            Transform3D t = new Transform3D();
            TransformGroup tg = new TransformGroup(t);
            Scene scene = loader.load(wrlURL);
            tg.addChild((Node)scene.getSceneGroup());
            shapeAndBF.sg.addChild((Node)tg);
            shapeAndBF.b = scene.getBackgroundNodes();
            shapeAndBF.f = scene.getFogNodes();
            this.shapes.put(p.fileName, shapeAndBF);
        }
    }

    void loadAllMotions() throws Exception {
        HashSet<String> s = new HashSet<String>();
        for (int i = 0; i < this.actions.length; ++i) {
            if (this.actions[i].bvhFile == null) continue;
            s.add(this.actions[i].bvhFile);
        }
        this.motions = new HashMap();
        for (String filename : s) {
            File f;
            if (filename.equals("none")) continue;
            URL motionURL = null;
            motionURL = this.url.getProtocol().equals("file") ? ((f = new File(this.url.toURI())).isDirectory() ? new URL(this.url.toString() + "/" + filename) : new URL("x-rzip:" + this.url.toString() + "!/" + filename)) : new URL("x-rzip:" + this.url.toString() + "!/" + filename);
            BVH bvh = new BVH(motionURL);
            this.motions.put(filename, bvh);
        }
    }

    void loadAllSounds() throws Exception {
        HashSet<String> s = new HashSet<String>();
        for (int i = 0; i < this.actions.length; ++i) {
            if (this.actions[i].soundFile == null) continue;
            s.add(this.actions[i].soundFile);
        }
        this.sounds = new HashMap();
        for (String filename : s) {
            File f;
            URL soundURL = null;
            soundURL = this.url.getProtocol().equals("file") ? ((f = new File(this.url.toURI())).isDirectory() ? new URL(this.url.toString() + "/" + filename) : new URL("x-rzip:" + this.url.toString() + "!/" + filename)) : new URL("x-rzip:" + this.url.toString() + "!/" + filename);
            MediaContainer mc = new MediaContainer(soundURL);
            this.sounds.put(filename, mc);
        }
    }

    void construct3DNode(Action3D a3) {
        for (int i = 0; i < this.actions.length; ++i) {
            this.actions[i].construct3DNode(a3);
        }
        this.allActionBranchGroup = new BranchGroup();
        this.allActionBranchGroup.setCapability(17);
        this.allActionBranchGroup.setCapability(13);
        this.allActionBranchGroup.setCapability(14);
        this.allActionBranchGroup.addChild((Node)this.actions[0].rootGroup);
    }

    Node getNode() {
        this.allActionBranchGroup.detach();
        return this.allActionBranchGroup;
    }

    String getActionNameFromActionNo(int an) {
        return this.actionNames[an];
    }

    int getActionNoFromActionName(String an) {
        for (int i = 0; i < this.actionNames.length; ++i) {
            if (!this.actionNames[i].equals(an)) continue;
            return i;
        }
        return -1;
    }

    int getActionCount() {
        return this.actions.length;
    }

    String[] getActionNames() {
        return (String[])this.actionNames.clone();
    }

    boolean isStoped(int actionNo) {
        return this.actions[actionNo].isStoped();
    }

    double getMotionLength(int actionNo) {
        return this.actions[actionNo].getMotionLength();
    }

    double getMotionLength(String actionName) {
        int actionNo = this.getActionNoFromActionName(actionName);
        return this.actions[actionNo].getMotionLength();
    }

    String getActionName(int i) {
        return null;
    }

    String getComment() {
        return this.comment;
    }

    int getFrameCount() {
        return this.actionNames.length;
    }

    void setMode(Motion.Mode m) {
        for (int i = 0; i < this.actions.length; ++i) {
            this.actions[i].setMode(m);
        }
    }

    void setAutoActionControl(boolean b) {
        this.autoActionControl = b;
    }

    boolean autoActionControl() {
        return this.autoActionControl;
    }

    void setHaltAction(int i) {
        this.haltActionNo = i;
    }

    void setHaltAction(Serializable s) {
        if (s instanceof String) {
            this.setHaltAction(this.getActionNoFromActionName((String)((Object)s)));
        } else if (s instanceof Integer) {
            this.setHaltAction((Integer)s);
        }
    }

    int getHaltActionNo() {
        return this.haltActionNo;
    }

    void setWalkAction(int i) {
        this.walkActionNo = i;
    }

    void setWalkAction(Serializable s) {
        if (s instanceof String) {
            this.setWalkAction(this.getActionNoFromActionName((String)((Object)s)));
        } else if (s instanceof Integer) {
            this.setWalkAction((Integer)s);
        }
    }

    int getWalkActionNo() {
        return this.walkActionNo;
    }

    void setMinWalkSpeed(double d) {
        this.minWalkSpeed = d;
    }

    double getMinWalkSpeed() {
        return this.minWalkSpeed;
    }

    void setRunAction(int i) {
        this.runActionNo = i;
    }

    void setRunAction(Serializable s) {
        if (s instanceof String) {
            this.setRunAction(this.getActionNoFromActionName((String)((Object)s)));
        } else if (s instanceof Integer) {
            this.setRunAction((Integer)s);
        }
    }

    int getRunActionNo() {
        return this.runActionNo;
    }

    void setMinRunSpeed(double d) {
        this.minRunSpeed = d;
    }

    double getMinRunSpeed() {
        return this.minRunSpeed;
    }

    void setShape(int actionNo, String boneName, Node shape) {
        Part p = this.actions[actionNo].pHash.get(boneName);
        p.tg.removeChild(p.shape);
        p.shape = shape;
        p.tg.addChild(shape);
    }

    void setShape(Serializable action, String boneName, Node shape) {
        if (action instanceof String) {
            int i = this.getActionNoFromActionName((String)((Object)action));
            this.setShape(i, boneName, shape);
        } else if (action instanceof Integer) {
            int i = (Integer)action;
            this.setShape(i, boneName, shape);
        }
    }

    class DummyMotion
    implements Motion {
        DummyMotion() {
        }

        @Override
        public double getMotionLength() {
            return 0.001;
        }

        @Override
        public double getDefaultFrameTime() {
            return 0.0333;
        }

        @Override
        public String getRootBone() {
            return null;
        }

        @Override
        public String getParentBone(String b) {
            return null;
        }

        @Override
        public String[] getChildBones(String b) {
            return new String[0];
        }

        @Override
        public String[] getAllBones() {
            return new String[0];
        }

        @Override
        public Transform3D getTransform3D(String bone, double time) {
            return new Transform3D();
        }
    }

    class ShapeAndBF {
        SharedGroup sg;
        Background[] b;
        Fog[] f;

        ShapeAndBF() {
        }
    }

    class Action {
        int actionNo;
        String actionName;
        boolean loopFlag;
        String bvhFile;
        String soundFile;
        boolean soundLoop;
        String soundType = "PointSound";
        float soundGain = 1.0f;
        float[] soundOffsetXYZ = new float[]{0.0f, 0.0f, 0.0f};
        float[] soundDirectionXYZ = new float[]{0.0f, 0.0f, 1.0f};
        boolean soundContinue = true;
        Sound sound;
        double scale;
        double[] offsetXYZ;
        double[] rotationXYZ;
        HashMap<String, Part> pHash;
        double segno;
        double dalsegno;
        A3Object.BalloonDir balloonDirection = A3Object.BalloonDir.RIGHT;
        double[] rightBalloonOffset = new double[]{0.0, 0.0};
        double[] leftBalloonOffset = new double[]{0.0, 0.0};
        double[] topBalloonOffset = new double[]{0.0, 0.0};
        double[] bottomBalloonOffset = new double[]{0.0, 0.0};
        double[] labelOffset = new double[]{0.0, 0.0};
        Group rootGroup;
        ActionBehavior behavior;
        Motion motion;
        HashMap<String, TransformGroup> tgMap;

        Action() {
        }

        Action copy() {
            Action ret = new Action();
            ret.actionNo = this.actionNo;
            ret.actionName = this.actionName;
            ret.loopFlag = this.loopFlag;
            ret.bvhFile = this.bvhFile;
            ret.soundFile = this.soundFile;
            ret.soundLoop = this.soundLoop;
            ret.soundType = this.soundType;
            ret.soundGain = this.soundGain;
            ret.soundOffsetXYZ = (float[])this.soundOffsetXYZ.clone();
            ret.soundDirectionXYZ = (float[])this.soundDirectionXYZ.clone();
            ret.soundContinue = this.soundContinue;
            ret.scale = this.scale;
            ret.rotationXYZ = this.rotationXYZ == null ? null : (double[])this.rotationXYZ.clone();
            ret.offsetXYZ = this.offsetXYZ == null ? null : (double[])this.offsetXYZ.clone();
            ret.pHash = new HashMap<String, Part>(this.pHash);
            ret.motion = this.motion;
            ret.segno = this.segno;
            ret.dalsegno = this.dalsegno;
            ret.rightBalloonOffset = (double[])this.rightBalloonOffset.clone();
            ret.leftBalloonOffset = (double[])this.leftBalloonOffset.clone();
            ret.topBalloonOffset = (double[])this.topBalloonOffset.clone();
            ret.bottomBalloonOffset = (double[])this.bottomBalloonOffset.clone();
            ret.labelOffset = (double[])this.labelOffset.clone();
            return ret;
        }

        void construct3DNode(Action3D a3) {
            this.tgMap = new HashMap();
            this.rootGroup = new BranchGroup();
            this.rootGroup.setCapability(17);
            TransformGroup tg = new TransformGroup();
            tg.setCapability(18);
            tg.setCapability(17);
            TransformGroup tg0 = null;
            if (this.rotationXYZ == null && this.offsetXYZ == null && this.scale == 1.0) {
                tg0 = null;
            } else {
                Transform3D t0a = new Transform3D();
                Transform3D t0b = new Transform3D();
                if (this.rotationXYZ != null) {
                    t0a.rotX(this.rotationXYZ[0] / 180.0 * 2.0 * Math.PI);
                    t0b.rotY(this.rotationXYZ[1] / 180.0 * 2.0 * Math.PI);
                    t0a.mul(t0b);
                    t0b.rotZ(this.rotationXYZ[2] / 180.0 * 2.0 * Math.PI);
                    t0a.mul(t0b);
                }
                t0b.set(2.0);
                t0b.setScale(this.scale);
                if (this.offsetXYZ != null) {
                    t0b.setTranslation(new Vector3d(this.offsetXYZ[0], this.offsetXYZ[1], this.offsetXYZ[2]));
                }
                t0a.mul(t0b);
                tg0 = new TransformGroup(t0a);
                tg0.addChild((Node)tg);
            }
            if (tg0 != null) {
                this.rootGroup.addChild(tg0);
            } else {
                this.rootGroup.addChild((Node)tg);
            }
            this.motion = this.bvhFile.equals("none") ? new DummyMotion() : Action3DData.this.motions.get(this.bvhFile);
            String rootBoneName = this.motion.getRootBone();
            Part p = this.pHash.get(rootBoneName);
            if (p != null) {
                Link n = null;
                ShapeAndBF sabf = Action3DData.this.shapes.get(p.fileName);
                if (p.rotationXYZ == null && p.offsetXYZ == null && p.scale == 1.0) {
                    n = new Link(sabf.sg);
                } else {
                    Transform3D t9a = new Transform3D();
                    Transform3D t9b = new Transform3D();
                    t9a.set(2.0);
                    t9b.set(2.0);
                    if (p.rotationXYZ != null) {
                        t9a.rotX(p.rotationXYZ[0] / 180.0 * Math.PI);
                        t9b.rotY(p.rotationXYZ[1] / 180.0 * Math.PI);
                        t9a.mul(t9b);
                        t9b.rotZ(p.rotationXYZ[2] / 180.0 * Math.PI);
                        t9a.mul(t9b);
                    }
                    t9b.set(2.0);
                    t9b.setScale(p.scale);
                    t9a.mul(t9b);
                    if (p.offsetXYZ != null) {
                        t9b.set(2.0);
                        t9b.setTranslation(new Vector3d(p.offsetXYZ[0], p.offsetXYZ[1], p.offsetXYZ[2]));
                        t9a.mul(t9b);
                    }
                    TransformGroup tg9 = new TransformGroup(t9a);
                    tg9.addChild((Node)new Link(sabf.sg));
                    n = tg9;
                }
                tg.addChild((Node)n);
                p.tg = tg;
                p.shape = n;
                if (sabf.b != null) {
                    for (int i = 0; i < sabf.b.length; ++i) {
                        this.rootGroup.addChild(sabf.b[i].cloneNode(false));
                    }
                }
                if (sabf.f != null) {
                    for (int i = 0; i < sabf.f.length; ++i) {
                        this.rootGroup.addChild(sabf.f[i].cloneNode(false));
                    }
                }
            }
            this.tgMap.put(rootBoneName, tg);
            this.construct((Group)tg, rootBoneName);
            if (this.soundFile != null) {
                MediaContainer mc = Action3DData.this.sounds.get(this.soundFile);
                if (this.soundType.equals("BackgroundSound")) {
                    this.sound = new BackgroundSound(mc, this.soundGain);
                } else if (this.soundType.equals("PointSound")) {
                    this.sound = new PointSound(mc, this.soundGain, this.soundOffsetXYZ[0], this.soundOffsetXYZ[1], this.soundOffsetXYZ[2]);
                } else if (this.soundType.equals("ConeSound")) {
                    Point2f[] myFrontAtten = new Point2f[]{new Point2f(100.0f, 1.0f), new Point2f(350.0f, 0.5f), new Point2f(600.0f, 0.0f)};
                    Point2f[] myBackAtten = new Point2f[]{new Point2f(50.0f, 1.0f), new Point2f(100.0f, 0.5f), new Point2f(200.0f, 0.0f)};
                    Point3f[] myAngular = new Point3f[]{new Point3f(0.0f, 1.0f, 20000.0f), new Point3f(0.785f, 0.5f, 5000.0f), new Point3f(1.571f, 0.0f, 2000.0f)};
                    this.sound = new ConeSound();
                    ((ConeSound)this.sound).setSoundData(mc);
                    ((ConeSound)this.sound).setInitialGain(this.soundGain);
                    ((ConeSound)this.sound).setPosition(this.soundOffsetXYZ[0], this.soundOffsetXYZ[1], this.soundOffsetXYZ[2]);
                    ((ConeSound)this.sound).setDirection(this.soundDirectionXYZ[0], this.soundDirectionXYZ[1], this.soundDirectionXYZ[2]);
                    ((ConeSound)this.sound).setDistanceGain(myFrontAtten, myBackAtten);
                    ((ConeSound)this.sound).setAngularAttenuation(myAngular);
                }
                this.sound.setEnable(false);
                this.sound.setPause(false);
                if (this.soundLoop) {
                    this.sound.setLoop(-1);
                } else {
                    this.sound.setLoop(0);
                }
                this.sound.setSchedulingBounds((Bounds)bounding);
                this.sound.setCapability(23);
                SharedGroup sg = new SharedGroup();
                sg.addChild((Node)this.sound);
                Link ll = new Link(sg);
                this.rootGroup.addChild((Node)ll);
            }
            String[] bones = this.motion.getAllBones();
            String[] parts = this.pHash.keySet().toArray(new String[0]);
            for (int i = 0; i < parts.length; ++i) {
                boolean exist = false;
                for (int j = 0; j < bones.length; ++j) {
                    if (!parts[i].equals(bones[j])) continue;
                    exist = true;
                    break;
                }
                if (exist) continue;
                p = this.pHash.get(parts[i]);
                Link n = null;
                ShapeAndBF sabf = Action3DData.this.shapes.get(p.fileName);
                if (p.rotationXYZ == null && p.offsetXYZ == null && p.scale == 1.0) {
                    n = new Link(sabf.sg);
                } else {
                    Transform3D t9a = new Transform3D();
                    Transform3D t9b = new Transform3D();
                    t9a.set(2.0);
                    t9b.set(2.0);
                    if (p.rotationXYZ != null) {
                        t9a.rotX(p.rotationXYZ[0] / 180.0 * Math.PI);
                        t9b.rotY(p.rotationXYZ[1] / 180.0 * Math.PI);
                        t9a.mul(t9b);
                        t9b.rotZ(p.rotationXYZ[2] / 180.0 * Math.PI);
                        t9a.mul(t9b);
                    }
                    t9b.set(2.0);
                    t9b.setScale(p.scale);
                    t9a.mul(t9b);
                    if (p.offsetXYZ != null) {
                        t9b.set(2.0);
                        t9b.setTranslation(new Vector3d(p.offsetXYZ[0], p.offsetXYZ[1], p.offsetXYZ[2]));
                        t9a.mul(t9b);
                    }
                    TransformGroup tg9 = new TransformGroup(t9a);
                    tg9.addChild((Node)new Link(sabf.sg));
                    n = tg9;
                }
                tg.addChild((Node)n);
                p.tg = tg;
                p.shape = n;
                if (sabf.b != null) {
                    for (int j = 0; j < sabf.b.length; ++j) {
                        this.rootGroup.addChild(sabf.b[j].cloneNode(false));
                    }
                }
                if (sabf.f == null) continue;
                for (int j = 0; j < sabf.f.length; ++j) {
                    this.rootGroup.addChild(sabf.f[j].cloneNode(false));
                }
            }
        }

        void construct(Group parent, String parentName) {
            String[] children = this.motion.getChildBones(parentName);
            for (int i = 0; i < children.length; ++i) {
                TransformGroup tg = new TransformGroup();
                tg.setCapability(18);
                parent.addChild((Node)tg);
                Part p = this.pHash.get(children[i]);
                if (p != null) {
                    Link n = null;
                    ShapeAndBF sabf = Action3DData.this.shapes.get(p.fileName);
                    if (p.rotationXYZ == null && p.offsetXYZ == null && p.scale == 1.0) {
                        n = new Link(sabf.sg);
                    } else {
                        Transform3D t9a = new Transform3D();
                        Transform3D t9b = new Transform3D();
                        t9a.set(2.0);
                        t9b.set(2.0);
                        if (p.rotationXYZ != null) {
                            t9a.rotX(p.rotationXYZ[0] / 180.0 * Math.PI);
                            t9b.rotY(p.rotationXYZ[1] / 180.0 * Math.PI);
                            t9a.mul(t9b);
                            t9b.rotZ(p.rotationXYZ[2] / 180.0 * Math.PI);
                            t9a.mul(t9b);
                        }
                        t9b.set(2.0);
                        t9b.setScale(p.scale);
                        t9a.mul(t9b);
                        if (p.offsetXYZ != null) {
                            t9b.set(2.0);
                            t9b.setTranslation(new Vector3d(p.offsetXYZ[0], p.offsetXYZ[1], p.offsetXYZ[2]));
                            t9a.mul(t9b);
                        }
                        TransformGroup tg9 = new TransformGroup(t9a);
                        tg9.addChild((Node)new Link(sabf.sg));
                        n = tg9;
                    }
                    tg.addChild((Node)n);
                    p.tg = tg;
                    p.shape = n;
                    if (sabf.b != null) {
                        for (int j = 0; j < sabf.b.length; ++j) {
                            this.rootGroup.addChild(sabf.b[j].cloneNode(false));
                        }
                    }
                    if (sabf.f != null) {
                        for (int j = 0; j < sabf.f.length; ++j) {
                            this.rootGroup.addChild(sabf.f[j].cloneNode(false));
                        }
                    }
                }
                this.tgMap.put(children[i], tg);
                this.construct((Group)tg, children[i]);
            }
        }

        Group getRootGroup() {
            return this.rootGroup;
        }

        void start() {
        }

        void stop() {
        }

        boolean isStoped() {
            return this.behavior.isStoped();
        }

        double getMotionLength() {
            return this.motion.getMotionLength();
        }

        void setMode(Motion.Mode m) {
            this.behavior.setMode(m);
        }

        void setPauseTime(double t) {
            this.behavior.setPauseTime(t);
        }
    }

    class Part {
        String fileName;
        double scale = 1.0;
        double[] offsetXYZ;
        double[] rotationXYZ;
        TransformGroup tg;
        Node shape;

        Part() {
        }
    }
}

