package jp.sourceforge.acerola3d.a3;

import java.util.*;
import javax.media.j3d.*;
import javax.vecmath.*;

class A3Behavior extends Behavior {
    static long elapsedTime = 100l;
    static Node selected3d_egg = new Selected3D();
    A3Object a3 = null;
    A3BranchGroup topGroup;
    TransformGroup transGroup;
    Transform3D t;
    A3VirtualUniverse universe = null;
    boolean isInterpolate = false;
    boolean autoDirectionControl = false;
    boolean billboardControl = false;
    double nextS = 1.0;
    Quat4d nextQ = new Quat4d(0.0,0.0,0.0,1.0);
    Vector3d nextV = new Vector3d();
    double nowS = 1.0;
    Quat4d nowQ = new Quat4d(0.0,0.0,0.0,1.0);
    Vector3d nowV = new Vector3d();
    boolean needRecalc = true;
    Vector3d nowTrans = new Vector3d();
    BranchGroup selected3d_bg = null;
    TransformGroup selected3d_tg = null;
    
    A3Behavior(A3Object a) {
        a3 = a;
        topGroup = new A3BranchGroup();
        topGroup.setCapability(Group.ALLOW_CHILDREN_WRITE);
        topGroup.setCapability(Group.ALLOW_CHILDREN_EXTEND);
        topGroup.setA3(a3);
        t = new Transform3D();
        transGroup = new TransformGroup(t);
        transGroup.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
        transGroup.addChild(this);
        topGroup.addChild(transGroup);
    }
    void setA3VirtualUniverse(A3VirtualUniverse u) {
        universe = u;
    }
    void setNode(Node n) {
        transGroup.addChild(n);
    }
    void init() {
        if (universe!=null) {
            if (universe.scene.upperDirection==A3Object.UpperDirection.Z) {
                tmpQ.mul(nowQ,tmpQQ);
            } else {
                tmpQ.set(nowQ);
            }
        } else {
            tmpQ.set(nowQ);
        }
        t.set(tmpQ,nowV,nowS);
        transGroup.setTransform(t);
    }
    public void initialize() {
        WakeupOnElapsedTime w = new WakeupOnElapsedTime(elapsedTime);
        wakeupOn(w);
    }
    Quat4d tmpQ = new Quat4d();
    static Quat4d tmpQQ = new Quat4d(1.0*Math.sin(Math.PI/4.0),0.0,0.0,Math.cos(Math.PI/4.0));
    @SuppressWarnings("unchecked")
    public void processStimulus(Enumeration criteria) {
        if (universe==null) {
            WakeupOnElapsedTime w = new WakeupOnElapsedTime(elapsedTime);
            wakeupOn(w);
        } else {
            WakeupOnBehaviorPost w = null;
            w = new WakeupOnBehaviorPost(universe.getTimerBehavior(),1);
            wakeupOn(w);
        }

        if (needRecalc==false)
            return;
        nowTrans.sub(nextV,nowV);
        nowTrans.scale(0.2);
        nowV.add(nowTrans);
        if (autoDirectionControl) {
            autoQuatControl();
        } else if (billboardControl) {
            billboardControl();
        } else {
            nowQ.normalize();
            nowQ.interpolate(nextQ,0.2);
            nowQ.normalize();
        }
        nowS = nowS + 0.2*(nextS - nowS);
        if (universe!=null) {
            if (universe.scene.upperDirection==A3Object.UpperDirection.Z) {
                tmpQ.mul(nowQ,tmpQQ);
            } else {
                tmpQ.set(nowQ);
            }
        } else {
            tmpQ.set(nowQ);
        }
        t.set(tmpQ,nowV,nowS);
        transGroup.setTransform(t);
        if (!isInterpolate) {
            needRecalc = false;
        }
    }
    Quat4d calQuat(Vector3d front,Vector3d up) {
        boolean isZ = false;
        if (universe!=null)
            if (universe.scene.upperDirection==A3Object.UpperDirection.Z)
                isZ=true;

        up.normalize();
        front.normalize();
        //なぜかm.get(nowQ)が上手くいかないときがある。
        //原因はよくわかってない。しょうがないので強引に
        //以下のif文を入れる。
        if ((Math.abs(front.x)<0.0001)&&(front.z<0.0)) {
            front.x=0.0001;
            front.normalize();
        }
        double d = front.dot(up);
        Vector3d vTmp = new Vector3d(front);
        vTmp.scale(d);
        Vector3d top = new Vector3d(up);
        top.sub(vTmp);
        if (top.lengthSquared()<0.00001) {
            //この場合とりあえず適当
            if (isZ) {
                front.set(0.0,-1.0,0.0);
                top.set(0.0,0.0,1.0);
            } else {
                front.set(0.0,0.0,1.0);
                top.set(0.0,1.0,0.0);
            }
        } else {
            top.normalize();
        }
        Vector3d right = new Vector3d();
        right.cross(front,top);

        Matrix4d m = new Matrix4d();
        if (isZ) {
            m.m00 = -right.x;m.m01 = -front.x;m.m02 = top.x;
            m.m10 = -right.y;m.m11 = -front.y;m.m12 = top.y;
            m.m20 = -right.z;m.m21 = -front.z;m.m22 = top.z;
        } else {
            m.m00 = -right.x;m.m01 = top.x;m.m02 = front.x;
            m.m10 = -right.y;m.m11 = top.y;m.m12 = front.y;
            m.m20 = -right.z;m.m21 = top.z;m.m22 = front.z;
        }
        Quat4d q = new Quat4d();
        m.get(q);
        return q;
    }
    void autoQuatControl() {
        Vector3d front = new Vector3d(); 
        front.sub(nextV,nowV);
        Vector3d up = new Vector3d(a3.upperVector);
        if (front.length()>universe.scene.cameraNowS/1000.0) {
            Quat4d q = calQuat(front,up);
            nowQ.set(q);
        }
    }
    void billboardControl() {
        Vector3d front = new Vector3d(); 
        front.sub(universe.scene.cameraNowV,nowV);
        Vector3d up = new Vector3d(a3.upperVector);
        if (front.length()>universe.scene.cameraNowS/1000.0) {
            Quat4d q = calQuat(front,up);
            nowQ.set(q);
        }
    }
    void setEnableBehavior(boolean b) {
        isInterpolate = b;
    }
    void setAutoDirectionControl(boolean b) {
        autoDirectionControl = b;
        if (autoDirectionControl&&billboardControl)
            billboardControl=false;
    }
    void setBillboardControl(boolean b) {
        billboardControl = b;
        if (billboardControl&&autoDirectionControl)
            autoDirectionControl=false;
    }
    void move(Vector3d v, Quat4d q, double s) {
        if (isInterpolate) {
            nextS = s;
            nextV.set(v);
            nextQ.set(q);
            nextQ.normalize();
        } else {
            nowS = s;
            nowV.set(v);
            nowQ.set(q);
            nextS = s;
            nextV.set(v);
            nextQ.set(q);
        }
        needRecalc = true;
    }
    void moveImmediately(Vector3d v, Quat4d q, double s) {
        nowS = s;
        nowV.set(v);
        nowQ.set(q);
        nextS = s;
        nextV.set(v);
        nextQ.set(q);
        if (universe!=null) {
            if (universe.scene.upperDirection==A3Object.UpperDirection.Z) {
                tmpQ.mul(nowQ,tmpQQ);
            } else {
                tmpQ.set(nowQ);
            }
        } else {
            tmpQ.set(nowQ);
        }
        t.set(tmpQ,nowV,nowS);
        transGroup.setTransform(t);
//        needRecalc = true;
    }
    void setLoc(Vector3d v) {
        if (isInterpolate) {
            nextV.set(v);
        } else {
            nowV.set(v);
            nextV.set(v);
        }
        needRecalc = true;
    }
    void setLocImmediately(Vector3d v) {
        nowV.set(v);
        nextV.set(v);
        if (universe!=null) {
            if (universe.scene.upperDirection==A3Object.UpperDirection.Z) {
                tmpQ.mul(nowQ,tmpQQ);
            } else {
                tmpQ.set(nowQ);
            }
        } else {
            tmpQ.set(nowQ);
        }
        t.set(tmpQ,nowV,nowS);
        transGroup.setTransform(t);
//        needRecalc = true;
    }
    Vector3d getLoc() {
        return new Vector3d(nowV);
    }
    void setQuat(Quat4d q) {
        if (isInterpolate) {
            nextQ.set(q);
        } else {
            nowQ.set(q);
            nextQ.set(q);
        }
        needRecalc = true;
    }
    void setQuatImmediately(Quat4d q) {
        nowQ.set(q);
        nextQ.set(q);
        if (universe!=null) {
            if (universe.scene.upperDirection==A3Object.UpperDirection.Z) {
                tmpQ.mul(nowQ,tmpQQ);
            } else {
                tmpQ.set(nowQ);
            }
        } else {
            tmpQ.set(nowQ);
        }
        t.set(tmpQ,nowV,nowS);
        transGroup.setTransform(t);
//        needRecalc = true;
    }
    Quat4d getQuat() {
        return new Quat4d(nowQ);
    }
    void setLookAtPoint(Vector3d lookAt) {
        Vector3d front = new Vector3d();
        front.sub(lookAt,nowV);
        Vector3d up = new Vector3d(a3.upperVector);
        Quat4d q = calQuat(front,up);
        nextQ.set(q);
        if (!isInterpolate) {
            nowQ.set(q);
        }
        needRecalc = true;
    }
    void setLookAtPointImmediately(Vector3d lookAt) {
        Vector3d front = new Vector3d();
        front.sub(lookAt,nowV);
        Vector3d up = new Vector3d(a3.upperVector);
        Quat4d q = calQuat(front,up);
        nextQ.set(q);
        nowQ.set(q);
        if (universe!=null) {
            if (universe.scene.upperDirection==A3Object.UpperDirection.Z) {
                tmpQ.mul(nowQ,tmpQQ);
            } else {
                tmpQ.set(nowQ);
            }
        } else {
            tmpQ.set(nowQ);
        }
        t.set(tmpQ,nowV,nowS);
        transGroup.setTransform(t);
//        needRecalc = true;
    }
    void setScale(double s) {
        if (isInterpolate) {
            nextS = s;
        } else {
            nowS = s;
            nextS = s;
        }
        needRecalc = true;
    }
    void setScaleImmediately(double s) {
        nowS = s;
        nextS = s;
        if (universe!=null) {
            if (universe.scene.upperDirection==A3Object.UpperDirection.Z) {
                tmpQ.mul(nowQ,tmpQQ);
            } else {
                tmpQ.set(nowQ);
            }
        } else {
            tmpQ.set(nowQ);
        }
        t.set(tmpQ,nowV,nowS);
        transGroup.setTransform(t);
//        needRecalc = true;
    }
    double getScale() {
        return nowS;
    }
    double getSpeed() {
        if (isInterpolate) {
            if (universe!=null)
                return nowTrans.length()/(TimerBehavior.elapsedTime/1000.0);
            else
                return nowTrans.length()/(elapsedTime/1000.0);
        } else {
            return 0.0;
        }
    }
    static void setSelected3DMarker(Node n) {
        selected3d_egg = n;
    }
    void setSelected3D(boolean b) {
        if (b&&(selected3d_bg==null)) {
            Node n = selected3d_egg.cloneTree();
            n.setPickable(false);
            selected3d_tg = new TransformGroup();
            selected3d_tg.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
            selected3d_tg.addChild(n);
            selected3d_bg = new BranchGroup();
            selected3d_bg.setCapability(BranchGroup.ALLOW_DETACH);
            selected3d_bg.addChild(selected3d_tg);
            adjustSelected3D();
            topGroup.addChild(selected3d_bg);
        } else if (!b && selected3d_bg!=null) {
            topGroup.removeChild(selected3d_bg);
            selected3d_bg = null;
            selected3d_tg = null;
        }
    }
    void adjustSelected3D() {
        Bounds b = transGroup.getBounds();
        if (b instanceof BoundingSphere) {
            BoundingSphere bs = (BoundingSphere)b;
            Point3d p = new Point3d();
            bs.getCenter(p);
            double r = bs.getRadius();
            Transform3D t = new Transform3D();
            t.setScale(r*nowS);
            p.scale(nowS);
            Vector3d v = new Vector3d();
            v.add(nowV,p);
            t.setTranslation(v);
            selected3d_tg.setTransform(t);
        } else {
            // TODO
        }
    }
    boolean isSelected3D() {
        if (selected3d_bg==null)
            return false;
        else
            return true;
    }
}
