/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.acerola3d.a3;

import com.sun.j3d.audioengines.javasound.JavaSoundMixer;
import java.awt.Point;
import java.awt.event.KeyListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import javax.media.j3d.AudioDevice;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.Light;
import javax.media.j3d.Locale;
import javax.media.j3d.Node;
import javax.media.j3d.PhysicalBody;
import javax.media.j3d.PhysicalEnvironment;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.View;
import javax.media.j3d.ViewPlatform;
import javax.media.j3d.VirtualUniverse;
import javax.vecmath.Point3d;
import javax.vecmath.Quat4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import jp.sourceforge.acerola3d.a3.A3Canvas;
import jp.sourceforge.acerola3d.a3.A3CanvasInterface;
import jp.sourceforge.acerola3d.a3.A3Controller;
import jp.sourceforge.acerola3d.a3.A3Listener;
import jp.sourceforge.acerola3d.a3.A3Object;
import jp.sourceforge.acerola3d.a3.A3Widget;
import jp.sourceforge.acerola3d.a3.CameraBehavior;
import jp.sourceforge.acerola3d.a3.Component2D;
import jp.sourceforge.acerola3d.a3.JA3Canvas;
import jp.sourceforge.acerola3d.a3.PickingBehavior;
import jp.sourceforge.acerola3d.a3.Scene;
import jp.sourceforge.acerola3d.a3.TimerBehavior;
import org.jdesktop.j3d.audioengines.joal.JOALMixer;

class A3VirtualUniverse
extends VirtualUniverse
implements A3CanvasInterface {
    A3CanvasInterface canvas = null;
    Canvas3D canvas3d = null;
    Locale locale;
    View view;
    BranchGroup rootGroup;
    TransformGroup tGroup;
    Transform3D transform;
    BranchGroup vpGroup;
    ViewPlatform vp;
    HashMap<Integer, Scene> scenes = new HashMap();
    Scene scene;
    TimerBehavior timerBehavior;
    PickingBehavior pickingBehavior;
    CameraBehavior cameraBehavior;
    Light headLight;

    A3VirtualUniverse(A3CanvasInterface c) {
        this.canvas = c;
        if (this.canvas instanceof A3Canvas) {
            this.init((Canvas3D)c);
        } else if (this.canvas instanceof JA3Canvas) {
            this.init(((JA3Canvas)this.canvas).getOffscreenCanvas3D());
        } else if (this.canvas instanceof A3Widget) {
            this.init(((A3Widget)this.canvas).tCanvas.getOffscreenCanvas3D());
        }
    }

    void init(Canvas3D c3d) {
        this.canvas3d = c3d;
        this.locale = new Locale((VirtualUniverse)this);
        PhysicalBody body = new PhysicalBody();
        PhysicalEnvironment environment = new PhysicalEnvironment();
        this.view = new View();
        this.view.addCanvas3D(this.canvas3d);
        this.view.setPhysicalBody(body);
        this.view.setPhysicalEnvironment(environment);
        this.view.setFrontClipDistance(0.1);
        this.view.setBackClipDistance(100.0);
        this.view.setUserHeadToVworldEnable(true);
        this.vpGroup = new BranchGroup();
        this.tGroup = new TransformGroup();
        this.tGroup.setCapability(18);
        this.tGroup.setCapability(17);
        this.tGroup.setCapability(14);
        this.tGroup.setCapability(13);
        this.vpGroup.addChild((Node)this.tGroup);
        this.transform = new Transform3D();
        this.tGroup.setTransform(this.transform);
        this.timerBehavior = new TimerBehavior();
        BoundingSphere bs = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), Double.MAX_VALUE);
        this.timerBehavior.setSchedulingBounds((Bounds)bs);
        this.tGroup.addChild((Node)this.timerBehavior);
        this.vp = new ViewPlatform();
        this.tGroup.addChild((Node)this.vp);
        this.headLight = new DirectionalLight();
        this.headLight.setCapability(13);
        this.headLight.setInfluencingBounds((Bounds)new BoundingSphere(new Point3d(0.0, 0.0, 0.0), Double.MAX_VALUE));
        this.headLight.setEnable(true);
        this.tGroup.addChild((Node)this.headLight);
        this.view.attachViewPlatform(this.vp);
        this.pickingBehavior = new PickingBehavior(this, this.view, this.tGroup, this.locale);
        this.vpGroup.addChild((Node)this.pickingBehavior);
        BoundingSphere sb = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), Double.MAX_VALUE);
        this.pickingBehavior.setSchedulingBounds((Bounds)sb);
        this.cameraBehavior = new CameraBehavior(this);
        this.vpGroup.addChild((Node)this.cameraBehavior);
        this.cameraBehavior.setSchedulingBounds((Bounds)sb);
        this.rootGroup = new BranchGroup();
        this.rootGroup.setCapability(14);
        this.rootGroup.setCapability(13);
        this.rootGroup.addChild((Node)this.vpGroup);
        this.locale.addBranchGraph(this.rootGroup);
        JOALMixer mixer = null;
        String mixerClassName = AccessController.doPrivilegedWithCombiner(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("j3d.audiodevice");
            }
        });
        System.out.println(mixerClassName);
        if (mixerClassName != null) {
            try {
                Class<?> c = Class.forName(mixerClassName);
                Class<AudioDevice> mixerClass = c.asSubclass(AudioDevice.class);
                Constructor<AudioDevice> constructor = mixerClass.getConstructor(PhysicalEnvironment.class);
                mixer = constructor.newInstance(environment);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (mixer == null) {
            try {
                mixer = new JOALMixer(environment);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (mixer == null) {
            try {
                mixer = new JavaSoundMixer(environment);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (mixer == null) {
            System.out.println("null AudioDevice!");
        } else {
            System.out.println(mixer.getClass().getName());
            environment.setAudioDevice((AudioDevice)mixer);
            try {
                mixer.initialize();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.scene = new Scene(this, 0);
        this.scenes.put(0, this.scene);
        this.scene.activate();
    }

    TimerBehavior getTimerBehavior() {
        return this.timerBehavior;
    }

    void prepareVirtualUniverse() {
    }

    @Override
    public void add(A3Object a) {
        this.scene.add(a);
    }

    @Override
    public void del(A3Object a) {
        this.scene.del(a);
    }

    @Override
    public void delAll() {
        this.scene.delAll();
    }

    @Override
    public void setBackground(A3Object a) {
        this.scene.setBackground(a);
    }

    @Override
    public void delBackground() {
        this.scene.delBackground();
    }

    @Override
    public void setAvatar(A3Object a) {
        this.scene.setAvatar(a);
    }

    @Override
    public A3Object getAvatar() {
        return this.scene.getAvatar();
    }

    @Override
    public void addA3Listener(A3Listener l) {
        this.pickingBehavior.addA3Listener(l);
    }

    @Override
    public void removeA3Listener(A3Listener l) {
        this.pickingBehavior.removeA3Listener(l);
    }

    @Override
    public void setDefaultCameraLoc(double x, double y, double z) {
        this.scene.setDefaultCameraLoc(x, y, z);
    }

    @Override
    public void setDefaultCameraLoc(Vector3d loc) {
        this.scene.setDefaultCameraLoc(loc);
    }

    @Override
    public void setDefaultCameraQuat(double x, double ay, double z, double w) {
        this.scene.setDefaultCameraQuat(x, ay, z, w);
    }

    @Override
    public void setDefaultCameraQuat(Quat4d quat) {
        this.scene.setDefaultCameraQuat(quat);
    }

    @Override
    public void setDefaultCameraRot(double x, double y, double z) {
        this.scene.setDefaultCameraRot(x, y, z);
    }

    @Override
    public void setDefaultCameraRot(Vector3d rot) {
        this.scene.setDefaultCameraRot(rot);
    }

    @Override
    public void setDefaultCameraScale(double s) {
        this.scene.setDefaultCameraScale(s);
    }

    @Override
    public void resetCamera() {
        this.scene.resetCamera();
    }

    @Override
    public void setCameraLoc(double x, double y, double z) {
        this.scene.setCameraLoc(x, y, z);
    }

    @Override
    public void setCameraLoc(Vector3d loc) {
        this.scene.setCameraLoc(loc);
    }

    @Override
    public void setCameraLocImmediately(double x, double y, double z) {
        this.scene.setCameraLocImmediately(x, y, z);
    }

    @Override
    public void setCameraLocImmediately(Vector3d loc) {
        this.scene.setCameraLocImmediately(loc);
    }

    @Override
    public Vector3d getCameraLoc() {
        return this.scene.getCameraLoc();
    }

    @Override
    public void setCameraQuat(double x, double y, double z, double w) {
        this.scene.setCameraQuat(x, y, z, w);
    }

    @Override
    public void setCameraQuat(Quat4d quat) {
        this.scene.setCameraQuat(quat);
    }

    @Override
    public void setCameraQuatImmediately(double x, double y, double z, double w) {
        this.scene.setCameraQuatImmediately(x, y, z, w);
    }

    @Override
    public void setCameraQuatImmediately(Quat4d quat) {
        this.scene.setCameraQuatImmediately(quat);
    }

    @Override
    public Quat4d getCameraQuat() {
        return this.scene.getCameraQuat();
    }

    @Override
    public void setCameraRot(double x, double y, double z) {
        this.scene.setCameraRot(x, y, z);
    }

    @Override
    public void setCameraRot(Vector3d rot) {
        this.scene.setCameraRot(rot);
    }

    @Override
    public void setCameraRotImmediately(double x, double y, double z) {
        this.scene.setCameraRotImmediately(x, y, z);
    }

    @Override
    public void setCameraRotImmediately(Vector3d rot) {
        this.scene.setCameraRotImmediately(rot);
    }

    @Override
    public void setCameraScale(double s) {
        this.scene.setCameraScale(s);
    }

    @Override
    public void setCameraScaleImmediately(double s) {
        this.scene.setCameraScaleImmediately(s);
    }

    @Override
    public double getCameraScale() {
        return this.scene.getCameraScale();
    }

    @Override
    public void setCameraLookAtPoint(Vector3d lookAt) {
        this.scene.setCameraLookAtPoint(lookAt);
    }

    @Override
    public void setCameraLookAtPointImmediately(Vector3d lookAt) {
        this.scene.setCameraLookAtPointImmediately(lookAt);
    }

    @Override
    public void setCameraLookAtPoint(double x, double y, double z) {
        this.scene.setCameraLookAtPoint(x, y, z);
    }

    @Override
    public void setCameraLookAtPointImmediately(double x, double y, double z) {
        this.scene.setCameraLookAtPointImmediately(x, y, z);
    }

    @Override
    public void setCameraLookAtPoint(Vector3d lookAt, Vector3d up) {
        this.scene.setCameraLookAtPoint(lookAt, up);
    }

    @Override
    public void setCameraLookAtPoint(double x, double y, double z, Vector3d up) {
        this.scene.setCameraLookAtPoint(x, y, z, up);
    }

    @Override
    public void setCameraLookAtPointImmediately(double x, double y, double z, Vector3d up) {
        this.scene.setCameraLookAtPointImmediately(x, y, z, up);
    }

    @Override
    public void setHeadLightEnable(boolean b) {
        this.headLight.setEnable(b);
    }

    @Override
    public void setNavigationMode(A3CanvasInterface.NaviMode m) {
        this.scene.setNavigationMode(m);
    }

    @Override
    public void setNavigationSpeed(double s) {
        this.scene.setNavigationSpeed(s);
    }

    @Override
    public double getNavigationSpeed() {
        return this.scene.getNavigationSpeed();
    }

    @Override
    public void setA3Controller(A3Controller c) {
        this.scene.setA3Controller(c);
    }

    @Override
    public Point3d canvasToVirtualCS(int x, int y) {
        return this.pickingBehavior.canvasToVirtualCS(x, y);
    }

    @Override
    public Point3d canvasToVirtualCS(int x, int y, double dis) {
        return this.pickingBehavior.canvasToVirtualCS(x, y, dis);
    }

    @Override
    public Point3d canvasToPhysicalCS(int x, int y) {
        return this.pickingBehavior.canvasToPhysicalCS(x, y);
    }

    @Override
    public Point3d canvasToPhysicalCS(int x, int y, double dis) {
        return this.pickingBehavior.canvasToPhysicalCS(x, y, dis);
    }

    @Override
    public Vector3d physicalCSToVirtualCS(Vector3d v) {
        Point3d p = this.pickingBehavior.physicalCSToVirtualCS(new Point3d((Tuple3d)v));
        return new Vector3d((Tuple3d)p);
    }

    @Override
    public Point physicalCSToCanvas(Point3d p) {
        return this.pickingBehavior.physicalCSToCanvas(p);
    }

    @Override
    public Point virtualCSToCanvas(Point3d p) {
        return this.pickingBehavior.virtualCSToCanvas(p);
    }

    @Override
    public Vector3d virtualCSToPhysicalCS(Vector3d v) {
        Point3d p = this.pickingBehavior.virtualCSToPhysicalCS(new Point3d((Tuple3d)v));
        return new Vector3d((Tuple3d)p);
    }

    @Override
    public Vector3d getCameraUnitVecX() {
        Vector3d v = this.physicalCSToVirtualCS(new Vector3d(1.0, 0.0, 0.0));
        v.sub((Tuple3d)this.scene.cameraNowV);
        return v;
    }

    @Override
    public Vector3d getCameraUnitVecY() {
        Vector3d v = this.physicalCSToVirtualCS(new Vector3d(0.0, 1.0, 0.0));
        v.sub((Tuple3d)this.scene.cameraNowV);
        return v;
    }

    @Override
    public Vector3d getCameraUnitVecZ() {
        Vector3d v = this.physicalCSToVirtualCS(new Vector3d(0.0, 0.0, 1.0));
        v.sub((Tuple3d)this.scene.cameraNowV);
        return v;
    }

    @Override
    public A3Object pickA3(int x, int y) {
        return this.pickingBehavior.pickA3(x, y);
    }

    @Override
    public void prepareScene(int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            s = new Scene(this, scene);
            this.scenes.put(scene, s);
        }
    }

    @Override
    public void changeActiveScene(int s) {
        Scene newScene = this.scenes.get(s);
        if (newScene == null) {
            throw new IllegalArgumentException();
        }
        this.scene.deactivate();
        this.scene = newScene;
        this.transform.set(this.scene.cameraNowQ, this.scene.cameraNowV, this.scene.cameraNowS);
        this.tGroup.setTransform(this.transform);
        this.scene.activate();
    }

    @Override
    public void add(A3Object a, int s) {
        Scene tmpScene = this.scenes.get(s);
        if (tmpScene == null) {
            throw new IllegalArgumentException();
        }
        tmpScene.add(a);
    }

    @Override
    public void del(A3Object a, int s) {
        Scene tmpScene = this.scenes.get(s);
        if (tmpScene == null) {
            throw new IllegalArgumentException();
        }
        tmpScene.del(a);
    }

    @Override
    public void setDefaultCameraLoc(double x, double y, double z, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.setDefaultCameraLoc(x, y, z);
    }

    @Override
    public void setDefaultCameraLoc(Vector3d loc, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.setDefaultCameraLoc(loc);
    }

    @Override
    public void setDefaultCameraQuat(double x, double y, double z, double w, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.setDefaultCameraQuat(x, y, z, w);
    }

    @Override
    public void setDefaultCameraQuat(Quat4d quat, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.setDefaultCameraQuat(quat);
    }

    @Override
    public void setDefaultCameraRot(double x, double y, double z, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.setDefaultCameraRot(x, y, z);
    }

    @Override
    public void setDefaultCameraRot(Vector3d rot, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.setDefaultCameraRot(rot);
    }

    @Override
    public void setDefaultCameraScale(double s, int scene) {
        Scene sTmp = this.scenes.get(scene);
        if (sTmp == null) {
            throw new IllegalArgumentException();
        }
        sTmp.setDefaultCameraScale(s);
    }

    @Override
    public void resetCamera(int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.resetCamera();
    }

    @Override
    public void setCameraLoc(double x, double y, double z, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.setCameraLoc(x, y, z);
    }

    @Override
    public void setCameraLoc(Vector3d loc, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.setCameraLoc(loc);
    }

    @Override
    public void setCameraLocImmediately(double x, double y, double z, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.setCameraLocImmediately(x, y, z);
    }

    @Override
    public void setCameraLocImmediately(Vector3d loc, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.setCameraLocImmediately(loc);
    }

    @Override
    public Vector3d getCameraLoc(int scene) {
        Scene s = this.scenes.get(scene);
        if (s != null) {
            return s.getCameraLoc();
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void setCameraQuat(double x, double y, double z, double w, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.setCameraQuat(x, y, z, w);
    }

    @Override
    public void setCameraQuat(Quat4d quat, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.setCameraQuat(quat);
    }

    @Override
    public void setCameraQuatImmediately(double x, double y, double z, double w, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.setCameraQuatImmediately(x, y, z, w);
    }

    @Override
    public void setCameraQuatImmediately(Quat4d quat, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.setCameraQuatImmediately(quat);
    }

    @Override
    public Quat4d getCameraQuat(int scene) {
        Scene s = this.scenes.get(scene);
        if (s != null) {
            return s.getCameraQuat();
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void setCameraRot(double x, double y, double z, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.setCameraRot(x, y, z);
    }

    @Override
    public void setCameraRot(Vector3d rot, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.setCameraRot(rot);
    }

    @Override
    public void setCameraRotImmediately(double x, double y, double z, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.setCameraRotImmediately(x, y, z);
    }

    @Override
    public void setCameraRotImmediately(Vector3d rot, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.setCameraRotImmediately(rot);
    }

    @Override
    public void setCameraScale(double s, int scene) {
        Scene sTmp = this.scenes.get(scene);
        if (sTmp == null) {
            throw new IllegalArgumentException();
        }
        sTmp.setCameraScale(s);
    }

    @Override
    public void setCameraScaleImmediately(double s, int scene) {
        Scene sTmp = this.scenes.get(scene);
        if (sTmp == null) {
            throw new IllegalArgumentException();
        }
        sTmp.setCameraScaleImmediately(s);
    }

    @Override
    public double getCameraScale(int scene) {
        Scene s = this.scenes.get(scene);
        if (s != null) {
            return s.getCameraScale();
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void setCameraLookAtPoint(Vector3d lookAt, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.setCameraLookAtPoint(lookAt);
    }

    @Override
    public void setCameraLookAtPointImmediately(Vector3d lookAt, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.setCameraLookAtPointImmediately(lookAt);
    }

    @Override
    public void setCameraLookAtPoint(double x, double y, double z, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.setCameraLookAtPoint(x, y, z);
    }

    @Override
    public void setCameraLookAtPointImmediately(double x, double y, double z, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.setCameraLookAtPointImmediately(x, y, z);
    }

    @Override
    public void setCameraLookAtPoint(Vector3d lookAt, Vector3d up, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.setCameraLookAtPoint(lookAt, up);
    }

    @Override
    public void setCameraLookAtPointImmediately(Vector3d lookAt, Vector3d up, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.setCameraLookAtPointImmediately(lookAt, up);
    }

    @Override
    public void setCameraLookAtPoint(double x, double y, double z, Vector3d up, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.setCameraLookAtPoint(x, y, z, up);
    }

    @Override
    public void setCameraLookAtPointImmediately(double x, double y, double z, Vector3d up, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.setCameraLookAtPointImmediately(x, y, z, up);
    }

    @Override
    public void setNavigationMode(A3CanvasInterface.NaviMode m, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.setNavigationMode(m);
    }

    @Override
    public void setNavigationSpeed(double s, int scene) {
        Scene sTmp = this.scenes.get(scene);
        if (sTmp == null) {
            throw new IllegalArgumentException();
        }
        sTmp.setNavigationSpeed(s);
    }

    @Override
    public double getNavigationSpeed(int scene) {
        Scene s = this.scenes.get(scene);
        if (s != null) {
            return s.getNavigationSpeed();
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void setA3Controller(A3Controller c, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.setA3Controller(c);
    }

    @Override
    public void setBackground(A3Object a, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.setBackground(a);
    }

    @Override
    public void delBackground(int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.delBackground();
    }

    @Override
    public void setAvatar(A3Object a, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.setAvatar(a);
    }

    @Override
    public A3Object getAvatar(int scene) {
        Scene s = this.scenes.get(scene);
        if (s != null) {
            return s.getAvatar();
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void add(Component2D c) {
        this.scene.add(c);
    }

    @Override
    public void del(Component2D c) {
        this.scene.del(c);
    }

    @Override
    public void add(Component2D c, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.add(c);
    }

    @Override
    public void del(Component2D c, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.del(c);
    }

    ArrayList<Component2D> getComponents2D() {
        return this.scene.getComponents2D();
    }

    @Override
    public void addLockedA3(A3Object a) {
        this.scene.addLockedA3(a);
    }

    @Override
    public void delLockedA3(A3Object a) {
        this.scene.delLockedA3(a);
    }

    @Override
    public void delAllLockedA3() {
        this.scene.delAllLockedA3();
    }

    @Override
    public void addLockedA3(A3Object a, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.addLockedA3(a);
    }

    @Override
    public void delLockedA3(A3Object a, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.delLockedA3(a);
    }

    @Override
    public void delAllLockedA3(int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.delAllLockedA3();
    }

    @Override
    public void setUpperDirection(A3Object.UpperDirection d) {
        this.scene.setUpperDirection(d);
    }

    @Override
    public void setUpperDirection(A3Object.UpperDirection d, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.setUpperDirection(d);
    }

    @Override
    public A3Object.UpperDirection getUpperDirection() {
        return this.scene.upperDirection;
    }

    @Override
    public A3Object.UpperDirection getUpperDirection(int scene) {
        Scene s = this.scenes.get(scene);
        if (s != null) {
            return s.upperDirection;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void addKeyListener(KeyListener l) {
    }

    @Override
    public void removeKeyListener(KeyListener l) {
    }

    @Override
    public void saveImage(File file) throws IOException {
    }

    @Override
    public void setCameraLookAtPointImmediately(Vector3d lookAt, Vector3d up) {
    }
}

