/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.acerola3d.a3;

import java.util.Enumeration;
import javax.media.j3d.Behavior;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupOnBehaviorPost;
import javax.media.j3d.WakeupOnElapsedTime;
import javax.vecmath.Point3d;
import javax.vecmath.Quat4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple4d;
import javax.vecmath.Vector3d;
import jp.sourceforge.acerola3d.a3.A3BranchGroup;
import jp.sourceforge.acerola3d.a3.A3Object;
import jp.sourceforge.acerola3d.a3.A3VirtualUniverse;
import jp.sourceforge.acerola3d.a3.Action3D;
import jp.sourceforge.acerola3d.a3.Selected3D;
import jp.sourceforge.acerola3d.a3.Util;

class A3Behavior
extends Behavior {
    static long elapsedTime = 33L;
    static Node selected3d_egg = new Selected3D();
    A3Object a3 = null;
    A3BranchGroup topGroup;
    TransformGroup transGroup;
    Transform3D t;
    A3VirtualUniverse universe = null;
    boolean isInterpolate = false;
    boolean autoDirectionControl = false;
    boolean billboardControl = false;
    double nextS = 1.0;
    Quat4d nextQ = new Quat4d(0.0, 0.0, 0.0, 1.0);
    Vector3d nextV = new Vector3d();
    double nowS = 1.0;
    Quat4d nowQ = new Quat4d(0.0, 0.0, 0.0, 1.0);
    Vector3d nowV = new Vector3d();
    boolean needRecalc = true;
    Vector3d nowTrans = new Vector3d();
    BranchGroup selected3d_bg = null;
    TransformGroup selected3d_tg = null;
    double interpolateRatio = 0.1;
    Quat4d actualQ = new Quat4d();
    static Quat4d fixQ = new Quat4d(1.0 * Math.sin(0.7853981633974483), 0.0, 0.0, Math.cos(0.7853981633974483));

    A3Behavior(A3Object a) {
        this.a3 = a;
        this.topGroup = new A3BranchGroup();
        this.topGroup.setCapability(13);
        this.topGroup.setCapability(14);
        this.topGroup.setA3(this.a3);
        this.t = new Transform3D();
        this.transGroup = new TransformGroup(this.t);
        this.transGroup.setCapability(18);
        this.transGroup.addChild((Node)this);
        this.topGroup.addChild((Node)this.transGroup);
    }

    void setA3VirtualUniverse(A3VirtualUniverse u) {
        this.universe = u;
    }

    void setNode(Node n) {
        this.transGroup.addChild(n);
    }

    boolean isZ() {
        if (this.universe != null) {
            return this.universe.scene.upperDirection == A3Object.UpperDirection.Z;
        }
        return false;
    }

    void setNow() {
        if (this.isZ()) {
            this.actualQ.mul(this.nowQ, fixQ);
        } else {
            this.actualQ.set((Tuple4d)this.nowQ);
        }
        this.t.set(this.actualQ, this.nowV, this.nowS);
        this.transGroup.setTransform(this.t);
        if (this.a3 instanceof Action3D) {
            ((Action3D)this.a3).setSoundLocQuat(this.nowV, this.actualQ);
        }
    }

    void init() {
        this.setNow();
    }

    public void initialize() {
        WakeupOnElapsedTime w = new WakeupOnElapsedTime(elapsedTime);
        this.wakeupOn((WakeupCondition)w);
    }

    public void processStimulus(Enumeration criteria) {
        WakeupOnElapsedTime w;
        long et;
        if (this.universe == null) {
            et = elapsedTime;
            w = new WakeupOnElapsedTime(elapsedTime);
            this.wakeupOn((WakeupCondition)w);
        } else {
            et = this.universe.elapsedTime;
            w = null;
            w = new WakeupOnBehaviorPost((Behavior)this.universe.getTimerBehavior(), 1);
            this.wakeupOn((WakeupCondition)w);
        }
        double ratio = 1.0 - Math.pow(this.interpolateRatio, (double)et / 1000.0);
        if (!this.needRecalc) {
            return;
        }
        this.nowTrans.sub((Tuple3d)this.nextV, (Tuple3d)this.nowV);
        this.nowTrans.scale(ratio);
        this.nowV.add((Tuple3d)this.nowTrans);
        if (this.autoDirectionControl) {
            this.autoQuatControl();
        } else if (this.billboardControl) {
            this.billboardControl();
        } else {
            this.nowQ.normalize();
            this.nowQ.interpolate(this.nextQ, ratio);
            this.nowQ.normalize();
        }
        this.nowS += ratio * (this.nextS - this.nowS);
        this.setNow();
        if (!this.isInterpolate) {
            this.needRecalc = false;
        }
    }

    void autoQuatControl() {
        Vector3d front = new Vector3d();
        front.sub((Tuple3d)this.nextV, (Tuple3d)this.nowV);
        if (front.length() > this.universe.scene.cameraNowS / 1000.0) {
            Vector3d up = new Vector3d(this.a3.upperVector);
            if (this.isZ()) {
                this.nowQ.set((Tuple4d)Util.frontFacingQuat_A3Z(front, up));
            } else {
                this.nowQ.set((Tuple4d)Util.frontFacingQuat_A3Y(front, up));
            }
        }
    }

    void billboardControl() {
        Vector3d front = new Vector3d();
        front.sub((Tuple3d)this.universe.scene.cameraNowV, (Tuple3d)this.nowV);
        if (front.length() > this.universe.scene.cameraNowS / 1000.0) {
            Vector3d up = new Vector3d(this.a3.upperVector);
            if (this.isZ()) {
                this.nowQ.set((Tuple4d)Util.frontFacingQuat_A3Z(front, up));
            } else {
                this.nowQ.set((Tuple4d)Util.frontFacingQuat_A3Y(front, up));
            }
        }
    }

    void setEnableBehavior(boolean b) {
        this.isInterpolate = b;
    }

    void setInterpolateRatio(double ir) {
        this.interpolateRatio = ir;
    }

    void setAutoDirectionControl(boolean b) {
        this.autoDirectionControl = b;
        if (this.autoDirectionControl && this.billboardControl) {
            this.billboardControl = false;
        }
    }

    void setBillboardControl(boolean b) {
        this.billboardControl = b;
        if (this.billboardControl && this.autoDirectionControl) {
            this.autoDirectionControl = false;
        }
    }

    void move(Vector3d v, Quat4d q, double s) {
        if (this.isInterpolate) {
            this.nextS = s;
            this.nextV.set((Tuple3d)v);
            this.nextQ.set((Tuple4d)q);
            this.nextQ.normalize();
        } else {
            this.nowS = s;
            this.nowV.set((Tuple3d)v);
            this.nowQ.set((Tuple4d)q);
            this.nextS = s;
            this.nextV.set((Tuple3d)v);
            this.nextQ.set((Tuple4d)q);
        }
        this.needRecalc = true;
    }

    void moveImmediately(Vector3d v, Quat4d q, double s) {
        this.nowS = s;
        this.nowV.set((Tuple3d)v);
        this.nowQ.set((Tuple4d)q);
        this.nextS = s;
        this.nextV.set((Tuple3d)v);
        this.nextQ.set((Tuple4d)q);
        this.needRecalc = true;
    }

    void setLoc(Vector3d v) {
        if (this.isInterpolate) {
            this.nextV.set((Tuple3d)v);
        } else {
            this.nowV.set((Tuple3d)v);
            this.nextV.set((Tuple3d)v);
        }
        this.needRecalc = true;
    }

    void setLocImmediately(Vector3d v) {
        this.nowV.set((Tuple3d)v);
        this.nextV.set((Tuple3d)v);
        this.needRecalc = true;
    }

    Vector3d getLoc() {
        return new Vector3d(this.nowV);
    }

    void setQuat(Quat4d q) {
        if (this.isInterpolate) {
            this.nextQ.set((Tuple4d)q);
        } else {
            this.nowQ.set((Tuple4d)q);
            this.nextQ.set((Tuple4d)q);
        }
        this.needRecalc = true;
    }

    void setQuatImmediately(Quat4d q) {
        this.nowQ.set((Tuple4d)q);
        this.nextQ.set((Tuple4d)q);
        this.needRecalc = true;
    }

    Quat4d getQuat() {
        return new Quat4d(this.nowQ);
    }

    void setLookAtPoint(Vector3d lookAt) {
        Vector3d front = new Vector3d();
        front.sub((Tuple3d)lookAt, (Tuple3d)this.nowV);
        Vector3d up = new Vector3d(this.a3.upperVector);
        Quat4d q = null;
        q = this.isZ() ? Util.frontFacingQuat_A3Z(front, up) : Util.frontFacingQuat_A3Y(front, up);
        this.nextQ.set((Tuple4d)q);
        if (!this.isInterpolate) {
            this.nowQ.set((Tuple4d)q);
        }
        this.needRecalc = true;
    }

    void setLookAtPointImmediately(Vector3d lookAt) {
        Vector3d front = new Vector3d();
        front.sub((Tuple3d)lookAt, (Tuple3d)this.nowV);
        Vector3d up = new Vector3d(this.a3.upperVector);
        Quat4d q = null;
        q = this.isZ() ? Util.frontFacingQuat_A3Z(front, up) : Util.frontFacingQuat_A3Y(front, up);
        this.nextQ.set((Tuple4d)q);
        this.nowQ.set((Tuple4d)q);
        this.needRecalc = true;
    }

    void setScale(double s) {
        if (this.isInterpolate) {
            this.nextS = s;
        } else {
            this.nowS = s;
            this.nextS = s;
        }
        this.needRecalc = true;
    }

    void setScaleImmediately(double s) {
        this.nowS = s;
        this.nextS = s;
        this.needRecalc = true;
    }

    double getScale() {
        return this.nowS;
    }

    double getSpeed() {
        if (this.isInterpolate) {
            if (this.universe != null) {
                return this.nowTrans.length() / ((double)this.universe.elapsedTime / 1000.0);
            }
            return this.nowTrans.length() / ((double)elapsedTime / 1000.0);
        }
        return 0.0;
    }

    static void setSelected3DMarker(Node n) {
        selected3d_egg = n;
    }

    void setSelected3D(boolean b) {
        if (b && this.selected3d_bg == null) {
            Node n = selected3d_egg.cloneTree();
            n.setPickable(false);
            this.selected3d_tg = new TransformGroup();
            this.selected3d_tg.setCapability(18);
            this.selected3d_tg.addChild(n);
            this.selected3d_bg = new BranchGroup();
            this.selected3d_bg.setCapability(17);
            this.selected3d_bg.addChild((Node)this.selected3d_tg);
            this.adjustSelected3D();
            this.topGroup.addChild((Node)this.selected3d_bg);
        } else if (!b && this.selected3d_bg != null) {
            this.topGroup.removeChild((Node)this.selected3d_bg);
            this.selected3d_bg = null;
            this.selected3d_tg = null;
        }
    }

    void adjustSelected3D() {
        Bounds b = this.transGroup.getBounds();
        if (b instanceof BoundingSphere) {
            BoundingSphere bs = (BoundingSphere)b;
            Point3d p = new Point3d();
            bs.getCenter(p);
            double r = bs.getRadius();
            Transform3D t = new Transform3D();
            t.setScale(r * this.nowS);
            p.scale(this.nowS);
            Vector3d v = new Vector3d();
            v.add((Tuple3d)this.nowV, (Tuple3d)p);
            t.setTranslation(v);
            this.selected3d_tg.setTransform(t);
        }
    }

    boolean isSelected3D() {
        return this.selected3d_bg != null;
    }
}

