/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.acerola3d.a3;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.media.j3d.Behavior;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Group;
import javax.media.j3d.MediaContainer;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupOnBehaviorPost;
import javax.media.j3d.WakeupOnElapsedTime;
import javax.vecmath.Point3d;
import javax.vecmath.Quat4d;
import javax.vecmath.Vector3d;
import jp.sourceforge.acerola3d.a3.A3Object;
import jp.sourceforge.acerola3d.a3.A3VirtualUniverse;
import jp.sourceforge.acerola3d.a3.Action3D;
import jp.sourceforge.acerola3d.a3.Action3DData;
import jp.sourceforge.acerola3d.a3.Motion;

class ActionBehavior
extends Behavior
implements Cloneable {
    static BoundingSphere bounding = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), Double.MAX_VALUE);
    static final int S0 = 0;
    static final int S1 = 1;
    static final int S2 = 2;
    static final int S3 = 3;
    static final int S4 = 4;
    static final int ACTION_QUEUE_SIZE = 10;
    int actionNo = 0;
    boolean immediatelyFlag = false;
    int playCount = 0;
    int playStatus = 0;
    boolean loopFlag;
    ArrayList<Integer> actionQueue = new ArrayList();
    Action3DData a3Data;
    BranchGroup allBranchGroup = null;
    A3VirtualUniverse universe = null;
    long motionLength;
    int elapsedTime;
    Motion.Mode mode = Motion.Mode.PLAY;
    long timeOffset = 0L;
    long pauseTime;
    Action3D a3;
    long segnoTime;
    long dalsegnoTime;
    long epilogueStartTime;
    long epilogueEndTime;

    public ActionBehavior(Action3D action3d, Action3DData action3DData) {
        this.a3 = action3d;
        this.a3Data = action3DData;
        this.a3Data.construct3DNode(this.a3);
        this.actionNo = 0;
        this.resetParameters();
        this.setSchedulingBounds((Bounds)bounding);
        this.allBranchGroup = new BranchGroup();
        this.allBranchGroup.addChild(this.a3Data.getNode());
        this.allBranchGroup.addChild((Node)this);
    }

    void setA3VirtualUniverse(A3VirtualUniverse u) {
        this.universe = u;
    }

    void resetBalloonParameters() {
        if (this.a3.balloon != null) {
            double x = this.a3Data.actions[this.actionNo].rightBalloonOffset[0];
            double y = this.a3Data.actions[this.actionNo].rightBalloonOffset[1];
            this.a3.balloon.setOffset(A3Object.BalloonDir.RIGHT, x, y);
            x = this.a3Data.actions[this.actionNo].leftBalloonOffset[0];
            y = this.a3Data.actions[this.actionNo].leftBalloonOffset[1];
            this.a3.balloon.setOffset(A3Object.BalloonDir.LEFT, x, y);
            x = this.a3Data.actions[this.actionNo].topBalloonOffset[0];
            y = this.a3Data.actions[this.actionNo].topBalloonOffset[1];
            this.a3.balloon.setOffset(A3Object.BalloonDir.TOP, x, y);
            x = this.a3Data.actions[this.actionNo].bottomBalloonOffset[0];
            y = this.a3Data.actions[this.actionNo].bottomBalloonOffset[1];
            this.a3.balloon.setOffset(A3Object.BalloonDir.BOTTOM, x, y);
            this.a3.balloon.direction = this.a3Data.actions[this.actionNo].balloonDirection;
        }
    }

    void resetLabelParameters() {
        if (this.a3.label != null) {
            double x = this.a3Data.actions[this.actionNo].labelOffset[0];
            double y = this.a3Data.actions[this.actionNo].labelOffset[1];
            this.a3.label.setOffset(x, y);
        }
    }

    void resetParameters() {
        this.playCount = 0;
        this.playStatus = 0;
        this.immediatelyFlag = false;
        this.timeOffset = System.currentTimeMillis();
        this.loopFlag = this.a3Data.actions[this.actionNo].loopFlag;
        this.motionLength = (long)(this.a3Data.actions[this.actionNo].getMotionLength() * 1000.0);
        this.elapsedTime = (int)(this.a3Data.actions[this.actionNo].motion.getDefaultFrameTime() * 1000.0);
        this.segnoTime = (long)(this.a3Data.actions[this.actionNo].segno * 1000.0);
        this.dalsegnoTime = (long)(this.a3Data.actions[this.actionNo].dalsegno * 1000.0);
        if (this.dalsegnoTime < 0L) {
            this.dalsegnoTime = this.motionLength;
        }
        if (this.loopFlag) {
            this.epilogueStartTime = Long.MAX_VALUE;
            this.epilogueEndTime = Long.MAX_VALUE;
        } else {
            this.epilogueStartTime = this.dalsegnoTime;
            this.epilogueEndTime = this.motionLength;
        }
        this.resetBalloonParameters();
        this.resetLabelParameters();
    }

    void doChangeAction(int newActionNo) {
        this.a3Data.actions[this.actionNo].stop();
        this.actionNo = newActionNo;
        Group n = this.a3Data.actions[this.actionNo].getRootGroup();
        this.a3Data.allActionBranchGroup.removeAllChildren();
        this.a3Data.allActionBranchGroup.addChild((Node)n);
        this.a3Data.actions[this.actionNo].start();
        this.resetParameters();
        if (this.a3.isSelected3D()) {
            this.a3.behavior.adjustSelected3D();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void init() {
        ArrayList<Integer> arrayList = this.actionQueue;
        synchronized (arrayList) {
            if (this.actionQueue.size() > 0) {
                int newActionNo = this.actionQueue.remove(0);
                this.doChangeAction(newActionNo);
            }
        }
    }

    public void initialize() {
        if (this.elapsedTime == 0) {
            return;
        }
        this.timeOffset = System.currentTimeMillis();
        this.processStimulus(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processStimulus(Enumeration criteria) {
        ArrayList<Integer> arrayList = this.actionQueue;
        synchronized (arrayList) {
            long time;
            WakeupOnElapsedTime w;
            if (this.universe == null) {
                w = new WakeupOnElapsedTime((long)this.elapsedTime);
                this.wakeupOn((WakeupCondition)w);
            } else {
                w = null;
                w = new WakeupOnBehaviorPost((Behavior)this.universe.getTimerBehavior(), 1);
                this.wakeupOn((WakeupCondition)w);
            }
            if (this.a3Data.autoActionControl) {
                double ls = this.a3.getSpeed();
                int i = -1;
                i = ls < this.a3Data.getMinWalkSpeed() ? this.a3Data.getHaltActionNo() : (ls < this.a3Data.getMinRunSpeed() ? this.a3Data.getWalkActionNo() : this.a3Data.getRunActionNo());
                if (i != this.actionNo && this.actionQueue.size() == 0) {
                    this.actionQueue.add(i);
                }
            }
            if (this.immediatelyFlag) {
                if (this.actionQueue.size() > 0) {
                    int newActionNo = this.actionQueue.remove(0);
                    this.doChangeAction(newActionNo);
                }
            } else if (this.playStatus == 4 && this.actionQueue.size() > 0) {
                int newActionNo = this.actionQueue.remove(0);
                this.doChangeAction(newActionNo);
            }
            long nowTime = System.currentTimeMillis();
            if (this.mode == Motion.Mode.PAUSE) {
                this.epilogueStartTime = this.dalsegnoTime;
                this.epilogueEndTime = this.motionLength;
                time = this.pauseTime;
            } else {
                time = nowTime - this.timeOffset;
            }
            if (this.epilogueStartTime == Long.MAX_VALUE && this.actionQueue.size() > 0) {
                this.epilogueStartTime = time + (this.dalsegnoTime - this.segnoTime) - (time - this.segnoTime) % (this.dalsegnoTime - this.segnoTime);
                this.epilogueEndTime = this.epilogueStartTime + (this.motionLength - this.dalsegnoTime);
            }
            int newPlayStatus = time < this.segnoTime ? 1 : (time < this.epilogueStartTime ? 2 : (time < this.epilogueEndTime ? 3 : 4));
            if (this.playStatus == 4 && newPlayStatus == 4 && this.motionLength > 0L) {
                return;
            }
            int newPlayCount = (int)((time - this.segnoTime) / (this.dalsegnoTime - this.segnoTime));
            if (newPlayStatus != 1) {
                if (newPlayStatus == 2) {
                    time = this.segnoTime + (time - this.segnoTime) % (this.dalsegnoTime - this.segnoTime);
                } else if (newPlayStatus == 3) {
                    time = this.dalsegnoTime + (time - this.epilogueStartTime);
                } else if (newPlayStatus == 4) {
                    time = this.motionLength - 1L;
                }
            }
            double timeD = (double)time / 1000.0;
            Action3DData.Action a = this.a3Data.actions[this.actionNo];
            for (String boneName : a.tgMap.keySet()) {
                TransformGroup tg = a.tgMap.get(boneName);
                Transform3D t = a.motion.getTransform3D(boneName, timeD);
                tg.setTransform(t);
            }
            if (this.a3.isSelected3D()) {
                this.a3.behavior.adjustSelected3D();
            }
            if (newPlayStatus >= 2 && this.playStatus < 2 && this.a3Data.actions[this.actionNo].sound != null) {
                this.a3Data.actions[this.actionNo].soundStart();
            }
            if (newPlayStatus == 2 && this.playCount != newPlayCount && this.a3Data.actions[this.actionNo].sound != null) {
                this.a3Data.actions[this.actionNo].soundStart();
            }
            if (newPlayStatus == 4 && !this.a3Data.actions[this.actionNo].soundContinue && this.a3Data.actions[this.actionNo].sound != null) {
                this.a3Data.actions[this.actionNo].soundStop();
            }
            this.playStatus = newPlayStatus;
            this.playCount = newPlayCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initAction(int initActionNo) {
        ArrayList<Integer> arrayList = this.actionQueue;
        synchronized (arrayList) {
            if (initActionNo < 0 || initActionNo >= this.a3Data.actions.length) {
                initActionNo = 0;
            }
            this.actionQueue.clear();
            this.actionQueue.add(initActionNo);
        }
    }

    void initAction(Serializable s) {
        if (s instanceof Integer) {
            this.initAction((Integer)s);
        }
        if (s instanceof String) {
            this.initAction(this.a3Data.getActionNoFromActionName((String)((Object)s)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void change(int newActionNo) {
        ArrayList<Integer> arrayList = this.actionQueue;
        synchronized (arrayList) {
            if (newActionNo < 0 || newActionNo >= this.a3Data.actions.length) {
                return;
            }
            if (this.actionQueue.size() < 10) {
                this.actionQueue.add(newActionNo);
            } else {
                this.actionQueue.set(9, newActionNo);
            }
        }
    }

    void change(Serializable s) {
        if (s instanceof Integer) {
            this.change((Integer)s);
        }
        if (s instanceof String) {
            this.change(this.a3Data.getActionNoFromActionName((String)((Object)s)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void changeImmediately(int newActionNo) {
        ArrayList<Integer> arrayList = this.actionQueue;
        synchronized (arrayList) {
            if (newActionNo < 0 || newActionNo >= this.a3Data.actions.length) {
                return;
            }
            this.actionQueue.clear();
            this.actionQueue.add(newActionNo);
            this.immediatelyFlag = true;
        }
    }

    void changeImmediately(Serializable s) {
        if (s instanceof Integer) {
            this.changeImmediately((Integer)s);
        }
        if (s instanceof String) {
            this.changeImmediately(this.a3Data.getActionNoFromActionName((String)((Object)s)));
        }
    }

    public void setFrameTime(double d) {
        this.elapsedTime = (int)(1000.0 * d);
    }

    public void setPauseTime(double t) {
        this.pauseTime = (long)(1000.0 * t);
    }

    public void setMode(Motion.Mode m) {
        this.mode = m;
    }

    public boolean isStoped() {
        return !this.loopFlag && this.playCount > 0;
    }

    public void dispose() {
        this.a3Data.actions[this.actionNo].soundStop();
    }

    Node getNode() {
        return this.allBranchGroup;
    }

    int getActionNo() {
        return this.actionNo;
    }

    String getActionName() {
        return this.a3Data.actions[this.actionNo].actionName;
    }

    String getActionNameFromActionNo(int an) {
        return this.a3Data.actions[an].actionName;
    }

    int getActionNoFromActionName(String an) {
        return this.a3Data.getActionNoFromActionName(an);
    }

    int getActionCount() {
        return this.a3Data.actions.length;
    }

    String[] getActionNames() {
        return (String[])this.a3Data.actionNames.clone();
    }

    boolean isStoped(int actionNo) {
        return this.a3Data.actions[actionNo].isStoped();
    }

    double getMotionLength(int actionNo) {
        return this.a3Data.actions[actionNo].getMotionLength();
    }

    double getMotionLength(String actionName) {
        int actionNo = this.getActionNoFromActionName(actionName);
        return this.a3Data.actions[actionNo].getMotionLength();
    }

    String getActionName(int i) {
        return null;
    }

    String getComment() {
        return this.a3Data.comment;
    }

    int getFrameCount() {
        return this.a3Data.actionNames.length;
    }

    void setAutoActionControl(boolean b) {
        this.a3Data.autoActionControl = b;
    }

    boolean autoActionControl() {
        return this.a3Data.autoActionControl;
    }

    void setHaltAction(int i) {
        this.a3Data.haltActionNo = i;
    }

    void setHaltAction(Serializable s) {
        if (s instanceof String) {
            this.setHaltAction(this.getActionNoFromActionName((String)((Object)s)));
        } else if (s instanceof Integer) {
            this.setHaltAction((Integer)s);
        }
    }

    int getHaltActionNo() {
        return this.a3Data.haltActionNo;
    }

    void setWalkAction(int i) {
        this.a3Data.walkActionNo = i;
    }

    void setWalkAction(Serializable s) {
        if (s instanceof String) {
            this.setWalkAction(this.getActionNoFromActionName((String)((Object)s)));
        } else if (s instanceof Integer) {
            this.setWalkAction((Integer)s);
        }
    }

    int getWalkActionNo() {
        return this.a3Data.walkActionNo;
    }

    void setMinWalkSpeed(double d) {
        this.a3Data.minWalkSpeed = d;
    }

    double getMinWalkSpeed() {
        return this.a3Data.minWalkSpeed;
    }

    String getRDF() {
        return this.a3Data.rdf;
    }

    String[] getTags() {
        return (String[])this.a3Data.tags.clone();
    }

    String[] getProfiles() {
        return (String[])this.a3Data.profiles.clone();
    }

    String[] getThumbnails() {
        return (String[])this.a3Data.thumbnails.clone();
    }

    String getHTML() {
        return this.a3Data.html;
    }

    void setRunAction(int i) {
        this.a3Data.runActionNo = i;
    }

    void setRunAction(Serializable s) {
        if (s instanceof String) {
            this.setRunAction(this.getActionNoFromActionName((String)((Object)s)));
        } else if (s instanceof Integer) {
            this.setRunAction((Integer)s);
        }
    }

    int getRunActionNo() {
        return this.a3Data.runActionNo;
    }

    void setMinRunSpeed(double d) {
        this.a3Data.minRunSpeed = d;
    }

    double getMinRunSpeed() {
        return this.a3Data.minRunSpeed;
    }

    void setMotion(int actionNo, Motion motion) {
        this.a3Data.actions[actionNo].motion = motion;
    }

    void setMotion(Serializable action, Motion motion) {
        int actionNo = 0;
        if (action instanceof String) {
            actionNo = this.a3Data.getActionNoFromActionName((String)((Object)action));
        }
        if (action instanceof Integer) {
            actionNo = (Integer)action;
        }
        this.setMotion(actionNo, motion);
    }

    void setShape(int actionNo, String boneName, Node shape) {
        this.a3Data.setShape(actionNo, boneName, shape);
    }

    void setShape(Serializable action, String boneName, Node shape) {
        this.a3Data.setShape(action, boneName, shape);
    }

    void setSound(int actionNo, MediaContainer sound) {
    }

    void setSound(Serializable action, MediaContainer sound) {
    }

    public void setSoundGain(double g) {
        this.a3Data.actions[this.actionNo].setSoundGain(g);
    }

    public void setSoundGain(int an, double g) {
        this.a3Data.actions[an].setSoundGain(g);
    }

    public void setSoundGain(Serializable action, double g) {
        int actionNo = 0;
        if (action instanceof String) {
            actionNo = this.a3Data.getActionNoFromActionName((String)((Object)action));
        }
        if (action instanceof Integer) {
            actionNo = (Integer)action;
        }
        this.a3Data.actions[actionNo].setSoundGain(g);
    }

    public double getSoundGain() {
        return this.a3Data.actions[this.actionNo].getSoundGain();
    }

    public double getSoundGain(int an) {
        return this.a3Data.actions[an].getSoundGain();
    }

    public double getSoundGain(Serializable action) {
        int actionNo = 0;
        if (action instanceof String) {
            actionNo = this.a3Data.getActionNoFromActionName((String)((Object)action));
        }
        if (action instanceof Integer) {
            actionNo = (Integer)action;
        }
        return this.a3Data.actions[actionNo].getSoundGain();
    }

    public void setLabelLoc(double x, double y) {
        this.a3Data.actions[this.actionNo].labelOffset[0] = x;
        this.a3Data.actions[this.actionNo].labelOffset[1] = y;
    }

    public void setLabelLoc(int actionNo, double x, double y) {
        this.a3Data.actions[actionNo].labelOffset[0] = x;
        this.a3Data.actions[actionNo].labelOffset[1] = y;
    }

    public void setBalloonLoc(A3Object.BalloonDir d, double x, double y) {
        this.a3Data.actions[this.actionNo].balloonDirection = d;
        if (d == A3Object.BalloonDir.RIGHT) {
            this.a3Data.actions[this.actionNo].rightBalloonOffset[0] = x;
            this.a3Data.actions[this.actionNo].rightBalloonOffset[1] = y;
        } else if (d == A3Object.BalloonDir.LEFT) {
            this.a3Data.actions[this.actionNo].leftBalloonOffset[0] = x;
            this.a3Data.actions[this.actionNo].leftBalloonOffset[1] = y;
        } else if (d == A3Object.BalloonDir.TOP) {
            this.a3Data.actions[this.actionNo].topBalloonOffset[0] = x;
            this.a3Data.actions[this.actionNo].topBalloonOffset[1] = y;
        } else if (d == A3Object.BalloonDir.BOTTOM) {
            this.a3Data.actions[this.actionNo].bottomBalloonOffset[0] = x;
            this.a3Data.actions[this.actionNo].bottomBalloonOffset[1] = y;
        }
    }

    public void setBalloonLoc(int actionNo, A3Object.BalloonDir d, double x, double y) {
        this.a3Data.actions[actionNo].balloonDirection = d;
        if (d == A3Object.BalloonDir.RIGHT) {
            this.a3Data.actions[actionNo].rightBalloonOffset[0] = x;
            this.a3Data.actions[actionNo].rightBalloonOffset[1] = y;
        } else if (d == A3Object.BalloonDir.LEFT) {
            this.a3Data.actions[actionNo].leftBalloonOffset[0] = x;
            this.a3Data.actions[actionNo].leftBalloonOffset[1] = y;
        } else if (d == A3Object.BalloonDir.TOP) {
            this.a3Data.actions[actionNo].topBalloonOffset[0] = x;
            this.a3Data.actions[actionNo].topBalloonOffset[1] = y;
        } else if (d == A3Object.BalloonDir.BOTTOM) {
            this.a3Data.actions[actionNo].bottomBalloonOffset[0] = x;
            this.a3Data.actions[actionNo].bottomBalloonOffset[1] = y;
        }
    }

    public void setBalloonLoc(Serializable action, A3Object.BalloonDir d, double x, double y) {
        if (action instanceof Integer) {
            int actionNo = (Integer)action;
            this.setBalloonLoc(actionNo, d, x, y);
        } else if (action instanceof String) {
            int actionNo = this.a3Data.getActionNoFromActionName((String)((Object)action));
            this.setBalloonLoc(actionNo, d, x, y);
        }
    }

    public void setBalloonDir(A3Object.BalloonDir d) {
        this.a3Data.actions[this.actionNo].balloonDirection = d;
    }

    public void setBalloonDir(int actionNo, A3Object.BalloonDir d) {
        this.a3Data.actions[actionNo].balloonDirection = d;
    }

    public void setBalloonDir(Serializable action, A3Object.BalloonDir d) {
        if (action instanceof Integer) {
            int actionNo = (Integer)action;
            this.setBalloonDir(actionNo, d);
        } else if (action instanceof String) {
            int actionNo = this.a3Data.getActionNoFromActionName((String)((Object)action));
            this.setBalloonDir(actionNo, d);
        }
    }

    void setSoundLocQuat(Vector3d v, Quat4d q) {
        this.a3Data.actions[this.actionNo].setSoundLocQuat(v, q);
    }
}

