/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.acerola3d.a3;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.CapabilityNotSetException;
import javax.media.j3d.Group;
import javax.media.j3d.Link;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.SharedGroup;
import javax.vecmath.Quat4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple4d;
import javax.vecmath.Vector3d;
import jp.sourceforge.acerola3d.A23;
import jp.sourceforge.acerola3d.a3.A3BranchGroup;
import jp.sourceforge.acerola3d.a3.A3CanvasInterface;
import jp.sourceforge.acerola3d.a3.A3Controller;
import jp.sourceforge.acerola3d.a3.A3Object;
import jp.sourceforge.acerola3d.a3.A3VirtualUniverse;
import jp.sourceforge.acerola3d.a3.ChaseController;
import jp.sourceforge.acerola3d.a3.Component2D;
import jp.sourceforge.acerola3d.a3.Component2DContainerInterface;
import jp.sourceforge.acerola3d.a3.EditController;
import jp.sourceforge.acerola3d.a3.ExamController;
import jp.sourceforge.acerola3d.a3.FlyController;
import jp.sourceforge.acerola3d.a3.NoneController;
import jp.sourceforge.acerola3d.a3.SimpleController;
import jp.sourceforge.acerola3d.a3.Util;
import jp.sourceforge.acerola3d.a3.WalkController;

class Scene
implements Component2DContainerInterface {
    int sceneNo;
    A3VirtualUniverse universe;
    A3CanvasInterface canvas = null;
    BranchGroup mainGroup;
    BranchGroup cameraGroup;
    A3Object.UpperDirection upperDirection = A3Object.UpperDirection.Y;
    A3Object background = null;
    A3Object avatar = null;
    Hashtable<A3Object, BranchGroup> a3Hash = new Hashtable();
    ArrayList<Component2D> components2D = new ArrayList();
    Hashtable<A3Object, BranchGroup> lockedA3Hash = new Hashtable();
    BranchGroup backgroundBG = null;
    Vector3d cameraNowV = new Vector3d(0.0, 0.0, 2.0);
    Quat4d cameraNowQ = new Quat4d(0.0, 0.0, 0.0, 1.0);
    double cameraNowS = 1.0;
    Vector3d cameraNextV = new Vector3d(0.0, 0.0, 2.0);
    Quat4d cameraNextQ = new Quat4d(0.0, 0.0, 0.0, 1.0);
    double cameraNextS = 1.0;
    Vector3d defaultV = new Vector3d(0.0, 0.0, 2.0);
    Quat4d defaultQ = new Quat4d(0.0, 0.0, 0.0, 1.0);
    double defaultS = 1.0;
    A3CanvasInterface.NaviMode naviMode = A3CanvasInterface.NaviMode.NONE;
    double naviSpeed = 1.0;
    A3Controller controller = null;

    Scene(A3VirtualUniverse v, int no) {
        this.sceneNo = no;
        this.universe = v;
        this.canvas = v.canvas;
        this.mainGroup = new BranchGroup();
        this.mainGroup.setCapability(17);
        this.mainGroup.setCapability(12);
        this.mainGroup.setCapability(14);
        this.mainGroup.setCapability(13);
        this.cameraGroup = new BranchGroup();
        this.cameraGroup.setCapability(17);
        this.cameraGroup.setCapability(12);
        this.cameraGroup.setCapability(14);
        this.cameraGroup.setCapability(13);
        if (A23.getDefaultUpperDirection() != A3Object.UpperDirection.Y) {
            if (A23.getDefaultUpperDirection() == A3Object.UpperDirection.Z) {
                this.upperDirection = A3Object.UpperDirection.Z;
                this.cameraNowV.set(0.0, -2.0, 0.0);
                this.cameraNowQ.set(1.0 * Math.sin(0.7853981633974483), 0.0, 0.0, Math.cos(0.7853981633974483));
                this.cameraNowS = 1.0;
                this.cameraNextV.set((Tuple3d)this.cameraNowV);
                this.cameraNextQ.set((Tuple4d)this.cameraNowQ);
                this.cameraNextS = this.cameraNowS;
                this.defaultV.set((Tuple3d)this.cameraNowV);
                this.defaultQ.set((Tuple4d)this.cameraNowQ);
                this.defaultS = this.cameraNowS;
            } else {
                System.out.println("Error in Scene.(init). ");
            }
        }
    }

    void activate() {
        this.universe.rootGroup.addChild((Node)this.mainGroup);
        this.universe.tGroup.addChild((Node)this.cameraGroup);
        if (this.controller != null) {
            this.universe.addA3Listener(this.controller);
            this.canvas.addKeyListener(this.controller);
            this.controller.init();
        }
    }

    void deactivate() {
        this.universe.rootGroup.removeChild((Node)this.mainGroup);
        this.universe.tGroup.removeChild((Node)this.cameraGroup);
        if (this.controller != null) {
            this.universe.removeA3Listener(this.controller);
            this.canvas.removeKeyListener(this.controller);
            this.controller.stop();
        }
    }

    public void add(A3Object a) {
        if (this.a3Hash.containsKey(a)) {
            return;
        }
        Scene.setAppearanceOverrideEnable((Group)a.getNode());
        ((BranchGroup)a.getNode()).compile();
        a.setComponent2DContainerInterface(this);
        a.lockedA3 = false;
        a.init();
        A3BranchGroup bg = a.getA3BranchGroup();
        this.mainGroup.addChild((Node)bg);
        this.a3Hash.put(a, bg);
    }

    static void setAppearanceOverrideEnable(Group g) {
        Enumeration e = g.getAllChildren();
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            if (o instanceof Shape3D) {
                try {
                    ((Shape3D)o).setAppearanceOverrideEnable(true);
                }
                catch (CapabilityNotSetException ee) {}
                continue;
            }
            if (o instanceof Group) {
                Scene.setAppearanceOverrideEnable((Group)o);
                continue;
            }
            if (!(o instanceof Link)) continue;
            SharedGroup sg = ((Link)o).getSharedGroup();
            Scene.setAppearanceOverrideEnable((Group)sg);
        }
    }

    public void del(A3Object a) {
        BranchGroup bg = this.a3Hash.get(a);
        if (bg == null) {
            return;
        }
        bg.detach();
        a.dispose();
        this.a3Hash.remove(a);
    }

    public void delAll() {
        Enumeration<A3Object> e = this.a3Hash.keys();
        while (e.hasMoreElements()) {
            A3Object a3 = e.nextElement();
            BranchGroup bg = this.a3Hash.get(a3);
            bg.detach();
            a3.dispose();
        }
        this.a3Hash.clear();
    }

    public void setBackground(A3Object a) {
        if (this.backgroundBG != null) {
            this.backgroundBG.detach();
        }
        A3BranchGroup n = a.getA3BranchGroup();
        this.backgroundBG = new BranchGroup();
        this.backgroundBG.setCapability(17);
        this.backgroundBG.addChild((Node)n);
        this.mainGroup.addChild((Node)this.backgroundBG);
        this.background = a;
        a.pickable = false;
    }

    public void delBackground() {
        if (this.backgroundBG != null) {
            this.backgroundBG.detach();
        }
        this.background = null;
    }

    public void setAvatar(A3Object a) {
        this.avatar = a;
    }

    public A3Object getAvatar() {
        return this.avatar;
    }

    public void setDefaultCameraLoc(double x, double y, double z) {
        this.defaultV = new Vector3d(x, y, z);
    }

    public void setDefaultCameraLoc(Vector3d loc) {
        this.defaultV = new Vector3d(loc);
    }

    public void setDefaultCameraQuat(double x, double y, double z, double w) {
        this.defaultQ = new Quat4d(x, y, z, w);
    }

    public void setDefaultCameraQuat(Quat4d quat) {
        this.defaultQ = new Quat4d(quat);
    }

    public void setDefaultCameraRot(double x, double y, double z) {
        this.defaultQ = Util.euler2quat(x, y, z);
    }

    public void setDefaultCameraRot(Vector3d rot) {
        this.defaultQ = Util.euler2quat(rot);
    }

    public void setDefaultCameraScale(double s) {
        this.defaultS = s;
    }

    public void resetCamera() {
        this.cameraNowV.set((Tuple3d)this.defaultV);
        this.cameraNowQ.set((Tuple4d)this.defaultQ);
        this.cameraNowS = this.defaultS;
        this.cameraNextV.set((Tuple3d)this.defaultV);
        this.cameraNextQ.set((Tuple4d)this.defaultQ);
        this.cameraNextS = this.defaultS;
    }

    public void setCameraLoc(double x, double y, double z) {
        this.cameraNextV.set(x, y, z);
    }

    public void setCameraLoc(Vector3d loc) {
        this.cameraNextV.set((Tuple3d)loc);
    }

    public void setCameraLocImmediately(double x, double y, double z) {
        this.cameraNowV.set(x, y, z);
        this.cameraNextV.set(x, y, z);
    }

    public void setCameraLocImmediately(Vector3d loc) {
        this.cameraNowV.set((Tuple3d)loc);
        this.cameraNextV.set((Tuple3d)loc);
    }

    public Vector3d getCameraLoc() {
        return new Vector3d(this.cameraNowV);
    }

    public void setCameraQuat(double x, double y, double z, double w) {
        this.cameraNextQ.set(x, y, z, w);
    }

    public void setCameraQuat(Quat4d quat) {
        this.cameraNextQ.set((Tuple4d)quat);
    }

    public void setCameraQuatImmediately(double x, double y, double z, double w) {
        this.cameraNowQ.set(x, y, z, w);
        this.cameraNextQ.set(x, y, z, w);
    }

    public void setCameraQuatImmediately(Quat4d quat) {
        this.cameraNowQ.set((Tuple4d)quat);
        this.cameraNextQ.set((Tuple4d)quat);
    }

    public Quat4d getCameraQuat() {
        return new Quat4d(this.cameraNowQ);
    }

    public void setCameraRot(double x, double y, double z) {
        this.setCameraQuat(Util.euler2quat(x, y, z));
    }

    public void setCameraRot(Vector3d rot) {
        this.setCameraQuat(Util.euler2quat(rot));
    }

    public void setCameraRotImmediately(double x, double y, double z) {
        this.setCameraQuatImmediately(Util.euler2quat(x, y, z));
    }

    public void setCameraRotImmediately(Vector3d rot) {
        this.setCameraQuatImmediately(Util.euler2quat(rot));
    }

    public void setCameraScale(double s) {
        this.cameraNextS = s;
    }

    public void setCameraScaleImmediately(double s) {
        this.cameraNowS = s;
        this.cameraNextS = s;
    }

    public double getCameraScale() {
        return this.cameraNowS;
    }

    public void setCameraLookAtPoint(Vector3d lookAt) {
        Vector3d up = null;
        up = this.upperDirection == A3Object.UpperDirection.Y ? new Vector3d(0.0, 1.0, 0.0) : new Vector3d(0.0, 0.0, 1.0);
        this.setCameraLookAtPoint(lookAt, up);
    }

    public void setCameraLookAtPointImmediately(Vector3d lookAt) {
        this.setCameraLookAtPoint(lookAt);
        this.cameraNowQ.set((Tuple4d)this.cameraNextQ);
    }

    public void setCameraLookAtPoint(double x, double y, double z) {
        Vector3d lookAt = new Vector3d(x, y, z);
        this.setCameraLookAtPoint(lookAt);
    }

    public void setCameraLookAtPointImmediately(double x, double y, double z) {
        Vector3d lookAt = new Vector3d(x, y, z);
        this.setCameraLookAtPoint(lookAt);
        this.cameraNowQ.set((Tuple4d)this.cameraNextQ);
    }

    public void setCameraLookAtPoint(Vector3d lookAt, Vector3d up) {
        Vector3d front = new Vector3d(lookAt);
        front.sub((Tuple3d)this.cameraNextV);
        this.cameraNextQ.set((Tuple4d)Util.frontFacingQuat_CAMERA(front, up));
    }

    public void setCameraLookAtPointImmediately(Vector3d lookAt, Vector3d up) {
        this.setCameraLookAtPoint(lookAt, up);
        this.cameraNowQ.set((Tuple4d)this.cameraNextQ);
    }

    public void setCameraLookAtPoint(double x, double y, double z, Vector3d up) {
        Vector3d lookAt = new Vector3d(x, y, z);
        this.setCameraLookAtPoint(lookAt, up);
    }

    public void setCameraLookAtPointImmediately(double x, double y, double z, Vector3d up) {
        this.setCameraLookAtPoint(x, y, z, up);
        this.cameraNowQ.set((Tuple4d)this.cameraNextQ);
    }

    public void setNavigationMode(A3CanvasInterface.NaviMode m) {
        this.naviMode = m;
        if (this.naviMode == A3CanvasInterface.NaviMode.NONE) {
            this.setA3Controller0(new NoneController());
        } else if (this.naviMode == A3CanvasInterface.NaviMode.WALK) {
            this.setA3Controller0(new WalkController());
        } else if (this.naviMode == A3CanvasInterface.NaviMode.FLY) {
            this.setA3Controller0(new FlyController());
        } else if (this.naviMode == A3CanvasInterface.NaviMode.EXAMINE) {
            this.setA3Controller0(new ExamController());
        } else if (this.naviMode == A3CanvasInterface.NaviMode.EDIT) {
            this.setA3Controller0(new EditController());
        } else if (this.naviMode == A3CanvasInterface.NaviMode.SIMPLE) {
            this.setA3Controller0(new SimpleController());
        } else if (this.naviMode == A3CanvasInterface.NaviMode.CHASE) {
            this.setA3Controller0(new ChaseController());
        }
    }

    public void setNavigationSpeed(double s) {
        this.naviSpeed = s;
    }

    public double getNavigationSpeed() {
        return this.naviSpeed;
    }

    void setA3Controller0(A3Controller c) {
        if (this.canvas != null && c != null) {
            c.setA3CanvasInterface(this.canvas);
        }
        if (this.universe.scene == this) {
            if (this.controller != null) {
                this.universe.removeA3Listener(this.controller);
                this.canvas.removeKeyListener(this.controller);
                this.controller.stop();
            }
            this.controller = c;
            if (this.controller != null) {
                this.universe.addA3Listener(this.controller);
                this.canvas.addKeyListener(this.controller);
                this.controller.init();
            }
        } else {
            this.controller = c;
        }
    }

    public void setA3Controller(A3Controller c) {
        this.naviMode = A3CanvasInterface.NaviMode.USER;
        this.setA3Controller0(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Component2D c) {
        ArrayList<Component2D> arrayList = this.components2D;
        synchronized (arrayList) {
            if (!this.components2D.contains(c)) {
                this.components2D.add(c);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void del(Component2D c) {
        ArrayList<Component2D> arrayList = this.components2D;
        synchronized (arrayList) {
            this.components2D.remove(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Component2D> getComponents2D() {
        ArrayList<Component2D> ret = null;
        ArrayList<Component2D> arrayList = this.components2D;
        synchronized (arrayList) {
            ret = new ArrayList<Component2D>(this.components2D);
        }
        return ret;
    }

    @Override
    public A3VirtualUniverse getA3VirtualUniverse() {
        return this.universe;
    }

    public void addLockedA3(A3Object a) {
        if (this.lockedA3Hash.containsKey(a)) {
            return;
        }
        a.setComponent2DContainerInterface(this);
        a.lockedA3 = true;
        a.init();
        A3BranchGroup bg = a.getA3BranchGroup();
        this.cameraGroup.addChild((Node)bg);
        this.lockedA3Hash.put(a, bg);
    }

    public void delLockedA3(A3Object a) {
        BranchGroup bg = this.lockedA3Hash.get(a);
        if (bg == null) {
            return;
        }
        bg.detach();
        a.dispose();
        this.lockedA3Hash.remove(a);
    }

    public void delAllLockedA3() {
        Enumeration<A3Object> e = this.lockedA3Hash.keys();
        while (e.hasMoreElements()) {
            A3Object a3 = e.nextElement();
            BranchGroup bg = this.lockedA3Hash.get(a3);
            bg.detach();
            a3.dispose();
        }
        this.lockedA3Hash.clear();
    }

    public void setUpperDirection(A3Object.UpperDirection d) {
        this.upperDirection = d;
    }
}

