/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.acerola3d.a3;

import com.sun.j3d.exp.swing.impl.AutoOffScreenCanvas3D;
import java.awt.AlphaComposite;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfigTemplate;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.InputMethodEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.image.BufferedImage;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.DepthComponent;
import javax.media.j3d.DepthComponentFloat;
import javax.media.j3d.GraphicsConfigTemplate3D;
import javax.media.j3d.GraphicsContext3D;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.Raster;
import javax.swing.JPanel;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.vecmath.Point3f;
import jp.sourceforge.acerola3d.a3.A3Widget;
import jp.sourceforge.acerola3d.a3.Component2D;
import jp.sourceforge.acerola3d.a3.Component2DComparator;

class TransCanvas3D
extends JPanel
implements AncestorListener {
    private static final long serialVersionUID = 1L;
    public static final int RESIZE_IMMEDIATELY = 0;
    public static final int RESIZE_DELAYED = 1;
    private static double METERS_PER_PIXEL = 2.8222222222222223E-4;
    private GraphicsConfigTemplate3D template;
    private GraphicsConfiguration graphicsConfig;
    private InternalCanvas3D canvas;
    private boolean hasBeenAdded = false;
    int resizeMode;
    int resizeValidationDelay;
    private GraphicsDevice device;
    A3Widget widget = null;
    float[] depthData = null;
    long fpsStartTime;
    int fpsCounter = 0;
    int fps;

    public TransCanvas3D() {
        this(null, GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice());
    }

    public TransCanvas3D(GraphicsDevice device) {
        this(null, device);
    }

    public TransCanvas3D(GraphicsConfigTemplate3D template) {
        this(template, GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice());
    }

    public TransCanvas3D(GraphicsConfigTemplate3D template, GraphicsDevice device) {
        this.device = device;
        this.template = new GraphicsConfigTemplate3D();
        if (template != null) {
            this.template.setRedSize(template.getRedSize());
            this.template.setGreenSize(template.getGreenSize());
            this.template.setBlueSize(template.getBlueSize());
            this.template.setDepthSize(template.getDepthSize());
            this.template.setSceneAntialiasing(template.getSceneAntialiasing());
            this.template.setStencilSize(template.getStencilSize());
        }
        this.template.setStereo(3);
        this.template.setDoubleBuffer(3);
        this.graphicsConfig = this.device.getBestConfiguration((GraphicsConfigTemplate)this.template);
        this.addAncestorListener(this);
        this.setDoubleBuffered(false);
        this.setResizeMode(0);
        this.setResizeValidationDelay(100);
        this.setFocusable(true);
        this.setOpaque(false);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.enableEvents(16L);
        this.enableEvents(32L);
        this.enableEvents(131072L);
    }

    @Override
    public void ancestorAdded(AncestorEvent event) {
        Dimension sz = this.getSize();
        if (0 == sz.width) {
            sz.width = 100;
        }
        if (0 == sz.height) {
            sz.height = 100;
        }
        this.createCanvas(sz.width, sz.height);
        this.canvas.addNotifyFlag = true;
        this.canvas.addNotify();
        this.hasBeenAdded = true;
    }

    @Override
    public void ancestorMoved(AncestorEvent event) {
    }

    @Override
    public void ancestorRemoved(AncestorEvent event) {
        this.hasBeenAdded = false;
        this.canvas.removeNotify();
    }

    private void computePhysicalDimensions() {
        Rectangle screenRect = this.graphicsConfig.getBounds();
        int screenWidth = (int)screenRect.getWidth();
        int screenHeight = (int)screenRect.getHeight();
        this.canvas.getScreen3D().setSize(screenWidth, screenHeight);
        this.canvas.getScreen3D().setPhysicalScreenWidth((double)screenWidth * METERS_PER_PIXEL);
        this.canvas.getScreen3D().setPhysicalScreenHeight((double)screenHeight * METERS_PER_PIXEL);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void createCanvas(int width, int height) {
        if (this.getParent() == null) {
            return;
        }
        if (null != this.canvas) {
            if (width == this.canvas.getWidth() && height == this.canvas.getHeight()) return;
            if (null != this.canvas.getOffScreenBuffer() && null != this.canvas.getOffScreenBuffer().getImage()) {
                this.canvas.getOffScreenBuffer().getImage().flush();
            }
        } else {
            this.canvas = new InternalCanvas3D(this.graphicsConfig, this);
        }
        this.createOffScreenBuffer(width, height);
    }

    private void createOffScreenBuffer(int width, int height) {
        this.computePhysicalDimensions();
        BufferedImage bImage = new BufferedImage(width, height, 2);
        ImageComponent2D image = new ImageComponent2D(2, bImage, true, false);
        image.setCapability(2);
        image.setCapability(3);
        this.canvas.stopRenderer();
        this.canvas.waitForOffScreenRendering();
        this.canvas.setOffScreenBuffer(image);
        this.canvas.startRenderer();
        DepthComponentFloat dcf = new DepthComponentFloat(width, height);
        this.canvas.zRaster = new Raster(new Point3f(0.0f, 0.0f, 0.0f), 2, 0, 0, width, height, null, (DepthComponent)dcf);
    }

    public Canvas3D getOffscreenCanvas3D() {
        if (null == this.canvas) {
            this.createCanvas(this.getWidth(), this.getHeight());
        }
        return this.canvas;
    }

    public int getResizeMode() {
        return this.resizeMode;
    }

    public int getResizeValidationDelay() {
        return this.resizeValidationDelay;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.hasBeenAdded) {
            if (this.canvas.canvasCrashed) {
                return;
            }
            this.canvas.stopRenderer();
            this.canvas.waitForOffScreenRendering();
            if (null != this.canvas.bi) {
                int w = this.canvas.bi.getWidth();
                int h = this.canvas.bi.getHeight();
                if (this.depthData == null) {
                    this.depthData = new float[w * h];
                }
                if (w * h != this.depthData.length) {
                    this.depthData = new float[w * h];
                }
                DepthComponentFloat dcf = (DepthComponentFloat)this.canvas.zRaster.getDepthComponent();
                dcf.getDepthData(this.depthData);
                for (int x = 0; x < w; ++x) {
                    for (int y = 0; y < h; ++y) {
                        if (!((double)this.depthData[x + w * y] > 0.999)) continue;
                        this.canvas.bi.setRGB(x, y, 0);
                    }
                }
                if (this.widget != null && this.widget.universe != null) {
                    Component2D[] cs;
                    Graphics2D g2 = this.canvas.bi.createGraphics();
                    g2.setComposite(AlphaComposite.Src);
                    for (Component2D c : cs = this.widget.universe.getComponents2D().toArray(new Component2D[0])) {
                        c.calPhysicalZ(this.widget);
                    }
                    Arrays.sort(cs, Component2DComparator.comparator);
                    for (Component2D c : cs) {
                        if (c.z > 0.0) continue;
                        c.paint(g2, this.widget);
                    }
                    if (Component2D.advertisement != null) {
                        Component2D.advertisement.paint(g2, this.widget);
                    }
                    g2.dispose();
                }
                ((Graphics2D)g).setComposite(AlphaComposite.Src);
                g.drawImage(this.canvas.bi, 0, 0, this.getWidth(), this.getHeight(), null);
                ++this.fpsCounter;
                long l = System.currentTimeMillis() - this.fpsStartTime;
                if (l > 1000L) {
                    this.fps = (int)((long)(1000 * this.fpsCounter) / l);
                    this.fpsCounter = 0;
                    this.fpsStartTime = System.currentTimeMillis();
                }
            }
            this.canvas.startRenderer();
        }
    }

    int getFPS() {
        return this.fps;
    }

    @Override
    protected void processComponentKeyEvent(KeyEvent e) {
        super.processComponentKeyEvent(e);
        Object src = e.getSource();
        e.setSource((Object)this.canvas);
        this.canvas.processComponentEvent(e);
        e.setSource(src);
    }

    @Override
    protected void processFocusEvent(FocusEvent e) {
        super.processFocusEvent(e);
        Object src = e.getSource();
        e.setSource((Object)this.canvas);
        this.canvas.processFocusEvent(e);
        e.setSource(src);
    }

    @Override
    protected void processInputMethodEvent(InputMethodEvent e) {
        super.processInputMethodEvent(e);
        Object src = e.getSource();
        e.setSource((Object)this.canvas);
        this.canvas.processInputMethodEvent(e);
        e.setSource(src);
    }

    @Override
    protected void processKeyEvent(KeyEvent e) {
        super.processKeyEvent(e);
        Object src = e.getSource();
        e.setSource((Object)this.canvas);
        this.canvas.processKeyEvent(e);
        e.setSource(src);
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        super.processMouseEvent(e);
        Object src = e.getSource();
        e.setSource((Object)this.canvas);
        this.canvas.processMouseEvent(e);
        e.setSource(src);
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent e) {
        super.processMouseMotionEvent(e);
        Object src = e.getSource();
        e.setSource((Object)this.canvas);
        this.canvas.processMouseMotionEvent(e);
        e.setSource(src);
    }

    @Override
    protected void processMouseWheelEvent(MouseWheelEvent e) {
        super.processMouseWheelEvent(e);
        Object src = e.getSource();
        e.setSource((Object)this.canvas);
        this.canvas.processMouseWheelEvent(e);
        e.setSource(src);
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        if (null == this.canvas || null == this.canvas.getOffScreenBuffer() || 0 == this.getResizeMode()) {
            this.createCanvas(width, height);
        } else if (1 == this.getResizeMode() && null != this.canvas.getParent() && this.canvas.getParent().isVisible()) {
            if (null == this.canvas.resizeThread || !this.canvas.resizeThread.isAlive()) {
                this.canvas.resizeThread = new ResizeThread(width, height, this.getResizeValidationDelay(), this);
                this.canvas.resizeThread.start();
            } else {
                this.canvas.resizeThread.setWidth(width);
                this.canvas.resizeThread.setHeight(height);
            }
        }
    }

    public void setResizeMode(int resizeMode) {
        this.resizeMode = resizeMode;
    }

    public void setResizeValidationDelay(int resizeValidationDelay) {
        this.resizeValidationDelay = resizeValidationDelay;
    }

    static class ResizeThread
    extends Thread {
        TransCanvas3D canvas;
        boolean sizeChanged;
        int delay;
        int height;
        int width;

        public ResizeThread(int width, int height, int delay, TransCanvas3D canvas) {
            this.width = width;
            this.height = height;
            this.delay = delay;
            this.sizeChanged = true;
            this.canvas = canvas;
        }

        public int getHeight() {
            return this.height;
        }

        public int getWidth() {
            return this.width;
        }

        @Override
        public void run() {
            try {
                while (this.sizeChanged) {
                    while (this.sizeChanged) {
                        this.sizeChanged = false;
                        Thread.sleep(this.delay);
                    }
                    try {
                        EventQueue.invokeAndWait(new ResizeSwingRunnable(this.canvas, this.width, this.height));
                    }
                    catch (InterruptedException ie) {
                    }
                    catch (InvocationTargetException ite) {}
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public void setHeight(int height) {
            if (!this.isAlive()) {
                throw new RuntimeException("Resizing order arrived to a dead resizing thread. Spawn a new one.");
            }
            this.height = height;
            this.sizeChanged = true;
        }

        public void setWidth(int width) {
            if (!this.isAlive()) {
                throw new RuntimeException("Resizing order arrived to a dead resizing thread. Spawn a new one.");
            }
            this.width = width;
            this.sizeChanged = true;
        }
    }

    static class ResizeSwingRunnable
    implements Runnable {
        TransCanvas3D canvas;
        int height;
        int width;

        public ResizeSwingRunnable(TransCanvas3D canvas, int width, int height) {
            this.canvas = canvas;
            this.width = width;
            this.height = height;
        }

        @Override
        public void run() {
            this.canvas.createCanvas(this.width, this.height);
        }
    }

    static class InternalCanvas3D
    extends Canvas3D
    implements AutoOffScreenCanvas3D {
        private static final long serialVersionUID = 1L;
        private static final int MAX_WAIT_LOOPS = 5;
        private static final long MAX_WAIT_TIME = 100L;
        BufferedImage bi = null;
        Raster zRaster = null;
        GraphicsContext3D gc3d = null;
        TransCanvas3D lwCanvas;
        ResizeThread resizeThread;
        boolean addNotifyFlag;
        protected boolean canvasCrashed;
        boolean imageReadyBis;
        boolean waitingForSwap;

        public InternalCanvas3D(GraphicsConfiguration graphicsConfiguration, TransCanvas3D lwCanvas) {
            super(graphicsConfiguration, true);
            this.lwCanvas = lwCanvas;
            this.imageReadyBis = false;
            this.waitingForSwap = false;
            this.addNotifyFlag = false;
            this.gc3d = this.getGraphicsContext3D();
        }

        public void addNotify() {
            if (!this.addNotifyFlag) {
                throw new UnsupportedOperationException("CHANGE ME");
            }
            this.addNotifyFlag = false;
            super.addNotify();
        }

        public Container getParent() {
            if (null == this.lwCanvas) {
                return null;
            }
            return this.lwCanvas.getParent();
        }

        public void postRender() {
            this.imageReadyBis = false;
        }

        public synchronized void postSwap() {
            if (this.isRendererRunning()) {
                this.bi = this.getOffScreenBuffer().getImage();
                this.gc3d.readRaster(this.zRaster);
                this.imageReadyBis = true;
                if (!this.waitingForSwap) {
                    this.lwCanvas.repaint();
                } else {
                    ((Object)((Object)this)).notify();
                }
            }
        }

        protected void processComponentEvent(ComponentEvent e) {
            super.processComponentEvent(e);
        }

        protected void processFocusEvent(FocusEvent e) {
            super.processFocusEvent(e);
        }

        protected void processInputMethodEvent(InputMethodEvent e) {
            super.processInputMethodEvent(e);
        }

        protected void processKeyEvent(KeyEvent e) {
            super.processKeyEvent(e);
        }

        protected void processMouseEvent(MouseEvent e) {
            super.processMouseEvent(e);
        }

        protected void processMouseMotionEvent(MouseEvent e) {
            super.processMouseMotionEvent(e);
        }

        protected void processMouseWheelEvent(MouseWheelEvent e) {
            super.processMouseWheelEvent(e);
        }

        synchronized void waitForSwap() {
            int counter = 5;
            while (!this.imageReadyBis) {
                try {
                    this.waitingForSwap = true;
                    ((Object)((Object)this)).wait(100L);
                    this.waitingForSwap = false;
                    if (this.imageReadyBis || --counter > 0) continue;
                    System.err.println("CANVAS CRASHED!!!");
                    this.canvasCrashed = true;
                    return;
                }
                catch (InterruptedException ex) {
                    System.err.println(ex);
                }
            }
        }
    }
}

