/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import com.jogamp.common.nio.Buffers;
import com.jogamp.nativewindow.awt.AWTGraphicsConfiguration;
import com.jogamp.nativewindow.awt.AWTGraphicsDevice;
import com.jogamp.nativewindow.awt.AWTGraphicsScreen;
import com.jogamp.nativewindow.awt.JAWTWindow;
import com.jogamp.opengl.FBObject;
import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.DisplayMode;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Context;
import javax.media.j3d.Drawable;
import javax.media.j3d.DrawingSurfaceObject;
import javax.media.j3d.GeometryArrayRetained;
import javax.media.j3d.GeometryStripArrayRetained;
import javax.media.j3d.GraphicsConfigInfo;
import javax.media.j3d.GraphicsConfigTemplate3D;
import javax.media.j3d.IllegalRenderingStateException;
import javax.media.j3d.IndexedGeometryStripArrayRetained;
import javax.media.j3d.JoglContext;
import javax.media.j3d.JoglDrawable;
import javax.media.j3d.JoglDrawingSurfaceObject;
import javax.media.j3d.JoglGraphicsConfiguration;
import javax.media.j3d.JoglShaderObject;
import javax.media.j3d.Pipeline;
import javax.media.j3d.ShaderAttrLoc;
import javax.media.j3d.ShaderError;
import javax.media.j3d.ShaderId;
import javax.media.j3d.ShaderProgramId;
import javax.media.j3d.VirtualUniverse;
import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.AbstractGraphicsScreen;
import javax.media.nativewindow.CapabilitiesChooser;
import javax.media.nativewindow.CapabilitiesImmutable;
import javax.media.nativewindow.GraphicsConfigurationFactory;
import javax.media.nativewindow.NativeSurface;
import javax.media.nativewindow.NativeWindow;
import javax.media.nativewindow.NativeWindowFactory;
import javax.media.nativewindow.ProxySurface;
import javax.media.nativewindow.UpstreamSurfaceHook;
import javax.media.opengl.DefaultGLCapabilitiesChooser;
import javax.media.opengl.GL;
import javax.media.opengl.GL2;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesChooser;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLException;
import javax.media.opengl.GLFBODrawable;
import javax.media.opengl.GLProfile;
import javax.media.opengl.Threading;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JoglPipeline
extends Pipeline {
    private static final boolean DEBUG = true;
    private static final boolean VERBOSE = false;
    private static final boolean DEBUG_CONFIG = false;
    private static final boolean EXTRA_DEBUGGING = false;
    private static final int WAIT_TIME = 1000;
    private static final int MIN_FRAME_SIZE = 1;
    private GLProfile profile;
    private Object mainThreadContext;
    private static final float[] black;
    private static final int[][] screen_door;
    private static final ByteBuffer[] screen_door_table;
    private static final int[] blendFunctionTable;
    private static final int[] _gl_combineRgbSrcIndex;
    private static final int[] _gl_combineAlphaSrcIndex;
    private static final int[] _gl_combineRgbOpIndex;
    private static final int[] _gl_combineAlphaOpIndex;
    private static final int[] _gl_combineSrc;
    private static final int[] _gl_combineFcn;
    private static final int[] _gl_textureCubeMapFace;
    int numInvalidLists = 0;
    private boolean checkedForGetScreenMethod = false;
    private Method getScreenMethod = null;
    private static ThreadLocal<FloatBuffer> nioVertexTemp;
    private static ThreadLocal<DoubleBuffer> nioVertexDoubleTemp;
    private static ThreadLocal<FloatBuffer> nioColorTemp;
    private static ThreadLocal<ByteBuffer> nioColorByteTemp;
    private static ThreadLocal<FloatBuffer> nioNormalTemp;
    private static ThreadLocal<FloatBuffer[]> nioTexCoordSetTemp;
    private static ThreadLocal<FloatBuffer[]> nioVertexAttrSetTemp;

    protected JoglPipeline() {
        try {
            this.mainThreadContext = Class.forName("sun.awt.AppContext").getMethod("getAppContext", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    void initialize(Pipeline.Type type) {
        super.initialize(type);
        assert (type == Pipeline.Type.JOGL);
        Threading.disableSingleThreading();
        this.profile = GLProfile.getMaxFixedFunc((boolean)true);
    }

    @Override
    void execute(Context context, GeometryArrayRetained geometryArrayRetained, int n, boolean bl, boolean bl2, boolean bl3, int n2, int n3, int n4, int n5, int[] nArray, int n6, int[] nArray2, int n7, int n8, int[] nArray3, float[] fArray, float[] fArray2, int n9) {
        this.executeGeometryArray(context, geometryArrayRetained, n, bl, bl2, bl3, n2, n3, n4, n5, nArray, n6, nArray2, n7, n8, nArray3, fArray, null, fArray2, n9);
    }

    @Override
    void executeVA(Context context, GeometryArrayRetained geometryArrayRetained, int n, boolean bl, boolean bl2, int n2, int n3, int n4, int n5, float[] fArray, double[] dArray, int n6, float[] fArray2, byte[] byArray, int n7, float[] fArray3, int n8, int[] nArray, int[] nArray2, float[][] fArray4, int n9, int[] nArray3, int n10, int[] nArray4, int n11, Object[] objectArray, int n12) {
        boolean bl3 = (n4 & 1) != 0;
        boolean bl4 = (n4 & 2) != 0;
        boolean bl5 = (n4 & 4) != 0;
        boolean bl6 = (n4 & 8) != 0;
        boolean bl7 = (n4 & 0x10) != 0;
        boolean bl8 = (n4 & 0x40) != 0;
        boolean bl9 = (n4 & 0x20) != 0;
        FloatBuffer floatBuffer = null;
        DoubleBuffer doubleBuffer = null;
        FloatBuffer floatBuffer2 = null;
        ByteBuffer byteBuffer = null;
        FloatBuffer[] floatBufferArray = null;
        FloatBuffer floatBuffer3 = null;
        FloatBuffer[] floatBufferArray2 = null;
        if (bl8) {
            floatBufferArray2 = JoglPipeline.getVertexAttrSetBuffer((Object[])fArray4);
        }
        if (bl9) {
            floatBufferArray = JoglPipeline.getTexCoordSetBuffer(objectArray);
        }
        if (bl3) {
            floatBuffer = JoglPipeline.getVertexArrayBuffer(fArray);
        } else if (bl4) {
            doubleBuffer = JoglPipeline.getVertexArrayBuffer(dArray);
        }
        if (bl5) {
            floatBuffer2 = JoglPipeline.getColorArrayBuffer(fArray2);
        } else if (bl6) {
            byteBuffer = JoglPipeline.getColorArrayBuffer(byArray);
        }
        if (bl7) {
            floatBuffer3 = JoglPipeline.getNormalArrayBuffer(fArray3);
        }
        int[] nArray5 = null;
        int[] nArray6 = null;
        int n13 = 0;
        if (n == 5 || n == 6 || n == 7) {
            nArray5 = ((GeometryStripArrayRetained)geometryArrayRetained).stripVertexCounts;
            n13 = nArray5.length;
            nArray6 = ((GeometryStripArrayRetained)geometryArrayRetained).stripStartOffsetIndices;
        }
        this.executeGeometryArrayVA(context, geometryArrayRetained, n, bl, bl2, n2, n3, n4, n5, floatBuffer, doubleBuffer, n6, floatBuffer2, byteBuffer, n7, floatBuffer3, n8, nArray, nArray2, floatBufferArray2, n9, nArray3, n10, nArray4, n11, floatBufferArray, n12, nArray5, n13, nArray6);
    }

    @Override
    void executeVABuffer(Context context, GeometryArrayRetained geometryArrayRetained, int n, boolean bl, boolean bl2, int n2, int n3, int n4, int n5, Buffer buffer, int n6, Buffer buffer2, float[] fArray, byte[] byArray, int n7, FloatBuffer floatBuffer, int n8, int[] nArray, int[] nArray2, FloatBuffer[] floatBufferArray, int n9, int[] nArray3, int n10, int[] nArray4, int n11, Object[] objectArray, int n12) {
        boolean bl3 = (n4 & 1) != 0;
        boolean bl4 = (n4 & 2) != 0;
        boolean bl5 = (n4 & 4) != 0;
        boolean bl6 = (n4 & 8) != 0;
        boolean bl7 = (n4 & 0x10) != 0;
        boolean bl8 = (n4 & 0x40) != 0;
        boolean bl9 = (n4 & 0x20) != 0;
        FloatBuffer floatBuffer2 = null;
        DoubleBuffer doubleBuffer = null;
        FloatBuffer floatBuffer3 = null;
        ByteBuffer byteBuffer = null;
        FloatBuffer[] floatBufferArray2 = null;
        FloatBuffer floatBuffer4 = null;
        FloatBuffer[] floatBufferArray3 = null;
        if (bl8) {
            floatBufferArray3 = floatBufferArray;
        }
        if (bl9) {
            floatBufferArray2 = new FloatBuffer[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                floatBufferArray2[i] = (FloatBuffer)objectArray[i];
            }
        }
        if (bl3) {
            floatBuffer2 = (FloatBuffer)buffer;
        } else if (bl4) {
            doubleBuffer = (DoubleBuffer)buffer;
        }
        if (floatBuffer2 == null && doubleBuffer == null) {
            return;
        }
        if (bl5) {
            floatBuffer3 = fArray != null ? JoglPipeline.getColorArrayBuffer(fArray) : (FloatBuffer)buffer2;
        } else if (bl6) {
            byteBuffer = byArray != null ? JoglPipeline.getColorArrayBuffer(byArray) : (ByteBuffer)buffer2;
        }
        if (bl7) {
            floatBuffer4 = floatBuffer;
        }
        int[] nArray5 = null;
        int[] nArray6 = null;
        int n13 = 0;
        if (n == 5 || n == 6 || n == 7) {
            nArray5 = ((GeometryStripArrayRetained)geometryArrayRetained).stripVertexCounts;
            n13 = nArray5.length;
            nArray6 = ((GeometryStripArrayRetained)geometryArrayRetained).stripStartOffsetIndices;
        }
        this.executeGeometryArrayVA(context, geometryArrayRetained, n, bl, bl2, n2, n3, n4, n5, floatBuffer2, doubleBuffer, n6, floatBuffer3, byteBuffer, n7, floatBuffer4, n8, nArray, nArray2, floatBufferArray3, n9, nArray3, n10, nArray4, n11, floatBufferArray2, n12, nArray5, n13, nArray6);
    }

    @Override
    void executeInterleavedBuffer(Context context, GeometryArrayRetained geometryArrayRetained, int n, boolean bl, boolean bl2, boolean bl3, int n2, int n3, int n4, int n5, int[] nArray, int n6, int[] nArray2, int n7, FloatBuffer floatBuffer, float[] fArray, int n8) {
        this.executeGeometryArray(context, geometryArrayRetained, n, bl, bl2, bl3, n2, n3, n4, n5, nArray, n6, nArray2, n7, 0, null, null, floatBuffer, fArray, n8);
    }

    @Override
    void setVertexFormat(Context context, GeometryArrayRetained geometryArrayRetained, int n, boolean bl, boolean bl2) {
        GL2 gL2 = this.context(context).getGL().getGL2();
        if ((n & 2) != 0) {
            gL2.glEnableClientState(32885);
        } else {
            gL2.glDisableClientState(32885);
        }
        if (!bl2 && (n & 4) != 0) {
            gL2.glEnableClientState(32886);
        } else {
            gL2.glDisableClientState(32886);
        }
        if ((n & 1) != 0) {
            gL2.glEnableClientState(32884);
        } else {
            gL2.glDisableClientState(32884);
        }
    }

    @Override
    void buildGA(Context context, GeometryArrayRetained geometryArrayRetained, int n, boolean bl, boolean bl2, float f, boolean bl3, int n2, int n3, int n4, int n5, int[] nArray, int n6, int[] nArray2, int n7, int[] nArray3, double[] dArray, double[] dArray2, float[] fArray) {
        int n8;
        JoglContext joglContext = (JoglContext)context;
        GL2 gL2 = this.context(context).getGL().getGL2();
        FloatBuffer floatBuffer = null;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        int n15 = 0;
        if ((n4 & 1) != 0) {
            n9 += 3;
        }
        if ((n4 & 2) != 0) {
            n9 += 3;
            n10 += 3;
        }
        if ((n4 & 4) != 0) {
            if ((n4 & 0x80) != 0) {
                if ((n4 & 8) != 0) {
                    n9 += 4;
                    n11 += 4;
                    n10 += 4;
                } else {
                    n9 += 3;
                    n11 += 3;
                    n10 += 3;
                }
            } else {
                n9 += 4;
                n11 += 4;
                n10 += 4;
            }
        }
        if ((n4 & 0x460) != 0) {
            if ((n4 & 0x20) != 0) {
                n14 = 2 * n5;
            } else if ((n4 & 0x40) != 0) {
                n14 = 3 * n5;
            } else if ((n4 & 0x400) != 0) {
                n14 = 4 * n5;
            }
            n9 += n14;
            n11 += n14;
            n12 += n14;
            n10 += n14;
        }
        int n16 = 0;
        if ((n4 & 0x1000) != 0) {
            for (n8 = 0; n8 < n7; ++n8) {
                n16 += nArray3[n8];
            }
            n9 += n16;
            n11 += n16;
            n12 += n16;
            n10 += n16;
            n13 += n16;
        }
        n8 = n9 * 4;
        int n17 = n2 * n9;
        n11 += n17;
        n12 += n17;
        n10 += n17;
        n13 += n17;
        n15 += n17;
        boolean bl4 = false;
        if (bl2 && !bl3) {
            bl4 = true;
        }
        if (n == 5 || n == 6 || n == 7) {
            int[] nArray4 = ((GeometryStripArrayRetained)geometryArrayRetained).stripVertexCounts;
            int n18 = 0;
            switch (n) {
                case 5: {
                    n18 = 5;
                    break;
                }
                case 6: {
                    n18 = 6;
                    break;
                }
                case 7: {
                    n18 = 3;
                }
            }
            if (bl3) {
                n4 &= 0xFFFFFFFB;
            }
            for (int i = 0; i < nArray4.length; ++i) {
                gL2.glBegin(n18);
                for (int j = 0; j < nArray4[i]; ++j) {
                    float f2;
                    float f3;
                    float f4;
                    if ((n4 & 2) != 0) {
                        if (dArray2 != null) {
                            f4 = (float)(dArray2[0] * (double)fArray[n11] + dArray2[1] * (double)fArray[n11 + 1] + dArray2[2] * (double)fArray[n11 + 2]);
                            f3 = (float)(dArray2[4] * (double)fArray[n11] + dArray2[5] * (double)fArray[n11 + 1] + dArray2[6] * (double)fArray[n11 + 2]);
                            f2 = (float)(dArray2[8] * (double)fArray[n11] + dArray2[9] * (double)fArray[n11 + 1] + dArray2[10] * (double)fArray[n11 + 2]);
                            gL2.glNormal3f(f4, f3, f2);
                        } else {
                            gL2.glNormal3f(fArray[n11], fArray[n11 + 1], fArray[n11 + 2]);
                        }
                    }
                    if ((n4 & 4) != 0) {
                        if (bl4) {
                            gL2.glColor4f(fArray[n12], fArray[n12 + 1], fArray[n12 + 2], fArray[n12 + 3] * f);
                        } else if ((n4 & 8) != 0) {
                            gL2.glColor4f(fArray[n12], fArray[n12 + 1], fArray[n12 + 2], fArray[n12 + 3]);
                        } else {
                            gL2.glColor3f(fArray[n12], fArray[n12 + 1], fArray[n12 + 2]);
                        }
                    }
                    if ((n4 & 0x1000) != 0) {
                        int n19 = n15;
                        if (floatBuffer == null) {
                            floatBuffer = FloatBuffer.wrap(fArray);
                        }
                        for (int k = 0; k < n7; ++k) {
                            switch (nArray3[k]) {
                                case 1: {
                                    floatBuffer.position(n19);
                                    joglContext.vertexAttr1fv((GL)gL2, k, floatBuffer);
                                    break;
                                }
                                case 2: {
                                    floatBuffer.position(n19);
                                    joglContext.vertexAttr2fv((GL)gL2, k, floatBuffer);
                                    break;
                                }
                                case 3: {
                                    floatBuffer.position(n19);
                                    joglContext.vertexAttr3fv((GL)gL2, k, floatBuffer);
                                    break;
                                }
                                case 4: {
                                    floatBuffer.position(n19);
                                    joglContext.vertexAttr4fv((GL)gL2, k, floatBuffer);
                                }
                            }
                            n19 += nArray3[k];
                        }
                    }
                    if ((n4 & 0x460) != 0 && n6 > 0) {
                        if (gL2.isExtensionAvailable("GL_VERSION_1_3")) {
                            if ((n4 & 0x20) != 0) {
                                for (int k = 0; k < n6; ++k) {
                                    if (nArray2[k] == -1) continue;
                                    int n20 = n13 + nArray2[k];
                                    gL2.glMultiTexCoord2f(33984 + k, fArray[n20], fArray[n20 + 1]);
                                }
                            } else if ((n4 & 0x40) != 0) {
                                for (int k = 0; k < n6; ++k) {
                                    if (nArray2[k] == -1) continue;
                                    int n21 = n13 + nArray2[k];
                                    gL2.glMultiTexCoord3f(33984 + k, fArray[n21], fArray[n21 + 1], fArray[n21 + 2]);
                                }
                            } else {
                                for (int k = 0; k < n6; ++k) {
                                    if (nArray2[k] == -1) continue;
                                    int n22 = n13 + nArray2[k];
                                    gL2.glMultiTexCoord4f(33984 + k, fArray[n22], fArray[n22 + 1], fArray[n22 + 2], fArray[n22 + 3]);
                                }
                            }
                        } else if (nArray2[0] != -1) {
                            int n23 = n13 + nArray2[0];
                            if ((n4 & 0x20) != 0) {
                                gL2.glTexCoord2f(fArray[n23], fArray[n23 + 1]);
                            } else if ((n4 & 0x40) != 0) {
                                gL2.glTexCoord3f(fArray[n23], fArray[n23 + 1], fArray[n23 + 2]);
                            } else {
                                gL2.glTexCoord4f(fArray[n23], fArray[n23 + 1], fArray[n23 + 2], fArray[n23 + 3]);
                            }
                        }
                    }
                    if ((n4 & 1) != 0) {
                        if (dArray != null) {
                            f4 = (float)(dArray[12] * (double)fArray[n10] + dArray[13] * (double)fArray[n10 + 1] + dArray[14] * (double)fArray[n10 + 2] + dArray[15]);
                            f3 = 1.0f / f4;
                            f2 = (float)(dArray[0] * (double)fArray[n10] + dArray[1] * (double)fArray[n10 + 1] + dArray[2] * (double)fArray[n10 + 2] + dArray[3]) * f3;
                            float f5 = (float)(dArray[4] * (double)fArray[n10] + dArray[5] * (double)fArray[n10 + 1] + dArray[6] * (double)fArray[n10 + 2] + dArray[7]) * f3;
                            float f6 = (float)(dArray[8] * (double)fArray[n10] + dArray[9] * (double)fArray[n10 + 1] + dArray[10] * (double)fArray[n10 + 2] + dArray[11]) * f3;
                            gL2.glVertex3f(f2, f5, f6);
                        } else {
                            gL2.glVertex3f(fArray[n10], fArray[n10 + 1], fArray[n10 + 2]);
                        }
                    }
                    n11 += n9;
                    n12 += n9;
                    n10 += n9;
                    n13 += n9;
                    n15 += n9;
                }
                gL2.glEnd();
            }
        } else if (n == 1 || n == 2 || n == 3 || n == 4) {
            int n24 = 0;
            switch (n) {
                case 1: {
                    n24 = 7;
                    break;
                }
                case 2: {
                    n24 = 4;
                    break;
                }
                case 3: {
                    n24 = 0;
                    break;
                }
                case 4: {
                    n24 = 1;
                }
            }
            if (bl3) {
                n4 &= 0xFFFFFFFB;
            }
            gL2.glBegin(n24);
            for (int i = 0; i < n3; ++i) {
                float f7;
                float f8;
                if ((n4 & 2) != 0) {
                    if (dArray2 != null) {
                        float f9 = (float)(dArray2[0] * (double)fArray[n11] + dArray2[1] * (double)fArray[n11 + 1] + dArray2[2] * (double)fArray[n11 + 2]);
                        float f10 = (float)(dArray2[4] * (double)fArray[n11] + dArray2[5] * (double)fArray[n11 + 1] + dArray2[6] * (double)fArray[n11 + 2]);
                        f8 = (float)(dArray2[8] * (double)fArray[n11] + dArray2[9] * (double)fArray[n11 + 1] + dArray2[10] * (double)fArray[n11 + 2]);
                        gL2.glNormal3f(f9, f10, f8);
                    } else {
                        gL2.glNormal3f(fArray[n11], fArray[n11 + 1], fArray[n11 + 2]);
                    }
                }
                if ((n4 & 4) != 0) {
                    if (bl4) {
                        float f11;
                        float f12;
                        if ((n4 & 8) != 0) {
                            f12 = fArray[n12];
                            f11 = fArray[n12 + 1];
                            f8 = fArray[n12 + 2];
                            f7 = fArray[n12 + 3] * f;
                        } else {
                            f12 = fArray[n12];
                            f11 = fArray[n12 + 1];
                            f8 = fArray[n12 + 2];
                            f7 = f;
                        }
                        gL2.glColor4f(f12, f11, f8, f7);
                    } else if ((n4 & 8) != 0) {
                        gL2.glColor4f(fArray[n12], fArray[n12 + 1], fArray[n12 + 2], fArray[n12 + 3]);
                    } else {
                        gL2.glColor3f(fArray[n12], fArray[n12 + 1], fArray[n12 + 2]);
                    }
                }
                if ((n4 & 0x1000) != 0) {
                    int n25 = n15;
                    if (floatBuffer == null) {
                        floatBuffer = FloatBuffer.wrap(fArray);
                    }
                    for (int j = 0; j < n7; ++j) {
                        switch (nArray3[j]) {
                            case 1: {
                                floatBuffer.position(n25);
                                joglContext.vertexAttr1fv((GL)gL2, j, floatBuffer);
                                break;
                            }
                            case 2: {
                                floatBuffer.position(n25);
                                joglContext.vertexAttr2fv((GL)gL2, j, floatBuffer);
                                break;
                            }
                            case 3: {
                                floatBuffer.position(n25);
                                joglContext.vertexAttr3fv((GL)gL2, j, floatBuffer);
                                break;
                            }
                            case 4: {
                                floatBuffer.position(n25);
                                joglContext.vertexAttr4fv((GL)gL2, j, floatBuffer);
                            }
                        }
                        n25 += nArray3[j];
                    }
                }
                if ((n4 & 0x460) != 0 && n6 > 0) {
                    if (gL2.isExtensionAvailable("GL_VERSION_1_3")) {
                        if ((n4 & 0x20) != 0) {
                            for (int j = 0; j < n6; ++j) {
                                if (nArray2[j] == -1) continue;
                                int n26 = n13 + nArray2[j];
                                gL2.glMultiTexCoord2f(33984 + j, fArray[n26], fArray[n26 + 1]);
                            }
                        } else if ((n4 & 0x40) != 0) {
                            for (int j = 0; j < n6; ++j) {
                                if (nArray2[j] == -1) continue;
                                int n27 = n13 + nArray2[j];
                                gL2.glMultiTexCoord3f(33984 + j, fArray[n27], fArray[n27 + 1], fArray[n27 + 2]);
                            }
                        } else {
                            for (int j = 0; j < n6; ++j) {
                                if (nArray2[j] == -1) continue;
                                int n28 = n13 + nArray2[j];
                                gL2.glMultiTexCoord4f(33984 + j, fArray[n28], fArray[n28 + 1], fArray[n28 + 2], fArray[n28 + 3]);
                            }
                        }
                    } else if (nArray2[0] != -1) {
                        int n29 = n13 + nArray2[0];
                        if ((n4 & 0x20) != 0) {
                            gL2.glTexCoord2f(fArray[n29], fArray[n29 + 1]);
                        } else if ((n4 & 0x40) != 0) {
                            gL2.glTexCoord3f(fArray[n29], fArray[n29 + 1], fArray[n29 + 2]);
                        } else {
                            gL2.glTexCoord4f(fArray[n29], fArray[n29 + 1], fArray[n29 + 2], fArray[n29 + 3]);
                        }
                    }
                }
                if ((n4 & 1) != 0) {
                    if (dArray != null) {
                        float f13 = (float)(dArray[12] * (double)fArray[n10] + dArray[13] * (double)fArray[n10 + 1] + dArray[14] * (double)fArray[n10 + 2] + dArray[15]);
                        float f14 = 1.0f / f13;
                        f8 = (float)(dArray[0] * (double)fArray[n10] + dArray[1] * (double)fArray[n10 + 1] + dArray[2] * (double)fArray[n10 + 2] + dArray[3]) * f14;
                        f7 = (float)(dArray[4] * (double)fArray[n10] + dArray[5] * (double)fArray[n10 + 1] + dArray[6] * (double)fArray[n10 + 2] + dArray[7]) * f14;
                        float f15 = (float)(dArray[8] * (double)fArray[n10] + dArray[9] * (double)fArray[n10 + 1] + dArray[10] * (double)fArray[n10 + 2] + dArray[11]) * f14;
                        gL2.glVertex3f(f8, f7, f15);
                    } else {
                        gL2.glVertex3f(fArray[n10], fArray[n10 + 1], fArray[n10 + 2]);
                    }
                }
                n11 += n9;
                n12 += n9;
                n10 += n9;
                n13 += n9;
                n15 += n9;
            }
            gL2.glEnd();
        }
    }

    @Override
    void buildGAForByRef(Context context, GeometryArrayRetained geometryArrayRetained, int n, boolean bl, boolean bl2, float f, boolean bl3, int n2, int n3, int n4, int n5, float[] fArray, double[] dArray, int n6, float[] fArray2, byte[] byArray, int n7, float[] fArray3, int n8, int[] nArray, int[] nArray2, float[][] fArray4, int n9, int[] nArray3, int[] nArray4, int n10, Object[] objectArray, double[] dArray2, double[] dArray3) {
        int n11;
        int n12;
        GL2 gL2 = this.context(context).getGL().getGL2();
        boolean bl4 = (n4 & 1) != 0;
        boolean bl5 = (n4 & 2) != 0;
        boolean bl6 = (n4 & 4) != 0;
        boolean bl7 = (n4 & 8) != 0;
        boolean bl8 = (n4 & 0x10) != 0;
        boolean bl9 = (n4 & 0x40) != 0;
        boolean bl10 = (n4 & 0x20) != 0;
        FloatBuffer floatBuffer = null;
        DoubleBuffer doubleBuffer = null;
        FloatBuffer floatBuffer2 = null;
        ByteBuffer byteBuffer = null;
        FloatBuffer[] floatBufferArray = null;
        FloatBuffer floatBuffer3 = null;
        FloatBuffer[] floatBufferArray2 = null;
        if (bl9) {
            floatBufferArray2 = JoglPipeline.getVertexAttrSetBuffer((Object[])fArray4);
        }
        if (bl10) {
            floatBufferArray = JoglPipeline.getTexCoordSetBuffer(objectArray);
        }
        boolean bl11 = false;
        if (bl2 && !bl3) {
            bl11 = true;
        }
        int[] nArray5 = null;
        int[] nArray6 = null;
        int n13 = 0;
        if (n == 5 || n == 6 || n == 7) {
            nArray5 = ((GeometryStripArrayRetained)geometryArrayRetained).stripVertexCounts;
            n13 = nArray5.length;
            nArray6 = ((GeometryStripArrayRetained)geometryArrayRetained).stripStartOffsetIndices;
        }
        if (bl3) {
            n3 &= 0xFFFFFFFB;
            bl6 = false;
            bl7 = false;
        }
        if (bl4) {
            gL2.glEnableClientState(32884);
            floatBuffer = JoglPipeline.getVertexArrayBuffer(fArray, dArray2 == null);
            if (dArray2 != null) {
                for (n12 = n5; n12 < n2 * 3; n12 += 3) {
                    floatBuffer.put(n12, (float)(dArray2[0] * (double)fArray[n12] + dArray2[1] * (double)fArray[n12 + 1] + dArray2[2] * (double)fArray[n12 + 2]));
                    floatBuffer.put(n12 + 1, (float)(dArray2[4] * (double)fArray[n12] + dArray2[5] * (double)fArray[n12 + 1] + dArray2[6] * (double)fArray[n12 + 2]));
                    floatBuffer.put(n12 + 2, (float)(dArray2[8] * (double)fArray[n12] + dArray2[9] * (double)fArray[n12 + 1] + dArray2[10] * (double)fArray[n12 + 2]));
                }
            }
        } else if (bl5) {
            gL2.glEnableClientState(32884);
            doubleBuffer = JoglPipeline.getVertexArrayBuffer(dArray, dArray2 == null);
            if (dArray2 != null) {
                for (n12 = n5; n12 < n2 * 3; n12 += 3) {
                    doubleBuffer.put(n12, dArray2[0] * dArray[n12] + dArray2[1] * dArray[n12 + 1] + dArray2[2] * dArray[n12 + 2]);
                    doubleBuffer.put(n12 + 1, dArray2[4] * dArray[n12] + dArray2[5] * dArray[n12 + 1] + dArray2[6] * dArray[n12 + 2]);
                    doubleBuffer.put(n12 + 2, dArray2[8] * dArray[n12] + dArray2[9] * dArray[n12 + 1] + dArray2[10] * dArray[n12 + 2]);
                }
            }
        } else {
            gL2.glDisableClientState(32884);
        }
        if (bl6) {
            gL2.glEnableClientState(32886);
            floatBuffer2 = JoglPipeline.getColorArrayBuffer(fArray2, !bl11);
            if (bl11) {
                if ((n3 & 8) != 0) {
                    for (n12 = n6; n12 < n2 * 4; n12 += 4) {
                        floatBuffer2.put(n12, fArray2[n12]);
                        floatBuffer2.put(n12 + 1, fArray2[n12 + 1]);
                        floatBuffer2.put(n12 + 2, fArray2[n12 + 2]);
                        floatBuffer2.put(n12 + 3, f * fArray2[n12 + 3]);
                    }
                } else {
                    n12 = 0;
                    for (n11 = n6; n11 < n2 * 4; n11 += 4) {
                        floatBuffer2.put(n11, fArray2[n12++]);
                        floatBuffer2.put(n11 + 1, fArray2[n12++]);
                        floatBuffer2.put(n11 + 2, fArray2[n12++]);
                        floatBuffer2.put(n11 + 3, f);
                    }
                }
                n3 |= 8;
            }
        } else if (bl7) {
            gL2.glEnableClientState(32886);
            byteBuffer = JoglPipeline.getColorArrayBuffer(byArray, !bl11);
            if (bl11) {
                if ((n3 & 8) != 0) {
                    for (n12 = n6; n12 < n2 * 4; n12 += 4) {
                        byteBuffer.put(n12, byArray[n12]);
                        byteBuffer.put(n12 + 1, byArray[n12 + 1]);
                        byteBuffer.put(n12 + 2, byArray[n12 + 2]);
                        byteBuffer.put(n12 + 3, (byte)(f * (float)(byArray[n12 + 3] & 0xFF)));
                    }
                } else {
                    n12 = 0;
                    for (n11 = n6; n11 < n2 * 4; n11 += 4) {
                        byteBuffer.put(n11, byArray[n12++]);
                        byteBuffer.put(n11 + 1, byArray[n12++]);
                        byteBuffer.put(n11 + 2, byArray[n12++]);
                        byteBuffer.put(n11 + 3, (byte)(f * 255.0f));
                    }
                }
                n3 |= 8;
            }
        } else {
            gL2.glDisableClientState(32886);
        }
        if (bl8) {
            gL2.glEnableClientState(32885);
            floatBuffer3 = JoglPipeline.getNormalArrayBuffer(fArray3, dArray3 == null);
            if (dArray3 != null) {
                for (n12 = n7; n12 < n2 * 3; n12 += 3) {
                    floatBuffer3.put(n12, (float)(dArray3[0] * (double)fArray3[n12] + dArray3[1] * (double)fArray3[n12 + 1] + dArray3[2] * (double)fArray3[n12 + 2]));
                    floatBuffer3.put(n12 + 1, (float)(dArray3[4] * (double)fArray3[n12] + dArray3[5] * (double)fArray3[n12 + 1] + dArray3[6] * (double)fArray3[n12 + 2]));
                    floatBuffer3.put(n12 + 2, (float)(dArray3[8] * (double)fArray3[n12] + dArray3[9] * (double)fArray3[n12 + 1] + dArray3[10] * (double)fArray3[n12 + 2]));
                }
            }
        } else {
            gL2.glDisableClientState(32885);
        }
        this.executeGeometryArrayVA(context, geometryArrayRetained, n, bl, bl3, n2, n3, n4, n5, floatBuffer, doubleBuffer, n6, floatBuffer2, byteBuffer, n7, floatBuffer3, n8, nArray, nArray2, floatBufferArray2, n9, nArray3, n9, nArray4, n10, floatBufferArray, 0, nArray5, n13, nArray6);
    }

    private void testForInterleavedArrays(int n, boolean[] blArray, int[] nArray) {
        blArray[0] = true;
        switch (n) {
            case 1: {
                nArray[0] = 10785;
                break;
            }
            case 3: {
                nArray[0] = 10789;
                break;
            }
            case 33: {
                nArray[0] = 10791;
                break;
            }
            case 7: 
            case 15: {
                nArray[0] = 10790;
                break;
            }
            case 35: {
                nArray[0] = 10795;
                break;
            }
            case 39: 
            case 47: {
                nArray[0] = 10796;
                break;
            }
            default: {
                blArray[0] = false;
            }
        }
    }

    private void enableTexCoordPointer(GL2 gL2, int n, int n2, int n3, int n4, Buffer buffer) {
        this.clientActiveTextureUnit(gL2, n);
        gL2.glEnableClientState(32888);
        gL2.glTexCoordPointer(n2, n3, n4, buffer);
    }

    private void disableTexCoordPointer(GL2 gL2, int n) {
        this.clientActiveTextureUnit(gL2, n);
        gL2.glDisableClientState(32888);
    }

    private void clientActiveTextureUnit(GL2 gL2, int n) {
        if (gL2.isExtensionAvailable("GL_VERSION_1_3")) {
            gL2.glClientActiveTexture(n + 33984);
        }
    }

    private void executeTexture(int n, int n2, int n3, int n4, int[] nArray, int n5, FloatBuffer floatBuffer, GL2 gL2) {
        int n6 = 0;
        for (int i = 0; i < n5; ++i) {
            n6 = i;
            if (n6 < n && nArray[n6] != -1) {
                floatBuffer.position(n4 + nArray[n6]);
                this.enableTexCoordPointer(gL2, i, n2, 5126, n3, floatBuffer);
                continue;
            }
            this.disableTexCoordPointer(gL2, i);
        }
    }

    private void resetTexture(GL2 gL2, JoglContext joglContext) {
        for (int i = 0; i < joglContext.getMaxTexCoordSets(); ++i) {
            this.disableTexCoordPointer(gL2, i);
        }
        this.clientActiveTextureUnit(gL2, 0);
    }

    private void executeGeometryArray(Context context, GeometryArrayRetained geometryArrayRetained, int n, boolean bl, boolean bl2, boolean bl3, int n2, int n3, int n4, int n5, int[] nArray, int n6, int[] nArray2, int n7, int n8, int[] nArray3, float[] fArray, FloatBuffer floatBuffer, float[] fArray2, int n9) {
        int n10;
        JoglContext joglContext = (JoglContext)context;
        GLContext gLContext = this.context(joglContext);
        GL2 gL2 = gLContext.getGL().getGL2();
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        int n15 = 0;
        int n16 = 0;
        int n17 = 0;
        int n18 = 0;
        int n19 = 0;
        int n20 = 0;
        int n21 = 0;
        int n22 = 0;
        int n23 = 0;
        FloatBuffer floatBuffer2 = null;
        FloatBuffer floatBuffer3 = null;
        int[] nArray4 = null;
        int[] nArray5 = null;
        if ((n4 & 1) != 0) {
            n13 += 3;
        }
        if ((n4 & 2) != 0) {
            n13 += 3;
            n14 += 3;
        }
        if ((n4 & 4) != 0) {
            if ((n4 & 8) != 0) {
                n13 += 4;
                n15 += 4;
                n14 += 4;
            } else {
                n13 += 3;
                n15 += 3;
                n14 += 3;
            }
        }
        if ((n4 & 0x460) != 0) {
            if ((n4 & 0x20) != 0) {
                n18 = 2;
                n19 = 2 * n5;
            } else if ((n4 & 0x40) != 0) {
                n18 = 3;
                n19 = 3 * n5;
            } else if ((n4 & 0x400) != 0) {
                n18 = 4;
                n19 = 4 * n5;
            }
            n13 += n19;
            n15 += n19;
            n16 += n19;
            n14 += n19;
        }
        if ((n4 & 0x1000) != 0) {
            for (n10 = 0; n10 < n8; ++n10) {
                n21 += nArray3[n10];
            }
            n13 += n21;
            n15 += n21;
            n16 += n21;
            n14 += n21;
            n17 += n21;
        }
        n22 = n13 * 4;
        if (n == 5 || n == 6 || n == 7) {
            nArray4 = ((GeometryStripArrayRetained)geometryArrayRetained).stripVertexCounts;
            nArray5 = ((GeometryStripArrayRetained)geometryArrayRetained).stripStartOffsetIndices;
        }
        if (fArray != null) {
            floatBuffer2 = JoglPipeline.getVertexArrayBuffer(fArray);
        } else if (floatBuffer != null) {
            floatBuffer2 = floatBuffer;
        } else {
            throw new AssertionError((Object)"Unable to get vertex pointer");
        }
        n10 = n13;
        if (fArray2 != null) {
            floatBuffer3 = JoglPipeline.getColorArrayBuffer(fArray2);
            n10 = 4;
        } else {
            floatBuffer3 = floatBuffer2;
        }
        n23 = n10 * 4;
        if (bl) {
            gL2.glEnable(2977);
        }
        int n24 = n13 * n2;
        int n25 = n10 * n2;
        if (floatBuffer3 == floatBuffer2) {
            n25 += n16;
        }
        if (n == 5 || n == 6 || n == 7) {
            boolean bl4;
            if (bl3 || fArray2 != null || (n4 & 0x460) != 0 && (n6 > 1 || n5 > 1)) {
                bl4 = false;
            } else {
                boolean[] blArray = new boolean[1];
                int[] nArray6 = new int[1];
                this.testForInterleavedArrays(n4, blArray, nArray6);
                bl4 = blArray[0];
                n11 = nArray6[0];
            }
            if (bl4) {
                floatBuffer2.position(n24);
                gL2.glInterleavedArrays(n11, n22, (Buffer)floatBuffer2);
            } else {
                if ((n4 & 2) != 0) {
                    floatBuffer2.position(n24 + n15);
                    gL2.glNormalPointer(5126, n22, (Buffer)floatBuffer2);
                }
                if (!bl3 && (n4 & 4) != 0) {
                    floatBuffer3.position(n25);
                    if ((n4 & 8) != 0 || bl2) {
                        gL2.glColorPointer(4, 5126, n23, (Buffer)floatBuffer3);
                    } else {
                        gL2.glColorPointer(3, 5126, n23, (Buffer)floatBuffer3);
                    }
                }
                if ((n4 & 1) != 0) {
                    floatBuffer2.position(n24 + n14);
                    gL2.glVertexPointer(3, 5126, n22, (Buffer)floatBuffer2);
                }
                if ((n4 & 0x460) != 0) {
                    this.executeTexture(n6, n18, n22, n17, nArray2, n7, floatBuffer2, gL2);
                }
                if ((n4 & 0x1000) != 0) {
                    int n26 = n24 + n20;
                    for (int i = 0; i < n8; ++i) {
                        joglContext.enableVertexAttrArray((GL)gL2, i);
                        floatBuffer2.position(n26);
                        joglContext.vertexAttrPointer((GL)gL2, i, nArray3[i], 5126, n22, floatBuffer2);
                        n26 += nArray3[i];
                    }
                }
            }
            switch (n) {
                case 5: {
                    n12 = 5;
                    break;
                }
                case 6: {
                    n12 = 6;
                    break;
                }
                case 7: {
                    n12 = 3;
                }
            }
            if (gL2.isExtensionAvailable("GL_EXT_multi_draw_arrays")) {
                gL2.glMultiDrawArrays(n12, nArray5, 0, nArray4, 0, nArray4.length);
            } else {
                for (int i = 0; i < nArray4.length; ++i) {
                    gL2.glDrawArrays(n12, nArray5[i], nArray4[i]);
                }
            }
        } else if (n == 1 || n == 2 || n == 3 || n == 4) {
            boolean bl5;
            if (bl3 || fArray2 != null || (n4 & 0x460) != 0 && (n6 > 1 || n5 > 1)) {
                bl5 = false;
            } else {
                boolean[] blArray = new boolean[1];
                int[] nArray7 = new int[1];
                this.testForInterleavedArrays(n4, blArray, nArray7);
                bl5 = blArray[0];
                n11 = nArray7[0];
            }
            if (bl5) {
                floatBuffer2.position(n24);
                gL2.glInterleavedArrays(n11, n22, (Buffer)floatBuffer2);
            } else {
                if ((n4 & 2) != 0) {
                    floatBuffer2.position(n24 + n15);
                    gL2.glNormalPointer(5126, n22, (Buffer)floatBuffer2);
                }
                if (!bl3 && (n4 & 4) != 0) {
                    floatBuffer3.position(n25);
                    if ((n4 & 8) != 0 || bl2) {
                        gL2.glColorPointer(4, 5126, n23, (Buffer)floatBuffer3);
                    } else {
                        gL2.glColorPointer(3, 5126, n23, (Buffer)floatBuffer3);
                    }
                }
                if ((n4 & 1) != 0) {
                    floatBuffer2.position(n24 + n14);
                    gL2.glVertexPointer(3, 5126, n22, (Buffer)floatBuffer2);
                }
                if ((n4 & 0x460) != 0) {
                    this.executeTexture(n6, n18, n22, n17, nArray2, n7, floatBuffer2, gL2);
                }
                if ((n4 & 0x1000) != 0) {
                    int n27 = n24 + n20;
                    for (int i = 0; i < n8; ++i) {
                        joglContext.enableVertexAttrArray((GL)gL2, i);
                        floatBuffer2.position(n27);
                        joglContext.vertexAttrPointer((GL)gL2, i, nArray3[i], 5126, n22, floatBuffer2);
                        n27 += nArray3[i];
                    }
                }
            }
            switch (n) {
                case 1: {
                    gL2.glDrawArrays(7, 0, n3);
                    break;
                }
                case 2: {
                    gL2.glDrawArrays(4, 0, n3);
                    break;
                }
                case 3: {
                    gL2.glDrawArrays(0, 0, n3);
                    break;
                }
                case 4: {
                    gL2.glDrawArrays(1, 0, n3);
                }
            }
        }
        if (bl) {
            gL2.glDisable(2977);
        }
        if ((n4 & 0x1000) != 0) {
            this.resetVertexAttrs((GL)gL2, joglContext, n8);
        }
        if ((n4 & 0x460) != 0) {
            this.resetTexture(gL2, joglContext);
        }
    }

    private void lockArray(GL2 gL2, int n) {
        if (gL2.isExtensionAvailable("GL_EXT_compiled_vertex_array")) {
            gL2.glLockArraysEXT(0, n);
        }
    }

    private void unlockArray(GL2 gL2) {
        if (gL2.isExtensionAvailable("GL_EXT_compiled_vertex_array")) {
            gL2.glUnlockArraysEXT();
        }
    }

    private void executeGeometryArrayVA(Context context, GeometryArrayRetained geometryArrayRetained, int n, boolean bl, boolean bl2, int n2, int n3, int n4, int n5, FloatBuffer floatBuffer, DoubleBuffer doubleBuffer, int n6, FloatBuffer floatBuffer2, ByteBuffer byteBuffer, int n7, FloatBuffer floatBuffer3, int n8, int[] nArray, int[] nArray2, FloatBuffer[] floatBufferArray, int n9, int[] nArray3, int n10, int[] nArray4, int n11, FloatBuffer[] floatBufferArray2, int n12, int[] nArray5, int n13, int[] nArray6) {
        int n14;
        int n15;
        boolean bl3;
        JoglContext joglContext = (JoglContext)context;
        GLContext gLContext = this.context(joglContext);
        GL2 gL2 = gLContext.getGL().getGL2();
        boolean bl4 = (n4 & 1) != 0;
        boolean bl5 = (n4 & 2) != 0;
        boolean bl6 = (n4 & 4) != 0;
        boolean bl7 = (n4 & 8) != 0;
        boolean bl8 = (n4 & 0x10) != 0;
        boolean bl9 = (n4 & 0x40) != 0;
        boolean bl10 = bl3 = (n4 & 0x20) != 0;
        if (bl) {
            gL2.glEnable(2977);
        }
        int n16 = 3 * n5;
        if (bl4) {
            floatBuffer.position(n16);
            gL2.glVertexPointer(3, 5126, 0, (Buffer)floatBuffer);
        } else if (bl5) {
            doubleBuffer.position(n16);
            gL2.glVertexPointer(3, 5130, 0, (Buffer)doubleBuffer);
        }
        if (bl6) {
            if ((n3 & 8) != 0) {
                n15 = 4 * n6;
                n14 = 4;
            } else {
                n15 = 3 * n6;
                n14 = 3;
            }
            floatBuffer2.position(n15);
            gL2.glColorPointer(n14, 5126, 0, (Buffer)floatBuffer2);
        } else if (bl7) {
            if ((n3 & 8) != 0) {
                n15 = 4 * n6;
                n14 = 4;
            } else {
                n15 = 3 * n6;
                n14 = 3;
            }
            byteBuffer.position(n15);
            gL2.glColorPointer(n14, 5121, 0, (Buffer)byteBuffer);
        }
        if (bl8) {
            n15 = 3 * n7;
            floatBuffer3.position(n15);
            gL2.glNormalPointer(5126, 0, (Buffer)floatBuffer3);
        }
        if (bl9) {
            for (n15 = 0; n15 < n8; ++n15) {
                FloatBuffer floatBuffer4 = floatBufferArray[n15];
                int n17 = nArray[n15];
                int n18 = nArray2[n15];
                joglContext.enableVertexAttrArray((GL)gL2, n15);
                floatBuffer4.position(n18 * n17);
                joglContext.vertexAttrPointer((GL)gL2, n15, n17, 5126, 0, floatBuffer4);
            }
        }
        if (bl3) {
            n15 = 0;
            for (n14 = 0; n14 < n10; ++n14) {
                if (n14 < n9 && (n15 = nArray3[n14]) != -1) {
                    FloatBuffer floatBuffer5 = floatBufferArray2[n15];
                    floatBuffer5.position(n11 * nArray4[n15]);
                    this.enableTexCoordPointer(gL2, n14, n11, 5126, 0, floatBuffer5);
                    continue;
                }
                this.disableTexCoordPointer(gL2, n14);
            }
            this.clientActiveTextureUnit(gL2, 0);
        }
        if (n == 5 || n == 6 || n == 7) {
            n15 = 0;
            switch (n) {
                case 5: {
                    n15 = 5;
                    break;
                }
                case 6: {
                    n15 = 6;
                    break;
                }
                case 7: {
                    n15 = 3;
                }
            }
            if (gL2.isExtensionAvailable("GL_EXT_multi_draw_arrays")) {
                gL2.glMultiDrawArrays(n15, nArray6, 0, nArray5, 0, n13);
            } else if (gL2.isExtensionAvailable("GL_VERSION_1_4")) {
                gL2.glMultiDrawArrays(n15, nArray6, 0, nArray5, 0, n13);
            } else {
                for (n14 = 0; n14 < n13; ++n14) {
                    gL2.glDrawArrays(n15, nArray6[n14], nArray5[n14]);
                }
            }
        } else {
            switch (n) {
                case 1: {
                    gL2.glDrawArrays(7, 0, n2);
                    break;
                }
                case 2: {
                    gL2.glDrawArrays(4, 0, n2);
                    break;
                }
                case 3: {
                    gL2.glDrawArrays(0, 0, n2);
                    break;
                }
                case 4: {
                    gL2.glDrawArrays(1, 0, n2);
                }
            }
        }
        if (bl) {
            gL2.glDisable(2977);
        }
        if (bl9) {
            this.resetVertexAttrs((GL)gL2, joglContext, n8);
        }
        if (bl3) {
            this.resetTexture(gL2, joglContext);
        }
    }

    private String getVertexDescription(int n) {
        String string = "";
        if ((n & 1) != 0) {
            string = string + "COORDINATES ";
        }
        if ((n & 2) != 0) {
            string = string + "NORMALS ";
        }
        if ((n & 4) != 0) {
            string = string + "COLOR ";
        }
        if ((n & 8) != 0) {
            string = string + "(WITH_ALPHA) ";
        }
        if ((n & 0x460) != 0) {
            string = string + "TEXTURE_COORDINATE ";
        }
        if ((n & 0x20) != 0) {
            string = string + "(2) ";
        }
        if ((n & 0x40) != 0) {
            string = string + "(3) ";
        }
        if ((n & 0x400) != 0) {
            string = string + "(4) ";
        }
        if ((n & 0x1000) != 0) {
            string = string + "VERTEX_ATTRIBUTES ";
        }
        return string;
    }

    private String getGeometryDescription(int n) {
        switch (n) {
            case 5: {
                return "GEO_TYPE_TRI_STRIP_SET";
            }
            case 6: {
                return "GEO_TYPE_TRI_FAN_SET";
            }
            case 7: {
                return "GEO_TYPE_LINE_STRIP_SET";
            }
            case 1: {
                return "GEO_TYPE_QUAD_SET";
            }
            case 2: {
                return "GEO_TYPE_TRI_SET";
            }
            case 3: {
                return "GEO_TYPE_POINT_SET";
            }
            case 4: {
                return "GEO_TYPE_LINE_SET";
            }
        }
        return "(unknown " + n + ")";
    }

    private void resetVertexAttrs(GL gL, JoglContext joglContext, int n) {
        for (int i = 0; i < n; ++i) {
            joglContext.disableVertexAttrArray(gL, i);
        }
    }

    @Override
    void executeIndexedGeometry(Context context, GeometryArrayRetained geometryArrayRetained, int n, boolean bl, boolean bl2, boolean bl3, int n2, int n3, int n4, int n5, int n6, int[] nArray, int n7, int[] nArray2, int n8, int[] nArray3, int n9, float[] fArray, float[] fArray2, int n10, int[] nArray4) {
        this.executeIndexedGeometryArray(context, geometryArrayRetained, n, bl, bl2, bl3, n2, n3, n4, n5, n6, nArray, n7, nArray2, n8, nArray3, n9, fArray, null, fArray2, n10, nArray4);
    }

    @Override
    void executeIndexedGeometryBuffer(Context context, GeometryArrayRetained geometryArrayRetained, int n, boolean bl, boolean bl2, boolean bl3, int n2, int n3, int n4, int n5, int n6, int[] nArray, int n7, int[] nArray2, int n8, FloatBuffer floatBuffer, float[] fArray, int n9, int[] nArray3) {
        this.executeIndexedGeometryArray(context, geometryArrayRetained, n, bl, bl2, bl3, n2, n3, n4, n5, 0, null, n6, nArray, n7, nArray2, n8, null, floatBuffer, fArray, n9, nArray3);
    }

    @Override
    void executeIndexedGeometryVA(Context context, GeometryArrayRetained geometryArrayRetained, int n, boolean bl, boolean bl2, int n2, int n3, int n4, int n5, int n6, float[] fArray, double[] dArray, float[] fArray2, byte[] byArray, float[] fArray3, int n7, int[] nArray, float[][] fArray4, int n8, int[] nArray2, int n9, int n10, Object[] objectArray, int n11, int[] nArray3) {
        boolean bl3 = (n6 & 1) != 0;
        boolean bl4 = (n6 & 2) != 0;
        boolean bl5 = (n6 & 4) != 0;
        boolean bl6 = (n6 & 8) != 0;
        boolean bl7 = (n6 & 0x10) != 0;
        boolean bl8 = (n6 & 0x40) != 0;
        boolean bl9 = (n6 & 0x20) != 0;
        FloatBuffer floatBuffer = null;
        DoubleBuffer doubleBuffer = null;
        FloatBuffer floatBuffer2 = null;
        ByteBuffer byteBuffer = null;
        FloatBuffer[] floatBufferArray = null;
        FloatBuffer floatBuffer3 = null;
        FloatBuffer[] floatBufferArray2 = null;
        if (bl8) {
            floatBufferArray2 = JoglPipeline.getVertexAttrSetBuffer((Object[])fArray4);
        }
        if (bl9) {
            floatBufferArray = JoglPipeline.getTexCoordSetBuffer(objectArray);
        }
        int[] nArray4 = null;
        int n12 = 0;
        if (n == 12 || n == 13 || n == 14) {
            nArray4 = ((IndexedGeometryStripArrayRetained)geometryArrayRetained).stripIndexCounts;
            n12 = nArray4.length;
        }
        if (bl3) {
            floatBuffer = JoglPipeline.getVertexArrayBuffer(fArray);
        } else if (bl4) {
            doubleBuffer = JoglPipeline.getVertexArrayBuffer(dArray);
        }
        if (bl5) {
            floatBuffer2 = JoglPipeline.getColorArrayBuffer(fArray2);
        } else if (bl6) {
            byteBuffer = JoglPipeline.getColorArrayBuffer(byArray);
        }
        if (bl7) {
            floatBuffer3 = JoglPipeline.getNormalArrayBuffer(fArray3);
        }
        this.executeIndexedGeometryArrayVA(context, geometryArrayRetained, n, bl, bl2, n2, n3, n4, n5, n6, floatBuffer, doubleBuffer, floatBuffer2, byteBuffer, floatBuffer3, n7, nArray, floatBufferArray2, n8, nArray2, n9, n10, floatBufferArray, n11, nArray3, nArray4, n12);
    }

    @Override
    void executeIndexedGeometryVABuffer(Context context, GeometryArrayRetained geometryArrayRetained, int n, boolean bl, boolean bl2, int n2, int n3, int n4, int n5, int n6, Buffer buffer, Buffer buffer2, float[] fArray, byte[] byArray, FloatBuffer floatBuffer, int n7, int[] nArray, FloatBuffer[] floatBufferArray, int n8, int[] nArray2, int n9, int n10, Object[] objectArray, int n11, int[] nArray3) {
        boolean bl3 = (n6 & 1) != 0;
        boolean bl4 = (n6 & 2) != 0;
        boolean bl5 = (n6 & 4) != 0;
        boolean bl6 = (n6 & 8) != 0;
        boolean bl7 = (n6 & 0x10) != 0;
        boolean bl8 = (n6 & 0x40) != 0;
        boolean bl9 = (n6 & 0x20) != 0;
        FloatBuffer floatBuffer2 = null;
        DoubleBuffer doubleBuffer = null;
        FloatBuffer floatBuffer3 = null;
        ByteBuffer byteBuffer = null;
        FloatBuffer[] floatBufferArray2 = null;
        FloatBuffer floatBuffer4 = null;
        FloatBuffer[] floatBufferArray3 = null;
        if (bl8) {
            floatBufferArray3 = floatBufferArray;
        }
        if (bl9) {
            floatBufferArray2 = new FloatBuffer[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                floatBufferArray2[i] = (FloatBuffer)objectArray[i];
            }
        }
        if (bl3) {
            floatBuffer2 = (FloatBuffer)buffer;
        } else if (bl4) {
            doubleBuffer = (DoubleBuffer)buffer;
        }
        if (floatBuffer2 == null && doubleBuffer == null) {
            return;
        }
        int[] nArray4 = null;
        int n12 = 0;
        if (n == 12 || n == 13 || n == 14) {
            nArray4 = ((IndexedGeometryStripArrayRetained)geometryArrayRetained).stripIndexCounts;
            n12 = nArray4.length;
        }
        if (bl5) {
            floatBuffer3 = fArray != null ? JoglPipeline.getColorArrayBuffer(fArray) : (FloatBuffer)buffer2;
        } else if (bl6) {
            byteBuffer = byArray != null ? JoglPipeline.getColorArrayBuffer(byArray) : (ByteBuffer)buffer2;
        }
        if (bl7) {
            floatBuffer4 = floatBuffer;
        }
        this.executeIndexedGeometryArrayVA(context, geometryArrayRetained, n, bl, bl2, n2, n3, n4, n5, n6, floatBuffer2, doubleBuffer, floatBuffer3, byteBuffer, floatBuffer4, n7, nArray, floatBufferArray3, n8, nArray2, n9, n10, floatBufferArray2, n11, nArray3, nArray4, n12);
    }

    @Override
    void buildIndexedGeometry(Context context, GeometryArrayRetained geometryArrayRetained, int n, boolean bl, boolean bl2, float f, boolean bl3, int n2, int n3, int n4, int n5, int n6, int[] nArray, int n7, int[] nArray2, int n8, int[] nArray3, double[] dArray, double[] dArray2, float[] fArray, int[] nArray4) {
        int n9;
        int n10;
        JoglContext joglContext = (JoglContext)context;
        GL2 gL2 = this.context(joglContext).getGL().getGL2();
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        int n15 = 0;
        int n16 = 0;
        int n17 = 0;
        int n18 = 0;
        int n19 = 0;
        int n20 = 0;
        int n21 = 0;
        int n22 = 0;
        boolean bl4 = false;
        FloatBuffer floatBuffer = null;
        Object var39_38 = null;
        int[] nArray5 = null;
        int n23 = 0;
        boolean bl5 = false;
        if ((n5 & 1) != 0) {
            gL2.glEnableClientState(32884);
            n13 += 3;
        } else {
            gL2.glDisableClientState(32884);
        }
        if ((n5 & 2) != 0) {
            gL2.glEnableClientState(32885);
            n13 += 3;
            n14 += 3;
        } else {
            gL2.glDisableClientState(32885);
        }
        if ((n5 & 4) != 0) {
            gL2.glEnableClientState(32886);
            n13 += 4;
            n15 += 4;
            n14 += 4;
        } else {
            gL2.glDisableClientState(32886);
        }
        if ((n5 & 0x460) != 0) {
            if ((n5 & 0x20) != 0) {
                n18 = 2;
                n19 = 2 * n7;
            } else if ((n5 & 0x40) != 0) {
                n18 = 3;
                n19 = 3 * n7;
            } else if ((n5 & 0x400) != 0) {
                n18 = 4;
                n19 = 4 * n7;
            }
            n13 += n19;
            n15 += n19;
            n16 += n19;
            n14 += n19;
        }
        if ((n5 & 0x1000) != 0) {
            for (n10 = 0; n10 < n6; ++n10) {
                n21 += nArray[n10];
            }
            n13 += n21;
            n15 += n21;
            n16 += n21;
            n14 += n21;
            n17 += n21;
        }
        n22 = n13 * 4;
        if (bl2 && !bl3) {
            bl5 = true;
        }
        if (n == 12 || n == 13 || n == 14) {
            nArray5 = ((IndexedGeometryStripArrayRetained)geometryArrayRetained).stripIndexCounts;
            n23 = nArray5.length;
        }
        floatBuffer = JoglPipeline.getVertexArrayBuffer(fArray);
        if ((n5 & 2) != 0 && dArray2 != null) {
            n10 = n15;
            for (n9 = 0; n9 < n4 * 3; n9 += 3) {
                floatBuffer.put(n10, (float)(dArray2[0] * (double)fArray[n10] + dArray2[1] * (double)fArray[n10 + 1] + dArray2[2] * (double)fArray[n10 + 2]));
                floatBuffer.put(n10 + 1, (float)(dArray2[4] * (double)fArray[n10] + dArray2[5] * (double)fArray[n10 + 1] + dArray2[6] * (double)fArray[n10 + 2]));
                floatBuffer.put(n10 + 2, (float)(dArray2[8] * (double)fArray[n10] + dArray2[9] * (double)fArray[n10 + 1] + dArray2[10] * (double)fArray[n10 + 2]));
                n10 += n13;
            }
        }
        if ((n5 & 1) != 0 && dArray != null) {
            n10 = n14;
            for (n9 = 0; n9 < n4 * 3; n9 += 3) {
                floatBuffer.put(n10, (float)(dArray[0] * (double)fArray[n10] + dArray[1] * (double)fArray[n10 + 1] + dArray[2] * (double)fArray[n10 + 2]));
                floatBuffer.put(n10 + 1, (float)(dArray[4] * (double)fArray[n10] + dArray[5] * (double)fArray[n10 + 1] + dArray[6] * (double)fArray[n10 + 2]));
                floatBuffer.put(n10 + 2, (float)(dArray[8] * (double)fArray[n10] + dArray[9] * (double)fArray[n10 + 1] + dArray[10] * (double)fArray[n10 + 2]));
                n10 += n13;
            }
        }
        if (n == 12 || n == 13 || n == 14) {
            boolean bl6;
            if (bl3 || (n5 & 0x460) != 0 && (n8 > 1 || n7 > 1)) {
                bl6 = false;
            } else {
                boolean[] blArray = new boolean[1];
                int[] nArray6 = new int[1];
                this.testForInterleavedArrays(n5, blArray, nArray6);
                bl6 = blArray[0];
                n11 = nArray6[0];
            }
            if (bl6) {
                floatBuffer.position(0);
                gL2.glInterleavedArrays(n11, n22, (Buffer)floatBuffer);
            } else {
                if ((n5 & 2) != 0) {
                    floatBuffer.position(n15);
                    gL2.glNormalPointer(5126, n22, (Buffer)floatBuffer);
                }
                if (!bl3 && (n5 & 4) != 0) {
                    floatBuffer.position(n16);
                    if ((n5 & 8) != 0 || bl5) {
                        gL2.glColorPointer(4, 5126, n22, (Buffer)floatBuffer);
                    } else {
                        gL2.glColorPointer(3, 5126, n22, (Buffer)floatBuffer);
                    }
                }
                if ((n5 & 1) != 0) {
                    floatBuffer.position(n14);
                    gL2.glVertexPointer(3, 5126, n22, (Buffer)floatBuffer);
                }
                if ((n5 & 0x460) != 0) {
                    this.executeTexture(n8, n18, n22, n17, nArray3, n8, floatBuffer, gL2);
                }
                if ((n5 & 0x1000) != 0) {
                    int n24 = n20;
                    for (int i = 0; i < n6; ++i) {
                        joglContext.enableVertexAttrArray((GL)gL2, i);
                        floatBuffer.position(n24);
                        joglContext.vertexAttrPointer((GL)gL2, i, nArray[i], 5126, n22, floatBuffer);
                        n24 += nArray[i];
                    }
                }
            }
            switch (n) {
                case 12: {
                    n12 = 5;
                    break;
                }
                case 13: {
                    n12 = 6;
                    break;
                }
                case 14: {
                    n12 = 3;
                }
            }
            this.lockArray(gL2, n4);
            int n25 = n2;
            IntBuffer intBuffer = IntBuffer.wrap(nArray4);
            for (int i = 0; i < n23; ++i) {
                intBuffer.position(n25);
                int n26 = nArray5[i];
                gL2.glDrawElements(n12, n26, 5125, (Buffer)intBuffer);
                n25 += n26;
            }
        } else if (n == 8 || n == 9 || n == 10 || n == 11) {
            boolean bl7;
            if (bl3 || (n5 & 0x460) != 0 && (n8 > 1 || n7 > 1)) {
                bl7 = false;
            } else {
                boolean[] blArray = new boolean[1];
                int[] nArray7 = new int[1];
                this.testForInterleavedArrays(n5, blArray, nArray7);
                bl7 = blArray[0];
                n11 = nArray7[0];
            }
            if (bl7) {
                floatBuffer.position(0);
                gL2.glInterleavedArrays(n11, n22, (Buffer)floatBuffer);
            } else {
                if ((n5 & 2) != 0) {
                    floatBuffer.position(n15);
                    gL2.glNormalPointer(5126, n22, (Buffer)floatBuffer);
                }
                if (!bl3 && (n5 & 4) != 0) {
                    floatBuffer.position(n16);
                    if ((n5 & 8) != 0 || bl5) {
                        gL2.glColorPointer(4, 5126, n22, (Buffer)floatBuffer);
                    } else {
                        gL2.glColorPointer(3, 5126, n22, (Buffer)floatBuffer);
                    }
                }
                if ((n5 & 1) != 0) {
                    floatBuffer.position(n14);
                    gL2.glVertexPointer(3, 5126, n22, (Buffer)floatBuffer);
                }
                if ((n5 & 0x460) != 0) {
                    this.executeTexture(n8, n18, n22, n17, nArray3, n8, floatBuffer, gL2);
                }
                if ((n5 & 0x1000) != 0) {
                    int n27 = n20;
                    for (int i = 0; i < n6; ++i) {
                        joglContext.enableVertexAttrArray((GL)gL2, i);
                        floatBuffer.position(n27);
                        joglContext.vertexAttrPointer((GL)gL2, i, nArray[i], 5126, n22, floatBuffer);
                        n27 += nArray[i];
                    }
                }
                switch (n) {
                    case 8: {
                        n12 = 7;
                        break;
                    }
                    case 9: {
                        n12 = 4;
                        break;
                    }
                    case 10: {
                        n12 = 0;
                        break;
                    }
                    case 11: {
                        n12 = 1;
                    }
                }
                this.lockArray(gL2, n4);
                IntBuffer intBuffer = IntBuffer.wrap(nArray4);
                intBuffer.position(n2);
                gL2.glDrawElements(n12, n3, 5125, (Buffer)intBuffer);
            }
        }
        this.unlockArray(gL2);
        if ((n5 & 0x1000) != 0) {
            this.resetVertexAttrs((GL)gL2, joglContext, n6);
        }
        if ((n5 & 0x460) != 0) {
            this.resetTexture(gL2, joglContext);
        }
    }

    private void executeIndexedGeometryArray(Context context, GeometryArrayRetained geometryArrayRetained, int n, boolean bl, boolean bl2, boolean bl3, int n2, int n3, int n4, int n5, int n6, int[] nArray, int n7, int[] nArray2, int n8, int[] nArray3, int n9, float[] fArray, FloatBuffer floatBuffer, float[] fArray2, int n10, int[] nArray4) {
        int n11;
        JoglContext joglContext = (JoglContext)context;
        GL2 gL2 = this.context(joglContext).getGL().getGL2();
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        int n15 = 0;
        int n16 = 0;
        int n17 = 0;
        int n18 = 0;
        int n19 = 0;
        int n20 = 0;
        int n21 = 0;
        int n22 = 0;
        int n23 = 0;
        int n24 = 0;
        FloatBuffer floatBuffer2 = null;
        FloatBuffer floatBuffer3 = null;
        int[] nArray5 = null;
        int n25 = 0;
        if ((n5 & 1) != 0) {
            n14 += 3;
        }
        if ((n5 & 2) != 0) {
            n14 += 3;
            n15 += 3;
        }
        if ((n5 & 4) != 0) {
            if ((n5 & 8) != 0) {
                n14 += 4;
                n16 += 4;
                n15 += 4;
            } else {
                n14 += 3;
                n16 += 3;
                n15 += 3;
            }
        }
        if ((n5 & 0x460) != 0) {
            if ((n5 & 0x20) != 0) {
                n19 = 2;
                n20 = 2 * n7;
            } else if ((n5 & 0x40) != 0) {
                n19 = 3;
                n20 = 3 * n7;
            } else if ((n5 & 0x400) != 0) {
                n19 = 4;
                n20 = 4 * n7;
            }
            n14 += n20;
            n16 += n20;
            n17 += n20;
            n15 += n20;
        }
        if ((n5 & 0x1000) != 0) {
            for (n11 = 0; n11 < n6; ++n11) {
                n22 += nArray[n11];
            }
            n14 += n22;
            n16 += n22;
            n17 += n22;
            n15 += n22;
            n18 += n22;
        }
        n23 = n14 * 4;
        if (n == 12 || n == 13 || n == 14) {
            nArray5 = ((IndexedGeometryStripArrayRetained)geometryArrayRetained).stripIndexCounts;
            n25 = nArray5.length;
        }
        if (fArray != null) {
            floatBuffer2 = JoglPipeline.getVertexArrayBuffer(fArray);
        } else if (floatBuffer != null) {
            floatBuffer2 = floatBuffer;
        } else {
            throw new AssertionError((Object)"Unable to get vertex pointer");
        }
        n11 = n14;
        if (fArray2 != null) {
            floatBuffer3 = JoglPipeline.getColorArrayBuffer(fArray2);
            n11 = 4;
        } else {
            floatBuffer3 = floatBuffer2;
        }
        n24 = n11 * 4;
        if (bl) {
            gL2.glEnable(2977);
        }
        if (n == 12 || n == 13 || n == 14) {
            Object object;
            boolean bl4;
            if (bl3 || fArray2 != null || (n5 & 0x460) != 0 && (n8 > 1 || n7 > 1)) {
                bl4 = false;
            } else {
                boolean[] blArray = new boolean[1];
                object = new int[1];
                this.testForInterleavedArrays(n5, blArray, (int[])object);
                bl4 = blArray[0];
                n12 = object[0];
            }
            if (bl4) {
                floatBuffer2.position(0);
                gL2.glInterleavedArrays(n12, n23, (Buffer)floatBuffer2);
            } else {
                if ((n5 & 2) != 0) {
                    floatBuffer2.position(n16);
                    gL2.glNormalPointer(5126, n23, (Buffer)floatBuffer2);
                }
                if (!bl3 && (n5 & 4) != 0) {
                    if (floatBuffer3 == floatBuffer2) {
                        floatBuffer3.position(n17);
                    }
                    if ((n5 & 8) != 0 || bl2) {
                        gL2.glColorPointer(4, 5126, n24, (Buffer)floatBuffer3);
                    } else {
                        gL2.glColorPointer(3, 5126, n24, (Buffer)floatBuffer3);
                    }
                }
                if ((n5 & 1) != 0) {
                    floatBuffer2.position(n15);
                    gL2.glVertexPointer(3, 5126, n23, (Buffer)floatBuffer2);
                }
                if ((n5 & 0x460) != 0) {
                    this.executeTexture(n8, n19, n23, n18, nArray3, n9, floatBuffer2, gL2);
                }
                if ((n5 & 0x1000) != 0) {
                    int n26 = n21;
                    for (int i = 0; i < n6; ++i) {
                        joglContext.enableVertexAttrArray((GL)gL2, i);
                        floatBuffer2.position(n26);
                        joglContext.vertexAttrPointer((GL)gL2, i, nArray[i], 5126, n23, floatBuffer2);
                        n26 += nArray[i];
                    }
                }
            }
            switch (n) {
                case 12: {
                    n13 = 5;
                    break;
                }
                case 13: {
                    n13 = 6;
                    break;
                }
                case 14: {
                    n13 = 3;
                }
            }
            this.lockArray(gL2, n4);
            int n27 = n2;
            object = IntBuffer.wrap(nArray4);
            for (int i = 0; i < n25; ++i) {
                ((IntBuffer)object).position(n27);
                int n28 = nArray5[i];
                gL2.glDrawElements(n13, n28, 5125, (Buffer)object);
                n27 += n28;
            }
        } else if (n == 8 || n == 9 || n == 10 || n == 11) {
            boolean bl5;
            if (bl3 || fArray2 != null || (n5 & 0x460) != 0 && (n8 > 1 || n7 > 1)) {
                bl5 = false;
            } else {
                boolean[] blArray = new boolean[1];
                int[] nArray6 = new int[1];
                this.testForInterleavedArrays(n5, blArray, nArray6);
                bl5 = blArray[0];
                n12 = nArray6[0];
            }
            if (bl5) {
                floatBuffer2.position(0);
                gL2.glInterleavedArrays(n12, n23, (Buffer)floatBuffer2);
            } else {
                if ((n5 & 2) != 0) {
                    floatBuffer2.position(n16);
                    gL2.glNormalPointer(5126, n23, (Buffer)floatBuffer2);
                }
                if (!bl3 && (n5 & 4) != 0) {
                    if (floatBuffer3 == floatBuffer2) {
                        floatBuffer3.position(n17);
                    }
                    if ((n5 & 8) != 0 || bl2) {
                        gL2.glColorPointer(4, 5126, n24, (Buffer)floatBuffer3);
                    } else {
                        gL2.glColorPointer(3, 5126, n24, (Buffer)floatBuffer3);
                    }
                }
                if ((n5 & 1) != 0) {
                    floatBuffer2.position(n15);
                    gL2.glVertexPointer(3, 5126, n23, (Buffer)floatBuffer2);
                }
                if ((n5 & 0x460) != 0) {
                    this.executeTexture(n8, n19, n23, n18, nArray3, n9, floatBuffer2, gL2);
                }
                if ((n5 & 0x1000) != 0) {
                    int n29 = n21;
                    for (int i = 0; i < n6; ++i) {
                        joglContext.enableVertexAttrArray((GL)gL2, i);
                        floatBuffer2.position(n29);
                        joglContext.vertexAttrPointer((GL)gL2, i, nArray[i], 5126, n23, floatBuffer2);
                        n29 += nArray[i];
                    }
                }
            }
            this.lockArray(gL2, n4);
            IntBuffer intBuffer = IntBuffer.wrap(nArray4);
            intBuffer.position(n2);
            switch (n) {
                case 8: {
                    gL2.glDrawElements(7, n3, 5125, (Buffer)intBuffer);
                    break;
                }
                case 9: {
                    gL2.glDrawElements(4, n3, 5125, (Buffer)intBuffer);
                    break;
                }
                case 10: {
                    gL2.glDrawElements(0, n3, 5125, (Buffer)intBuffer);
                    break;
                }
                case 11: {
                    gL2.glDrawElements(1, n3, 5125, (Buffer)intBuffer);
                }
            }
        }
        this.unlockArray(gL2);
        if ((n5 & 0x1000) != 0) {
            this.resetVertexAttrs((GL)gL2, joglContext, n6);
        }
        if ((n5 & 0x460) != 0) {
            this.resetTexture(gL2, joglContext);
        }
        if (bl) {
            gL2.glDisable(2977);
        }
    }

    private void executeIndexedGeometryArrayVA(Context context, GeometryArrayRetained geometryArrayRetained, int n, boolean bl, boolean bl2, int n2, int n3, int n4, int n5, int n6, FloatBuffer floatBuffer, DoubleBuffer doubleBuffer, FloatBuffer floatBuffer2, ByteBuffer byteBuffer, FloatBuffer floatBuffer3, int n7, int[] nArray, FloatBuffer[] floatBufferArray, int n8, int[] nArray2, int n9, int n10, FloatBuffer[] floatBufferArray2, int n11, int[] nArray3, int[] nArray4, int n12) {
        int n13;
        boolean bl3;
        JoglContext joglContext = (JoglContext)context;
        GL2 gL2 = this.context(joglContext).getGL().getGL2();
        boolean bl4 = (n6 & 1) != 0;
        boolean bl5 = (n6 & 2) != 0;
        boolean bl6 = (n6 & 4) != 0;
        boolean bl7 = (n6 & 8) != 0;
        boolean bl8 = (n6 & 0x10) != 0;
        boolean bl9 = (n6 & 0x40) != 0;
        boolean bl10 = bl3 = (n6 & 0x20) != 0;
        if (bl) {
            gL2.glEnable(2977);
        }
        if (bl4) {
            floatBuffer.position(0);
            gL2.glVertexPointer(3, 5126, 0, (Buffer)floatBuffer);
        } else if (bl5) {
            doubleBuffer.position(0);
            gL2.glVertexPointer(3, 5130, 0, (Buffer)doubleBuffer);
        }
        if (bl6) {
            floatBuffer2.position(0);
            if ((n5 & 8) != 0) {
                gL2.glColorPointer(4, 5126, 0, (Buffer)floatBuffer2);
            } else {
                gL2.glColorPointer(3, 5126, 0, (Buffer)floatBuffer2);
            }
        } else if (bl7) {
            byteBuffer.position(0);
            if ((n5 & 8) != 0) {
                gL2.glColorPointer(4, 5121, 0, (Buffer)byteBuffer);
            } else {
                gL2.glColorPointer(3, 5121, 0, (Buffer)byteBuffer);
            }
        }
        if (bl8) {
            floatBuffer3.position(0);
            gL2.glNormalPointer(5126, 0, (Buffer)floatBuffer3);
        }
        if (bl9) {
            for (n13 = 0; n13 < n7; ++n13) {
                FloatBuffer floatBuffer4 = floatBufferArray[n13];
                int n14 = nArray[n13];
                joglContext.enableVertexAttrArray((GL)gL2, n13);
                floatBuffer4.position(0);
                joglContext.vertexAttrPointer((GL)gL2, n13, n14, 5126, 0, floatBuffer4);
            }
        }
        if (bl3) {
            n13 = 0;
            for (int i = 0; i < n9; ++i) {
                if (i < n8 && (n13 = nArray2[i]) != -1) {
                    FloatBuffer floatBuffer5 = floatBufferArray2[n13];
                    floatBuffer5.position(0);
                    this.enableTexCoordPointer(gL2, i, n10, 5126, 0, floatBuffer5);
                    continue;
                }
                this.disableTexCoordPointer(gL2, i);
            }
            this.clientActiveTextureUnit(gL2, 0);
        }
        this.lockArray(gL2, n4);
        if (n == 12 || n == 13 || n == 14) {
            n13 = 0;
            switch (n) {
                case 12: {
                    n13 = 5;
                    break;
                }
                case 13: {
                    n13 = 6;
                    break;
                }
                case 14: {
                    n13 = 3;
                }
            }
            int n15 = n2;
            IntBuffer intBuffer = IntBuffer.wrap(nArray3);
            for (int i = 0; i < n12; ++i) {
                intBuffer.position(n15);
                int n16 = nArray4[i];
                gL2.glDrawElements(n13, n16, 5125, (Buffer)intBuffer);
                n15 += n16;
            }
        } else {
            IntBuffer intBuffer = IntBuffer.wrap(nArray3);
            intBuffer.position(n2);
            switch (n) {
                case 8: {
                    gL2.glDrawElements(7, n3, 5125, (Buffer)intBuffer);
                    break;
                }
                case 9: {
                    gL2.glDrawElements(4, n3, 5125, (Buffer)intBuffer);
                    break;
                }
                case 10: {
                    gL2.glDrawElements(0, n3, 5125, (Buffer)intBuffer);
                    break;
                }
                case 11: {
                    gL2.glDrawElements(1, n3, 5125, (Buffer)intBuffer);
                }
            }
        }
        this.unlockArray(gL2);
        if (bl) {
            gL2.glDisable(2977);
        }
        if (bl9) {
            this.resetVertexAttrs((GL)gL2, joglContext, n7);
        }
        if (bl3) {
            this.resetTexture(gL2, joglContext);
        }
    }

    @Override
    void readRaster(Context context, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Object object, int n9, Object object2) {
        GL2 gL2 = this.context(context).getGL().getGL2();
        gL2.glPixelStorei(3330, n4);
        gL2.glPixelStorei(3333, 1);
        int n10 = n6 - n5 - n3;
        if ((n & 1) != 0) {
            int n11 = 0;
            if (n7 == 4096) {
                switch (n8) {
                    case 1: {
                        n11 = 32992;
                        break;
                    }
                    case 2: {
                        n11 = 6407;
                        break;
                    }
                    case 4: {
                        if (gL2.isExtensionAvailable("GL_EXT_abgr")) {
                            n11 = 32768;
                            break;
                        }
                        assert (false);
                        return;
                    }
                    case 8: {
                        n11 = 6408;
                        break;
                    }
                    case 16: {
                        n11 = 6410;
                        break;
                    }
                    default: {
                        assert (false);
                        return;
                    }
                }
                gL2.glReadPixels(n2, n10, n4, n5, n11, 5121, (Buffer)ByteBuffer.wrap((byte[])object));
            } else if (n7 == 8192) {
                int n12 = 32821;
                boolean bl = false;
                switch (n8) {
                    case 128: {
                        n11 = 6408;
                        n12 = 33639;
                        bl = true;
                        break;
                    }
                    case 256: {
                        bl = true;
                    }
                    case 512: {
                        n11 = 32993;
                        n12 = 33639;
                        break;
                    }
                    default: {
                        assert (false);
                        return;
                    }
                }
                if (bl) {
                    gL2.glPixelTransferf(3356, 0.0f);
                    gL2.glPixelTransferf(3357, 1.0f);
                }
                gL2.glReadPixels(n2, n10, n4, n5, n11, n12, (Buffer)IntBuffer.wrap((int[])object));
                if (bl) {
                    gL2.glPixelTransferf(3356, 1.0f);
                    gL2.glPixelTransferf(3357, 0.0f);
                }
            } else assert (false);
        }
        if ((n & 2) != 0) {
            if (n9 == 1) {
                gL2.glReadPixels(n2, n10, n4, n5, 6402, 5125, (Buffer)IntBuffer.wrap((int[])object2));
            } else {
                gL2.glReadPixels(n2, n10, n4, n5, 6402, 5126, (Buffer)FloatBuffer.wrap((float[])object2));
            }
        }
    }

    @Override
    ShaderError setGLSLUniform1i(Context context, ShaderProgramId shaderProgramId, ShaderAttrLoc shaderAttrLoc, int n) {
        GL2 gL2 = this.context(context).getGL().getGL2();
        gL2.glUniform1iARB(this.unbox(shaderAttrLoc), n);
        return null;
    }

    @Override
    ShaderError setGLSLUniform1f(Context context, ShaderProgramId shaderProgramId, ShaderAttrLoc shaderAttrLoc, float f) {
        GL2 gL2 = this.context(context).getGL().getGL2();
        gL2.glUniform1fARB(this.unbox(shaderAttrLoc), f);
        return null;
    }

    @Override
    ShaderError setGLSLUniform2i(Context context, ShaderProgramId shaderProgramId, ShaderAttrLoc shaderAttrLoc, int[] nArray) {
        GL2 gL2 = this.context(context).getGL().getGL2();
        gL2.glUniform2iARB(this.unbox(shaderAttrLoc), nArray[0], nArray[1]);
        return null;
    }

    @Override
    ShaderError setGLSLUniform2f(Context context, ShaderProgramId shaderProgramId, ShaderAttrLoc shaderAttrLoc, float[] fArray) {
        GL2 gL2 = this.context(context).getGL().getGL2();
        gL2.glUniform2fARB(this.unbox(shaderAttrLoc), fArray[0], fArray[1]);
        return null;
    }

    @Override
    ShaderError setGLSLUniform3i(Context context, ShaderProgramId shaderProgramId, ShaderAttrLoc shaderAttrLoc, int[] nArray) {
        GL2 gL2 = this.context(context).getGL().getGL2();
        gL2.glUniform3iARB(this.unbox(shaderAttrLoc), nArray[0], nArray[1], nArray[2]);
        return null;
    }

    @Override
    ShaderError setGLSLUniform3f(Context context, ShaderProgramId shaderProgramId, ShaderAttrLoc shaderAttrLoc, float[] fArray) {
        GL2 gL2 = this.context(context).getGL().getGL2();
        gL2.glUniform3fARB(this.unbox(shaderAttrLoc), fArray[0], fArray[1], fArray[2]);
        return null;
    }

    @Override
    ShaderError setGLSLUniform4i(Context context, ShaderProgramId shaderProgramId, ShaderAttrLoc shaderAttrLoc, int[] nArray) {
        GL2 gL2 = this.context(context).getGL().getGL2();
        gL2.glUniform4iARB(this.unbox(shaderAttrLoc), nArray[0], nArray[1], nArray[2], nArray[3]);
        return null;
    }

    @Override
    ShaderError setGLSLUniform4f(Context context, ShaderProgramId shaderProgramId, ShaderAttrLoc shaderAttrLoc, float[] fArray) {
        GL2 gL2 = this.context(context).getGL().getGL2();
        gL2.glUniform4fARB(this.unbox(shaderAttrLoc), fArray[0], fArray[1], fArray[2], fArray[3]);
        return null;
    }

    @Override
    ShaderError setGLSLUniformMatrix3f(Context context, ShaderProgramId shaderProgramId, ShaderAttrLoc shaderAttrLoc, float[] fArray) {
        GL2 gL2 = this.context(context).getGL().getGL2();
        gL2.glUniformMatrix3fvARB(this.unbox(shaderAttrLoc), 1, true, fArray, 0);
        return null;
    }

    @Override
    ShaderError setGLSLUniformMatrix4f(Context context, ShaderProgramId shaderProgramId, ShaderAttrLoc shaderAttrLoc, float[] fArray) {
        GL2 gL2 = this.context(context).getGL().getGL2();
        gL2.glUniformMatrix4fvARB(this.unbox(shaderAttrLoc), 1, true, fArray, 0);
        return null;
    }

    @Override
    ShaderError setGLSLUniform1iArray(Context context, ShaderProgramId shaderProgramId, ShaderAttrLoc shaderAttrLoc, int n, int[] nArray) {
        GL2 gL2 = this.context(context).getGL().getGL2();
        gL2.glUniform1ivARB(this.unbox(shaderAttrLoc), n, nArray, 0);
        return null;
    }

    @Override
    ShaderError setGLSLUniform1fArray(Context context, ShaderProgramId shaderProgramId, ShaderAttrLoc shaderAttrLoc, int n, float[] fArray) {
        GL2 gL2 = this.context(context).getGL().getGL2();
        gL2.glUniform1fvARB(this.unbox(shaderAttrLoc), n, fArray, 0);
        return null;
    }

    @Override
    ShaderError setGLSLUniform2iArray(Context context, ShaderProgramId shaderProgramId, ShaderAttrLoc shaderAttrLoc, int n, int[] nArray) {
        GL2 gL2 = this.context(context).getGL().getGL2();
        gL2.glUniform2ivARB(this.unbox(shaderAttrLoc), n, nArray, 0);
        return null;
    }

    @Override
    ShaderError setGLSLUniform2fArray(Context context, ShaderProgramId shaderProgramId, ShaderAttrLoc shaderAttrLoc, int n, float[] fArray) {
        GL2 gL2 = this.context(context).getGL().getGL2();
        gL2.glUniform2fvARB(this.unbox(shaderAttrLoc), n, fArray, 0);
        return null;
    }

    @Override
    ShaderError setGLSLUniform3iArray(Context context, ShaderProgramId shaderProgramId, ShaderAttrLoc shaderAttrLoc, int n, int[] nArray) {
        GL2 gL2 = this.context(context).getGL().getGL2();
        gL2.glUniform3ivARB(this.unbox(shaderAttrLoc), n, nArray, 0);
        return null;
    }

    @Override
    ShaderError setGLSLUniform3fArray(Context context, ShaderProgramId shaderProgramId, ShaderAttrLoc shaderAttrLoc, int n, float[] fArray) {
        GL2 gL2 = this.context(context).getGL().getGL2();
        gL2.glUniform3fvARB(this.unbox(shaderAttrLoc), n, fArray, 0);
        return null;
    }

    @Override
    ShaderError setGLSLUniform4iArray(Context context, ShaderProgramId shaderProgramId, ShaderAttrLoc shaderAttrLoc, int n, int[] nArray) {
        GL2 gL2 = this.context(context).getGL().getGL2();
        gL2.glUniform4ivARB(this.unbox(shaderAttrLoc), n, nArray, 0);
        return null;
    }

    @Override
    ShaderError setGLSLUniform4fArray(Context context, ShaderProgramId shaderProgramId, ShaderAttrLoc shaderAttrLoc, int n, float[] fArray) {
        GL2 gL2 = this.context(context).getGL().getGL2();
        gL2.glUniform4fvARB(this.unbox(shaderAttrLoc), n, fArray, 0);
        return null;
    }

    @Override
    ShaderError setGLSLUniformMatrix3fArray(Context context, ShaderProgramId shaderProgramId, ShaderAttrLoc shaderAttrLoc, int n, float[] fArray) {
        GL2 gL2 = this.context(context).getGL().getGL2();
        gL2.glUniformMatrix3fvARB(this.unbox(shaderAttrLoc), n, true, fArray, 0);
        return null;
    }

    @Override
    ShaderError setGLSLUniformMatrix4fArray(Context context, ShaderProgramId shaderProgramId, ShaderAttrLoc shaderAttrLoc, int n, float[] fArray) {
        GL2 gL2 = this.context(context).getGL().getGL2();
        gL2.glUniformMatrix4fvARB(this.unbox(shaderAttrLoc), n, true, fArray, 0);
        return null;
    }

    @Override
    ShaderError createGLSLShader(Context context, int n, ShaderId[] shaderIdArray) {
        GL2 gL2 = this.context(context).getGL().getGL2();
        int n2 = 0;
        if (n == 1) {
            n2 = gL2.glCreateShaderObjectARB(35633);
        } else if (n == 2) {
            n2 = gL2.glCreateShaderObjectARB(35632);
        }
        if (n2 == 0) {
            return new ShaderError(1, "Unable to create native shader object");
        }
        shaderIdArray[0] = new JoglShaderObject(n2);
        return null;
    }

    @Override
    ShaderError destroyGLSLShader(Context context, ShaderId shaderId) {
        GL2 gL2 = this.context(context).getGL().getGL2();
        gL2.glDeleteObjectARB(this.unbox(shaderId));
        return null;
    }

    @Override
    ShaderError compileGLSLShader(Context context, ShaderId shaderId, String string) {
        int n = this.unbox(shaderId);
        if (n == 0) {
            throw new AssertionError((Object)"shaderId == 0");
        }
        if (string == null) {
            throw new AssertionError((Object)"shader program string is null");
        }
        GL2 gL2 = this.context(context).getGL().getGL2();
        gL2.glShaderSourceARB(n, 1, new String[]{string}, null, 0);
        gL2.glCompileShaderARB(n);
        int[] nArray = new int[1];
        gL2.glGetObjectParameterivARB(n, 35713, nArray, 0);
        if (nArray[0] == 0) {
            String string2 = this.getInfoLog(gL2, n);
            ShaderError shaderError = new ShaderError(1, "GLSL shader compile error");
            shaderError.setDetailMessage(string2);
            return shaderError;
        }
        return null;
    }

    @Override
    ShaderError createGLSLShaderProgram(Context context, ShaderProgramId[] shaderProgramIdArray) {
        GL2 gL2 = this.context(context).getGL().getGL2();
        int n = gL2.glCreateProgramObjectARB();
        if (n == 0) {
            return new ShaderError(2, "Unable to create native shader program object");
        }
        shaderProgramIdArray[0] = new JoglShaderObject(n);
        return null;
    }

    @Override
    ShaderError destroyGLSLShaderProgram(Context context, ShaderProgramId shaderProgramId) {
        GL2 gL2 = this.context(context).getGL().getGL2();
        gL2.glDeleteObjectARB(this.unbox(shaderProgramId));
        return null;
    }

    @Override
    ShaderError linkGLSLShaderProgram(Context context, ShaderProgramId shaderProgramId, ShaderId[] shaderIdArray) {
        GL2 gL2 = this.context(context).getGL().getGL2();
        int n = this.unbox(shaderProgramId);
        for (int i = 0; i < shaderIdArray.length; ++i) {
            gL2.glAttachObjectARB(n, this.unbox(shaderIdArray[i]));
        }
        gL2.glLinkProgramARB(n);
        int[] nArray = new int[1];
        gL2.glGetObjectParameterivARB(n, 35714, nArray, 0);
        if (nArray[0] == 0) {
            String string = this.getInfoLog(gL2, n);
            ShaderError shaderError = new ShaderError(2, "GLSL shader program link error");
            shaderError.setDetailMessage(string);
            return shaderError;
        }
        return null;
    }

    @Override
    ShaderError bindGLSLVertexAttrName(Context context, ShaderProgramId shaderProgramId, String string, int n) {
        GL2 gL2 = this.context(context).getGL().getGL2();
        gL2.glBindAttribLocation(this.unbox(shaderProgramId), n + VirtualUniverse.mc.glslVertexAttrOffset, string);
        return null;
    }

    @Override
    void lookupGLSLShaderAttrNames(Context context, ShaderProgramId shaderProgramId, int n, String[] stringArray, ShaderAttrLoc[] shaderAttrLocArray, int[] nArray, int[] nArray2, boolean[] blArray) {
        int n2;
        int n3;
        int n4;
        for (n4 = 0; n4 < stringArray.length; ++n4) {
            shaderAttrLocArray[n4] = null;
            nArray[n4] = -1;
            nArray2[n4] = -1;
        }
        n4 = this.unbox(shaderProgramId);
        int[] nArray3 = new int[1];
        int[] nArray4 = new int[1];
        int[] nArray5 = new int[1];
        GL2 gL2 = this.context(context).getGL().getGL2();
        gL2.glGetObjectParameterivARB(n4, 35718, nArray3, 0);
        int n5 = nArray3[0];
        gL2.glGetObjectParameterivARB(n4, 35719, nArray3, 0);
        int n6 = nArray3[0];
        byte[] byArray = new byte[n6];
        block3: for (n3 = 0; n3 < n5; ++n3) {
            gL2.glGetActiveUniformARB(n4, n3, n6, nArray5, 0, nArray3, 0, nArray4, 0, byArray, 0);
            n2 = nArray3[0];
            int n7 = nArray4[0];
            String string = null;
            try {
                string = new String(byArray, 0, nArray5[0], "US-ASCII");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new RuntimeException(unsupportedEncodingException);
            }
            if (string.length() >= 3 && string.endsWith("]")) {
                if (!string.endsWith("[0]")) continue;
                string = string.substring(0, string.length() - 3);
            }
            for (int i = 0; i < n; ++i) {
                if (!string.equals(stringArray[i])) continue;
                nArray2[i] = n2;
                blArray[i] = n2 > 1;
                nArray[i] = this.glslToJ3dType(n7);
                continue block3;
            }
        }
        for (n3 = 0; n3 < n; ++n3) {
            n2 = gL2.glGetUniformLocationARB(n4, stringArray[n3]);
            shaderAttrLocArray[n3] = new JoglShaderObject(n2);
        }
    }

    @Override
    ShaderError useGLSLShaderProgram(Context context, ShaderProgramId shaderProgramId) {
        GL2 gL2 = this.context(context).getGL().getGL2();
        gL2.glUseProgramObjectARB(this.unbox(shaderProgramId));
        ((JoglContext)context).setShaderProgram((JoglShaderObject)shaderProgramId);
        return null;
    }

    private int unbox(ShaderAttrLoc shaderAttrLoc) {
        if (shaderAttrLoc == null) {
            return 0;
        }
        return ((JoglShaderObject)shaderAttrLoc).getValue();
    }

    private int unbox(ShaderProgramId shaderProgramId) {
        if (shaderProgramId == null) {
            return 0;
        }
        return ((JoglShaderObject)shaderProgramId).getValue();
    }

    private int unbox(ShaderId shaderId) {
        if (shaderId == null) {
            return 0;
        }
        return ((JoglShaderObject)shaderId).getValue();
    }

    private String getInfoLog(GL2 gL2, int n) {
        int[] nArray = new int[1];
        gL2.glGetObjectParameterivARB(n, 35716, nArray, 0);
        if (nArray[0] > 0) {
            byte[] byArray = new byte[nArray[0]];
            int[] nArray2 = new int[1];
            gL2.glGetInfoLogARB(n, nArray[0], nArray2, 0, byArray, 0);
            try {
                return new String(byArray, 0, nArray2[0], "US-ASCII");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new RuntimeException(unsupportedEncodingException);
            }
        }
        return null;
    }

    private int glslToJ3dType(int n) {
        switch (n) {
            case 5124: 
            case 35670: 
            case 35678: 
            case 35679: 
            case 35680: {
                return 0;
            }
            case 5126: {
                return 1;
            }
            case 35667: 
            case 35671: {
                return 2;
            }
            case 35664: {
                return 3;
            }
            case 35668: 
            case 35672: {
                return 4;
            }
            case 35665: {
                return 5;
            }
            case 35669: 
            case 35673: {
                return 6;
            }
            case 35666: {
                return 7;
            }
            case 35675: {
                return 8;
            }
            case 35676: {
                return 9;
            }
        }
        return -1;
    }

    @Override
    void updateColoringAttributes(Context context, float f, float f2, float f3, float f4, float f5, float f6, float f7, boolean bl, int n) {
        float f8;
        float f9;
        float f10;
        GL2 gL2 = this.context(context).getGL().getGL2();
        if (bl) {
            f10 = f;
            f9 = f2;
            f8 = f3;
        } else {
            f10 = f4;
            f9 = f5;
            f8 = f6;
        }
        gL2.glColor4f(f10, f9, f8, f7);
        if (n == 2) {
            gL2.glShadeModel(7424);
        } else {
            gL2.glShadeModel(7425);
        }
    }

    @Override
    void updateDirectionalLight(Context context, int n, float f, float f2, float f3, float f4, float f5, float f6) {
        GL2 gL2 = this.context(context).getGL().getGL2();
        int n2 = 16384 + n;
        float[] fArray = new float[]{f, f2, f3, 1.0f};
        gL2.glLightfv(n2, 4609, fArray, 0);
        gL2.glLightfv(n2, 4610, fArray, 0);
        fArray[0] = -f4;
        fArray[1] = -f5;
        fArray[2] = -f6;
        fArray[3] = 0.0f;
        gL2.glLightfv(n2, 4611, fArray, 0);
        gL2.glLightfv(n2, 4608, black, 0);
        gL2.glLightf(n2, 4615, 1.0f);
        gL2.glLightf(n2, 4616, 0.0f);
        gL2.glLightf(n2, 4617, 0.0f);
        gL2.glLightf(n2, 4613, 0.0f);
        gL2.glLightf(n2, 4614, 180.0f);
    }

    @Override
    void updatePointLight(Context context, int n, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        GL2 gL2 = this.context(context).getGL().getGL2();
        int n2 = 16384 + n;
        float[] fArray = new float[]{f, f2, f3, 1.0f};
        gL2.glLightfv(n2, 4609, fArray, 0);
        gL2.glLightfv(n2, 4610, fArray, 0);
        gL2.glLightfv(n2, 4608, black, 0);
        fArray[0] = f7;
        fArray[1] = f8;
        fArray[2] = f9;
        gL2.glLightfv(n2, 4611, fArray, 0);
        gL2.glLightf(n2, 4615, f4);
        gL2.glLightf(n2, 4616, f5);
        gL2.glLightf(n2, 4617, f6);
        gL2.glLightf(n2, 4613, 0.0f);
        gL2.glLightf(n2, 4614, 180.0f);
    }

    @Override
    void updateSpotLight(Context context, int n, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14) {
        GL2 gL2 = this.context(context).getGL().getGL2();
        int n2 = 16384 + n;
        float[] fArray = new float[]{f, f2, f3, 1.0f};
        gL2.glLightfv(n2, 4609, fArray, 0);
        gL2.glLightfv(n2, 4610, fArray, 0);
        gL2.glLightfv(n2, 4608, black, 0);
        fArray[0] = f7;
        fArray[1] = f8;
        fArray[2] = f9;
        gL2.glLightfv(n2, 4611, fArray, 0);
        gL2.glLightf(n2, 4615, f4);
        gL2.glLightf(n2, 4616, f5);
        gL2.glLightf(n2, 4617, f6);
        fArray[0] = f12;
        fArray[1] = f13;
        fArray[2] = f14;
        gL2.glLightfv(n2, 4612, fArray, 0);
        gL2.glLightf(n2, 4613, f11);
        gL2.glLightf(n2, 4614, (float)((double)(f10 * 180.0f) / Math.PI));
    }

    @Override
    void updateExponentialFog(Context context, float f, float f2, float f3, float f4) {
        GL2 gL2 = this.context(context).getGL().getGL2();
        float[] fArray = new float[]{f, f2, f3};
        gL2.glFogi(2917, 2048);
        gL2.glFogfv(2918, fArray, 0);
        gL2.glFogf(2914, f4);
        gL2.glEnable(2912);
    }

    @Override
    void updateLinearFog(Context context, float f, float f2, float f3, double d, double d2) {
        GL2 gL2 = this.context(context).getGL().getGL2();
        float[] fArray = new float[]{f, f2, f3};
        gL2.glFogi(2917, 9729);
        gL2.glFogfv(2918, fArray, 0);
        gL2.glFogf(2915, (float)d);
        gL2.glFogf(2916, (float)d2);
        gL2.glEnable(2912);
    }

    @Override
    void updateLineAttributes(Context context, float f, int n, int n2, int n3, boolean bl) {
        GL2 gL2 = this.context(context).getGL().getGL2();
        gL2.glLineWidth(f);
        if (n == 0) {
            gL2.glDisable(2852);
        } else {
            if (n == 1) {
                gL2.glLineStipple(1, (short)255);
            } else if (n == 2) {
                gL2.glLineStipple(1, (short)257);
            } else if (n == 3) {
                gL2.glLineStipple(1, (short)2175);
            } else if (n == 4) {
                gL2.glLineStipple(n3, (short)n2);
            }
            gL2.glEnable(2852);
        }
        if (bl) {
            gL2.glEnable(2848);
        } else {
            gL2.glDisable(2848);
        }
    }

    @Override
    void updateMaterial(Context context, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16, float f17, int n, boolean bl) {
        float[] fArray = new float[4];
        GL2 gL2 = this.context(context).getGL().getGL2();
        gL2.glMaterialf(1032, 5633, f17);
        switch (n) {
            case 2: {
                gL2.glColorMaterial(1032, 4609);
                break;
            }
            case 0: {
                gL2.glColorMaterial(1032, 4608);
                break;
            }
            case 1: {
                gL2.glColorMaterial(1032, 5632);
                break;
            }
            case 3: {
                gL2.glColorMaterial(1032, 4610);
                break;
            }
            case 4: {
                gL2.glColorMaterial(1032, 5634);
            }
        }
        fArray[0] = f8;
        fArray[1] = f9;
        fArray[2] = f10;
        gL2.glMaterialfv(1032, 5632, fArray, 0);
        fArray[0] = f5;
        fArray[1] = f6;
        fArray[2] = f7;
        gL2.glMaterialfv(1032, 4608, fArray, 0);
        fArray[0] = f14;
        fArray[1] = f15;
        fArray[2] = f16;
        gL2.glMaterialfv(1032, 4610, fArray, 0);
        if (bl) {
            fArray[0] = f11;
            fArray[1] = f12;
            fArray[2] = f13;
        } else {
            fArray[0] = f;
            fArray[1] = f2;
            fArray[2] = f3;
        }
        fArray[3] = f4;
        gL2.glMaterialfv(1032, 4609, fArray, 0);
        gL2.glColor4f(fArray[0], fArray[1], fArray[2], fArray[3]);
        if (bl) {
            gL2.glEnable(2896);
        } else {
            gL2.glDisable(2896);
        }
    }

    @Override
    void updateModelClip(Context context, int n, boolean bl, double d, double d2, double d3, double d4) {
        GL2 gL2 = this.context(context).getGL().getGL2();
        double[] dArray = new double[4];
        int n2 = 12288 + n;
        if (bl) {
            dArray[0] = -d;
            dArray[1] = -d2;
            dArray[2] = -d3;
            dArray[3] = -d4;
            gL2.glClipPlane(n2, DoubleBuffer.wrap(dArray));
            gL2.glEnable(n2);
        } else {
            gL2.glDisable(n2);
        }
    }

    @Override
    void updatePointAttributes(Context context, float f, boolean bl) {
        GL2 gL2 = this.context(context).getGL().getGL2();
        gL2.glPointSize(f);
        if (bl) {
            gL2.glEnable(2832);
        } else {
            gL2.glDisable(2832);
        }
    }

    @Override
    void updatePolygonAttributes(Context context, int n, int n2, boolean bl, float f, float f2) {
        GL2 gL2 = this.context(context).getGL().getGL2();
        if (n2 == 0) {
            gL2.glDisable(2884);
        } else {
            if (n2 == 1) {
                gL2.glCullFace(1029);
            } else {
                gL2.glCullFace(1028);
            }
            gL2.glEnable(2884);
        }
        if (bl && n2 != 1) {
            gL2.glLightModeli(2898, 1);
        } else {
            gL2.glLightModeli(2898, 0);
        }
        if (n == 0) {
            gL2.glPolygonMode(1032, 6912);
        } else if (n == 1) {
            gL2.glPolygonMode(1032, 6913);
        } else {
            gL2.glPolygonMode(1032, 6914);
        }
        gL2.glPolygonOffset(f2, f);
        if ((double)f2 != 0.0 || (double)f != 0.0) {
            switch (n) {
                case 0: {
                    gL2.glEnable(10753);
                    gL2.glDisable(10754);
                    gL2.glDisable(32823);
                    break;
                }
                case 1: {
                    gL2.glEnable(10754);
                    gL2.glDisable(10753);
                    gL2.glDisable(32823);
                    break;
                }
                case 2: {
                    gL2.glEnable(32823);
                    gL2.glDisable(10753);
                    gL2.glDisable(10754);
                }
            }
        } else {
            gL2.glDisable(10753);
            gL2.glDisable(10754);
            gL2.glDisable(32823);
        }
    }

    @Override
    void updateRenderingAttributes(Context context, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n, float f, int n2, boolean bl5, boolean bl6, int n3, boolean bl7, boolean bl8, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        GL2 gL2 = this.context(context).getGL().getGL2();
        if (!bl2) {
            if (bl3) {
                gL2.glEnable(2929);
                gL2.glDepthFunc(this.getFunctionValue(n));
            } else {
                gL2.glDisable(2929);
            }
        }
        if (!bl) {
            if (bl4) {
                gL2.glDepthMask(true);
            } else {
                gL2.glDepthMask(false);
            }
        }
        if (n2 == 0) {
            gL2.glDisable(3008);
        } else {
            gL2.glEnable(3008);
            gL2.glAlphaFunc(this.getFunctionValue(n2), f);
        }
        if (bl5) {
            gL2.glDisable(2903);
        } else {
            gL2.glEnable(2903);
        }
        if (bl6) {
            gL2.glEnable(3058);
            switch (n3) {
                case 0: {
                    gL2.glLogicOp(5376);
                    break;
                }
                case 1: {
                    gL2.glLogicOp(5377);
                    break;
                }
                case 2: {
                    gL2.glLogicOp(5378);
                    break;
                }
                case 3: {
                    gL2.glLogicOp(5379);
                    break;
                }
                case 4: {
                    gL2.glLogicOp(5380);
                    break;
                }
                case 5: {
                    gL2.glLogicOp(5381);
                    break;
                }
                case 6: {
                    gL2.glLogicOp(5382);
                    break;
                }
                case 7: {
                    gL2.glLogicOp(5383);
                    break;
                }
                case 8: {
                    gL2.glLogicOp(5384);
                    break;
                }
                case 9: {
                    gL2.glLogicOp(5385);
                    break;
                }
                case 10: {
                    gL2.glLogicOp(5386);
                    break;
                }
                case 11: {
                    gL2.glLogicOp(5387);
                    break;
                }
                case 12: {
                    gL2.glLogicOp(5388);
                    break;
                }
                case 13: {
                    gL2.glLogicOp(5389);
                    break;
                }
                case 14: {
                    gL2.glLogicOp(5390);
                    break;
                }
                case 15: {
                    gL2.glLogicOp(5391);
                }
            }
        } else {
            gL2.glDisable(3058);
        }
        if (bl7) {
            if (bl8) {
                gL2.glEnable(2960);
                gL2.glStencilOp(this.getStencilOpValue(n4), this.getStencilOpValue(n5), this.getStencilOpValue(n6));
                gL2.glStencilFunc(this.getFunctionValue(n7), n8, n9);
                gL2.glStencilMask(n10);
            } else {
                gL2.glDisable(2960);
            }
        }
    }

    private int getFunctionValue(int n) {
        switch (n) {
            case 0: {
                n = 519;
                break;
            }
            case 1: {
                n = 512;
                break;
            }
            case 2: {
                n = 514;
                break;
            }
            case 3: {
                n = 517;
                break;
            }
            case 4: {
                n = 513;
                break;
            }
            case 5: {
                n = 515;
                break;
            }
            case 6: {
                n = 516;
                break;
            }
            case 7: {
                n = 518;
            }
        }
        return n;
    }

    private int getStencilOpValue(int n) {
        switch (n) {
            case 1: {
                n = 7680;
                break;
            }
            case 2: {
                n = 0;
                break;
            }
            case 3: {
                n = 7681;
                break;
            }
            case 4: {
                n = 7682;
                break;
            }
            case 5: {
                n = 7683;
                break;
            }
            case 6: {
                n = 5386;
            }
        }
        return n;
    }

    @Override
    void updateTexCoordGeneration(Context context, boolean bl, int n, int n2, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16, double[] dArray) {
        GL2 gL2 = this.context(context).getGL().getGL2();
        float[] fArray = new float[4];
        float[] fArray2 = new float[4];
        float[] fArray3 = new float[4];
        float[] fArray4 = new float[4];
        if (bl) {
            gL2.glEnable(3168);
            gL2.glEnable(3169);
            if (n2 == 1) {
                gL2.glEnable(3170);
                gL2.glDisable(3171);
            } else if (n2 == 2) {
                gL2.glEnable(3170);
                gL2.glEnable(3171);
            } else {
                gL2.glDisable(3170);
                gL2.glDisable(3171);
            }
            if (n != 2) {
                fArray[0] = f;
                fArray[1] = f2;
                fArray[2] = f3;
                fArray[3] = f4;
                fArray2[0] = f5;
                fArray2[1] = f6;
                fArray2[2] = f7;
                fArray2[3] = f8;
                if (n2 == 1) {
                    fArray3[0] = f9;
                    fArray3[1] = f10;
                    fArray3[2] = f11;
                    fArray3[3] = f12;
                } else if (n2 == 2) {
                    fArray3[0] = f9;
                    fArray3[1] = f10;
                    fArray3[2] = f11;
                    fArray3[3] = f12;
                    fArray4[0] = f13;
                    fArray4[1] = f14;
                    fArray4[2] = f15;
                    fArray4[3] = f16;
                }
            }
            switch (n) {
                case 0: {
                    gL2.glTexGeni(8192, 9472, 9217);
                    gL2.glTexGeni(8193, 9472, 9217);
                    gL2.glTexGenfv(8192, 9473, fArray, 0);
                    gL2.glTexGenfv(8193, 9473, fArray2, 0);
                    if (n2 == 1) {
                        gL2.glTexGeni(8194, 9472, 9217);
                        gL2.glTexGenfv(8194, 9473, fArray3, 0);
                        break;
                    }
                    if (n2 != 2) break;
                    gL2.glTexGeni(8194, 9472, 9217);
                    gL2.glTexGenfv(8194, 9473, fArray3, 0);
                    gL2.glTexGeni(8195, 9472, 9217);
                    gL2.glTexGenfv(8195, 9473, fArray4, 0);
                    break;
                }
                case 1: {
                    gL2.glMatrixMode(5888);
                    gL2.glPushMatrix();
                    if (gL2.isExtensionAvailable("GL_VERSION_1_3")) {
                        gL2.glLoadTransposeMatrixd(dArray, 0);
                    } else {
                        double[] dArray2 = new double[16];
                        this.copyTranspose(dArray, dArray2);
                        gL2.glLoadMatrixd(dArray2, 0);
                    }
                    gL2.glTexGeni(8192, 9472, 9216);
                    gL2.glTexGeni(8193, 9472, 9216);
                    gL2.glTexGenfv(8192, 9474, fArray, 0);
                    gL2.glTexGenfv(8193, 9474, fArray2, 0);
                    if (n2 == 1) {
                        gL2.glTexGeni(8194, 9472, 9216);
                        gL2.glTexGenfv(8194, 9474, fArray3, 0);
                    } else if (n2 == 2) {
                        gL2.glTexGeni(8194, 9472, 9216);
                        gL2.glTexGenfv(8194, 9474, fArray3, 0);
                        gL2.glTexGeni(8195, 9472, 9216);
                        gL2.glTexGenfv(8195, 9474, fArray4, 0);
                    }
                    gL2.glPopMatrix();
                    break;
                }
                case 2: {
                    gL2.glTexGeni(8192, 9472, 9218);
                    gL2.glTexGeni(8193, 9472, 9218);
                    if (n2 == 1) {
                        gL2.glTexGeni(8194, 9472, 9218);
                        break;
                    }
                    if (n2 != 2) break;
                    gL2.glTexGeni(8194, 9472, 9218);
                    gL2.glTexGeni(8195, 9472, 9218);
                    break;
                }
                case 3: {
                    gL2.glTexGeni(8192, 9472, 34065);
                    gL2.glTexGeni(8193, 9472, 34065);
                    if (n2 == 1) {
                        gL2.glTexGeni(8194, 9472, 34065);
                        break;
                    }
                    if (n2 != 2) break;
                    gL2.glTexGeni(8194, 9472, 34065);
                    gL2.glTexGeni(8195, 9472, 34065);
                    break;
                }
                case 4: {
                    gL2.glTexGeni(8192, 9472, 34066);
                    gL2.glTexGeni(8193, 9472, 34066);
                    if (n2 == 1) {
                        gL2.glTexGeni(8194, 9472, 34066);
                        break;
                    }
                    if (n2 != 2) break;
                    gL2.glTexGeni(8194, 9472, 34066);
                    gL2.glTexGeni(8195, 9472, 34066);
                }
            }
        } else {
            gL2.glDisable(3168);
            gL2.glDisable(3169);
            gL2.glDisable(3170);
            gL2.glDisable(3171);
        }
    }

    @Override
    void updateTransparencyAttributes(Context context, float f, int n, int n2, boolean bl, boolean bl2, int n3, int n4, int n5) {
        GL2 gL2 = this.context(context).getGL().getGL2();
        if (n3 != 3) {
            gL2.glDisable(2882);
        } else {
            gL2.glEnable(2882);
            gL2.glPolygonStipple(screen_door_table[(int)(f * 16.0f)]);
        }
        if (n3 < 3 || ((n & 2) != 0 || n2 == 1) && bl || ((n & 1) != 0 || n2 == 0) && bl2) {
            gL2.glEnable(3042);
            gL2.glBlendFunc(blendFunctionTable[n4], blendFunctionTable[n5]);
        } else {
            gL2.glDisable(3042);
        }
    }

    @Override
    void updateTextureAttributes(Context context, double[] dArray, boolean bl, int n, int n2, float f, float f2, float f3, float f4, int n3) {
        Object[] objectArray;
        GL2 gL2 = this.context(context).getGL().getGL2();
        gL2.glHint(3152, n2 == 1 ? 4354 : 4353);
        gL2.glPushAttrib(4096);
        gL2.glMatrixMode(5890);
        if (bl) {
            gL2.glLoadIdentity();
        } else if (gL2.isExtensionAvailable("GL_VERSION_1_3")) {
            gL2.glLoadTransposeMatrixd(dArray, 0);
        } else {
            objectArray = new double[16];
            this.copyTranspose(dArray, (double[])objectArray);
            gL2.glLoadMatrixd(objectArray, 0);
        }
        gL2.glPopAttrib();
        objectArray = new float[4];
        objectArray[0] = f;
        objectArray[1] = f2;
        objectArray[2] = f3;
        objectArray[3] = f4;
        gL2.glTexEnvfv(8960, 8705, (float[])objectArray, 0);
        switch (n) {
            case 2: {
                gL2.glTexEnvi(8960, 8704, 8448);
                break;
            }
            case 3: {
                gL2.glTexEnvi(8960, 8704, 8449);
                break;
            }
            case 4: {
                gL2.glTexEnvi(8960, 8704, 3042);
                break;
            }
            case 5: {
                gL2.glTexEnvi(8960, 8704, 7681);
                break;
            }
            case 6: {
                gL2.glTexEnvi(8960, 8704, 34160);
            }
        }
    }

    @Override
    void updateRegisterCombiners(Context context, double[] dArray, boolean bl, int n, int n2, float f, float f2, float f3, float f4, int n3, int n4, int n5, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int n6, int n7) {
    }

    @Override
    void updateTextureColorTable(Context context, int n, int n2, int[] nArray) {
    }

    @Override
    void updateCombiner(Context context, int n, int n2, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int n3, int n4) {
        int n5;
        GL2 gL2 = this.context(context).getGL().getGL2();
        int[] nArray5 = new int[1];
        int[] nArray6 = new int[1];
        this.getGLCombineMode((GL)gL2, n, n2, nArray5, nArray6);
        gL2.glTexEnvi(8960, 34161, nArray5[0]);
        gL2.glTexEnvi(8960, 34162, nArray6[0]);
        int n6 = n == 0 ? 1 : (n == 5 ? 3 : 2);
        for (n5 = 0; n5 < n6; ++n5) {
            gL2.glTexEnvi(8960, _gl_combineRgbSrcIndex[n5], _gl_combineSrc[nArray[n5]]);
            gL2.glTexEnvi(8960, _gl_combineRgbOpIndex[n5], _gl_combineFcn[nArray3[n5]]);
        }
        n6 = n2 == 0 ? 1 : (n2 == 5 ? 3 : 2);
        for (n5 = 0; n5 < n6; ++n5) {
            gL2.glTexEnvi(8960, _gl_combineAlphaSrcIndex[n5], _gl_combineSrc[nArray2[n5]]);
            gL2.glTexEnvi(8960, _gl_combineAlphaOpIndex[n5], _gl_combineFcn[nArray4[n5]]);
        }
        gL2.glTexEnvi(8960, 34163, n3);
        gL2.glTexEnvi(8960, 3356, n4);
    }

    private void getGLCombineMode(GL gL, int n, int n2, int[] nArray, int[] nArray2) {
        switch (n) {
            case 0: {
                nArray[0] = 7681;
                break;
            }
            case 1: {
                nArray[0] = 8448;
                break;
            }
            case 2: {
                nArray[0] = 260;
                break;
            }
            case 3: {
                nArray[0] = 34164;
                break;
            }
            case 4: {
                nArray[0] = 34023;
                break;
            }
            case 5: {
                nArray[0] = 34165;
                break;
            }
            case 6: {
                nArray[0] = 34478;
                break;
            }
        }
        switch (n2) {
            case 0: {
                nArray2[0] = 7681;
                break;
            }
            case 1: {
                nArray2[0] = 8448;
                break;
            }
            case 2: {
                nArray2[0] = 260;
                break;
            }
            case 3: {
                nArray2[0] = 34164;
                break;
            }
            case 4: {
                nArray2[0] = 34023;
                break;
            }
            case 5: {
                nArray2[0] = 34165;
                break;
            }
            case 6: {
                if (n == 6) {
                    nArray[0] = 34479;
                    break;
                }
                nArray2[0] = 7681;
                break;
            }
        }
    }

    @Override
    void updateTextureUnitState(Context context, int n, boolean bl) {
        GL2 gL2 = this.context(context).getGL().getGL2();
        if (n >= 0 && gL2.isExtensionAvailable("GL_VERSION_1_3")) {
            gL2.glActiveTexture(n + 33984);
            gL2.glClientActiveTexture(33984 + n);
        }
        if (!bl) {
            gL2.glDisable(3552);
            gL2.glDisable(3553);
            gL2.glDisable(32879);
            gL2.glDisable(34067);
        }
    }

    @Override
    void bindTexture2D(Context context, int n, boolean bl) {
        GL gL = this.context(context).getGL();
        gL.glDisable(34067);
        gL.glDisable(32879);
        if (!bl) {
            gL.glDisable(3553);
        } else {
            gL.glBindTexture(3553, n);
            gL.glEnable(3553);
        }
    }

    @Override
    void updateTexture2DImage(Context context, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Object object, boolean bl) {
        this.updateTexture2DImage(context, 3553, n, n2, n3, n4, n5, n6, n7, n8, object, bl);
    }

    @Override
    void updateTexture2DSubImage(Context context, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, Object object, boolean bl) {
        this.updateTexture2DSubImage(context, 3553, n, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, object);
    }

    @Override
    void updateTexture2DLodRange(Context context, int n, int n2, float f, float f2) {
        this.updateTextureLodRange(context, 3553, n, n2, f, f2);
    }

    @Override
    void updateTexture2DLodOffset(Context context, float f, float f2, float f3) {
        this.updateTextureLodOffset(context, 3553, f, f2, f3);
    }

    @Override
    void updateTexture2DBoundary(Context context, int n, int n2, float f, float f2, float f3, float f4) {
        this.updateTextureBoundary(context, 3553, n, n2, -1, f, f2, f3, f4);
    }

    @Override
    void updateTexture2DFilterModes(Context context, int n, int n2) {
        this.updateTextureFilterModes(context, 3553, n, n2);
    }

    @Override
    void updateTexture2DSharpenFunc(Context context, int n, float[] fArray) {
        this.updateTextureSharpenFunc(context, 3553, n, fArray);
    }

    @Override
    void updateTexture2DFilter4Func(Context context, int n, float[] fArray) {
        this.updateTextureFilter4Func(context, 3553, n, fArray);
    }

    @Override
    void updateTexture2DAnisotropicFilter(Context context, float f) {
        this.updateTextureAnisotropicFilter(context, 3553, f);
    }

    private void updateTextureLodRange(Context context, int n, int n2, int n3, float f, float f2) {
        GL gL = this.context(context).getGL();
        gL.glTexParameteri(n, 33084, n2);
        gL.glTexParameteri(n, 33085, n3);
        gL.glTexParameterf(n, 33082, f);
        gL.glTexParameterf(n, 33083, f2);
    }

    private void updateTextureLodOffset(Context context, int n, float f, float f2, float f3) {
    }

    private void updateTextureAnisotropicFilter(Context context, int n, float f) {
        GL gL = this.context(context).getGL();
        gL.glTexParameterf(n, 34046, f);
    }

    @Override
    void bindTexture3D(Context context, int n, boolean bl) {
        GL gL = this.context(context).getGL();
        gL.glDisable(34067);
        if (!bl) {
            gL.glDisable(32879);
        } else {
            gL.glBindTexture(32879, n);
            gL.glEnable(32879);
        }
    }

    @Override
    void updateTexture3DImage(Context context, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, Object object, boolean bl) {
        GL2 gL2 = this.context(context).getGL().getGL2();
        int n10 = 0;
        int n11 = 0;
        int n12 = 32821;
        boolean bl2 = false;
        switch (n3) {
            case 1: {
                n11 = 32841;
                break;
            }
            case 2: {
                n11 = 6409;
                break;
            }
            case 3: {
                n11 = 6406;
                break;
            }
            case 4: {
                n11 = 6410;
                break;
            }
            case 5: {
                n11 = 6407;
                break;
            }
            case 6: {
                n11 = 6408;
                break;
            }
            default: {
                assert (false);
                return;
            }
        }
        if (bl) {
            gL2.glTexParameteri(32879, 33169, 1);
        } else {
            gL2.glTexParameteri(32879, 33169, 0);
        }
        if (n9 == 4096 || n9 == 16384) {
            switch (n4) {
                case 1: {
                    n10 = 32992;
                    break;
                }
                case 2: {
                    n10 = 6407;
                    break;
                }
                case 4: {
                    if (gL2.isExtensionAvailable("GL_EXT_abgr")) {
                        n10 = 32768;
                        break;
                    }
                    assert (false);
                    return;
                }
                case 8: {
                    n10 = 6408;
                    break;
                }
                case 16: {
                    n10 = 6410;
                    break;
                }
                case 32: {
                    if (n11 == 6406) {
                        n10 = 6406;
                        break;
                    }
                    n10 = 6409;
                    break;
                }
                default: {
                    assert (false);
                    return;
                }
            }
            if (n9 == 4096) {
                gL2.glTexImage3D(32879, n2, n11, n5, n6, n7, n8, n10, 5121, (Buffer)ByteBuffer.wrap((byte[])object));
            } else {
                gL2.glTexImage3D(32879, n2, n11, n5, n6, n7, n8, n10, 5121, (Buffer)((ByteBuffer)object));
            }
        } else if (n9 == 8192 || n9 == 32768) {
            switch (n4) {
                case 128: {
                    n10 = 6408;
                    n12 = 33639;
                    bl2 = true;
                    break;
                }
                case 256: {
                    bl2 = true;
                }
                case 512: {
                    n10 = 32993;
                    n12 = 33639;
                    break;
                }
                default: {
                    assert (false);
                    return;
                }
            }
            if (bl2) {
                gL2.glPixelTransferf(3356, 0.0f);
                gL2.glPixelTransferf(3357, 1.0f);
            }
            if (n9 == 8192) {
                gL2.glTexImage3D(32879, n2, n11, n5, n6, n7, n8, n10, n12, (Buffer)IntBuffer.wrap((int[])object));
            } else {
                gL2.glTexImage3D(32879, n2, n11, n5, n6, n7, n8, n10, n12, (Buffer)object);
            }
            if (bl2) {
                gL2.glPixelTransferf(3356, 1.0f);
                gL2.glPixelTransferf(3357, 0.0f);
            }
        } else assert (false);
    }

    @Override
    void updateTexture3DSubImage(Context context, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, int n15, Object object, boolean bl) {
        GL2 gL2 = this.context(context).getGL().getGL2();
        int n16 = 0;
        int n17 = 0;
        int n18 = 32821;
        int n19 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (n7 > 0 || n12 < n10) {
            bl3 = true;
            gL2.glPixelStorei(3314, n10);
        }
        switch (n5) {
            case 1: {
                n17 = 32841;
                break;
            }
            case 2: {
                n17 = 6409;
                break;
            }
            case 3: {
                n17 = 6406;
                break;
            }
            case 4: {
                n17 = 6410;
                break;
            }
            case 5: {
                n17 = 6407;
                break;
            }
            case 6: {
                n17 = 6408;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        if (n15 == 4096 || n15 == 16384) {
            switch (n6) {
                case 1: {
                    n16 = 32992;
                    n19 = 3;
                    break;
                }
                case 2: {
                    n16 = 6407;
                    n19 = 3;
                    break;
                }
                case 4: {
                    if (gL2.isExtensionAvailable("GL_EXT_abgr")) {
                        n16 = 32768;
                        n19 = 4;
                        break;
                    }
                    assert (false);
                    return;
                }
                case 8: {
                    n16 = 6408;
                    n19 = 4;
                    break;
                }
                case 16: {
                    n16 = 6410;
                    n19 = 2;
                    break;
                }
                case 32: {
                    if (n17 == 6406) {
                        n16 = 6406;
                        n19 = 1;
                        break;
                    }
                    n16 = 6409;
                    n19 = 1;
                    break;
                }
                default: {
                    assert (false);
                    return;
                }
            }
            ByteBuffer byteBuffer = null;
            byteBuffer = n15 == 4096 ? ByteBuffer.wrap((byte[])object) : (ByteBuffer)object;
            int n20 = (n10 * n11 * n9 + n10 * n8 + n7) * n19;
            byteBuffer.position(n20);
            gL2.glTexSubImage3D(32879, n, n2, n3, n4, n12, n13, n14, n16, 5121, (Buffer)byteBuffer);
        } else if (n15 == 8192 || n15 == 32768) {
            switch (n6) {
                case 128: {
                    n16 = 6408;
                    n18 = 33639;
                    bl2 = true;
                    break;
                }
                case 256: {
                    bl2 = true;
                }
                case 512: {
                    n16 = 32993;
                    n18 = 33639;
                    break;
                }
                default: {
                    assert (false);
                    return;
                }
            }
            if (bl2) {
                gL2.glPixelTransferf(3356, 0.0f);
                gL2.glPixelTransferf(3357, 1.0f);
            }
            IntBuffer intBuffer = null;
            intBuffer = n15 == 8192 ? IntBuffer.wrap((int[])object) : (IntBuffer)object;
            int n21 = n10 * n11 * n9 + n10 * n8 + n7;
            intBuffer.position(n21);
            gL2.glTexSubImage3D(32879, n, n2, n3, n4, n12, n13, n14, n16, n18, (Buffer)intBuffer);
            if (bl2) {
                gL2.glPixelTransferf(3356, 1.0f);
                gL2.glPixelTransferf(3357, 0.0f);
            }
        } else {
            assert (false);
            return;
        }
        if (bl3) {
            gL2.glPixelStorei(3314, 0);
        }
    }

    @Override
    void updateTexture3DLodRange(Context context, int n, int n2, float f, float f2) {
        this.updateTextureLodRange(context, 32879, n, n2, f, f2);
    }

    @Override
    void updateTexture3DLodOffset(Context context, float f, float f2, float f3) {
        this.updateTextureLodOffset(context, 32879, f, f2, f3);
    }

    @Override
    void updateTexture3DBoundary(Context context, int n, int n2, int n3, float f, float f2, float f3, float f4) {
        this.updateTextureBoundary(context, 32879, n, n2, n3, f, f2, f3, f4);
    }

    @Override
    void updateTexture3DFilterModes(Context context, int n, int n2) {
        this.updateTextureFilterModes(context, 32879, n, n2);
    }

    @Override
    void updateTexture3DSharpenFunc(Context context, int n, float[] fArray) {
        this.updateTextureSharpenFunc(context, 32879, n, fArray);
    }

    @Override
    void updateTexture3DFilter4Func(Context context, int n, float[] fArray) {
        this.updateTextureFilter4Func(context, 32879, n, fArray);
    }

    @Override
    void updateTexture3DAnisotropicFilter(Context context, float f) {
        this.updateTextureAnisotropicFilter(context, 32879, f);
    }

    @Override
    void bindTextureCubeMap(Context context, int n, boolean bl) {
        GL gL = this.context(context).getGL();
        if (!bl) {
            gL.glDisable(34067);
        } else {
            gL.glBindTexture(34067, n);
            gL.glEnable(34067);
        }
    }

    @Override
    void updateTextureCubeMapImage(Context context, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, Object object, boolean bl) {
        this.updateTexture2DImage(context, _gl_textureCubeMapFace[n], n2, n3, n4, n5, n6, n7, n8, n9, object, bl);
    }

    @Override
    void updateTextureCubeMapSubImage(Context context, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, Object object, boolean bl) {
        this.updateTexture2DSubImage(context, _gl_textureCubeMapFace[n], n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, object);
    }

    @Override
    void updateTextureCubeMapLodRange(Context context, int n, int n2, float f, float f2) {
        this.updateTextureLodRange(context, 34067, n, n2, f, f2);
    }

    @Override
    void updateTextureCubeMapLodOffset(Context context, float f, float f2, float f3) {
        this.updateTextureLodOffset(context, 34067, f, f2, f3);
    }

    @Override
    void updateTextureCubeMapBoundary(Context context, int n, int n2, float f, float f2, float f3, float f4) {
        this.updateTextureBoundary(context, 34067, n, n2, -1, f, f2, f3, f4);
    }

    @Override
    void updateTextureCubeMapFilterModes(Context context, int n, int n2) {
        this.updateTextureFilterModes(context, 34067, n, n2);
    }

    @Override
    void updateTextureCubeMapSharpenFunc(Context context, int n, float[] fArray) {
        this.updateTextureSharpenFunc(context, 34067, n, fArray);
    }

    @Override
    void updateTextureCubeMapFilter4Func(Context context, int n, float[] fArray) {
        this.updateTextureFilter4Func(context, 34067, n, fArray);
    }

    @Override
    void updateTextureCubeMapAnisotropicFilter(Context context, float f) {
        this.updateTextureAnisotropicFilter(context, 34067, f);
    }

    private void updateTexture2DImage(Context context, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, Object object, boolean bl) {
        GL2 gL2 = this.context(context).getGL().getGL2();
        int n10 = 0;
        int n11 = 0;
        int n12 = 32821;
        boolean bl2 = false;
        switch (n4) {
            case 1: {
                n11 = 32841;
                break;
            }
            case 2: {
                n11 = 6409;
                break;
            }
            case 3: {
                n11 = 6406;
                break;
            }
            case 4: {
                n11 = 6410;
                break;
            }
            case 5: {
                n11 = 6407;
                break;
            }
            case 6: {
                n11 = 6408;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        if (bl) {
            gL2.glTexParameteri(n, 33169, 1);
        } else {
            gL2.glTexParameteri(n, 33169, 0);
        }
        if (n9 == 4096 || n9 == 16384) {
            switch (n5) {
                case 1: {
                    n10 = 32992;
                    break;
                }
                case 2: {
                    n10 = 6407;
                    break;
                }
                case 4: {
                    if (gL2.isExtensionAvailable("GL_EXT_abgr")) {
                        n10 = 32768;
                        break;
                    }
                    assert (false);
                    return;
                }
                case 8: {
                    n10 = 6408;
                    break;
                }
                case 16: {
                    n10 = 6410;
                    break;
                }
                case 32: {
                    if (n11 == 6406) {
                        n10 = 6406;
                        break;
                    }
                    n10 = 6409;
                    break;
                }
                default: {
                    assert (false);
                    return;
                }
            }
            if (n9 == 4096) {
                gL2.glTexImage2D(n, n3, n11, n6, n7, n8, n10, 5121, (Buffer)ByteBuffer.wrap((byte[])object));
            } else {
                gL2.glTexImage2D(n, n3, n11, n6, n7, n8, n10, 5121, (Buffer)object);
            }
        } else if (n9 == 8192 || n9 == 32768) {
            switch (n5) {
                case 128: {
                    n10 = 6408;
                    n12 = 33639;
                    bl2 = true;
                    break;
                }
                case 256: {
                    bl2 = true;
                }
                case 512: {
                    n10 = 32993;
                    n12 = 33639;
                    break;
                }
                default: {
                    assert (false);
                    return;
                }
            }
            if (bl2) {
                gL2.glPixelTransferf(3356, 0.0f);
                gL2.glPixelTransferf(3357, 1.0f);
            }
            if (n9 == 8192) {
                gL2.glTexImage2D(n, n3, n11, n6, n7, n8, n10, n12, (Buffer)IntBuffer.wrap((int[])object));
            } else {
                gL2.glTexImage2D(n, n3, n11, n6, n7, n8, n10, n12, (Buffer)object);
            }
            if (bl2) {
                gL2.glPixelTransferf(3356, 1.0f);
                gL2.glPixelTransferf(3357, 0.0f);
            }
        } else assert (false);
    }

    private void updateTexture2DSubImage(Context context, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, Object object) {
        GL2 gL2 = this.context(context).getGL().getGL2();
        int n13 = 0;
        int n14 = 0;
        int n15 = 0;
        int n16 = 32821;
        boolean bl = false;
        boolean bl2 = false;
        if (n7 > 0 || n10 < n9) {
            bl2 = true;
            gL2.glPixelStorei(3314, n9);
        }
        switch (n5) {
            case 1: {
                n14 = 32841;
                break;
            }
            case 2: {
                n14 = 6409;
                break;
            }
            case 3: {
                n14 = 6406;
                break;
            }
            case 4: {
                n14 = 6410;
                break;
            }
            case 5: {
                n14 = 6407;
                break;
            }
            case 6: {
                n14 = 6408;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        if (n12 == 4096 || n12 == 16384) {
            switch (n6) {
                case 1: {
                    n13 = 32992;
                    n15 = 3;
                    break;
                }
                case 2: {
                    n13 = 6407;
                    n15 = 3;
                    break;
                }
                case 4: {
                    if (gL2.isExtensionAvailable("GL_EXT_abgr")) {
                        n13 = 32768;
                        n15 = 4;
                        break;
                    }
                    assert (false);
                    return;
                }
                case 8: {
                    n13 = 6408;
                    n15 = 4;
                    break;
                }
                case 16: {
                    n13 = 6410;
                    n15 = 2;
                    break;
                }
                case 32: {
                    if (n14 == 6406) {
                        n13 = 6406;
                        n15 = 1;
                        break;
                    }
                    n13 = 6409;
                    n15 = 1;
                    break;
                }
                default: {
                    assert (false);
                    return;
                }
            }
            ByteBuffer byteBuffer = null;
            byteBuffer = n12 == 4096 ? ByteBuffer.wrap((byte[])object) : (ByteBuffer)object;
            byteBuffer.position((n9 * n8 + n7) * n15);
            gL2.glTexSubImage2D(n, n2, n3, n4, n10, n11, n13, 5121, (Buffer)byteBuffer);
        } else if (n12 == 8192 || n12 == 32768) {
            switch (n6) {
                case 128: {
                    n13 = 6408;
                    n16 = 33639;
                    bl = true;
                    break;
                }
                case 256: {
                    bl = true;
                }
                case 512: {
                    n13 = 32993;
                    n16 = 33639;
                    break;
                }
                default: {
                    assert (false);
                    return;
                }
            }
            if (bl) {
                gL2.glPixelTransferf(3356, 0.0f);
                gL2.glPixelTransferf(3357, 1.0f);
            }
            IntBuffer intBuffer = null;
            intBuffer = n12 == 8192 ? IntBuffer.wrap((int[])object) : (IntBuffer)object;
            intBuffer.position(n9 * n8 + n7);
            gL2.glTexSubImage2D(n, n2, n3, n4, n10, n11, n13, n16, (Buffer)intBuffer);
            if (bl) {
                gL2.glPixelTransferf(3356, 1.0f);
                gL2.glPixelTransferf(3357, 0.0f);
            }
        } else {
            assert (false);
            return;
        }
        if (bl2) {
            gL2.glPixelStorei(3314, 0);
        }
    }

    void updateTextureFilterModes(Context context, int n, int n2, int n3) {
        GL gL = this.context(context).getGL();
        switch (n2) {
            case 0: 
            case 2: {
                gL.glTexParameteri(n, 10241, 9728);
                break;
            }
            case 3: {
                gL.glTexParameteri(n, 10241, 9729);
                break;
            }
            case 4: {
                gL.glTexParameteri(n, 10241, 9984);
                break;
            }
            case 1: 
            case 5: {
                gL.glTexParameteri(n, 10241, 9987);
                break;
            }
        }
        switch (n3) {
            case 0: 
            case 2: {
                gL.glTexParameteri(n, 10240, 9728);
                break;
            }
            case 1: 
            case 3: {
                gL.glTexParameteri(n, 10240, 9729);
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                break;
            }
            case 11: {
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                break;
            }
        }
    }

    void updateTextureBoundary(Context context, int n, int n2, int n3, int n4, float f, float f2, float f3, float f4) {
        GL gL = this.context(context).getGL();
        switch (n2) {
            case 3: {
                gL.glTexParameteri(n, 10242, 10497);
                break;
            }
            case 2: {
                gL.glTexParameteri(n, 10242, 10496);
                break;
            }
            case 4: {
                gL.glTexParameteri(n, 10242, 33071);
                break;
            }
            case 5: {
                gL.glTexParameteri(n, 10242, 33069);
            }
        }
        switch (n3) {
            case 3: {
                gL.glTexParameteri(n, 10243, 10497);
                break;
            }
            case 2: {
                gL.glTexParameteri(n, 10243, 10496);
                break;
            }
            case 4: {
                gL.glTexParameteri(n, 10243, 33071);
                break;
            }
            case 5: {
                gL.glTexParameteri(n, 10243, 33069);
            }
        }
        if (n4 != -1) {
            switch (n4) {
                case 3: {
                    gL.glTexParameteri(n, 32882, 10497);
                    break;
                }
                case 2: {
                    gL.glTexParameteri(n, 32882, 10496);
                    break;
                }
                case 4: {
                    gL.glTexParameteri(n, 32882, 33071);
                    break;
                }
                case 5: {
                    gL.glTexParameteri(n, 32882, 33069);
                }
            }
        }
        if (n2 == 2 || n3 == 2 || n4 == 2) {
            float[] fArray = new float[]{f, f2, f3, f4};
            gL.glTexParameterfv(n, 4100, fArray, 0);
        }
    }

    private static final String getFilterName(int n) {
        switch (n) {
            case 0: {
                return "Texture.FASTEST";
            }
            case 1: {
                return "Texture.NICEST";
            }
            case 2: {
                return "Texture.BASE_LEVEL_POINT";
            }
            case 3: {
                return "Texture.BASE_LEVEL_LINEAR";
            }
            case 4: {
                return "Texture.MULTI_LEVEL_POINT";
            }
            case 5: {
                return "Texture.MULTI_LEVEL_LINEAR";
            }
            case 12: {
                return "Texture.FILTER4";
            }
            case 9: {
                return "Texture.LINEAR_SHARPEN";
            }
            case 10: {
                return "Texture.LINEAR_SHARPEN_RGB";
            }
            case 11: {
                return "Texture.LINEAR_SHARPEN_ALPHA";
            }
            case 6: {
                return "Texture.LINEAR_DETAIL";
            }
            case 7: {
                return "Texture.LINEAR_DETAIL_RGB";
            }
            case 8: {
                return "Texture.LINEAR_DETAIL_ALPHA";
            }
        }
        return "(unknown)";
    }

    private void updateTextureSharpenFunc(Context context, int n, int n2, float[] fArray) {
    }

    private void updateTextureFilter4Func(Context context, int n, int n2, float[] fArray) {
    }

    @Override
    int getMaximumLights() {
        return 8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void resizeOffscreenLayer(Canvas3D canvas3D, int n, int n2) {
        block14: {
            if (!JoglPipeline.isOffscreenLayerSurfaceEnabled(canvas3D)) {
                return;
            }
            JoglDrawable joglDrawable = (JoglDrawable)canvas3D.drawable;
            if (!JoglPipeline.hasFBObjectSizeChanged(joglDrawable, n, n2)) {
                return;
            }
            int n3 = Math.max(1, n);
            int n4 = Math.max(1, n2);
            GLDrawable gLDrawable = joglDrawable.getGLDrawable();
            GLContext gLContext = this.context(canvas3D.ctx);
            NativeSurface nativeSurface = gLDrawable.getNativeSurface();
            ProxySurface proxySurface = nativeSurface instanceof ProxySurface ? (ProxySurface)nativeSurface : null;
            int n5 = nativeSurface.lockSurface();
            try {
                UpstreamSurfaceHook upstreamSurfaceHook;
                if (proxySurface != null && (upstreamSurfaceHook = proxySurface.getUpstreamSurfaceHook()) instanceof UpstreamSurfaceHook.MutableSize) {
                    ((UpstreamSurfaceHook.MutableSize)upstreamSurfaceHook).setSurfaceSize(n3, n4);
                }
                upstreamSurfaceHook = gLContext.getGL().getGL2();
                if (gLDrawable instanceof GLFBODrawable) {
                    int n6 = ((GLFBODrawable)gLDrawable).getChosenGLCapabilities().getNumSamples();
                    FBObject fBObject = ((GLFBODrawable)gLDrawable).getFBObject(1029);
                    fBObject.reset((GL)upstreamSurfaceHook, n3, n4, n6, false);
                    fBObject.bind((GL)upstreamSurfaceHook);
                    break block14;
                }
                GLContext gLContext2 = GLContext.getCurrent();
                GLDrawableFactory gLDrawableFactory = gLDrawable.getFactory();
                if (gLContext2 != gLContext) {
                    gLContext.makeCurrent();
                }
                upstreamSurfaceHook.glFinish();
                gLContext.release();
                if (proxySurface != null) {
                    proxySurface.enableUpstreamSurfaceHookLifecycle(false);
                }
                try {
                    gLDrawable.setRealized(false);
                    gLDrawable = gLDrawableFactory.createGLDrawable(nativeSurface);
                    gLDrawable.setRealized(true);
                    joglDrawable.setGLDrawable(gLDrawable);
                }
                finally {
                    if (proxySurface != null) {
                        proxySurface.enableUpstreamSurfaceHookLifecycle(true);
                    }
                }
                gLContext.setGLDrawable(gLDrawable, true);
                if (gLContext2 != null) {
                    gLContext2.makeCurrent();
                }
            }
            finally {
                nativeSurface.unlockSurface();
            }
        }
    }

    private void checkAppContext() {
        if (this.mainThreadContext == null) {
            return;
        }
        try {
            Class<?> clazz = Class.forName("sun.awt.AppContext");
            if (clazz.getMethod("getAppContext", new Class[0]).invoke(null, new Object[0]) == null) {
                Field field = clazz.getDeclaredField("threadGroup2appContext");
                field.setAccessible(true);
                Map map = (Map)field.get(null);
                ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
                map.put(threadGroup, this.mainThreadContext);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.mainThreadContext = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Context createNewContext(Canvas3D canvas3D, Drawable drawable, Context context, boolean bl, boolean bl2) {
        this.checkAppContext();
        GLDrawable gLDrawable = null;
        GLContext gLContext = null;
        if (bl2) {
            gLDrawable = this.drawable(canvas3D.drawable);
            gLContext = gLDrawable.createContext(this.context(context));
        } else {
            GraphicsConfigInfo graphicsConfigInfo = Canvas3D.graphicsConfigTable.get(canvas3D.graphicsConfiguration);
            AWTGraphicsConfiguration aWTGraphicsConfiguration = (AWTGraphicsConfiguration)graphicsConfigInfo.getPrivateData();
            JAWTWindow jAWTWindow = (JAWTWindow)NativeWindowFactory.getNativeWindow((Object)canvas3D, (AbstractGraphicsConfiguration)aWTGraphicsConfiguration);
            jAWTWindow.lockSurface();
            try {
                gLDrawable = GLDrawableFactory.getFactory((GLProfile)this.profile).createGLDrawable((NativeSurface)jAWTWindow);
                gLContext = gLDrawable.createContext(this.context(context));
            }
            finally {
                jAWTWindow.unlockSurface();
            }
            canvas3D.drawable = new JoglDrawable(gLDrawable, (NativeWindow)jAWTWindow);
        }
        gLDrawable.setRealized(true);
        boolean bl3 = false;
        int n = 0;
        int n2 = 5;
        do {
            bl3 = false;
            int n3 = gLContext.makeCurrent();
            if (n3 != 0) continue;
            bl3 = true;
            ++n;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (bl3 && n < n2);
        if (n == n2) {
            throw new IllegalRenderingStateException("Unable to make new context current after " + n + "tries");
        }
        GL2 gL2 = gLContext.getGL().getGL2();
        JoglContext joglContext = new JoglContext(gLContext);
        try {
            GLCapabilitiesImmutable gLCapabilitiesImmutable;
            if (!this.getPropertiesFromCurrentContext(joglContext, gL2)) {
                throw new IllegalRenderingStateException("Unable to fetch properties from current OpenGL context");
            }
            if (!bl) {
                this.setupCanvasProperties(canvas3D, joglContext, (GL)gL2);
            }
            gL2.glEnable(32826);
            gL2.glColorMaterial(1032, 4609);
            gL2.glDepthFunc(515);
            gL2.glEnable(2903);
            gL2.glPixelStorei(3317, 1);
            gL2.glLightModeli(33272, 33274);
            if (!bl2 && gLDrawable instanceof GLFBODrawable) {
                gLCapabilitiesImmutable = (GLFBODrawable)gLDrawable;
                gLCapabilitiesImmutable.getFBObject(1029).bind((GL)gL2);
            }
            if (bl2) {
                gLCapabilitiesImmutable = gLDrawable.getChosenGLCapabilities();
                if (gLDrawable instanceof GLFBODrawable) {
                    GLFBODrawable gLFBODrawable = (GLFBODrawable)gLDrawable;
                    gLFBODrawable.getFBObject(1029).bind((GL)gL2);
                } else if (gLCapabilitiesImmutable.getDoubleBuffered()) {
                    gL2.glReadBuffer(1029);
                } else {
                    gL2.glReadBuffer(1028);
                }
            }
        }
        finally {
            gLContext.release();
        }
        return joglContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void createQueryContext(Canvas3D canvas3D, Drawable drawable, boolean bl, int n, int n2) {
        if (bl) {
            Drawable drawable2 = this.createOffScreenBuffer(canvas3D, null, n, n2);
            GLDrawable gLDrawable = this.drawable(drawable2);
            gLDrawable.setRealized(true);
            GLContext gLContext = gLDrawable.createContext(null);
            gLContext.makeCurrent();
            JoglContext joglContext = new JoglContext(gLContext);
            GL2 gL2 = gLContext.getGL().getGL2();
            this.getPropertiesFromCurrentContext(joglContext, gL2);
            this.setupCanvasProperties(canvas3D, joglContext, (GL)gL2);
            gLContext.release();
            gLContext.destroy();
            gLDrawable.setRealized(false);
        } else {
            Frame frame = new Frame();
            frame.setUndecorated(true);
            frame.setLayout(new BorderLayout());
            ContextQuerier contextQuerier = new ContextQuerier(canvas3D);
            AWTGraphicsConfiguration aWTGraphicsConfiguration = (AWTGraphicsConfiguration)Canvas3D.graphicsConfigTable.get(canvas3D.graphicsConfiguration).getPrivateData();
            QueryCanvas queryCanvas = new QueryCanvas(aWTGraphicsConfiguration, contextQuerier);
            frame.add((Component)queryCanvas, "Center");
            frame.setSize(1, 1);
            frame.setVisible(true);
            queryCanvas.doQuery();
            if (!EventQueue.isDispatchThread()) {
                ContextQuerier contextQuerier2 = contextQuerier;
                synchronized (contextQuerier2) {
                    if (!contextQuerier.done()) {
                        try {
                            contextQuerier.wait(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }
            this.disposeOnEDT(frame);
        }
    }

    @Override
    Drawable createOffScreenBuffer(Canvas3D canvas3D, Context context, int n, int n2) {
        JoglGraphicsConfiguration joglGraphicsConfiguration = (JoglGraphicsConfiguration)canvas3D.graphicsConfiguration;
        GraphicsConfigInfo graphicsConfigInfo = Canvas3D.graphicsConfigTable.get(joglGraphicsConfiguration);
        AWTGraphicsConfiguration aWTGraphicsConfiguration = (AWTGraphicsConfiguration)graphicsConfigInfo.getPrivateData();
        AbstractGraphicsDevice abstractGraphicsDevice = GLDrawableFactory.getDesktopFactory().getDefaultDevice();
        GLCapabilities gLCapabilities = (GLCapabilities)aWTGraphicsConfiguration.getChosenCapabilities();
        GraphicsConfigTemplate3D graphicsConfigTemplate3D = graphicsConfigInfo.getGraphicsConfigTemplate3D();
        GLCapabilities gLCapabilities2 = new GLCapabilities(this.profile);
        gLCapabilities2.copyFrom((GLCapabilitiesImmutable)gLCapabilities);
        if (!gLCapabilities2.getSampleBuffers()) {
            gLCapabilities2.setDoubleBuffered(false);
            gLCapabilities2.setNumSamples(0);
        }
        gLCapabilities2.setStereo(false);
        gLCapabilities2.setFBO(true);
        GLDrawable gLDrawable = GLDrawableFactory.getFactory((GLProfile)this.profile).createOffscreenDrawable(abstractGraphicsDevice, (GLCapabilitiesImmutable)gLCapabilities2, null, n, n2);
        return new JoglDrawable(gLDrawable, null);
    }

    @Override
    void destroyOffScreenBuffer(Canvas3D canvas3D, Context context, Drawable drawable) {
    }

    @Override
    void readOffScreenBuffer(Canvas3D canvas3D, Context context, int n, int n2, Object object, int n3, int n4) {
        GLDrawable gLDrawable = ((JoglDrawable)canvas3D.drawable).getGLDrawable();
        GLCapabilitiesImmutable gLCapabilitiesImmutable = gLDrawable.getChosenGLCapabilities();
        GLFBODrawable gLFBODrawable = null;
        GL2 gL2 = this.context(context).getGL().getGL2();
        if (gLCapabilitiesImmutable.isFBO()) {
            gLFBODrawable = (GLFBODrawable)gLDrawable;
            if (gLCapabilitiesImmutable.getDoubleBuffered()) {
                gLFBODrawable.swapBuffers();
                gL2.glBindTexture(3553, 0);
            }
            gLFBODrawable.getFBObject(1028).bind((GL)gL2);
        }
        gL2.glPixelStorei(3330, n3);
        gL2.glPixelStorei(3333, 1);
        int n5 = 0;
        if (n2 == 4096 || n2 == 16384) {
            switch (n) {
                case 1: {
                    n5 = 32992;
                    break;
                }
                case 2: {
                    n5 = 6407;
                    break;
                }
                case 4: {
                    if (gL2.isExtensionAvailable("GL_EXT_abgr")) {
                        n5 = 32768;
                        break;
                    }
                    assert (false);
                    return;
                }
                case 8: {
                    n5 = 6408;
                    break;
                }
                default: {
                    throw new AssertionError((Object)("illegal format " + n));
                }
            }
            gL2.glReadPixels(0, 0, n3, n4, n5, 5121, (Buffer)ByteBuffer.wrap((byte[])object));
        } else if (n2 == 8192 || n2 == 32768) {
            int n6 = 32821;
            boolean bl = false;
            switch (n) {
                case 128: {
                    n5 = 6408;
                    n6 = 33639;
                    bl = true;
                    break;
                }
                case 256: {
                    bl = true;
                }
                case 512: {
                    n5 = 32993;
                    n6 = 33639;
                    break;
                }
                default: {
                    throw new AssertionError((Object)("illegal format " + n));
                }
            }
            if (bl) {
                gL2.glPixelTransferf(3356, 0.0f);
                gL2.glPixelTransferf(3357, 1.0f);
            }
            gL2.glReadPixels(0, 0, n3, n4, n5, n6, (Buffer)IntBuffer.wrap((int[])object));
            if (bl) {
                gL2.glPixelTransferf(3356, 1.0f);
                gL2.glPixelTransferf(3357, 0.0f);
            }
        } else {
            throw new AssertionError((Object)("illegal image data type " + n2));
        }
        if (gLCapabilitiesImmutable.isFBO()) {
            gLFBODrawable.getFBObject(1029).bind((GL)gL2);
        }
    }

    @Override
    void swapBuffers(Canvas3D canvas3D, Context context, Drawable drawable) {
        GLDrawable gLDrawable = this.drawable(drawable);
        gLDrawable.swapBuffers();
    }

    @Override
    void updateMaterialColor(Context context, float f, float f2, float f3, float f4) {
        GL2 gL2 = this.context(context).getGL().getGL2();
        gL2.glColor4f(f, f2, f3, f4);
        gL2.glDisable(2896);
    }

    @Override
    void destroyContext(Drawable drawable, Context context) {
        JoglDrawable joglDrawable = (JoglDrawable)drawable;
        GLContext gLContext = this.context(context);
        if (GLContext.getCurrent() == gLContext) {
            gLContext.release();
        }
        gLContext.destroy();
        joglDrawable.getGLDrawable().setRealized(false);
        joglDrawable.destroyNativeWindow();
    }

    @Override
    void accum(Context context, float f) {
        GL2 gL2 = this.context(context).getGL().getGL2();
        gL2.glReadBuffer(1029);
        gL2.glAccum(256, f);
        gL2.glReadBuffer(1028);
    }

    @Override
    void accumReturn(Context context) {
        GL2 gL2 = this.context(context).getGL().getGL2();
        gL2.glAccum(258, 1.0f);
    }

    @Override
    void clearAccum(Context context) {
        GL gL = this.context(context).getGL();
        gL.glClear(512);
    }

    @Override
    int getNumCtxLights(Context context) {
        GL gL = this.context(context).getGL();
        int[] nArray = new int[1];
        gL.glGetIntegerv(3377, nArray, 0);
        return nArray[0];
    }

    @Override
    boolean decal1stChildSetup(Context context) {
        GL gL = this.context(context).getGL();
        gL.glEnable(2960);
        gL.glClearStencil(0);
        gL.glClear(1024);
        gL.glStencilFunc(519, 1, 1);
        gL.glStencilOp(7680, 7680, 7681);
        return gL.glIsEnabled(2929);
    }

    @Override
    void decalNthChildSetup(Context context) {
        GL gL = this.context(context).getGL();
        gL.glDisable(2929);
        gL.glStencilFunc(514, 1, 1);
        gL.glStencilOp(7680, 7680, 7680);
    }

    @Override
    void decalReset(Context context, boolean bl) {
        GL gL = this.context(context).getGL();
        gL.glDisable(2960);
        if (bl) {
            gL.glEnable(2929);
        }
    }

    @Override
    void ctxUpdateEyeLightingEnable(Context context, boolean bl) {
        GL2 gL2 = this.context(context).getGL().getGL2();
        if (bl) {
            gL2.glLightModeli(2897, 1);
        } else {
            gL2.glLightModeli(2897, 0);
        }
    }

    @Override
    void setBlendColor(Context context, float f, float f2, float f3, float f4) {
        GL2 gL2 = this.context(context).getGL().getGL2();
        if (gL2.isExtensionAvailable("GL_ARB_imaging")) {
            gL2.glBlendColor(f, f2, f3, f4);
        }
    }

    @Override
    void setBlendFunc(Context context, int n, int n2) {
        GL gL = this.context(context).getGL();
        gL.glEnable(3042);
        gL.glBlendFunc(blendFunctionTable[n], blendFunctionTable[n2]);
    }

    @Override
    void setFogEnableFlag(Context context, boolean bl) {
        GL gL = this.context(context).getGL();
        if (bl) {
            gL.glEnable(2912);
        } else {
            gL.glDisable(2912);
        }
    }

    @Override
    void setFullSceneAntialiasing(Context context, boolean bl) {
        JoglContext joglContext = (JoglContext)context;
        GL gL = this.context(joglContext).getGL();
        if (joglContext.getHasMultisample() && !VirtualUniverse.mc.implicitAntialiasing) {
            if (bl) {
                gL.glEnable(32925);
            } else {
                gL.glDisable(32925);
            }
        }
    }

    @Override
    void updateSeparateSpecularColorEnable(Context context, boolean bl) {
        GL2 gL2 = this.context(context).getGL().getGL2();
        if (bl) {
            gL2.glLightModeli(33272, 33274);
        } else {
            gL2.glLightModeli(33272, 33273);
        }
    }

    @Override
    boolean validGraphicsMode() {
        DisplayMode displayMode = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDisplayMode();
        return displayMode.getBitDepth() < 0 || displayMode.getBitDepth() > 8;
    }

    @Override
    void setLightEnables(Context context, long l, int n) {
        GL gL = this.context(context).getGL();
        for (int i = 0; i < n; ++i) {
            if ((l & (long)(1 << i)) != 0L) {
                gL.glEnable(16384 + i);
                continue;
            }
            gL.glDisable(16384 + i);
        }
    }

    @Override
    void setSceneAmbient(Context context, float f, float f2, float f3) {
        GL2 gL2 = this.context(context).getGL().getGL2();
        float[] fArray = new float[]{f, f2, f3, 1.0f};
        gL2.glLightModelfv(2899, fArray, 0);
    }

    @Override
    void disableFog(Context context) {
        GL gL = this.context(context).getGL();
        gL.glDisable(2912);
    }

    @Override
    void disableModelClip(Context context) {
        GL gL = this.context(context).getGL();
        gL.glDisable(12288);
        gL.glDisable(12289);
        gL.glDisable(12290);
        gL.glDisable(12291);
        gL.glDisable(12292);
        gL.glDisable(12293);
    }

    @Override
    void resetRenderingAttributes(Context context, boolean bl, boolean bl2) {
        GL2 gL2 = this.context(context).getGL().getGL2();
        if (!bl) {
            gL2.glDepthMask(true);
        }
        if (!bl2) {
            gL2.glEnable(2929);
        }
        gL2.glAlphaFunc(519, 0.0f);
        gL2.glDepthFunc(515);
        gL2.glEnable(2903);
        gL2.glDisable(3058);
    }

    @Override
    void resetTextureNative(Context context, int n) {
        GL2 gL2 = this.context(context).getGL().getGL2();
        if (n >= 0 && gL2.isExtensionAvailable("GL_VERSION_1_3")) {
            gL2.glActiveTexture(n + 33984);
            gL2.glClientActiveTexture(n + 33984);
        }
        gL2.glDisable(3552);
        gL2.glDisable(3553);
        gL2.glDisable(32879);
        gL2.glDisable(34067);
    }

    @Override
    void activeTextureUnit(Context context, int n) {
        GL2 gL2 = this.context(context).getGL().getGL2();
        if (gL2.isExtensionAvailable("GL_VERSION_1_3")) {
            gL2.glActiveTexture(n + 33984);
            gL2.glClientActiveTexture(n + 33984);
        }
    }

    @Override
    void resetTexCoordGeneration(Context context) {
        GL gL = this.context(context).getGL();
        gL.glDisable(3168);
        gL.glDisable(3169);
        gL.glDisable(3170);
        gL.glDisable(3171);
    }

    @Override
    void resetTextureAttributes(Context context) {
        GL2 gL2 = this.context(context).getGL().getGL2();
        float[] fArray = new float[4];
        gL2.glPushAttrib(4096);
        gL2.glMatrixMode(5890);
        gL2.glLoadIdentity();
        gL2.glPopAttrib();
        gL2.glTexEnvfv(8960, 8705, fArray, 0);
        gL2.glTexEnvi(8960, 8704, 7681);
        gL2.glHint(3152, 4354);
    }

    @Override
    void resetPolygonAttributes(Context context) {
        GL2 gL2 = this.context(context).getGL().getGL2();
        gL2.glCullFace(1029);
        gL2.glEnable(2884);
        gL2.glLightModeli(2898, 0);
        gL2.glPolygonMode(1032, 6914);
        gL2.glPolygonOffset(0.0f, 0.0f);
        gL2.glDisable(10753);
        gL2.glDisable(10754);
        gL2.glDisable(32823);
    }

    @Override
    void resetLineAttributes(Context context) {
        GL gL = this.context(context).getGL();
        gL.glLineWidth(1.0f);
        gL.glDisable(2852);
        gL.glDisable(2848);
    }

    @Override
    void resetPointAttributes(Context context) {
        GL2 gL2 = this.context(context).getGL().getGL2();
        gL2.glPointSize(1.0f);
        gL2.glDisable(2832);
    }

    @Override
    void resetTransparency(Context context, int n, int n2, boolean bl, boolean bl2) {
        GL gL = this.context(context).getGL();
        if (((n & 2) != 0 || n2 == 1) && bl || ((n & 1) != 0 || n2 == 0) && bl2) {
            gL.glEnable(3042);
            gL.glBlendFunc(770, 771);
        } else {
            gL.glDisable(3042);
        }
        gL.glDisable(2882);
    }

    @Override
    void resetColoringAttributes(Context context, float f, float f2, float f3, float f4, boolean bl) {
        GL2 gL2 = this.context(context).getGL().getGL2();
        if (!bl) {
            gL2.glColor4f(f, f2, f3, f4);
        }
        gL2.glShadeModel(7425);
    }

    @Override
    void syncRender(Context context, boolean bl) {
        GL gL = this.context(context).getGL();
        if (bl) {
            gL.glFinish();
        } else {
            gL.glFlush();
        }
    }

    @Override
    boolean useCtx(Context context, Drawable drawable) {
        GLContext gLContext = this.context(context);
        int n = gLContext.makeCurrent();
        return n != 0;
    }

    @Override
    boolean releaseCtx(Context context) {
        GLContext gLContext = this.context(context);
        gLContext.release();
        return true;
    }

    @Override
    void clear(Context context, float f, float f2, float f3, boolean bl) {
        JoglContext joglContext = (JoglContext)context;
        GLContext gLContext = this.context(context);
        GL2 gL2 = gLContext.getGL().getGL2();
        int n = 16640;
        if (bl) {
            gL2.glPushAttrib(1280);
            gL2.glClearStencil(0);
            gL2.glStencilMask(-1);
            n |= 0x400;
        } else {
            gL2.glPushAttrib(256);
        }
        gL2.glDepthMask(true);
        gL2.glClearColor(f, f2, f3, joglContext.getAlphaClearValue());
        gL2.glClear(n);
        gL2.glPopAttrib();
    }

    @Override
    void textureFillBackground(Context context, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, boolean bl) {
        GLContext gLContext = this.context(context);
        GL2 gL2 = gLContext.getGL().getGL2();
        gL2.glPushAttrib(270344);
        this.disableAttribFor2D((GL)gL2);
        gL2.glDepthMask(false);
        gL2.glEnable(3553);
        if (bl) {
            gL2.glTexParameteri(3553, 10241, 9729);
            gL2.glTexParameteri(3553, 10240, 9729);
        }
        gL2.glPolygonMode(1032, 6914);
        gL2.glPixelStorei(3317, 1);
        gL2.glMatrixMode(5889);
        gL2.glLoadIdentity();
        gL2.glOrtho(-1.0, 1.0, -1.0, 1.0, -1.0, 1.0);
        gL2.glMatrixMode(5888);
        gL2.glLoadIdentity();
        gL2.glMatrixMode(5890);
        gL2.glPushMatrix();
        gL2.glLoadIdentity();
        gL2.glBegin(7);
        gL2.glTexCoord2f(f, f3);
        gL2.glVertex2f(f5, f7);
        gL2.glTexCoord2f(f2, f3);
        gL2.glVertex2f(f6, f7);
        gL2.glTexCoord2f(f2, f4);
        gL2.glVertex2f(f6, f8);
        gL2.glTexCoord2f(f, f4);
        gL2.glVertex2f(f5, f8);
        gL2.glEnd();
        gL2.glPopMatrix();
        gL2.glMatrixMode(5888);
        gL2.glPopAttrib();
    }

    @Override
    void textureFillRaster(Context context, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, boolean bl) {
        GLContext gLContext = this.context(context);
        GL2 gL2 = gLContext.getGL().getGL2();
        gL2.glPushAttrib(270345);
        this.disableAttribForRaster((GL)gL2);
        if (bl) {
            gL2.glTexParameteri(3553, 10241, 9729);
            gL2.glTexParameteri(3553, 10240, 9729);
        }
        gL2.glTexEnvi(8960, 8704, 8448);
        gL2.glColor4f(1.0f, 1.0f, 1.0f, f10);
        gL2.glPolygonMode(1032, 6914);
        gL2.glPixelStorei(3317, 1);
        gL2.glMatrixMode(5888);
        gL2.glPushMatrix();
        gL2.glLoadIdentity();
        gL2.glMatrixMode(5889);
        gL2.glPushMatrix();
        gL2.glLoadIdentity();
        gL2.glOrtho(0.0, 1.0, 0.0, 1.0, 0.0, 1.0);
        gL2.glBegin(7);
        gL2.glTexCoord2f(f, f3);
        gL2.glVertex3f(f5, f7, f9);
        gL2.glTexCoord2f(f2, f3);
        gL2.glVertex3f(f6, f7, f9);
        gL2.glTexCoord2f(f2, f4);
        gL2.glVertex3f(f6, f8, f9);
        gL2.glTexCoord2f(f, f4);
        gL2.glVertex3f(f5, f8, f9);
        gL2.glEnd();
        gL2.glPopMatrix();
        gL2.glMatrixMode(5888);
        gL2.glPopMatrix();
        gL2.glPopAttrib();
    }

    @Override
    void executeRasterDepth(Context context, float f, float f2, float f3, int n, int n2, int n3, int n4, int n5, int n6, int n7, Object object) {
        GLContext gLContext = this.context(context);
        GL2 gL2 = gLContext.getGL().getGL2();
        gL2.glRasterPos3f(f, f2, f3);
        int[] nArray = new int[1];
        gL2.glGetIntegerv(3073, nArray, 0);
        gL2.glDrawBuffer(0);
        gL2.glPixelZoom(1.0f, -1.0f);
        gL2.glPixelStorei(3314, n5);
        if (n >= 0) {
            gL2.glPixelStorei(3316, n);
            if (n + n3 > n5) {
                n3 = n5 - n;
            }
        } else if ((n3 += n) > n5) {
            n3 = n5;
        }
        if (n2 >= 0) {
            gL2.glPixelStorei(3315, n2);
            if (n2 + n4 > n6) {
                n4 = n6 - n2;
            }
        } else if ((n4 += n2) > n6) {
            n4 = n6;
        }
        if (n7 == 1) {
            gL2.glDrawPixels(n3, n4, 6402, 5125, (Buffer)IntBuffer.wrap((int[])object));
        } else {
            gL2.glDrawPixels(n3, n4, 6402, 5126, (Buffer)FloatBuffer.wrap((float[])object));
        }
        gL2.glDrawBuffer(nArray[0]);
        gL2.glPixelStorei(3314, 0);
        gL2.glPixelStorei(3316, 0);
        gL2.glPixelStorei(3315, 0);
    }

    @Override
    void setModelViewMatrix(Context context, double[] dArray, double[] dArray2) {
        GLContext gLContext = this.context(context);
        GL2 gL2 = gLContext.getGL().getGL2();
        gL2.glMatrixMode(5888);
        if (gL2.isExtensionAvailable("GL_VERSION_1_3")) {
            gL2.glLoadTransposeMatrixd(dArray, 0);
            gL2.glMultTransposeMatrixd(dArray2, 0);
        } else {
            double[] dArray3 = new double[16];
            double[] dArray4 = new double[16];
            this.copyTranspose(dArray, dArray3);
            this.copyTranspose(dArray2, dArray4);
            gL2.glLoadMatrixd(dArray3, 0);
            gL2.glMultMatrixd(dArray4, 0);
        }
    }

    @Override
    void setProjectionMatrix(Context context, double[] dArray) {
        GLContext gLContext = this.context(context);
        GL2 gL2 = gLContext.getGL().getGL2();
        gL2.glMatrixMode(5889);
        if (gL2.isExtensionAvailable("GL_VERSION_1_3")) {
            dArray[8] = dArray[8] * -1.0;
            dArray[9] = dArray[9] * -1.0;
            dArray[10] = dArray[10] * -1.0;
            dArray[11] = dArray[11] * -1.0;
            gL2.glLoadTransposeMatrixd(dArray, 0);
            dArray[8] = dArray[8] * -1.0;
            dArray[9] = dArray[9] * -1.0;
            dArray[10] = dArray[10] * -1.0;
            dArray[11] = dArray[11] * -1.0;
        } else {
            double[] dArray2 = new double[16];
            this.copyTranspose(dArray, dArray2);
            dArray2[2] = dArray2[2] * -1.0;
            dArray2[6] = dArray2[6] * -1.0;
            dArray2[10] = dArray2[10] * -1.0;
            dArray2[14] = dArray2[14] * -1.0;
            gL2.glLoadMatrixd(dArray2, 0);
        }
    }

    static boolean isOffscreenLayerSurfaceEnabled(Canvas3D canvas3D) {
        if (canvas3D.drawable == null || canvas3D.offScreen) {
            return false;
        }
        JoglDrawable joglDrawable = (JoglDrawable)canvas3D.drawable;
        JAWTWindow jAWTWindow = (JAWTWindow)joglDrawable.getNativeWindow();
        if (jAWTWindow == null) {
            return false;
        }
        return jAWTWindow.isOffscreenLayerSurfaceEnabled();
    }

    static boolean hasFBObjectSizeChanged(JoglDrawable joglDrawable, int n, int n2) {
        if (!(joglDrawable.getGLDrawable() instanceof GLFBODrawable)) {
            return false;
        }
        FBObject fBObject = ((GLFBODrawable)joglDrawable.getGLDrawable()).getFBObject(1029);
        if (fBObject == null) {
            return false;
        }
        return n != fBObject.getWidth() || n2 != fBObject.getHeight();
    }

    @Override
    void setViewport(Context context, int n, int n2, int n3, int n4) {
        GL gL = this.context(context).getGL();
        gL.glViewport(n, n2, n3, n4);
    }

    @Override
    void newDisplayList(Context context, int n) {
        if (n <= 0) {
            System.err.println("JAVA 3D ERROR : glNewList(" + n + ") -- IGNORED");
        }
        GL2 gL2 = this.context(context).getGL().getGL2();
        gL2.glNewList(n, 4864);
    }

    @Override
    void endDisplayList(Context context) {
        GL2 gL2 = this.context(context).getGL().getGL2();
        gL2.glEndList();
    }

    @Override
    void callDisplayList(Context context, int n, boolean bl) {
        if (n <= 0) {
            if (this.numInvalidLists < 3) {
                ++this.numInvalidLists;
                System.err.println("JAVA 3D ERROR : glCallList(" + n + ") -- IGNORED");
            } else if (this.numInvalidLists == 3) {
                ++this.numInvalidLists;
                System.err.println("JAVA 3D : further glCallList error messages discarded");
            }
            return;
        }
        GL2 gL2 = this.context(context).getGL().getGL2();
        if (bl) {
            gL2.glEnable(2977);
        }
        gL2.glCallList(n);
        if (bl) {
            gL2.glDisable(2977);
        }
    }

    @Override
    void freeDisplayList(Context context, int n) {
        if (n <= 0) {
            System.err.println("JAVA 3D ERROR : glDeleteLists(" + n + ",1) -- IGNORED");
        }
        GL2 gL2 = this.context(context).getGL().getGL2();
        gL2.glDeleteLists(n, 1);
    }

    @Override
    void freeTexture(Context context, int n) {
        GL gL = this.context(context).getGL();
        if (n > 0) {
            int[] nArray = new int[]{n};
            gL.glDeleteTextures(1, nArray, 0);
        } else {
            System.err.println("tried to delete tex with texid <= 0");
        }
    }

    @Override
    int generateTexID(Context context) {
        GL gL = this.context(context).getGL();
        int[] nArray = new int[]{-1};
        gL.glGenTextures(1, nArray, 0);
        if (nArray[0] < 1) {
            return -1;
        }
        return nArray[0];
    }

    @Override
    void texturemapping(Context context, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, byte[] byArray, int n12, int n13) {
        GL2 gL2 = this.context(context).getGL().getGL2();
        int n14 = 6408;
        gL2.glPushAttrib(270600);
        this.disableAttribFor2D((GL)gL2);
        gL2.glPolygonMode(1032, 6914);
        gL2.glDepthMask(false);
        gL2.glPixelStorei(3317, 1);
        gL2.glBindTexture(3553, n11);
        gL2.glTexParameteri(3553, 10240, 9728);
        gL2.glTexParameteri(3553, 10241, 9728);
        gL2.glTexParameteri(3553, 10242, 10497);
        gL2.glTexParameteri(3553, 10243, 10497);
        gL2.glTexEnvf(8960, 8704, 7681.0f);
        gL2.glEnable(3042);
        gL2.glBlendFunc(770, 771);
        gL2.glEnable(3553);
        gL2.glMatrixMode(5889);
        gL2.glLoadIdentity();
        gL2.glOrtho(0.0, (double)n12, 0.0, (double)n13, 0.0, 0.0);
        gL2.glMatrixMode(5888);
        gL2.glLoadIdentity();
        if (gL2.isExtensionAvailable("GL_EXT_abgr")) {
            n14 = 32768;
        } else {
            switch (n10) {
                case 8: {
                    n14 = 6408;
                    break;
                }
                case 2: {
                    n14 = 6407;
                }
            }
        }
        gL2.glPixelStorei(3314, n9);
        gL2.glPixelStorei(3316, n3);
        gL2.glPixelStorei(3315, n4);
        gL2.glTexSubImage2D(3553, 0, n3, n4, n5 - n3, n6 - n4, n14, 5121, (Buffer)ByteBuffer.wrap(byArray));
        gL2.glPixelStorei(3314, 0);
        gL2.glPixelStorei(3316, 0);
        gL2.glPixelStorei(3315, 0);
        float f = (float)n3 / (float)n7;
        float f2 = (float)n4 / (float)n8;
        float f3 = (float)n5 / (float)n7;
        float f4 = (float)n6 / (float)n8;
        float f5 = (float)n12 / 2.0f;
        float f6 = (float)n13 / 2.0f;
        float f7 = ((float)(n + n3) - f5) / f5;
        float f8 = (f6 - (float)(n2 + n6)) / f6;
        float f9 = ((float)(n + n5) - f5) / f5;
        float f10 = (f6 - (float)(n2 + n4)) / f6;
        gL2.glBegin(7);
        gL2.glTexCoord2f(f, f4);
        gL2.glVertex2f(f7, f8);
        gL2.glTexCoord2f(f3, f4);
        gL2.glVertex2f(f9, f8);
        gL2.glTexCoord2f(f3, f2);
        gL2.glVertex2f(f9, f10);
        gL2.glTexCoord2f(f, f2);
        gL2.glVertex2f(f7, f10);
        gL2.glEnd();
        gL2.glDepthMask(true);
        gL2.glClear(256);
        gL2.glPopAttrib();
    }

    @Override
    boolean initTexturemapping(Context context, int n, int n2, int n3) {
        GL2 gL2 = this.context(context).getGL().getGL2();
        int n4 = gL2.isExtensionAvailable("GL_EXT_abgr") ? 32768 : 6408;
        gL2.glBindTexture(3553, n3);
        gL2.glTexImage2D(32868, 0, 6408, n, n2, 0, n4, 5121, null);
        int[] nArray = new int[1];
        gL2.glGetTexLevelParameteriv(32868, 0, 4096, nArray, 0);
        if (nArray[0] <= 0) {
            return false;
        }
        gL2.glTexImage2D(3553, 0, 6408, n, n2, 0, n4, 5121, null);
        return true;
    }

    @Override
    void setRenderMode(Context context, int n, boolean bl) {
        GL2 gL2 = this.context(context).getGL().getGL2();
        int n2 = 0;
        if (bl) {
            n2 = 1029;
            switch (n) {
                case 0: {
                    n2 = 1026;
                    break;
                }
                case 1: {
                    n2 = 1027;
                    break;
                }
                case 2: {
                    n2 = 1029;
                }
            }
        } else {
            n2 = 1028;
            switch (n) {
                case 0: {
                    n2 = 1024;
                    break;
                }
                case 1: {
                    n2 = 1025;
                    break;
                }
                case 2: {
                    n2 = 1028;
                }
            }
        }
        gL2.glDrawBuffer(n2);
    }

    @Override
    void setDepthBufferWriteEnable(Context context, boolean bl) {
        GL gL = this.context(context).getGL();
        if (bl) {
            gL.glDepthMask(true);
        } else {
            gL.glDepthMask(false);
        }
    }

    private boolean getPropertiesFromCurrentContext(JoglContext joglContext, GL2 gL2) {
        int[] nArray = new int[1];
        gL2.glGetIntegerv(34018, nArray, 0);
        joglContext.setMaxTexCoordSets(nArray[0]);
        if (VirtualUniverse.mc.transparentOffScreen) {
            joglContext.setAlphaClearValue(0.0f);
        } else {
            joglContext.setAlphaClearValue(1.0f);
        }
        if (gL2.isExtensionAvailable("GL_ARB_vertex_shader")) {
            gL2.glGetIntegerv(34929, nArray, 0);
            joglContext.setMaxTexCoordSets(nArray[0]);
        }
        return true;
    }

    private int[] extractVersionInfo(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ". ");
        int n = Integer.valueOf(stringTokenizer.nextToken());
        int n2 = Integer.valueOf(stringTokenizer.nextToken());
        stringTokenizer = new StringTokenizer(string, " ");
        if (stringTokenizer.hasMoreTokens()) {
            Pattern pattern;
            Matcher matcher;
            stringTokenizer.nextToken();
            if (stringTokenizer.hasMoreTokens() && (matcher = (pattern = Pattern.compile("\\D*(\\d+)\\.(\\d+)\\.?(\\d*).*")).matcher(stringTokenizer.nextToken())).matches()) {
                int n3 = Integer.valueOf(matcher.group(1));
                int n4 = Integer.valueOf(matcher.group(2));
                if (n3 == n && n4 > n2) {
                    n2 = n4;
                }
            }
        }
        return new int[]{n, n2};
    }

    private void checkTextureExtensions(Canvas3D canvas3D, JoglContext joglContext, GL gL, boolean bl) {
        Object[] objectArray;
        if (bl) {
            canvas3D.textureExtendedFeatures |= 4;
            canvas3D.multiTexAccelerated = true;
            objectArray = new int[1];
            gL.glGetIntegerv(34018, objectArray, 0);
            canvas3D.maxTexCoordSets = canvas3D.maxTextureUnits = objectArray[0];
            if (gL.isExtensionAvailable("GL_ARB_vertex_shader")) {
                gL.glGetIntegerv(34929, objectArray, 0);
                canvas3D.maxTexCoordSets = objectArray[0];
            }
        }
        if (gL.isExtensionAvailable("GL_ARB_texture_env_combine")) {
            canvas3D.textureExtendedFeatures |= 8;
            canvas3D.textureExtendedFeatures |= 0x20;
        } else if (gL.isExtensionAvailable("GL_EXT_texture_env_combine")) {
            canvas3D.textureExtendedFeatures |= 8;
        }
        if (gL.isExtensionAvailable("GL_ARB_texture_env_dot3") || gL.isExtensionAvailable("GL_EXT_texture_env_dot3")) {
            canvas3D.textureExtendedFeatures |= 0x10;
        }
        if (bl) {
            canvas3D.textureExtendedFeatures |= 0x80;
        }
        if (gL.isExtensionAvailable("GL_EXT_texture_filter_anisotropic")) {
            canvas3D.textureExtendedFeatures |= 0x800;
            objectArray = new float[1];
            gL.glGetFloatv(34047, (float[])objectArray, 0);
            canvas3D.anisotropicDegreeMax = objectArray[0];
        }
        if (!VirtualUniverse.mc.enforcePowerOfTwo && gL.isExtensionAvailable("GL_ARB_texture_non_power_of_two")) {
            canvas3D.textureExtendedFeatures |= 0x8000;
        }
        if (gL.isExtensionAvailable("GL_SGIS_generate_mipmap")) {
            canvas3D.textureExtendedFeatures |= 0x10000;
        }
    }

    private void checkGLSLShaderExtensions(Canvas3D canvas3D, JoglContext joglContext, GL gL, boolean bl) {
        if (!bl) {
            return;
        }
        if (gL.isExtensionAvailable("GL_ARB_shader_objects") && gL.isExtensionAvailable("GL_ARB_shading_language_100")) {
            int[] nArray = new int[1];
            gL.glGetIntegerv(34930, nArray, 0);
            canvas3D.maxTextureImageUnits = nArray[0];
            gL.glGetIntegerv(35660, nArray, 0);
            canvas3D.maxVertexTextureImageUnits = nArray[0];
            gL.glGetIntegerv(35661, nArray, 0);
            canvas3D.maxCombinedTextureImageUnits = nArray[0];
            int n = VirtualUniverse.mc.glslVertexAttrOffset;
            joglContext.setGLSLVertexAttrOffset(n);
            gL.glGetIntegerv(34921, nArray, 0);
            canvas3D.maxVertexAttrs = nArray[0];
            canvas3D.maxVertexAttrs -= n;
            if (canvas3D.maxVertexAttrs < 0) {
                canvas3D.maxVertexAttrs = 0;
            }
            canvas3D.shadingLanguageGLSL = true;
        }
    }

    private void setupCanvasProperties(Canvas3D canvas3D, JoglContext joglContext, GL gL) {
        canvas3D.multiTexAccelerated = false;
        canvas3D.maxTextureUnits = 1;
        canvas3D.maxTexCoordSets = 1;
        canvas3D.maxTextureImageUnits = 0;
        canvas3D.maxVertexTextureImageUnits = 0;
        canvas3D.maxCombinedTextureImageUnits = 0;
        canvas3D.maxVertexAttrs = 0;
        canvas3D.extensionsSupported = 0;
        canvas3D.textureExtendedFeatures = 0;
        canvas3D.textureColorTableSize = 0;
        canvas3D.anisotropicDegreeMax = 0.0f;
        canvas3D.textureBoundaryWidthMax = 0;
        canvas3D.textureWidthMax = 0;
        canvas3D.textureHeightMax = 0;
        canvas3D.texture3DWidthMax = 0;
        canvas3D.texture3DHeightMax = 0;
        canvas3D.texture3DDepthMax = 0;
        canvas3D.shadingLanguageGLSL = false;
        String string = gL.glGetString(7938);
        String string2 = gL.glGetString(7936);
        String string3 = gL.glGetString(7937);
        canvas3D.nativeGraphicsVersion = string;
        canvas3D.nativeGraphicsVendor = string2;
        canvas3D.nativeGraphicsRenderer = string3;
        int[] nArray = this.extractVersionInfo(string);
        int n = nArray[0];
        int n2 = nArray[1];
        if (n < 1 || n == 1 && n2 < 2) {
            throw new IllegalRenderingStateException("Java 3D ERROR : OpenGL 1.2 or better is required (GL_VERSION=" + n + "." + n2 + ")");
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (n == 1) {
            if (n2 == 2) {
                System.err.println("JAVA 3D: OpenGL 1.2 detected; will run with reduced functionality");
            }
            if (n2 >= 3) {
                bl3 = true;
            }
            if (n2 >= 4) {
                bl2 = true;
            }
        } else {
            bl3 = true;
            bl2 = true;
            bl = true;
        }
        if (bl) {
            assert (bl3);
            assert (bl2);
            assert (gL.isExtensionAvailable("GL_VERSION_2_0"));
        }
        if (bl2) {
            assert (bl3);
            assert (gL.isExtensionAvailable("GL_VERSION_1_4"));
        }
        if (bl3) assert (gL.isExtensionAvailable("GL_VERSION_1_3"));
        canvas3D.textureExtendedFeatures |= 1;
        canvas3D.textureExtendedFeatures |= 0x1000;
        if (bl2) {
            canvas3D.textureExtendedFeatures |= 0x10000;
        }
        if (gL.isExtensionAvailable("GL_EXT_abgr")) {
            canvas3D.extensionsSupported |= 2;
        }
        canvas3D.extensionsSupported |= 4;
        if (bl3) {
            canvas3D.extensionsSupported |= 8;
            joglContext.setHasMultisample(true);
        }
        if ((canvas3D.extensionsSupported & 8) != 0 && !VirtualUniverse.mc.implicitAntialiasing) {
            gL.glDisable(32925);
        }
        this.checkTextureExtensions(canvas3D, joglContext, gL, bl3);
        this.checkGLSLShaderExtensions(canvas3D, joglContext, gL, bl3);
        canvas3D.textureBoundaryWidthMax = 1;
        int[] nArray2 = new int[1];
        gL.glGetIntegerv(3379, nArray2, 0);
        canvas3D.textureWidthMax = nArray2[0];
        canvas3D.textureHeightMax = nArray2[0];
        nArray2[0] = -1;
        gL.glGetIntegerv(32883, nArray2, 0);
        canvas3D.texture3DWidthMax = nArray2[0];
        canvas3D.texture3DHeightMax = nArray2[0];
        canvas3D.texture3DDepthMax = nArray2[0];
    }

    private void disableAttribFor2D(GL gL) {
        gL.glDisable(3008);
        gL.glDisable(3042);
        gL.glDisable(3058);
        gL.glDisable(2903);
        gL.glDisable(2884);
        gL.glDisable(2929);
        gL.glDisable(2912);
        gL.glDisable(2896);
        gL.glDisable(32823);
        gL.glDisable(2882);
        gL.glDisable(2960);
        gL.glDisable(3553);
        gL.glDisable(3171);
        gL.glDisable(3170);
        gL.glDisable(3168);
        gL.glDisable(3169);
        for (int i = 0; i < 6; ++i) {
            gL.glDisable(12288 + i);
        }
        gL.glDisable(32879);
        gL.glDisable(34067);
    }

    private void disableAttribForRaster(GL gL) {
        gL.glDisable(2903);
        gL.glDisable(2884);
        gL.glDisable(2896);
        gL.glDisable(32823);
        gL.glDisable(2882);
    }

    private void copyTranspose(double[] dArray, double[] dArray2) {
        dArray2[0] = dArray[0];
        dArray2[1] = dArray[4];
        dArray2[2] = dArray[8];
        dArray2[3] = dArray[12];
        dArray2[4] = dArray[1];
        dArray2[5] = dArray[5];
        dArray2[6] = dArray[9];
        dArray2[7] = dArray[13];
        dArray2[8] = dArray[2];
        dArray2[9] = dArray[6];
        dArray2[10] = dArray[10];
        dArray2[11] = dArray[14];
        dArray2[12] = dArray[3];
        dArray2[13] = dArray[7];
        dArray2[14] = dArray[11];
        dArray2[15] = dArray[15];
    }

    @Override
    GraphicsConfiguration getGraphicsConfig(GraphicsConfiguration graphicsConfiguration) {
        GraphicsConfigInfo graphicsConfigInfo = Canvas3D.graphicsConfigTable.get(graphicsConfiguration);
        AWTGraphicsConfiguration aWTGraphicsConfiguration = (AWTGraphicsConfiguration)graphicsConfigInfo.getPrivateData();
        return aWTGraphicsConfiguration.getAWTGraphicsConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    GraphicsConfiguration getBestConfiguration(GraphicsConfigTemplate3D graphicsConfigTemplate3D, GraphicsConfiguration[] graphicsConfigurationArray) {
        Object object;
        Object object2;
        GraphicsDevice graphicsDevice;
        GLCapabilities gLCapabilities = new GLCapabilities(this.profile);
        gLCapabilities.setDoubleBuffered(graphicsConfigTemplate3D.getDoubleBuffer() != 3);
        gLCapabilities.setStereo(graphicsConfigTemplate3D.getStereo() != 3);
        if (graphicsConfigTemplate3D.getSceneAntialiasing() != 3 && graphicsConfigTemplate3D.getDoubleBuffer() != 3) {
            gLCapabilities.setSampleBuffers(true);
            gLCapabilities.setNumSamples(2);
        } else {
            gLCapabilities.setSampleBuffers(false);
            gLCapabilities.setNumSamples(0);
        }
        gLCapabilities.setDepthBits(graphicsConfigTemplate3D.getDepthSize());
        gLCapabilities.setStencilBits(graphicsConfigTemplate3D.getStencilSize());
        gLCapabilities.setRedBits(Math.max(5, graphicsConfigTemplate3D.getRedSize()));
        gLCapabilities.setGreenBits(Math.max(5, graphicsConfigTemplate3D.getGreenSize()));
        gLCapabilities.setBlueBits(Math.max(5, graphicsConfigTemplate3D.getBlueSize()));
        if (VirtualUniverse.mc.transparentOffScreen) {
            gLCapabilities.setAlphaBits(1);
        }
        ArrayList<DisabledCaps> arrayList = new ArrayList<DisabledCaps>();
        if (graphicsConfigTemplate3D.getStereo() == 2) {
            arrayList.add(DisabledCaps.STEREO);
        }
        if (graphicsConfigTemplate3D.getSceneAntialiasing() == 2) {
            arrayList.add(DisabledCaps.AA);
        }
        if (graphicsConfigTemplate3D.getSceneAntialiasing() != 1 && graphicsConfigTemplate3D.getDoubleBuffer() == 2) {
            arrayList.add(DisabledCaps.DOUBLE_BUFFER);
        }
        AbstractGraphicsScreen abstractGraphicsScreen = (graphicsDevice = graphicsConfigurationArray[0].getDevice()) != null ? AWTGraphicsScreen.createScreenDevice((GraphicsDevice)graphicsDevice, (int)0) : AWTGraphicsScreen.createDefault();
        boolean bl = true;
        CapabilitiesCapturer capabilitiesCapturer = null;
        AWTGraphicsConfiguration aWTGraphicsConfiguration = null;
        while (bl) {
            Frame frame = new Frame(graphicsDevice.getDefaultConfiguration());
            frame.setUndecorated(true);
            frame.setLayout(new BorderLayout());
            capabilitiesCapturer = new CapabilitiesCapturer();
            try {
                aWTGraphicsConfiguration = JoglPipeline.createAwtGraphicsConfiguration(gLCapabilities, (CapabilitiesChooser)capabilitiesCapturer, abstractGraphicsScreen);
                object2 = new QueryCanvas(aWTGraphicsConfiguration, capabilitiesCapturer);
                frame.add((Component)object2, "Center");
                frame.setSize(1, 1);
                frame.setVisible(true);
                ((QueryCanvas)object2).doQuery();
                if (!EventQueue.isDispatchThread()) {
                    object = capabilitiesCapturer;
                    synchronized (object) {
                        if (!capabilitiesCapturer.done()) {
                            try {
                                capabilitiesCapturer.wait(1000L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    }
                }
                this.disposeOnEDT(frame);
                bl = false;
            }
            catch (GLException gLException) {
                if (arrayList.size() == 0) {
                    bl = false;
                    continue;
                }
                switch ((DisabledCaps)((Object)arrayList.remove(0))) {
                    case STEREO: {
                        gLCapabilities.setStereo(false);
                        break;
                    }
                    case AA: {
                        gLCapabilities.setSampleBuffers(false);
                        break;
                    }
                    case DOUBLE_BUFFER: {
                        gLCapabilities.setDoubleBuffered(false);
                    }
                }
                aWTGraphicsConfiguration = null;
            }
        }
        int n = capabilitiesCapturer.getChosenIndex();
        object2 = null;
        object2 = n < 0 ? gLCapabilities : capabilitiesCapturer.getCapabilities();
        object = new JoglGraphicsConfiguration((GLCapabilities)object2, n, graphicsDevice);
        GraphicsConfigInfo graphicsConfigInfo = new GraphicsConfigInfo(graphicsConfigTemplate3D);
        graphicsConfigInfo.setPrivateData(aWTGraphicsConfiguration);
        Hashtable<GraphicsConfiguration, GraphicsConfigInfo> hashtable = Canvas3D.graphicsConfigTable;
        synchronized (hashtable) {
            Canvas3D.graphicsConfigTable.put((GraphicsConfiguration)object, graphicsConfigInfo);
        }
        return object;
    }

    @Override
    boolean isGraphicsConfigSupported(GraphicsConfigTemplate3D graphicsConfigTemplate3D, GraphicsConfiguration graphicsConfiguration) {
        return true;
    }

    @Override
    boolean hasDoubleBuffer(Canvas3D canvas3D) {
        return this.caps(canvas3D).getDoubleBuffered();
    }

    @Override
    boolean hasStereo(Canvas3D canvas3D) {
        return this.caps(canvas3D).getStereo();
    }

    @Override
    int getStencilSize(Canvas3D canvas3D) {
        return this.caps(canvas3D).getStencilBits();
    }

    @Override
    boolean hasSceneAntialiasingMultisample(Canvas3D canvas3D) {
        return this.caps(canvas3D).getSampleBuffers();
    }

    @Override
    boolean hasSceneAntialiasingAccum(Canvas3D canvas3D) {
        GLCapabilities gLCapabilities = this.caps(canvas3D);
        return gLCapabilities.getAccumRedBits() > 0 && gLCapabilities.getAccumGreenBits() > 0 && gLCapabilities.getAccumBlueBits() > 0;
    }

    @Override
    int getScreen(final GraphicsDevice graphicsDevice) {
        if (!this.checkedForGetScreenMethod) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    try {
                        JoglPipeline.this.getScreenMethod = graphicsDevice.getClass().getDeclaredMethod("getScreen", new Class[0]);
                        JoglPipeline.this.getScreenMethod.setAccessible(true);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    JoglPipeline.this.checkedForGetScreenMethod = true;
                    return null;
                }
            });
        }
        if (this.getScreenMethod != null) {
            try {
                return (Integer)this.getScreenMethod.invoke((Object)graphicsDevice, (Object[])null);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        return 0;
    }

    private static AWTGraphicsConfiguration createAwtGraphicsConfiguration(GLCapabilities gLCapabilities, CapabilitiesChooser capabilitiesChooser, AbstractGraphicsScreen abstractGraphicsScreen) {
        GraphicsConfigurationFactory graphicsConfigurationFactory = GraphicsConfigurationFactory.getFactory(AWTGraphicsDevice.class, GLCapabilities.class);
        AWTGraphicsConfiguration aWTGraphicsConfiguration = (AWTGraphicsConfiguration)graphicsConfigurationFactory.chooseGraphicsConfiguration((CapabilitiesImmutable)gLCapabilities, (CapabilitiesImmutable)gLCapabilities, capabilitiesChooser, abstractGraphicsScreen, 0);
        return aWTGraphicsConfiguration;
    }

    private void disposeOnEDT(final Frame frame) {
        Runnable runnable = new Runnable(){

            public void run() {
                frame.setVisible(false);
                frame.dispose();
            }
        };
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(runnable);
        } else {
            runnable.run();
        }
    }

    @Override
    DrawingSurfaceObject createDrawingSurfaceObject(Canvas3D canvas3D) {
        return new JoglDrawingSurfaceObject(canvas3D);
    }

    @Override
    void freeDrawingSurface(Canvas3D canvas3D, DrawingSurfaceObject drawingSurfaceObject) {
    }

    @Override
    void freeDrawingSurfaceNative(Object object) {
    }

    GLContext context(Context context) {
        if (context == null) {
            return null;
        }
        return ((JoglContext)context).getGLContext();
    }

    GLDrawable drawable(Drawable drawable) {
        if (drawable == null) {
            return null;
        }
        return ((JoglDrawable)drawable).getGLDrawable();
    }

    GLCapabilities caps(Canvas3D canvas3D) {
        if (canvas3D.drawable != null) {
            return (GLCapabilities)this.drawable(canvas3D.drawable).getChosenGLCapabilities();
        }
        return ((JoglGraphicsConfiguration)canvas3D.graphicsConfiguration).getGLCapabilities();
    }

    private static FloatBuffer getVertexArrayBuffer(float[] fArray) {
        return JoglPipeline.getVertexArrayBuffer(fArray, true);
    }

    private static FloatBuffer getVertexArrayBuffer(float[] fArray, boolean bl) {
        return JoglPipeline.getNIOBuffer(fArray, nioVertexTemp, bl);
    }

    private static DoubleBuffer getVertexArrayBuffer(double[] dArray) {
        return JoglPipeline.getVertexArrayBuffer(dArray, true);
    }

    private static DoubleBuffer getVertexArrayBuffer(double[] dArray, boolean bl) {
        return JoglPipeline.getNIOBuffer(dArray, nioVertexDoubleTemp, true);
    }

    private static FloatBuffer getColorArrayBuffer(float[] fArray) {
        return JoglPipeline.getColorArrayBuffer(fArray, true);
    }

    private static FloatBuffer getColorArrayBuffer(float[] fArray, boolean bl) {
        return JoglPipeline.getNIOBuffer(fArray, nioColorTemp, true);
    }

    private static ByteBuffer getColorArrayBuffer(byte[] byArray) {
        return JoglPipeline.getColorArrayBuffer(byArray, true);
    }

    private static ByteBuffer getColorArrayBuffer(byte[] byArray, boolean bl) {
        return JoglPipeline.getNIOBuffer(byArray, nioColorByteTemp, true);
    }

    private static FloatBuffer getNormalArrayBuffer(float[] fArray) {
        return JoglPipeline.getNormalArrayBuffer(fArray, true);
    }

    private static FloatBuffer getNormalArrayBuffer(float[] fArray, boolean bl) {
        return JoglPipeline.getNIOBuffer(fArray, nioNormalTemp, true);
    }

    private static FloatBuffer[] getTexCoordSetBuffer(Object[] objectArray) {
        return JoglPipeline.getNIOBuffer(objectArray, nioTexCoordSetTemp);
    }

    private static FloatBuffer[] getVertexAttrSetBuffer(Object[] objectArray) {
        return JoglPipeline.getNIOBuffer(objectArray, nioVertexAttrSetTemp);
    }

    private static FloatBuffer getNIOBuffer(float[] fArray, ThreadLocal<FloatBuffer> threadLocal, boolean bl) {
        if (fArray == null) {
            return null;
        }
        FloatBuffer floatBuffer = threadLocal.get();
        if (floatBuffer == null) {
            floatBuffer = Buffers.newDirectFloatBuffer((int)fArray.length);
            threadLocal.set(floatBuffer);
        } else {
            floatBuffer.rewind();
            if (floatBuffer.remaining() < fArray.length) {
                int n = Math.max(2 * floatBuffer.remaining(), fArray.length);
                floatBuffer = Buffers.newDirectFloatBuffer((int)n);
                threadLocal.set(floatBuffer);
            }
        }
        if (bl) {
            floatBuffer.put(fArray);
            floatBuffer.rewind();
        }
        return floatBuffer;
    }

    private static DoubleBuffer getNIOBuffer(double[] dArray, ThreadLocal<DoubleBuffer> threadLocal, boolean bl) {
        if (dArray == null) {
            return null;
        }
        DoubleBuffer doubleBuffer = threadLocal.get();
        if (doubleBuffer == null) {
            doubleBuffer = Buffers.newDirectDoubleBuffer((int)dArray.length);
            threadLocal.set(doubleBuffer);
        } else {
            doubleBuffer.rewind();
            if (doubleBuffer.remaining() < dArray.length) {
                int n = Math.max(2 * doubleBuffer.remaining(), dArray.length);
                doubleBuffer = Buffers.newDirectDoubleBuffer((int)n);
                threadLocal.set(doubleBuffer);
            }
        }
        if (bl) {
            doubleBuffer.put(dArray);
            doubleBuffer.rewind();
        }
        return doubleBuffer;
    }

    private static ByteBuffer getNIOBuffer(byte[] byArray, ThreadLocal<ByteBuffer> threadLocal, boolean bl) {
        if (byArray == null) {
            return null;
        }
        ByteBuffer byteBuffer = threadLocal.get();
        if (byteBuffer == null) {
            byteBuffer = Buffers.newDirectByteBuffer((int)byArray.length);
            threadLocal.set(byteBuffer);
        } else {
            byteBuffer.rewind();
            if (byteBuffer.remaining() < byArray.length) {
                int n = Math.max(2 * byteBuffer.remaining(), byArray.length);
                byteBuffer = Buffers.newDirectByteBuffer((int)n);
                threadLocal.set(byteBuffer);
            }
        }
        if (bl) {
            byteBuffer.put(byArray);
            byteBuffer.rewind();
        }
        return byteBuffer;
    }

    private static FloatBuffer[] getNIOBuffer(Object[] objectArray, ThreadLocal<FloatBuffer[]> threadLocal) {
        if (objectArray == null) {
            return null;
        }
        FloatBuffer[] floatBufferArray = threadLocal.get();
        if (floatBufferArray == null) {
            floatBufferArray = new FloatBuffer[objectArray.length];
            threadLocal.set(floatBufferArray);
        } else if (floatBufferArray.length < objectArray.length) {
            FloatBuffer[] floatBufferArray2 = new FloatBuffer[objectArray.length];
            System.arraycopy(floatBufferArray, 0, floatBufferArray2, 0, floatBufferArray.length);
            floatBufferArray = floatBufferArray2;
            threadLocal.set(floatBufferArray);
        }
        for (int i = 0; i < objectArray.length; ++i) {
            float[] fArray = (float[])objectArray[i];
            FloatBuffer floatBuffer = floatBufferArray[i];
            if (floatBuffer == null) {
                floatBufferArray[i] = floatBuffer = Buffers.newDirectFloatBuffer((int)fArray.length);
            } else {
                floatBuffer.rewind();
                if (floatBuffer.remaining() < fArray.length) {
                    int n = Math.max(2 * floatBuffer.remaining(), fArray.length);
                    floatBufferArray[i] = floatBuffer = Buffers.newDirectFloatBuffer((int)n);
                }
            }
            floatBuffer.put(fArray);
            floatBuffer.rewind();
        }
        return floatBufferArray;
    }

    static {
        int n;
        black = new float[4];
        screen_door = new int[][]{{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0x22222222, 0, 0, 0, 0x22222222, 0, 0, 0, 0x22222222, 0, 0, 0, 0x22222222, 0, 0, 0, 0x22222222, 0, 0, 0, 0x22222222, 0, 0, 0, 0x22222222, 0, 0, 0, 0x22222222, 0, 0}, {0, 0x22222222, 0, -2004318072, 0, 0x22222222, 0, -2004318072, 0, 0x22222222, 0, -2004318072, 0, 0x22222222, 0, -2004318072, 0, 0x22222222, 0, -2004318072, 0, 0x22222222, 0, -2004318072, 0, 0x22222222, 0, -2004318072, 0, 0x22222222, 0, -2004318072}, {0, -1431655766, 0, -2004318072, 0, -1431655766, 0, -2004318072, 0, -1431655766, 0, -2004318072, 0, -1431655766, 0, -2004318072, 0, -1431655766, 0, -2004318072, 0, -1431655766, 0, -2004318072, 0, -1431655766, 0, -2004318072, 0, -1431655766, 0, -2004318072}, {0, -1431655766, 0, -1431655766, 0, -1431655766, 0, -1431655766, 0, -1431655766, 0, -1431655766, 0, -1431655766, 0, -1431655766, 0, -1431655766, 0, -1431655766, 0, -1431655766, 0, -1431655766, 0, -1431655766, 0, -1431655766, 0, -1431655766, 0, -1431655766}, {0x11111111, -1431655766, 0, -1431655766, 0x11111111, -1431655766, 0, -1431655766, 0x11111111, -1431655766, 0, -1431655766, 0x11111111, -1431655766, 0, -1431655766, 0x11111111, -1431655766, 0, -1431655766, 0x11111111, -1431655766, 0, -1431655766, 0x11111111, -1431655766, 0, -1431655766, 0x11111111, -1431655766, 0, -1431655766}, {0x11111111, -1431655766, 0x44444444, -1431655766, 0x11111111, -1431655766, 0x44444444, -1431655766, 0x11111111, -1431655766, 0x44444444, -1431655766, 0x11111111, -1431655766, 0x44444444, -1431655766, 0x11111111, -1431655766, 0x44444444, -1431655766, 0x11111111, -1431655766, 0x44444444, -1431655766, 0x11111111, -1431655766, 0x44444444, -1431655766, 0x11111111, -1431655766, 0x44444444, -1431655766}, {0x55555555, -1431655766, 0x44444444, -1431655766, 0x55555555, -1431655766, 0x44444444, -1431655766, 0x55555555, -1431655766, 0x44444444, -1431655766, 0x55555555, -1431655766, 0x44444444, -1431655766, 0x55555555, -1431655766, 0x44444444, -1431655766, 0x55555555, -1431655766, 0x44444444, -1431655766, 0x55555555, -1431655766, 0x44444444, -1431655766, 0x55555555, -1431655766, 0x44444444, -1431655766}, {0x55555555, -1431655766, 0x55555555, -1431655766, 0x55555555, -1431655766, 0x55555555, -1431655766, 0x55555555, -1431655766, 0x55555555, -1431655766, 0x55555555, -1431655766, 0x55555555, -1431655766, 0x55555555, -1431655766, 0x55555555, -1431655766, 0x55555555, -1431655766, 0x55555555, -1431655766, 0x55555555, -1431655766, 0x55555555, -1431655766, 0x55555555, -1431655766, 0x55555555, -1431655766}, {0x77777777, -1431655766, 0x55555555, -1431655766, 0x77777777, -1431655766, 0x55555555, -1431655766, 0x77777777, -1431655766, 0x55555555, -1431655766, 0x77777777, -1431655766, 0x55555555, -1431655766, 0x77777777, -1431655766, 0x55555555, -1431655766, 0x77777777, -1431655766, 0x55555555, -1431655766, 0x77777777, -1431655766, 0x55555555, -1431655766, 0x77777777, -1431655766, 0x55555555, -1431655766}, {0x77777777, -1431655766, -572662307, -1431655766, 0x77777777, -1431655766, -572662307, -1431655766, 0x77777777, -1431655766, -572662307, -1431655766, 0x77777777, -1431655766, -572662307, -1431655766, 0x77777777, -1431655766, -572662307, -1431655766, 0x77777777, -1431655766, -572662307, -1431655766, 0x77777777, -1431655766, -572662307, -1431655766, 0x77777777, -1431655766, -572662307, -1431655766}, {-1, -1431655766, -572662307, -1431655766, -1, -1431655766, -572662307, -1431655766, -1, -1431655766, -572662307, -1431655766, -1, -1431655766, -572662307, -1431655766, -1, -1431655766, -572662307, -1431655766, -1, -1431655766, -572662307, -1431655766, -1, -1431655766, -572662307, -1431655766, -1, -1431655766, -572662307, -1431655766}, {-1, -1431655766, -1, -1431655766, -1, -1431655766, -1, -1431655766, -1, -1431655766, -1, -1431655766, -1, -1431655766, -1, -1431655766, -1, -1431655766, -1, -1431655766, -1, -1431655766, -1, -1431655766, -1, -1431655766, -1, -1431655766, -1, -1431655766, -1, -1431655766}, {-1, -1145324613, -1, -1431655766, -1, -1145324613, -1, -1431655766, -1, -1145324613, -1, -1431655766, -1, -1145324613, -1, -1431655766, -1, -1145324613, -1, -1431655766, -1, -1145324613, -1, -1431655766, -1, -1145324613, -1, -1431655766, -1, -1145324613, -1, -1431655766}, {-1, -1145324613, -1, -286331154, -1, -1145324613, -1, -286331154, -1, -1145324613, -1, -286331154, -1, -1145324613, -1, -286331154, -1, -1145324613, -1, -286331154, -1, -1145324613, -1, -286331154, -1, -1145324613, -1, -286331154, -1, -1145324613, -1, -286331154}, {-1, -1, -1, -286331154, -1, -1, -1, -286331154, -1, -1, -1, -286331154, -1, -1, -1, -286331154, -1, -1, -1, -286331154, -1, -1, -1, -286331154, -1, -1, -1, -286331154, -1, -1, -1, -286331154}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}};
        screen_door_table = new ByteBuffer[screen_door.length];
        int n2 = screen_door[0].length * 4;
        ByteBuffer byteBuffer = Buffers.newDirectByteBuffer((int)(screen_door.length * n2));
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        for (n = 0; n < screen_door.length; ++n) {
            intBuffer.put(screen_door[n]);
        }
        byteBuffer.rewind();
        for (n = 0; n < screen_door.length; ++n) {
            byteBuffer.position(n * n2);
            byteBuffer.limit((n + 1) * n2);
            JoglPipeline.screen_door_table[n] = byteBuffer.slice();
        }
        blendFunctionTable = new int[9];
        JoglPipeline.blendFunctionTable[0] = 0;
        JoglPipeline.blendFunctionTable[1] = 1;
        JoglPipeline.blendFunctionTable[2] = 770;
        JoglPipeline.blendFunctionTable[3] = 771;
        JoglPipeline.blendFunctionTable[4] = 774;
        JoglPipeline.blendFunctionTable[5] = 775;
        JoglPipeline.blendFunctionTable[6] = 768;
        JoglPipeline.blendFunctionTable[7] = 769;
        JoglPipeline.blendFunctionTable[8] = 32769;
        _gl_combineRgbSrcIndex = new int[]{34176, 34177, 34178};
        _gl_combineAlphaSrcIndex = new int[]{34184, 34185, 34186};
        _gl_combineRgbOpIndex = new int[]{34192, 34193, 34194};
        _gl_combineAlphaOpIndex = new int[]{34200, 34201, 34202};
        _gl_combineSrc = new int[]{34167, 5890, 34166, 34168};
        _gl_combineFcn = new int[]{768, 769, 770, 771};
        _gl_textureCubeMapFace = new int[]{34069, 34070, 34071, 34072, 34073, 34074};
        nioVertexTemp = new ThreadLocal();
        nioVertexDoubleTemp = new ThreadLocal();
        nioColorTemp = new ThreadLocal();
        nioColorByteTemp = new ThreadLocal();
        nioNormalTemp = new ThreadLocal();
        nioTexCoordSetTemp = new ThreadLocal();
        nioVertexAttrSetTemp = new ThreadLocal();
    }

    private final class ContextQuerier
    extends DefaultGLCapabilitiesChooser
    implements ExtendedCapabilitiesChooser {
        private Canvas3D canvas;
        private boolean done;

        public ContextQuerier(Canvas3D canvas3D) {
            this.canvas = canvas3D;
        }

        public boolean done() {
            return this.done;
        }

        public void init(GLContext gLContext) {
            JoglContext joglContext = new JoglContext(gLContext);
            GL2 gL2 = gLContext.getGL().getGL2();
            if (JoglPipeline.this.getPropertiesFromCurrentContext(joglContext, gL2)) {
                JoglPipeline.this.setupCanvasProperties(this.canvas, joglContext, (GL)gL2);
            }
            this.markDone();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void markDone() {
            ContextQuerier contextQuerier = this;
            synchronized (contextQuerier) {
                this.done = true;
                this.notifyAll();
            }
        }
    }

    static class CapabilitiesCapturer
    extends DefaultGLCapabilitiesChooser
    implements ExtendedCapabilitiesChooser {
        private boolean done;
        private GLCapabilities capabilities;
        private int chosenIndex = -1;

        CapabilitiesCapturer() {
        }

        public boolean done() {
            return this.done;
        }

        public GLCapabilities getCapabilities() {
            return this.capabilities;
        }

        public int getChosenIndex() {
            return this.chosenIndex;
        }

        public int chooseCapabilities(GLCapabilities gLCapabilities, GLCapabilities[] gLCapabilitiesArray, int n) {
            int n2 = super.chooseCapabilities((CapabilitiesImmutable)gLCapabilities, Arrays.asList(gLCapabilitiesArray), n);
            this.capabilities = gLCapabilitiesArray[n2];
            this.chosenIndex = n2;
            this.markDone();
            return n2;
        }

        public void init(GLContext gLContext) {
            this.kick();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void markDone() {
            CapabilitiesCapturer capabilitiesCapturer = this;
            synchronized (capabilitiesCapturer) {
                this.done = true;
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void kick() {
            CapabilitiesCapturer capabilitiesCapturer = this;
            synchronized (capabilitiesCapturer) {
                this.notifyAll();
            }
        }
    }

    private final class QueryCanvas
    extends Canvas {
        private GLDrawable glDrawable;
        private ExtendedCapabilitiesChooser chooser;
        private boolean alreadyRan;
        private AWTGraphicsConfiguration awtConfig;
        private JAWTWindow nativeWindow;

        private QueryCanvas(AWTGraphicsConfiguration aWTGraphicsConfiguration, ExtendedCapabilitiesChooser extendedCapabilitiesChooser) {
            super(aWTGraphicsConfiguration.getAWTGraphicsConfiguration());
            this.awtConfig = null;
            this.nativeWindow = null;
            this.awtConfig = aWTGraphicsConfiguration;
            this.chooser = extendedCapabilitiesChooser;
        }

        public void addNotify() {
            super.addNotify();
            this.nativeWindow = (JAWTWindow)NativeWindowFactory.getNativeWindow((Object)this, (AbstractGraphicsConfiguration)this.awtConfig);
            this.nativeWindow.lockSurface();
            try {
                this.glDrawable = GLDrawableFactory.getFactory((GLProfile)JoglPipeline.this.profile).createGLDrawable((NativeSurface)this.nativeWindow);
            }
            finally {
                this.nativeWindow.unlockSurface();
            }
            this.glDrawable.setRealized(true);
        }

        private void doQuery() {
            if (this.alreadyRan) {
                return;
            }
            GLContext gLContext = this.glDrawable.createContext(null);
            int n = gLContext.makeCurrent();
            if (n != 0) {
                try {
                    this.chooser.init(gLContext);
                }
                finally {
                    gLContext.release();
                }
            }
            gLContext.destroy();
            this.alreadyRan = true;
            this.glDrawable.setRealized(false);
            this.nativeWindow.destroy();
        }
    }

    static interface ExtendedCapabilitiesChooser
    extends GLCapabilitiesChooser {
        public void init(GLContext var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum DisabledCaps {
        STEREO,
        AA,
        DOUBLE_BUFFER;

    }
}

