/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.j3d.loaders.bsp;

import java.io.IOException;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Geometry;
import javax.media.j3d.Node;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Texture;
import javax.media.j3d.TriangleFanArray;
import javax.vecmath.Point3f;
import org.newdawn.j3d.loaders.NodeFactory;
import org.newdawn.j3d.loaders.bsp.BSPEdgeLump;
import org.newdawn.j3d.loaders.bsp.BSPTextureLump;
import org.newdawn.j3d.loaders.bsp.WALList;
import org.newdawn.j3d.loaders.pak.PAKArchive;

public class BSPFace {
    private int[] edgesIndexs;
    private int texIndex;
    private BSPEdgeLump edges;
    private BSPTextureLump textures;

    public BSPFace(int[] edgesIndexs, int texIndex, BSPEdgeLump edges, BSPTextureLump textures) {
        this.edgesIndexs = edgesIndexs;
        this.texIndex = texIndex;
        this.edges = edges;
        this.textures = textures;
    }

    public void render(BranchGroup group, String basedir, WALList list, NodeFactory factory) {
        float height;
        float width;
        if (this.textures.getFlags(this.texIndex) != 0) {
            return;
        }
        int format = 35;
        int[] stripIndexs = new int[]{this.edgesIndexs.length + 1};
        Appearance app = new Appearance();
        try {
            Texture t = list.getWAL(this.textures.getTextureName(this.texIndex), basedir);
            width = t.getWidth();
            height = t.getHeight();
            app.setTexture(t);
        }
        catch (IOException e) {
            System.out.println("Error loading texture: " + e);
            return;
        }
        TriangleFanArray array = new TriangleFanArray(this.edgesIndexs.length + 1, format, stripIndexs);
        Point3f pt = this.edges.getStartPoint(this.edgesIndexs[0]);
        array.setCoordinate(0, pt);
        array.setTextureCoordinate(0, this.textures.getPoint(this.texIndex, pt, width, height));
        int i = 0;
        while (i < this.edgesIndexs.length) {
            pt = this.edges.getEndPoint(this.edgesIndexs[i]);
            array.setCoordinate(i + 1, pt);
            array.setTextureCoordinate(i + 1, this.textures.getPoint(this.texIndex, pt, width, height));
            ++i;
        }
        PolygonAttributes poly = new PolygonAttributes();
        poly.setCullFace(0);
        app.setPolygonAttributes(poly);
        group.addChild((Node)factory.createShape3D((Geometry)array, app));
    }

    public void render(BranchGroup group, PAKArchive pak, WALList list, NodeFactory factory) {
        float height;
        float width;
        if (this.textures.getFlags(this.texIndex) != 0) {
            return;
        }
        int format = 33;
        int[] stripIndexs = new int[]{this.edgesIndexs.length + 1};
        Appearance app = new Appearance();
        try {
            Texture t = list.getWAL(this.textures.getTextureName(this.texIndex), pak);
            width = t.getWidth();
            height = t.getHeight();
            app.setTexture(t);
        }
        catch (IOException e) {
            System.out.println("Error loading texture: " + e);
            return;
        }
        TriangleFanArray array = new TriangleFanArray(this.edgesIndexs.length + 1, format, stripIndexs);
        Point3f pt = this.edges.getStartPoint(this.edgesIndexs[0]);
        array.setCoordinate(0, pt);
        array.setTextureCoordinate(0, this.textures.getPoint(this.texIndex, pt, width, height));
        int i = 0;
        while (i < this.edgesIndexs.length) {
            pt = this.edges.getEndPoint(this.edgesIndexs[i]);
            array.setCoordinate(i + 1, pt);
            array.setTextureCoordinate(i + 1, this.textures.getPoint(this.texIndex, pt, width, height));
            ++i;
        }
        PolygonAttributes poly = new PolygonAttributes();
        poly.setCullFace(0);
        app.setPolygonAttributes(poly);
        Shape3D shape = factory.createShape3D((Geometry)array, app);
        group.addChild((Node)shape);
    }
}

