/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.loaders.vrml97.impl;

import java.util.Vector;
import javax.media.j3d.SceneGraphPath;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.jdesktop.j3d.loaders.vrml97.impl.Loader;
import org.jdesktop.j3d.loaders.vrml97.impl.Node;
import org.jdesktop.j3d.loaders.vrml97.impl.SFBool;
import org.jdesktop.j3d.loaders.vrml97.impl.SFVec3f;
import org.jdesktop.j3d.loaders.vrml97.impl.VrmlSensor;

public abstract class DragSensor
extends Node
implements VrmlSensor {
    SFBool enabled;
    SFBool autoOffset;
    SFBool isActive;
    SFVec3f trackPoint;
    javax.media.j3d.Node parent;
    static double EPSILON = 1.0E-8;
    static double DELTA = 1.0E-5;

    public DragSensor(Loader loader) {
        super(loader);
        this.enabled = new SFBool(true);
        this.autoOffset = new SFBool(true);
        this.isActive = new SFBool(true);
        this.trackPoint = new SFVec3f(0.0f, 0.0f, 0.0f);
        this.initFields();
    }

    DragSensor(Loader loader, SFBool enabled) {
        super(loader);
        this.enabled = enabled;
        this.isActive = new SFBool(true);
        this.initFields();
    }

    void updateParent(javax.media.j3d.Node parentImpl) {
        Vector<DragSensor> v = (Vector<DragSensor>)parentImpl.getUserData();
        if (v == null) {
            v = new Vector<DragSensor>();
            parentImpl.setUserData(v);
            if (this.loader.debug) {
                System.out.println("Drag Sensor parent: " + parentImpl + " had no user data, added vector:" + v);
            }
        }
        v.addElement(this);
        parentImpl.setCapability(1);
        parentImpl.setCapability(3);
        parentImpl.setCapability(11);
        parentImpl.setCapability(12);
        parentImpl.setCapability(13);
        parentImpl.setCapability(14);
        if (parentImpl instanceof TransformGroup) {
            parentImpl.setCapability(17);
        }
        parentImpl.setPickable(true);
        this.parent = parentImpl;
    }

    void initFields() {
        this.enabled.init(this, this.FieldSpec, 3, "enabled");
        this.autoOffset.init(this, this.FieldSpec, 3, "autoOffset");
        this.isActive.init(this, this.FieldSpec, 2, "isActive");
        this.trackPoint.init(this, this.FieldSpec, 2, "trackPoint");
    }

    abstract void offset();

    abstract void simTick(double var1);

    abstract void update(Point3d var1, Point3d var2, javax.media.j3d.Node var3, SceneGraphPath var4);

    static void norm(Vector3d n) throws ArithmeticException {
        double norml = (float)Math.sqrt(n.x * n.x + n.y * n.y + n.z * n.z);
        if (norml == 0.0) {
            throw new ArithmeticException();
        }
        n.x /= norml;
        n.y /= norml;
        n.z /= norml;
    }

    static double angle(Vector3d t, Vector3d u) {
        double l1 = DragSensor.length(t);
        double l2 = DragSensor.length(u);
        if (l1 == 0.0 || l2 == 0.0) {
            return 0.0;
        }
        double a = Math.acos(DragSensor.dot(t, u) / (l1 * l2));
        if (a < 0.0 || a > 0.0) {
            return a;
        }
        return EPSILON;
    }

    static double length(Vector3d v) {
        double l = Math.sqrt(DragSensor.dot(v, v));
        return l;
    }

    static double dot(Vector3d v, Vector3d u) {
        return v.x * u.x + v.y * u.y + v.z * u.z;
    }

    static double coorelate(Transform3D tr) {
        double c = 0.0;
        double COORELATION_FACTOR = 10.0;
        if (c == 0.0) {
            Point3d p1 = new Point3d(0.0, 0.0, 0.0);
            Point3d p2 = new Point3d(0.0 + DELTA, 0.0, 0.0);
            tr.transform(p1);
            tr.transform(p2);
            Vector3d v1 = new Vector3d((Tuple3d)p1);
            Vector3d v2 = new Vector3d((Tuple3d)p2);
            DragSensor.norm(v1);
            DragSensor.norm(v2);
            c = COORELATION_FACTOR * DELTA / DragSensor.angle(v1, v2);
        }
        return c;
    }
}

