/*
 * Decompiled with CFR 0.152.
 */
package net.sf.nwn.bif;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import net.sf.nwn.bif.CommonFile;

public class BifFile
extends CommonFile {
    int entries;
    int[] offsets = new int[16384];
    int[] lengths = new int[16384];

    public BifFile(File file) throws IOException {
        super(file);
        this.bb.getInt();
        this.bb.getInt();
        this.entries = this.bb.getInt();
        this.bb.getInt();
        int n = this.bb.getInt();
        this.bb.position(n);
        for (int i = 0; i < this.entries; ++i) {
            int n2 = this.bb.getInt() & 0x1FFF;
            this.offsets[n2] = this.bb.getInt();
            this.lengths[n2] = this.bb.getInt();
            this.bb.getInt();
        }
    }

    public void dumpResource(int n, File file) throws IOException {
        System.out.println("Writing " + file + " len " + this.lengths[n]);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        FileChannel fileChannel = fileOutputStream.getChannel();
        this.bb.position(this.offsets[n]);
        ByteBuffer byteBuffer = this.bb.slice();
        byteBuffer.limit(this.lengths[n]);
        fileChannel.write(byteBuffer);
        fileChannel.close();
        fileOutputStream.close();
    }

    public void dump() {
        System.out.println("BIF " + this.entries + " entries");
        for (int i = 0; i < this.entries; ++i) {
            System.out.println("Id: " + i + " off:" + BifFile.hex(this.offsets[i]) + " size:" + this.lengths[i]);
        }
    }

    public static void main(String[] stringArray) throws IOException {
        BifFile bifFile = new BifFile(new File(stringArray[0]));
        bifFile.dump();
        bifFile.close();
    }
}

