/*
 * Decompiled with CFR 0.152.
 */
package net.sf.nwn.loader;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.MemoryImageSource;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class TargaImage {
    private static final int NO_TRANSPARENCY = 255;
    private static final int FULL_TRANSPARENCY = 0;
    private short idLength;
    private short colorMapType;
    private short imageType;
    private int cMapStart;
    private int cMapLength;
    private short cMapDepth;
    private int xOffset;
    private int yOffset;
    private int width;
    private int height;
    private short pixelDepth;
    private short imageDescriptor;
    private DirectColorModel cm;
    public int[] pixels;
    private static byte[] buf;

    public TargaImage(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        this.open(fileInputStream);
        ((InputStream)fileInputStream).close();
    }

    public TargaImage(URL uRL) throws IOException {
        InputStream inputStream = uRL.openStream();
        this.open(inputStream);
        inputStream.close();
    }

    public TargaImage(InputStream inputStream) throws IOException {
        this.open(inputStream);
    }

    private void open(InputStream inputStream) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream, 8192);
        DataInputStream dataInputStream = new DataInputStream(bufferedInputStream);
        this.idLength = (short)dataInputStream.read();
        this.colorMapType = (short)dataInputStream.read();
        this.imageType = (short)dataInputStream.read();
        this.cMapStart = this.flipEndian(dataInputStream.readShort());
        this.cMapLength = this.flipEndian(dataInputStream.readShort());
        this.cMapDepth = (short)dataInputStream.read();
        this.xOffset = this.flipEndian(dataInputStream.readShort());
        this.yOffset = this.flipEndian(dataInputStream.readShort());
        this.width = this.flipEndian(dataInputStream.readShort());
        this.height = this.flipEndian(dataInputStream.readShort());
        this.pixelDepth = (short)dataInputStream.read();
        if (this.pixelDepth == 24) {
            this.cm = new DirectColorModel(24, 0xFF0000, 65280, 255);
        } else if (this.pixelDepth == 32) {
            this.cm = new DirectColorModel(32, 0xFF0000, 65280, 255, -16777216);
        }
        this.imageDescriptor = (short)dataInputStream.read();
        if (this.idLength > 0) {
            bufferedInputStream.skip(this.idLength);
        }
        this.pixels = new int[this.width * this.height];
        if (this.pixelDepth == 32) {
            this.load32(bufferedInputStream);
        } else {
            this.load24(bufferedInputStream);
        }
        inputStream.close();
    }

    private void load32(BufferedInputStream bufferedInputStream) throws IOException {
        if (buf == null || buf.length < this.width * 4) {
            buf = new byte[this.width * 4];
        }
        for (int i = this.height - 1; i >= 0; --i) {
            int n = i * this.width;
            bufferedInputStream.read(buf, 0, this.width * 4);
            for (int j = 0; j < this.width; ++j) {
                int n2 = j << 2;
                int n3 = buf[n2] & 0xFF;
                int n4 = buf[n2 + 1] & 0xFF;
                int n5 = buf[n2 + 2] & 0xFF;
                int n6 = buf[n2 + 3] & 0xFF;
                n3 = n3 * n6 >> 8;
                n4 = n4 * n6 >> 8;
                n5 = n5 * n6 >> 8;
                this.pixels[n + j] = n6 << 24 | n5 << 16 | n4 << 8 | n3;
            }
        }
    }

    private void load24(BufferedInputStream bufferedInputStream) throws IOException {
        if (buf == null || buf.length < this.width * 3) {
            buf = new byte[this.width * 3];
        }
        for (int i = this.height - 1; i >= 0; --i) {
            int n = i * this.width;
            bufferedInputStream.read(buf, 0, this.width * 3);
            for (int j = 0; j < this.width; ++j) {
                int n2 = j + j + j;
                int n3 = buf[n2] & 0xFF;
                int n4 = buf[n2 + 1] & 0xFF;
                int n5 = buf[n2 + 2] & 0xFF;
                this.pixels[n + j] = n5 << 16 | n4 << 8 | n3;
            }
        }
    }

    public BufferedImage getImage() {
        BufferedImage bufferedImage = new BufferedImage(this.width, this.height, this.pixelDepth == 24 ? 1 : 2);
        bufferedImage.setRGB(0, 0, this.width, this.height, this.pixels, 0, this.width);
        return bufferedImage;
    }

    public Dimension getSize() {
        return new Dimension(this.width, this.height);
    }

    private short flipEndian(short s) {
        int n = s & 0xFFFF;
        return (short)(n << 8 | (n & 0xFF00) >>> 8);
    }

    public Image getThumbnail(int n, boolean bl) {
        Dimension dimension = new Dimension(0, 0);
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        double d = 0.0;
        if (this.width == n && this.height == n || this.width < n && this.height < n) {
            bl = false;
        }
        if (this.width >= this.height) {
            dimension.width = n;
            dimension.height = Math.round((float)this.height / (float)this.width * (float)n);
        } else {
            dimension.height = n;
            dimension.width = Math.round((float)this.width / (float)this.height * (float)n);
        }
        d = (double)this.width / (double)dimension.width;
        int[] nArray = new int[dimension.width * dimension.height];
        for (int i = 0; i < dimension.height; ++i) {
            n4 = (int)((double)i * d);
            for (int j = 0; j < dimension.width; ++j) {
                n3 = (int)((double)j * d);
                if (bl) {
                    int n5 = 0;
                    int n6 = 0;
                    int n7 = 0;
                    int[] nArray2 = new int[5];
                    int n8 = this.width == this.height ? 1 : 2;
                    nArray2[2] = this.pixels[n4 * this.width + n3];
                    nArray2[0] = n4 - n8 < 0 ? nArray2[2] : this.pixels[(n4 - n8) * this.width + n3];
                    nArray2[1] = n3 - n8 < 0 ? nArray2[2] : this.pixels[n4 * this.width + n3 - n8];
                    nArray2[3] = n3 + n8 > this.width - 1 ? nArray2[2] : this.pixels[n4 * this.width + n3 + n8];
                    nArray2[4] = n4 + n8 > this.height - 1 ? nArray2[2] : this.pixels[(n4 + n8) * this.width + n3];
                    for (int k = 0; k < nArray2.length; ++k) {
                        n5 += (nArray2[k] & 0xFF0000) >>> 16;
                        n6 += (nArray2[k] & 0xFF00) >>> 8;
                        n7 += nArray2[k] & 0xFF;
                    }
                    n2 = 0xFF000000 | (n5 /= nArray2.length) << 16 | (n6 /= nArray2.length) << 8 | (n7 /= nArray2.length);
                } else {
                    n2 = this.pixels[n4 * this.width + n3];
                }
                nArray[i * dimension.width + j] = n2;
            }
        }
        DirectColorModel directColorModel = new DirectColorModel(24, 0xFF0000, 65280, 255);
        return Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(dimension.width, dimension.height, (ColorModel)directColorModel, nArray, 0, dimension.width));
    }

    public int getPixelDepth() {
        return this.pixelDepth;
    }
}

