/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.awt;

import com.jogamp.common.util.PropertyAccess;
import com.jogamp.common.util.awt.AWTEDTExecutor;
import com.jogamp.common.util.locks.LockFactory;
import com.jogamp.common.util.locks.RecursiveLock;
import com.jogamp.nativewindow.AbstractGraphicsDevice;
import com.jogamp.nativewindow.NativeSurface;
import com.jogamp.nativewindow.ScalableSurface;
import com.jogamp.nativewindow.SurfaceUpdatedListener;
import com.jogamp.nativewindow.WindowClosingProtocol;
import com.jogamp.nativewindow.awt.AWTPrintLifecycle;
import com.jogamp.nativewindow.awt.AWTWindowClosingProtocol;
import com.jogamp.nativewindow.util.PixelFormat;
import com.jogamp.opengl.FBObject;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GL2ES3;
import com.jogamp.opengl.GLAnimatorControl;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesChooser;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLDrawable;
import com.jogamp.opengl.GLDrawableFactory;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLFBODrawable;
import com.jogamp.opengl.GLOffscreenAutoDrawable;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.GLRunnable;
import com.jogamp.opengl.GLSharedContextSetter;
import com.jogamp.opengl.Threading;
import com.jogamp.opengl.awt.AWTGLAutoDrawable;
import com.jogamp.opengl.util.GLDrawableUtil;
import com.jogamp.opengl.util.GLPixelBuffer;
import com.jogamp.opengl.util.GLPixelStorageModes;
import com.jogamp.opengl.util.TileRenderer;
import com.jogamp.opengl.util.awt.AWTGLPixelBuffer;
import com.jogamp.opengl.util.texture.TextureState;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.beans.Beans;
import java.nio.IntBuffer;
import java.util.List;
import javax.swing.JPanel;
import jogamp.nativewindow.SurfaceScaleUtils;
import jogamp.nativewindow.WrappedSurface;
import jogamp.nativewindow.jawt.JAWTUtil;
import jogamp.opengl.Debug;
import jogamp.opengl.GLContextImpl;
import jogamp.opengl.GLDrawableFactoryImpl;
import jogamp.opengl.GLDrawableHelper;
import jogamp.opengl.GLDrawableImpl;
import jogamp.opengl.awt.AWTTilePainter;
import jogamp.opengl.awt.Java2D;
import jogamp.opengl.util.glsl.GLSLTextureRaster;

public class GLJPanel
extends JPanel
implements AWTGLAutoDrawable,
WindowClosingProtocol,
AWTPrintLifecycle,
GLSharedContextSetter,
ScalableSurface {
    private static final boolean DEBUG;
    private static final boolean DEBUG_FRAMES;
    private static final boolean DEBUG_VIEWPORT;
    private static final boolean USE_GLSL_TEXTURE_RASTERIZER;
    private static final boolean SKIP_VERTICAL_FLIP_DEFAULT;
    private static final boolean java2dOGLEnabledByProp;
    private static final boolean useJava2DGLPipeline;
    private static boolean java2DGLPipelineOK;
    private static AWTGLPixelBuffer.SingleAWTGLPixelBufferProvider singleAWTGLPixelBufferProvider;
    private final RecursiveLock lock = LockFactory.createRecursiveLock();
    private final GLDrawableHelper helper;
    private boolean autoSwapBufferMode;
    private volatile boolean isInitialized;
    private AWTGLPixelBuffer.AWTGLPixelBufferProvider customPixelBufferProvider = null;
    private volatile GLCapabilitiesImmutable reqOffscreenCaps;
    private volatile GLDrawableFactoryImpl factory;
    private final GLCapabilitiesChooser chooser;
    private int additionalCtxCreationFlags = 0;
    private boolean handleReshape = false;
    private boolean sendReshape = true;
    private final float[] minPixelScale = new float[]{1.0f, 1.0f};
    private final float[] maxPixelScale = new float[]{1.0f, 1.0f};
    private final float[] hasPixelScale = new float[]{1.0f, 1.0f};
    private final float[] reqPixelScale = new float[]{0.0f, 0.0f};
    private int reshapeWidth;
    private int reshapeHeight;
    private int panelWidth = 0;
    private int panelHeight = 0;
    private int viewportX;
    private int viewportY;
    private int requestedTextureUnit = 0;
    private volatile Backend backend;
    private boolean skipGLOrientationVerticalFlip = SKIP_VERTICAL_FLIP_DEFAULT;
    private final Updater updater = new Updater();
    private volatile boolean isShowing;
    private final HierarchyListener hierarchyListener = new HierarchyListener(){

        @Override
        public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
            GLJPanel.this.isShowing = GLJPanel.this.isShowing();
        }
    };
    private final AWTWindowClosingProtocol awtWindowClosingProtocol = new AWTWindowClosingProtocol(this, new Runnable(){

        @Override
        public void run() {
            GLJPanel.this.destroy();
        }
    }, null);
    private final Runnable setSurfaceScaleAction = new Runnable(){

        @Override
        public void run() {
            Backend backend = GLJPanel.this.backend;
            if (null != backend && GLJPanel.this.setSurfaceScaleImpl(backend) && !GLJPanel.this.helper.isAnimatorAnimatingOnOtherThread()) {
                GLJPanel.this.paintImmediatelyAction.run();
            }
        }
    };
    private volatile boolean printActive = false;
    private GLAnimatorControl printAnimator = null;
    private GLAutoDrawable printGLAD = null;
    private AWTTilePainter printAWTTiles = null;
    private final Runnable setupPrintOnEDT = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            RecursiveLock recursiveLock = GLJPanel.this.lock;
            recursiveLock.lock();
            try {
                boolean bl;
                if (!GLJPanel.this.isInitialized) {
                    GLJPanel.this.initializeBackendImpl();
                }
                if (!GLJPanel.this.isInitialized) {
                    if (DEBUG) {
                        System.err.println(GLJPanel.getThreadName() + ": Info: GLJPanel setupPrint - skipped GL render, drawable not valid yet");
                    }
                    GLJPanel.this.printActive = false;
                    return;
                }
                if (!GLJPanel.this.isVisible()) {
                    if (DEBUG) {
                        System.err.println(GLJPanel.getThreadName() + ": Info: GLJPanel setupPrint - skipped GL render, panel not visible");
                    }
                    GLJPanel.this.printActive = false;
                    return;
                }
                GLJPanel.this.sendReshape = false;
                GLJPanel.this.handleReshape = false;
                GLJPanel.this.printAnimator = GLJPanel.this.helper.getAnimator();
                if (null != GLJPanel.this.printAnimator) {
                    GLJPanel.this.printAnimator.remove(GLJPanel.this);
                }
                GLJPanel.this.printGLAD = GLJPanel.this;
                GLCapabilitiesImmutable gLCapabilitiesImmutable = GLJPanel.this.getChosenGLCapabilities();
                int n = GLJPanel.this.printAWTTiles.getNumSamples(gLCapabilitiesImmutable);
                GLDrawable gLDrawable = GLJPanel.this.printGLAD.getDelegatedDrawable();
                boolean bl2 = n != gLCapabilitiesImmutable.getNumSamples();
                boolean bl3 = ((GLJPanel)GLJPanel.this).printAWTTiles.customTileWidth != -1 && ((GLJPanel)GLJPanel.this).printAWTTiles.customTileWidth != gLDrawable.getSurfaceWidth() || ((GLJPanel)GLJPanel.this).printAWTTiles.customTileHeight != -1 && ((GLJPanel)GLJPanel.this).printAWTTiles.customTileHeight != gLDrawable.getSurfaceHeight();
                GLCapabilities gLCapabilities = (GLCapabilities)gLCapabilitiesImmutable.cloneMutable();
                gLCapabilities.setDoubleBuffered(false);
                gLCapabilities.setOnscreen(false);
                if (n != gLCapabilities.getNumSamples()) {
                    gLCapabilities.setSampleBuffers(0 < n);
                    gLCapabilities.setNumSamples(n);
                }
                boolean bl4 = GLDrawableUtil.isSwapGLContextSafe(GLJPanel.this.getRequestedGLCapabilities(), gLCapabilitiesImmutable, gLCapabilities);
                boolean bl5 = bl = (bl2 || bl3) && bl4;
                if (DEBUG) {
                    System.err.println("AWT print.setup: reqNewGLAD " + bl + "[ samples " + bl2 + ", size " + bl3 + ", safe " + bl4 + "], " + ", drawableSize " + gLDrawable.getSurfaceWidth() + "x" + gLDrawable.getSurfaceHeight() + ", customTileSize " + ((GLJPanel)GLJPanel.this).printAWTTiles.customTileWidth + "x" + ((GLJPanel)GLJPanel.this).printAWTTiles.customTileHeight + ", scaleMat " + ((GLJPanel)GLJPanel.this).printAWTTiles.scaleMatX + " x " + ((GLJPanel)GLJPanel.this).printAWTTiles.scaleMatY + ", numSamples " + ((GLJPanel)GLJPanel.this).printAWTTiles.customNumSamples + " -> " + n + ", printAnimator " + GLJPanel.this.printAnimator);
                }
                if (bl) {
                    GLOffscreenAutoDrawable gLOffscreenAutoDrawable;
                    block18: {
                        GLDrawableFactory gLDrawableFactory = GLDrawableFactory.getFactory(gLCapabilities.getGLProfile());
                        gLOffscreenAutoDrawable = null;
                        try {
                            gLOffscreenAutoDrawable = gLDrawableFactory.createOffscreenAutoDrawable(null, gLCapabilities, null, ((GLJPanel)GLJPanel.this).printAWTTiles.customTileWidth != -1 ? ((GLJPanel)GLJPanel.this).printAWTTiles.customTileWidth : 1024, ((GLJPanel)GLJPanel.this).printAWTTiles.customTileHeight != -1 ? ((GLJPanel)GLJPanel.this).printAWTTiles.customTileHeight : 1024);
                        }
                        catch (GLException gLException) {
                            if (!DEBUG) break block18;
                            System.err.println("Caught: " + gLException.getMessage());
                            gLException.printStackTrace();
                        }
                    }
                    if (null != gLOffscreenAutoDrawable) {
                        GLJPanel.this.printGLAD = gLOffscreenAutoDrawable;
                        GLDrawableUtil.swapGLContextAndAllGLEventListener(GLJPanel.this, GLJPanel.this.printGLAD);
                        gLDrawable = GLJPanel.this.printGLAD.getDelegatedDrawable();
                    }
                }
                GLJPanel.this.printAWTTiles.setGLOrientation(!GLJPanel.this.skipGLOrientationVerticalFlip && GLJPanel.this.printGLAD.isGLOriented(), GLJPanel.this.printGLAD.isGLOriented());
                ((GLJPanel)GLJPanel.this).printAWTTiles.renderer.setTileSize(gLDrawable.getSurfaceWidth(), gLDrawable.getSurfaceHeight(), 0);
                ((GLJPanel)GLJPanel.this).printAWTTiles.renderer.attachAutoDrawable(GLJPanel.this.printGLAD);
                if (DEBUG) {
                    System.err.println("AWT print.setup " + GLJPanel.this.printAWTTiles);
                    System.err.println("AWT print.setup AA " + n + ", " + gLCapabilities);
                    System.err.println("AWT print.setup printGLAD: " + GLJPanel.this.printGLAD.getSurfaceWidth() + "x" + GLJPanel.this.printGLAD.getSurfaceHeight() + ", " + GLJPanel.this.printGLAD);
                    System.err.println("AWT print.setup printDraw: " + gLDrawable.getSurfaceWidth() + "x" + gLDrawable.getSurfaceHeight() + ", " + gLDrawable);
                }
            }
            finally {
                recursiveLock.unlock();
            }
        }
    };
    private final Runnable releasePrintOnEDT = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            RecursiveLock recursiveLock = GLJPanel.this.lock;
            recursiveLock.lock();
            try {
                if (DEBUG) {
                    System.err.println(GLJPanel.getThreadName() + ": GLJPanel.releasePrintOnEDT.0 " + GLJPanel.this.printAWTTiles);
                }
                GLJPanel.this.printAWTTiles.dispose();
                GLJPanel.this.printAWTTiles = null;
                if (GLJPanel.this.printGLAD != GLJPanel.this) {
                    GLDrawableUtil.swapGLContextAndAllGLEventListener(GLJPanel.this.printGLAD, GLJPanel.this);
                    GLJPanel.this.printGLAD.destroy();
                }
                GLJPanel.this.printGLAD = null;
                if (null != GLJPanel.this.printAnimator) {
                    GLJPanel.this.printAnimator.add(GLJPanel.this);
                    GLJPanel.this.printAnimator = null;
                }
                int n = GLJPanel.this.getWidth();
                int n2 = GLJPanel.this.getHeight();
                int n3 = SurfaceScaleUtils.scale(n, GLJPanel.this.hasPixelScale[0]);
                int n4 = SurfaceScaleUtils.scale(n2, GLJPanel.this.hasPixelScale[1]);
                GLDrawable gLDrawable = GLJPanel.this.getDelegatedDrawable();
                if (n3 != GLJPanel.this.panelWidth || n4 != GLJPanel.this.panelHeight || gLDrawable.getSurfaceWidth() != GLJPanel.this.panelWidth || gLDrawable.getSurfaceHeight() != GLJPanel.this.panelHeight) {
                    if (DEBUG) {
                        System.err.println(GLJPanel.getThreadName() + ": GLJPanel.releasePrintOnEDT.0: resize [printing] panel " + GLJPanel.this.panelWidth + "x" + GLJPanel.this.panelHeight + " @ scale " + GLJPanel.this.getPixelScaleStr() + ", draw " + gLDrawable.getSurfaceWidth() + "x" + gLDrawable.getSurfaceHeight() + " -> " + n + "x" + n2 + " * " + GLJPanel.this.getPixelScaleStr() + " -> " + n3 + "x" + n4);
                    }
                    GLJPanel.this.reshapeWidth = n3;
                    GLJPanel.this.reshapeHeight = n4;
                    GLJPanel.this.sendReshape = GLJPanel.this.handleReshape();
                } else {
                    GLJPanel.this.sendReshape = true;
                }
                GLJPanel.this.printActive = false;
                GLJPanel.this.display();
            }
            finally {
                recursiveLock.unlock();
            }
        }
    };
    private final Object initSync = new Object();
    private final Runnable disposeAction = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block11: {
                RecursiveLock recursiveLock = GLJPanel.this.lock;
                recursiveLock.lock();
                try {
                    if (null == GLJPanel.this.backend) break block11;
                    GLContext gLContext = GLJPanel.this.backend.getContext();
                    boolean bl = !GLJPanel.this.backend.isUsingOwnLifecycle();
                    GLException gLException = null;
                    if (null != gLContext && gLContext.isCreated()) {
                        try {
                            GLJPanel.this.helper.disposeGL(GLJPanel.this, gLContext, !bl);
                        }
                        catch (GLException gLException2) {
                            gLException = gLException2;
                        }
                    }
                    Throwable throwable = null;
                    if (bl) {
                        try {
                            GLJPanel.this.backend.destroy();
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                        }
                        GLJPanel.this.backend = null;
                        GLJPanel.this.isInitialized = false;
                    }
                    if (null != gLException) {
                        throw gLException;
                    }
                    if (null != throwable) {
                        throw GLException.newGLException(throwable);
                    }
                }
                finally {
                    recursiveLock.unlock();
                }
            }
        }
    };
    private final Runnable updaterInitAction = new Runnable(){

        @Override
        public void run() {
            GLJPanel.this.updater.init(GLJPanel.this);
        }
    };
    private final Runnable updaterDisplayAction = new Runnable(){

        @Override
        public void run() {
            GLJPanel.this.updater.display(GLJPanel.this);
        }
    };
    private final Runnable updaterPlainDisplayAction = new Runnable(){

        @Override
        public void run() {
            GLJPanel.this.updater.plainPaint(GLJPanel.this);
        }
    };
    private final Runnable paintImmediatelyAction = new Runnable(){

        @Override
        public void run() {
            GLJPanel.this.paintImmediately(0, 0, GLJPanel.this.getWidth(), GLJPanel.this.getHeight());
        }
    };

    private static synchronized AWTGLPixelBuffer.SingleAWTGLPixelBufferProvider getSingleAWTGLPixelBufferProvider() {
        if (null == singleAWTGLPixelBufferProvider) {
            singleAWTGLPixelBufferProvider = new AWTGLPixelBuffer.SingleAWTGLPixelBufferProvider(true);
        }
        return singleAWTGLPixelBufferProvider;
    }

    private boolean oglPipelineUsable() {
        return null == this.customPixelBufferProvider && useJava2DGLPipeline && java2DGLPipelineOK;
    }

    public GLJPanel() throws GLException {
        this((GLCapabilitiesImmutable)null);
    }

    public GLJPanel(GLCapabilitiesImmutable gLCapabilitiesImmutable) throws GLException {
        this(gLCapabilitiesImmutable, null);
    }

    public GLJPanel(GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesChooser gLCapabilitiesChooser) throws GLException {
        GLCapabilities gLCapabilities = gLCapabilitiesImmutable != null ? (GLCapabilities)gLCapabilitiesImmutable.cloneMutable() : new GLCapabilities(GLProfile.getDefault(GLProfile.getDefaultDevice()));
        gLCapabilities.setDoubleBuffered(false);
        this.reqOffscreenCaps = gLCapabilities;
        this.factory = GLDrawableFactoryImpl.getFactoryImpl(this.reqOffscreenCaps.getGLProfile());
        this.chooser = gLCapabilitiesChooser;
        this.helper = new GLDrawableHelper();
        this.autoSwapBufferMode = this.helper.getAutoSwapBufferMode();
        this.setFocusable(true);
        this.addHierarchyListener(this.hierarchyListener);
        this.isShowing = this.isShowing();
    }

    public final boolean initializeBackend(boolean bl) {
        if (bl) {
            new Thread(GLJPanel.getThreadName() + "-GLJPanel_Init"){

                @Override
                public void run() {
                    if (!GLJPanel.this.isInitialized) {
                        GLJPanel.this.initializeBackendImpl();
                    }
                }
            }.start();
            return true;
        }
        if (!this.isInitialized) {
            return this.initializeBackendImpl();
        }
        return true;
    }

    @Override
    public final void setSharedContext(GLContext gLContext) throws IllegalStateException {
        this.helper.setSharedContext(this.getContext(), gLContext);
    }

    @Override
    public final void setSharedAutoDrawable(GLAutoDrawable gLAutoDrawable) throws IllegalStateException {
        this.helper.setSharedAutoDrawable(this, gLAutoDrawable);
    }

    public AWTGLPixelBuffer.AWTGLPixelBufferProvider getCustomPixelBufferProvider() {
        return this.customPixelBufferProvider;
    }

    public void setPixelBufferProvider(AWTGLPixelBuffer.AWTGLPixelBufferProvider aWTGLPixelBufferProvider) throws IllegalArgumentException, IllegalStateException {
        if (null == aWTGLPixelBufferProvider) {
            throw new IllegalArgumentException("Null PixelBufferProvider");
        }
        if (null != this.backend) {
            throw new IllegalStateException("Backend already realized.");
        }
        this.customPixelBufferProvider = aWTGLPixelBufferProvider;
    }

    @Override
    public final Object getUpstreamWidget() {
        return this;
    }

    @Override
    public final RecursiveLock getUpstreamLock() {
        return this.lock;
    }

    @Override
    public final boolean isThreadGLCapable() {
        return EventQueue.isDispatchThread();
    }

    @Override
    public void display() {
        if (this.isShowing || this.printActive && this.isVisible()) {
            if (EventQueue.isDispatchThread()) {
                this.paintImmediatelyAction.run();
            } else {
                try {
                    EventQueue.invokeAndWait(this.paintImmediatelyAction);
                }
                catch (Exception exception) {
                    throw new GLException(exception);
                }
            }
        }
    }

    protected void dispose(Runnable runnable) {
        if (DEBUG) {
            System.err.println(GLJPanel.getThreadName() + ": GLJPanel.dispose() - start");
        }
        if (this.backend != null && this.backend.getContext() != null) {
            GLAnimatorControl gLAnimatorControl = this.getAnimator();
            boolean bl = null != gLAnimatorControl ? gLAnimatorControl.pause() : false;
            if (this.backend.getContext().isCreated()) {
                Threading.invoke(true, this.disposeAction, this.getTreeLock());
            }
            if (null != this.backend) {
                this.backend.destroy();
                this.isInitialized = false;
            }
            if (null != runnable) {
                runnable.run();
            }
            if (bl) {
                gLAnimatorControl.resume();
            }
        }
        if (DEBUG) {
            System.err.println(GLJPanel.getThreadName() + ": GLJPanel.dispose() - stop");
        }
    }

    @Override
    public void destroy() {
        this.removeNotify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintComponent(Graphics graphics) {
        if (Beans.isDesignTime()) {
            int n;
            graphics.setColor(Color.BLACK);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            FontMetrics fontMetrics = graphics.getFontMetrics();
            String string = this.getName();
            if (string == null && (n = (string = this.getClass().getName()).lastIndexOf(46)) >= 0) {
                string = string.substring(n + 1);
            }
            Rectangle2D rectangle2D = fontMetrics.getStringBounds(string, graphics);
            graphics.setColor(Color.WHITE);
            graphics.drawString(string, (int)(((double)this.getWidth() - rectangle2D.getWidth()) / 2.0), (int)(((double)this.getHeight() + rectangle2D.getHeight()) / 2.0));
            return;
        }
        RecursiveLock recursiveLock = this.lock;
        recursiveLock.lock();
        try {
            if (!this.isInitialized) {
                this.initializeBackendImpl();
            }
            if (!this.isInitialized || this.printActive) {
                return;
            }
            if (!this.printActive) {
                this.updatePixelScale(this.backend);
                if (this.handleReshape) {
                    this.handleReshape = false;
                    this.sendReshape = this.handleReshape();
                }
                if (this.isShowing) {
                    this.updater.setGraphics(graphics);
                    this.backend.doPaintComponent(graphics);
                }
            }
        }
        finally {
            recursiveLock.unlock();
        }
    }

    private final void updateWrappedSurfaceScale(GLDrawable gLDrawable) {
        NativeSurface nativeSurface = gLDrawable.getNativeSurface();
        if (nativeSurface instanceof WrappedSurface) {
            ((WrappedSurface)nativeSurface).setSurfaceScale(this.hasPixelScale);
        }
    }

    @Override
    public final boolean setSurfaceScale(float[] fArray) {
        System.arraycopy(fArray, 0, this.reqPixelScale, 0, 2);
        Backend backend = this.backend;
        if (this.isInitialized && null != backend && this.isShowing) {
            if (this.isShowing || this.printActive && this.isVisible()) {
                if (EventQueue.isDispatchThread()) {
                    this.setSurfaceScaleAction.run();
                } else {
                    try {
                        EventQueue.invokeAndWait(this.setSurfaceScaleAction);
                    }
                    catch (Exception exception) {
                        throw new GLException(exception);
                    }
                }
            }
            return true;
        }
        return false;
    }

    private final boolean setSurfaceScaleImpl(Backend backend) {
        if (SurfaceScaleUtils.setNewPixelScale(this.hasPixelScale, this.hasPixelScale, this.reqPixelScale, this.minPixelScale, this.maxPixelScale, DEBUG ? this.getClass().getSimpleName() : null)) {
            this.reshapeImpl(this.getWidth(), this.getHeight());
            this.updateWrappedSurfaceScale(backend.getDrawable());
            return true;
        }
        return false;
    }

    private final boolean updatePixelScale(Backend backend) {
        if (JAWTUtil.getPixelScale(this.getGraphicsConfiguration(), this.minPixelScale, this.maxPixelScale)) {
            return this.setSurfaceScaleImpl(backend);
        }
        return false;
    }

    @Override
    public final float[] getRequestedSurfaceScale(float[] fArray) {
        System.arraycopy(this.reqPixelScale, 0, fArray, 0, 2);
        return fArray;
    }

    @Override
    public final float[] getCurrentSurfaceScale(float[] fArray) {
        System.arraycopy(this.hasPixelScale, 0, fArray, 0, 2);
        return fArray;
    }

    @Override
    public float[] getMinimumSurfaceScale(float[] fArray) {
        System.arraycopy(this.minPixelScale, 0, fArray, 0, 2);
        return fArray;
    }

    @Override
    public float[] getMaximumSurfaceScale(float[] fArray) {
        System.arraycopy(this.maxPixelScale, 0, fArray, 0, 2);
        return fArray;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.awtWindowClosingProtocol.addClosingListener();
        JAWTUtil.getPixelScale(this.getGraphicsConfiguration(), this.minPixelScale, this.maxPixelScale);
        SurfaceScaleUtils.setNewPixelScale(this.hasPixelScale, this.hasPixelScale, this.reqPixelScale, this.minPixelScale, this.maxPixelScale, DEBUG ? this.getClass().getSimpleName() : null);
        if (DEBUG) {
            System.err.println(GLJPanel.getThreadName() + ": GLJPanel.addNotify()");
        }
    }

    @Override
    public void removeNotify() {
        this.awtWindowClosingProtocol.removeClosingListener();
        this.dispose(null);
        this.hasPixelScale[0] = 1.0f;
        this.hasPixelScale[1] = 1.0f;
        this.minPixelScale[0] = 1.0f;
        this.minPixelScale[1] = 1.0f;
        this.maxPixelScale[0] = 1.0f;
        this.maxPixelScale[1] = 1.0f;
        super.removeNotify();
    }

    @Override
    public void reshape(int n, int n2, int n3, int n4) {
        super.reshape(n, n2, n3, n4);
        this.reshapeImpl(n3, n4);
    }

    private void reshapeImpl(int n, int n2) {
        int n3 = SurfaceScaleUtils.scale(n, this.hasPixelScale[0]);
        int n4 = SurfaceScaleUtils.scale(n2, this.hasPixelScale[1]);
        if (!this.printActive && (this.handleReshape || n3 != this.panelWidth || n4 != this.panelHeight)) {
            this.reshapeWidth = n3;
            this.reshapeHeight = n4;
            this.handleReshape = true;
        }
        if (DEBUG) {
            System.err.println(GLJPanel.getThreadName() + ": GLJPanel.reshape.0 " + this.getName() + " resize [" + (this.printActive ? "printing" : "paint") + "] [ this " + this.getWidth() + "x" + this.getHeight() + ", pixelScale " + this.getPixelScaleStr() + ", panel " + this.panelWidth + "x" + this.panelHeight + "] -> " + (this.handleReshape ? "" : "[skipped] ") + n + "x" + n2 + " * " + this.getPixelScaleStr() + " -> " + n3 + "x" + n4 + ", reshapeSize " + this.reshapeWidth + "x" + this.reshapeHeight);
        }
    }

    @Override
    public void setupPrint(double d, double d2, int n, int n2, int n3) {
        this.printActive = true;
        if (DEBUG) {
            System.err.printf(GLJPanel.getThreadName() + ": GLJPanel.setupPrint: scale %f / %f, samples %d, tileSz %d x %d%n", d, d2, n, n2, n3);
        }
        int n4 = this.isOpaque() ? 3 : 4;
        TileRenderer tileRenderer = new TileRenderer();
        this.printAWTTiles = new AWTTilePainter(tileRenderer, n4, d, d2, n, n2, n3, DEBUG);
        AWTEDTExecutor.singleton.invoke(this.getTreeLock(), true, true, this.setupPrintOnEDT);
    }

    @Override
    public void releasePrint() {
        if (!this.printActive) {
            throw new IllegalStateException("setupPrint() not called");
        }
        this.sendReshape = false;
        this.handleReshape = false;
        AWTEDTExecutor.singleton.invoke(this.getTreeLock(), true, true, this.releasePrintOnEDT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void print(Graphics graphics) {
        block12: {
            if (!this.printActive) {
                throw new IllegalStateException("setupPrint() not called");
            }
            if (DEBUG && !EventQueue.isDispatchThread()) {
                System.err.println(GLJPanel.getThreadName() + ": Warning: GLCanvas print - not called from AWT-EDT");
            }
            this.sendReshape = false;
            this.handleReshape = false;
            Graphics2D graphics2D = (Graphics2D)graphics;
            try {
                this.printAWTTiles.setupGraphics2DAndClipBounds(graphics2D, this.getWidth(), this.getHeight());
                TileRenderer tileRenderer = this.printAWTTiles.renderer;
                if (DEBUG) {
                    System.err.println("AWT print.0: " + tileRenderer);
                }
                if (tileRenderer.eot()) break block12;
                try {
                    do {
                        if (this.printGLAD != this) {
                            tileRenderer.display();
                            continue;
                        }
                        this.backend.doPlainPaint();
                    } while (!tileRenderer.eot());
                    if (DEBUG) {
                        System.err.println("AWT print.1: " + this.printAWTTiles);
                    }
                }
                finally {
                    tileRenderer.reset();
                    this.printAWTTiles.resetGraphics2D();
                }
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                System.err.println("Caught: Inversion failed of: " + graphics2D.getTransform());
                noninvertibleTransformException.printStackTrace();
            }
        }
        if (DEBUG) {
            System.err.println("AWT print.X: " + this.printAWTTiles);
        }
    }

    @Override
    protected void printComponent(Graphics graphics) {
        if (DEBUG) {
            System.err.println("AWT printComponent.X: " + this.printAWTTiles);
        }
        this.print(graphics);
    }

    @Override
    public void setOpaque(boolean bl) {
        if (this.backend != null) {
            this.backend.setOpaque(bl);
        }
        super.setOpaque(bl);
    }

    @Override
    public void addGLEventListener(GLEventListener gLEventListener) {
        this.helper.addGLEventListener(gLEventListener);
    }

    @Override
    public void addGLEventListener(int n, GLEventListener gLEventListener) {
        this.helper.addGLEventListener(n, gLEventListener);
    }

    @Override
    public int getGLEventListenerCount() {
        return this.helper.getGLEventListenerCount();
    }

    @Override
    public GLEventListener getGLEventListener(int n) throws IndexOutOfBoundsException {
        return this.helper.getGLEventListener(n);
    }

    @Override
    public boolean areAllGLEventListenerInitialized() {
        return this.helper.areAllGLEventListenerInitialized();
    }

    @Override
    public boolean getGLEventListenerInitState(GLEventListener gLEventListener) {
        return this.helper.getGLEventListenerInitState(gLEventListener);
    }

    @Override
    public void setGLEventListenerInitState(GLEventListener gLEventListener, boolean bl) {
        this.helper.setGLEventListenerInitState(gLEventListener, bl);
    }

    @Override
    public GLEventListener disposeGLEventListener(GLEventListener gLEventListener, boolean bl) {
        DisposeGLEventListenerAction disposeGLEventListenerAction = new DisposeGLEventListenerAction(gLEventListener, bl);
        if (EventQueue.isDispatchThread()) {
            disposeGLEventListenerAction.run();
        } else {
            try {
                EventQueue.invokeAndWait(disposeGLEventListenerAction);
            }
            catch (Exception exception) {
                throw new GLException(exception);
            }
        }
        return disposeGLEventListenerAction.listener;
    }

    @Override
    public GLEventListener removeGLEventListener(GLEventListener gLEventListener) {
        return this.helper.removeGLEventListener(gLEventListener);
    }

    @Override
    public void setAnimator(GLAnimatorControl gLAnimatorControl) {
        this.helper.setAnimator(gLAnimatorControl);
    }

    @Override
    public GLAnimatorControl getAnimator() {
        return this.helper.getAnimator();
    }

    @Override
    public final Thread setExclusiveContextThread(Thread thread) throws GLException {
        return this.helper.setExclusiveContextThread(thread, this.getContext());
    }

    @Override
    public final Thread getExclusiveContextThread() {
        return this.helper.getExclusiveContextThread();
    }

    @Override
    public boolean invoke(boolean bl, GLRunnable gLRunnable) throws IllegalStateException {
        return this.helper.invoke((GLAutoDrawable)this, bl, gLRunnable);
    }

    @Override
    public boolean invoke(boolean bl, List<GLRunnable> list) throws IllegalStateException {
        return this.helper.invoke((GLAutoDrawable)this, bl, list);
    }

    @Override
    public void flushGLRunnables() {
        this.helper.flushGLRunnables();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GLContext createContext(GLContext gLContext) {
        RecursiveLock recursiveLock = this.lock;
        recursiveLock.lock();
        try {
            Backend backend = this.backend;
            if (null == backend) {
                GLContext gLContext2 = null;
                return gLContext2;
            }
            GLContext gLContext3 = backend.createContext(gLContext);
            return gLContext3;
        }
        finally {
            recursiveLock.unlock();
        }
    }

    @Override
    public void setRealized(boolean bl) {
    }

    @Override
    public boolean isRealized() {
        return this.isInitialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GLContext setContext(GLContext gLContext, boolean bl) {
        RecursiveLock recursiveLock = this.lock;
        recursiveLock.lock();
        try {
            Backend backend = this.backend;
            if (null == backend) {
                GLContext gLContext2 = null;
                return gLContext2;
            }
            GLContext gLContext3 = backend.getContext();
            GLDrawableHelper.switchContext(backend.getDrawable(), gLContext3, bl, gLContext, this.additionalCtxCreationFlags);
            backend.setContext(gLContext);
            GLContext gLContext4 = gLContext3;
            return gLContext4;
        }
        finally {
            recursiveLock.unlock();
        }
    }

    @Override
    public final GLDrawable getDelegatedDrawable() {
        Backend backend = this.backend;
        if (null == backend) {
            return null;
        }
        return backend.getDrawable();
    }

    @Override
    public GLContext getContext() {
        Backend backend = this.backend;
        if (null == backend) {
            return null;
        }
        return backend.getContext();
    }

    @Override
    public GL getGL() {
        if (Beans.isDesignTime()) {
            return null;
        }
        GLContext gLContext = this.getContext();
        return gLContext == null ? null : gLContext.getGL();
    }

    @Override
    public GL setGL(GL gL) {
        GLContext gLContext = this.getContext();
        if (gLContext != null) {
            gLContext.setGL(gL);
            return gL;
        }
        return null;
    }

    @Override
    public void setAutoSwapBufferMode(boolean bl) {
        Backend backend;
        this.autoSwapBufferMode = bl;
        boolean bl2 = false;
        if (this.isInitialized && null != (backend = this.backend)) {
            bl2 = backend.handlesSwapBuffer();
        }
        if (!bl2) {
            this.helper.setAutoSwapBufferMode(bl);
        }
    }

    @Override
    public boolean getAutoSwapBufferMode() {
        return this.autoSwapBufferMode;
    }

    @Override
    public void swapBuffers() {
        Backend backend;
        if (this.isInitialized && null != (backend = this.backend)) {
            backend.swapBuffers();
        }
    }

    @Override
    public void setContextCreationFlags(int n) {
        this.additionalCtxCreationFlags = n;
    }

    @Override
    public int getContextCreationFlags() {
        return this.additionalCtxCreationFlags;
    }

    public boolean shouldPreserveColorBufferIfTranslucent() {
        return this.oglPipelineUsable();
    }

    @Override
    public int getSurfaceWidth() {
        return this.panelWidth;
    }

    @Override
    public int getSurfaceHeight() {
        return this.panelHeight;
    }

    @Override
    public boolean isGLOriented() {
        Backend backend = this.backend;
        if (null == backend) {
            return true;
        }
        return backend.getDrawable().isGLOriented();
    }

    public final void setSkipGLOrientationVerticalFlip(boolean bl) {
        this.skipGLOrientationVerticalFlip = bl;
    }

    public final boolean getSkipGLOrientationVerticalFlip() {
        return this.skipGLOrientationVerticalFlip;
    }

    @Override
    public GLCapabilitiesImmutable getChosenGLCapabilities() {
        Backend backend = this.backend;
        if (null == backend) {
            return null;
        }
        return backend.getChosenGLCapabilities();
    }

    @Override
    public final GLCapabilitiesImmutable getRequestedGLCapabilities() {
        return this.reqOffscreenCaps;
    }

    public final void setRequestedGLCapabilities(final GLCapabilitiesImmutable gLCapabilitiesImmutable) {
        if (null == gLCapabilitiesImmutable) {
            throw new IllegalArgumentException("null caps");
        }
        Threading.invoke(true, new Runnable(){

            @Override
            public void run() {
                GLJPanel.this.dispose(new Runnable(){

                    @Override
                    public void run() {
                        GLJPanel.this.reqOffscreenCaps = gLCapabilitiesImmutable;
                        GLJPanel.this.initializeBackendImpl();
                    }
                });
            }
        }, this.getTreeLock());
    }

    @Override
    public final GLProfile getGLProfile() {
        return this.reqOffscreenCaps.getGLProfile();
    }

    @Override
    public NativeSurface getNativeSurface() {
        Backend backend = this.backend;
        if (null == backend) {
            return null;
        }
        return backend.getDrawable().getNativeSurface();
    }

    @Override
    public long getHandle() {
        Backend backend = this.backend;
        if (null == backend) {
            return 0L;
        }
        return backend.getDrawable().getNativeSurface().getSurfaceHandle();
    }

    @Override
    public final GLDrawableFactory getFactory() {
        return this.factory;
    }

    public final int getTextureUnit() {
        Backend backend = this.backend;
        if (null == backend) {
            return -1;
        }
        return backend.getTextureUnit();
    }

    public final void setTextureUnit(int n) {
        this.requestedTextureUnit = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initializeBackendImpl() {
        Object object = this.initSync;
        synchronized (object) {
            if (!this.isInitialized) {
                if (this.handleReshape) {
                    if (DEBUG) {
                        System.err.println(GLJPanel.getThreadName() + ": GLJPanel.createAndInitializeBackend.1: [" + (this.printActive ? "printing" : "paint") + "] " + this.panelWidth + "x" + this.panelHeight + " @ scale " + this.getPixelScaleStr() + " -> " + this.reshapeWidth + "x" + this.reshapeHeight + " @ scale " + this.getPixelScaleStr());
                    }
                    this.panelWidth = this.reshapeWidth;
                    this.panelHeight = this.reshapeHeight;
                    this.handleReshape = false;
                } else if (DEBUG) {
                    System.err.println(GLJPanel.getThreadName() + ": GLJPanel.createAndInitializeBackend.0: [" + (this.printActive ? "printing" : "paint") + "] " + this.panelWidth + "x" + this.panelHeight + " @ scale " + this.getPixelScaleStr());
                }
                if (0 >= this.panelWidth || 0 >= this.panelHeight) {
                    return false;
                }
                if (null == this.backend) {
                    this.backend = this.oglPipelineUsable() ? new J2DOGLBackend() : new OffscreenBackend(this.customPixelBufferProvider);
                    this.isInitialized = false;
                }
                if (!this.isInitialized) {
                    this.factory = GLDrawableFactoryImpl.getFactoryImpl(this.reqOffscreenCaps.getGLProfile());
                    this.backend.initialize();
                }
                return this.isInitialized;
            }
            return true;
        }
    }

    private final String getPixelScaleStr() {
        return "[" + this.hasPixelScale[0] + ", " + this.hasPixelScale[1] + "]";
    }

    @Override
    public WindowClosingProtocol.WindowClosingMode getDefaultCloseOperation() {
        return this.awtWindowClosingProtocol.getDefaultCloseOperation();
    }

    @Override
    public WindowClosingProtocol.WindowClosingMode setDefaultCloseOperation(WindowClosingProtocol.WindowClosingMode windowClosingMode) {
        return this.awtWindowClosingProtocol.setDefaultCloseOperation(windowClosingMode);
    }

    private boolean handleReshape() {
        if (DEBUG) {
            System.err.println(GLJPanel.getThreadName() + ": GLJPanel.handleReshape: " + this.panelWidth + "x" + this.panelHeight + " @ scale " + this.getPixelScaleStr() + " -> " + this.reshapeWidth + "x" + this.reshapeHeight + " @ scale " + this.getPixelScaleStr());
        }
        this.panelWidth = this.reshapeWidth;
        this.panelHeight = this.reshapeHeight;
        return this.backend.handleReshape();
    }

    @Override
    public String toString() {
        GLDrawable gLDrawable = null != this.backend ? this.backend.getDrawable() : null;
        return "AWT-GLJPanel[ drawableType " + (null != gLDrawable ? gLDrawable.getClass().getName() : "null") + ", chosenCaps " + this.getChosenGLCapabilities() + "]";
    }

    private int getGLInteger(GL gL, int n) {
        int[] nArray = new int[1];
        gL.glGetIntegerv(n, nArray, 0);
        return nArray[0];
    }

    protected static String getThreadName() {
        return Thread.currentThread().getName();
    }

    static {
        Debug.initSingleton();
        DEBUG = Debug.debug("GLJPanel");
        DEBUG_FRAMES = PropertyAccess.isPropertyDefined((String)"jogl.debug.GLJPanel.Frames", (boolean)true);
        DEBUG_VIEWPORT = PropertyAccess.isPropertyDefined((String)"jogl.debug.GLJPanel.Viewport", (boolean)true);
        USE_GLSL_TEXTURE_RASTERIZER = !PropertyAccess.isPropertyDefined((String)"jogl.gljpanel.noglsl", (boolean)true);
        SKIP_VERTICAL_FLIP_DEFAULT = PropertyAccess.isPropertyDefined((String)"jogl.gljpanel.noverticalflip", (boolean)true);
        boolean bl = PropertyAccess.getBooleanProperty((String)"sun.java2d.opengl", (boolean)false);
        java2dOGLEnabledByProp = bl && !PropertyAccess.isPropertyDefined((String)"jogl.gljpanel.noogl", (boolean)true);
        bl = false;
        if (java2dOGLEnabledByProp && Java2D.isOGLPipelineResourceCompatible() && Java2D.isFBOEnabled() && null != Java2D.getShareContext(GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice())) {
            bl = true;
        }
        useJava2DGLPipeline = bl;
        java2DGLPipelineOK = bl;
        if (DEBUG) {
            System.err.println("GLJPanel: DEBUG_VIEWPORT " + DEBUG_VIEWPORT);
            System.err.println("GLJPanel: USE_GLSL_TEXTURE_RASTERIZER " + USE_GLSL_TEXTURE_RASTERIZER);
            System.err.println("GLJPanel: SKIP_VERTICAL_FLIP_DEFAULT " + SKIP_VERTICAL_FLIP_DEFAULT);
            System.err.println("GLJPanel: java2dOGLEnabledByProp " + java2dOGLEnabledByProp);
            System.err.println("GLJPanel: useJava2DGLPipeline " + useJava2DGLPipeline);
            System.err.println("GLJPanel: java2DGLPipelineOK " + java2DGLPipelineOK);
        }
        singleAWTGLPixelBufferProvider = null;
    }

    class J2DOGLBackend
    implements Backend {
        private Object j2dSurface;
        private GLContext j2dContext;
        private GLDrawable joglDrawable;
        private GLContext joglContext;
        private final int[] drawBuffer = new int[1];
        private final int[] readBuffer = new int[1];
        private final int[] frameBuffer = new int[1];
        private boolean checkedForFBObjectWorkarounds;
        private boolean fbObjectWorkarounds;
        private int[] frameBufferDepthBuffer;
        private int[] frameBufferTexture;
        private boolean createNewDepthBuffer;
        private boolean checkedGLVendor;
        private boolean vendorIsATI;
        private GraphicsConfiguration workaroundConfig;

        J2DOGLBackend() {
        }

        @Override
        public final boolean isUsingOwnLifecycle() {
            return true;
        }

        @Override
        public final void initialize() {
            if (DEBUG) {
                System.err.println(GLJPanel.getThreadName() + ": J2DOGL: initialize()");
            }
            GLJPanel.this.isInitialized = true;
        }

        @Override
        public final void destroy() {
            Java2D.invokeWithOGLContextCurrent(null, new Runnable(){

                @Override
                public void run() {
                    if (DEBUG) {
                        System.err.println(GLJPanel.getThreadName() + ": J2DOGL: destroy() - joglContext: " + (null != J2DOGLBackend.this.joglContext) + " - joglDrawable: " + (null != J2DOGLBackend.this.joglDrawable));
                    }
                    if (J2DOGLBackend.this.joglContext != null) {
                        J2DOGLBackend.this.joglContext.destroy();
                        J2DOGLBackend.this.joglContext = null;
                    }
                    J2DOGLBackend.this.joglDrawable = null;
                    if (J2DOGLBackend.this.j2dContext != null) {
                        J2DOGLBackend.this.j2dContext.destroy();
                        J2DOGLBackend.this.j2dContext = null;
                    }
                }
            });
        }

        @Override
        public final void setOpaque(boolean bl) {
        }

        @Override
        public final GLContext createContext(GLContext gLContext) {
            if (null != gLContext) {
                throw new GLException("J2DOGLBackend cannot create context w/ additional shared context, since it already needs to share the context w/ J2D.");
            }
            return null != this.joglDrawable && null != this.j2dContext ? this.joglDrawable.createContext(this.j2dContext) : null;
        }

        @Override
        public final void setContext(GLContext gLContext) {
            this.joglContext = gLContext;
        }

        @Override
        public final GLContext getContext() {
            return this.joglContext;
        }

        @Override
        public final GLDrawable getDrawable() {
            return this.joglDrawable;
        }

        @Override
        public final int getTextureUnit() {
            return -1;
        }

        @Override
        public final GLCapabilitiesImmutable getChosenGLCapabilities() {
            return new GLCapabilities(null);
        }

        @Override
        public final GLProfile getGLProfile() {
            return GLProfile.getDefault(GLProfile.getDefaultDevice());
        }

        @Override
        public final boolean handleReshape() {
            return true;
        }

        @Override
        public final boolean preGL(Graphics graphics) {
            GL2 gL2 = this.joglContext.getGL().getGL2();
            gL2.glEnable(3089);
            Rectangle rectangle = Java2D.getOGLScissorBox(graphics);
            if (rectangle == null) {
                if (DEBUG) {
                    System.err.println(GLJPanel.getThreadName() + ": Java2D.getOGLScissorBox() returned null");
                }
                return false;
            }
            if (DEBUG) {
                System.err.println(GLJPanel.getThreadName() + ": GLJPanel: gl.glScissor(" + rectangle.x + ", " + rectangle.y + ", " + rectangle.width + ", " + rectangle.height + ")");
            }
            gL2.glScissor(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            Rectangle rectangle2 = Java2D.getOGLViewport(graphics, GLJPanel.this.panelWidth, GLJPanel.this.panelHeight);
            if (GLJPanel.this.viewportX != rectangle2.x || GLJPanel.this.viewportY != rectangle2.y) {
                GLJPanel.this.sendReshape = true;
                if (DEBUG) {
                    System.err.println(GLJPanel.getThreadName() + ": Sending reshape because viewport changed");
                    System.err.println("  viewportX (" + GLJPanel.this.viewportX + ") ?= oglViewport.x (" + rectangle2.x + ")");
                    System.err.println("  viewportY (" + GLJPanel.this.viewportY + ") ?= oglViewport.y (" + rectangle2.y + ")");
                }
            }
            GLJPanel.this.viewportX = rectangle2.x;
            GLJPanel.this.viewportY = rectangle2.y;
            if (Java2D.isFBOEnabled() && Java2D.getOGLSurfaceType(graphics) == Java2D.FBOBJECT) {
                int n;
                int n2 = Java2D.getOGLTextureType(graphics);
                if (!this.checkedForFBObjectWorkarounds) {
                    this.checkedForFBObjectWorkarounds = true;
                    gL2.glBindTexture(n2, 0);
                    gL2.glBindFramebuffer(36160, this.frameBuffer[0]);
                    n = gL2.glCheckFramebufferStatus(36160);
                    if (n != 36053) {
                        this.fbObjectWorkarounds = true;
                        this.createNewDepthBuffer = true;
                        if (DEBUG) {
                            System.err.println(GLJPanel.getThreadName() + ": GLJPanel: ERR GL_FRAMEBUFFER_BINDING: Discovered Invalid J2D FBO(" + this.frameBuffer[0] + "): " + FBObject.getStatusString(n) + ", frame_buffer_object workarounds to be necessary");
                        }
                    } else {
                        this.frameBufferTexture = null;
                        if (DEBUG) {
                            System.err.println(GLJPanel.getThreadName() + ": GLJPanel: OK GL_FRAMEBUFFER_BINDING: " + this.frameBuffer[0]);
                        }
                    }
                }
                if (this.fbObjectWorkarounds && this.createNewDepthBuffer) {
                    if (this.frameBufferDepthBuffer == null) {
                        this.frameBufferDepthBuffer = new int[1];
                    }
                    if (this.frameBufferDepthBuffer[0] != 0) {
                        gL2.glDeleteRenderbuffers(1, this.frameBufferDepthBuffer, 0);
                        this.frameBufferDepthBuffer[0] = 0;
                    }
                    gL2.glBindTexture(n2, this.frameBufferTexture[0]);
                    int[] nArray = new int[1];
                    int[] nArray2 = new int[1];
                    gL2.glGetTexLevelParameteriv(n2, 0, 4096, nArray, 0);
                    gL2.glGetTexLevelParameteriv(n2, 0, 4097, nArray2, 0);
                    gL2.glGenRenderbuffers(1, this.frameBufferDepthBuffer, 0);
                    if (DEBUG) {
                        System.err.println(GLJPanel.getThreadName() + ": GLJPanel: Generated frameBufferDepthBuffer " + this.frameBufferDepthBuffer[0] + " with width " + nArray[0] + ", height " + nArray2[0]);
                    }
                    gL2.glBindRenderbuffer(36161, this.frameBufferDepthBuffer[0]);
                    gL2.glRenderbufferStorage(36161, 33190, nArray[0], nArray2[0]);
                    gL2.glBindRenderbuffer(36161, 0);
                    this.createNewDepthBuffer = false;
                }
                gL2.glBindTexture(n2, 0);
                gL2.glBindFramebuffer(36160, this.frameBuffer[0]);
                if (this.fbObjectWorkarounds) {
                    gL2.glFramebufferTexture2D(36160, 36064, n2, this.frameBufferTexture[0], 0);
                    if (DEBUG) {
                        System.err.println(GLJPanel.getThreadName() + ": GLJPanel: frameBufferDepthBuffer: " + this.frameBufferDepthBuffer[0]);
                    }
                    gL2.glFramebufferRenderbuffer(36160, 36096, 36161, this.frameBufferDepthBuffer[0]);
                }
                if (DEBUG && (n = gL2.glCheckFramebufferStatus(36160)) != 36053) {
                    throw new GLException("Error: framebuffer was incomplete: status = 0x" + Integer.toHexString(n));
                }
            } else {
                if (DEBUG) {
                    System.err.println(GLJPanel.getThreadName() + ": GLJPanel: Setting up drawBuffer " + this.drawBuffer[0] + " and readBuffer " + this.readBuffer[0]);
                }
                gL2.glDrawBuffer(this.drawBuffer[0]);
                gL2.glReadBuffer(this.readBuffer[0]);
            }
            return true;
        }

        @Override
        public final boolean handlesSwapBuffer() {
            return false;
        }

        @Override
        public final void swapBuffers() {
            GLDrawable gLDrawable = this.joglDrawable;
            if (null != gLDrawable) {
                gLDrawable.swapBuffers();
            }
        }

        @Override
        public final void postGL(Graphics graphics, boolean bl) {
            GL gL = this.joglContext.getGL();
            gL.glFinish();
            if (Java2D.isFBOEnabled() && Java2D.getOGLSurfaceType(graphics) == Java2D.FBOBJECT) {
                gL.glBindFramebuffer(36160, 0);
            }
        }

        @Override
        public final void doPaintComponent(final Graphics graphics) {
            if (Java2D.isFBOEnabled()) {
                if (this.workaroundConfig == null) {
                    this.workaroundConfig = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
                }
                Java2D.invokeWithOGLSharedContextCurrent(this.workaroundConfig, new Runnable(){

                    @Override
                    public void run() {
                    }
                });
            }
            Java2D.invokeWithOGLContextCurrent(graphics, new Runnable(){

                @Override
                public void run() {
                    Object object;
                    if (DEBUG) {
                        System.err.println(GLJPanel.getThreadName() + ": GLJPanel.invokeWithOGLContextCurrent");
                    }
                    if (J2DOGLBackend.this.j2dContext == null) {
                        J2DOGLBackend.this.j2dContext = GLJPanel.this.factory.createExternalGLContext();
                        if (DEBUG) {
                            System.err.println(GLJPanel.getThreadName() + ": GLJPanel.Created External Context: " + J2DOGLBackend.this.j2dContext);
                        }
                        if (DEBUG) {
                            // empty if block
                        }
                        J2DOGLBackend.this.j2dContext.makeCurrent();
                        object = J2DOGLBackend.this.j2dContext.getGL();
                        if (GLJPanel.this.getGLInteger((GL)object, 3410) < GLJPanel.this.reqOffscreenCaps.getRedBits() || GLJPanel.this.getGLInteger((GL)object, 3411) < GLJPanel.this.reqOffscreenCaps.getGreenBits() || GLJPanel.this.getGLInteger((GL)object, 3412) < GLJPanel.this.reqOffscreenCaps.getBlueBits() || GLJPanel.this.getGLInteger((GL)object, 3416) < GLJPanel.this.reqOffscreenCaps.getAccumRedBits() || GLJPanel.this.getGLInteger((GL)object, 3417) < GLJPanel.this.reqOffscreenCaps.getAccumGreenBits() || GLJPanel.this.getGLInteger((GL)object, 3418) < GLJPanel.this.reqOffscreenCaps.getAccumBlueBits() || GLJPanel.this.getGLInteger((GL)object, 3419) < GLJPanel.this.reqOffscreenCaps.getAccumAlphaBits() || GLJPanel.this.getGLInteger((GL)object, 3415) < GLJPanel.this.reqOffscreenCaps.getStencilBits()) {
                            if (DEBUG) {
                                System.err.println(GLJPanel.getThreadName() + ": GLJPanel: Falling back to pbuffer-based support because Java2D context insufficient");
                                System.err.println("                    Available              Required");
                                System.err.println("GL_RED_BITS         " + GLJPanel.this.getGLInteger((GL)object, 3410) + "              " + GLJPanel.this.reqOffscreenCaps.getRedBits());
                                System.err.println("GL_GREEN_BITS       " + GLJPanel.this.getGLInteger((GL)object, 3411) + "              " + GLJPanel.this.reqOffscreenCaps.getGreenBits());
                                System.err.println("GL_BLUE_BITS        " + GLJPanel.this.getGLInteger((GL)object, 3412) + "              " + GLJPanel.this.reqOffscreenCaps.getBlueBits());
                                System.err.println("GL_ALPHA_BITS       " + GLJPanel.this.getGLInteger((GL)object, 3413) + "              " + GLJPanel.this.reqOffscreenCaps.getAlphaBits());
                                System.err.println("GL_ACCUM_RED_BITS   " + GLJPanel.this.getGLInteger((GL)object, 3416) + "              " + GLJPanel.this.reqOffscreenCaps.getAccumRedBits());
                                System.err.println("GL_ACCUM_GREEN_BITS " + GLJPanel.this.getGLInteger((GL)object, 3417) + "              " + GLJPanel.this.reqOffscreenCaps.getAccumGreenBits());
                                System.err.println("GL_ACCUM_BLUE_BITS  " + GLJPanel.this.getGLInteger((GL)object, 3418) + "              " + GLJPanel.this.reqOffscreenCaps.getAccumBlueBits());
                                System.err.println("GL_ACCUM_ALPHA_BITS " + GLJPanel.this.getGLInteger((GL)object, 3419) + "              " + GLJPanel.this.reqOffscreenCaps.getAccumAlphaBits());
                                System.err.println("GL_DEPTH_BITS       " + GLJPanel.this.getGLInteger((GL)object, 3414) + "              " + GLJPanel.this.reqOffscreenCaps.getDepthBits());
                                System.err.println("GL_STENCIL_BITS     " + GLJPanel.this.getGLInteger((GL)object, 3415) + "              " + GLJPanel.this.reqOffscreenCaps.getStencilBits());
                            }
                            GLJPanel.this.isInitialized = false;
                            GLJPanel.this.backend = null;
                            java2DGLPipelineOK = false;
                            GLJPanel.this.handleReshape = true;
                            J2DOGLBackend.this.j2dContext.destroy();
                            J2DOGLBackend.this.j2dContext = null;
                            return;
                        }
                    } else {
                        J2DOGLBackend.this.j2dContext.makeCurrent();
                    }
                    try {
                        J2DOGLBackend.this.captureJ2DState(J2DOGLBackend.this.j2dContext.getGL(), graphics);
                        object = Java2D.getOGLSurfaceIdentifier(graphics);
                        if (object != null) {
                            if (J2DOGLBackend.this.j2dSurface != object) {
                                if (J2DOGLBackend.this.joglContext != null) {
                                    J2DOGLBackend.this.joglContext.destroy();
                                    J2DOGLBackend.this.joglContext = null;
                                    J2DOGLBackend.this.joglDrawable = null;
                                    GLJPanel.this.sendReshape = true;
                                    if (DEBUG) {
                                        System.err.println(GLJPanel.getThreadName() + ": Sending reshape because surface changed");
                                        System.err.println("New surface = " + object);
                                    }
                                }
                                J2DOGLBackend.this.j2dSurface = object;
                                if (DEBUG) {
                                    System.err.print(GLJPanel.getThreadName() + ": Surface type: ");
                                    int n = Java2D.getOGLSurfaceType(graphics);
                                    if (n == Java2D.UNDEFINED) {
                                        System.err.println("UNDEFINED");
                                    } else if (n == Java2D.WINDOW) {
                                        System.err.println("WINDOW");
                                    } else if (n == Java2D.PBUFFER) {
                                        System.err.println("PBUFFER");
                                    } else if (n == Java2D.TEXTURE) {
                                        System.err.println("TEXTURE");
                                    } else if (n == Java2D.FLIP_BACKBUFFER) {
                                        System.err.println("FLIP_BACKBUFFER");
                                    } else if (n == Java2D.FBOBJECT) {
                                        System.err.println("FBOBJECT");
                                    } else {
                                        System.err.println("(Unknown surface type " + n + ")");
                                    }
                                }
                            }
                            if (J2DOGLBackend.this.joglContext == null) {
                                AbstractGraphicsDevice abstractGraphicsDevice = J2DOGLBackend.this.j2dContext.getGLDrawable().getNativeSurface().getGraphicsConfiguration().getScreen().getDevice();
                                if (GLJPanel.this.factory.canCreateExternalGLDrawable(abstractGraphicsDevice)) {
                                    J2DOGLBackend.this.joglDrawable = GLJPanel.this.factory.createExternalGLDrawable();
                                    J2DOGLBackend.this.joglContext = J2DOGLBackend.this.joglDrawable.createContext(J2DOGLBackend.this.j2dContext);
                                    if (DEBUG) {
                                        System.err.println("-- Created External Drawable: " + J2DOGLBackend.this.joglDrawable);
                                        System.err.println("-- Created Context: " + J2DOGLBackend.this.joglContext);
                                    }
                                }
                                if (Java2D.isFBOEnabled() && Java2D.getOGLSurfaceType(graphics) == Java2D.FBOBJECT && J2DOGLBackend.this.fbObjectWorkarounds) {
                                    J2DOGLBackend.this.createNewDepthBuffer = true;
                                }
                            }
                            GLJPanel.this.helper.invokeGL(J2DOGLBackend.this.joglDrawable, J2DOGLBackend.this.joglContext, GLJPanel.this.updaterDisplayAction, GLJPanel.this.updaterInitAction);
                        }
                    }
                    finally {
                        J2DOGLBackend.this.j2dContext.release();
                    }
                }
            });
        }

        @Override
        public final void doPlainPaint() {
            GLJPanel.this.helper.invokeGL(this.joglDrawable, this.joglContext, GLJPanel.this.updaterPlainDisplayAction, GLJPanel.this.updaterInitAction);
        }

        private final void captureJ2DState(GL gL, Graphics graphics) {
            gL.glGetIntegerv(3073, this.drawBuffer, 0);
            gL.glGetIntegerv(3074, this.readBuffer, 0);
            if (Java2D.isFBOEnabled() && Java2D.getOGLSurfaceType(graphics) == Java2D.FBOBJECT) {
                gL.glGetIntegerv(36006, this.frameBuffer, 0);
                if (!gL.glIsFramebuffer(this.frameBuffer[0])) {
                    this.checkedForFBObjectWorkarounds = true;
                    this.fbObjectWorkarounds = true;
                    this.createNewDepthBuffer = true;
                    if (DEBUG) {
                        System.err.println(GLJPanel.getThreadName() + ": GLJPanel: Fetched ERR GL_FRAMEBUFFER_BINDING: " + this.frameBuffer[0] + " - NOT A FBO" + ", frame_buffer_object workarounds to be necessary");
                    }
                } else if (DEBUG) {
                    System.err.println(GLJPanel.getThreadName() + ": GLJPanel: Fetched OK GL_FRAMEBUFFER_BINDING: " + this.frameBuffer[0]);
                }
                if (this.fbObjectWorkarounds || !this.checkedForFBObjectWorkarounds) {
                    if (this.frameBufferTexture == null) {
                        this.frameBufferTexture = new int[1];
                    }
                    gL.glGetFramebufferAttachmentParameteriv(36160, 36064, 36049, this.frameBufferTexture, 0);
                    if (DEBUG) {
                        System.err.println(GLJPanel.getThreadName() + ": GLJPanel: FBO COLOR_ATTACHMENT0: " + this.frameBufferTexture[0]);
                    }
                }
                if (!this.checkedGLVendor) {
                    this.checkedGLVendor = true;
                    String string = gL.glGetString(7936);
                    if (string != null && string.startsWith("ATI")) {
                        this.vendorIsATI = true;
                    }
                }
                if (this.vendorIsATI) {
                    gL.glBindFramebuffer(36160, 0);
                }
            }
        }
    }

    class OffscreenBackend
    implements Backend {
        private final AWTGLPixelBuffer.AWTGLPixelBufferProvider pixelBufferProvider;
        private final boolean useSingletonBuffer;
        private AWTGLPixelBuffer pixelBuffer;
        private BufferedImage alignedImage;
        protected IntBuffer readBackIntsForCPUVFlip;
        private volatile GLDrawable offscreenDrawable;
        private boolean offscreenIsFBO;
        private FBObject fboFlipped;
        private GLSLTextureRaster glslTextureRaster;
        private volatile GLContextImpl offscreenContext;
        private boolean flipVertical;
        private int frameCount = 0;
        private final GLPixelStorageModes psm = new GLPixelStorageModes();

        OffscreenBackend(AWTGLPixelBuffer.AWTGLPixelBufferProvider aWTGLPixelBufferProvider) {
            this.pixelBufferProvider = null == aWTGLPixelBufferProvider ? GLJPanel.getSingleAWTGLPixelBufferProvider() : aWTGLPixelBufferProvider;
            this.useSingletonBuffer = this.pixelBufferProvider instanceof GLPixelBuffer.SingletonGLPixelBufferProvider;
        }

        @Override
        public final boolean isUsingOwnLifecycle() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void initialize() {
            block22: {
                if (DEBUG) {
                    System.err.println(GLJPanel.getThreadName() + ": OffscreenBackend: initialize() - frameCount " + this.frameCount);
                }
                GLException gLException = null;
                try {
                    boolean bl;
                    GLContext[] gLContextArray = new GLContext[]{null};
                    if (GLJPanel.this.helper.isSharedGLContextPending(gLContextArray)) {
                        return;
                    }
                    this.offscreenDrawable = GLJPanel.this.factory.createOffscreenDrawable(null, GLJPanel.this.reqOffscreenCaps, GLJPanel.this.chooser, GLJPanel.this.panelWidth, GLJPanel.this.panelHeight);
                    GLJPanel.this.updateWrappedSurfaceScale(this.offscreenDrawable);
                    this.offscreenDrawable.setRealized(true);
                    if (DEBUG_FRAMES) {
                        this.offscreenDrawable.getNativeSurface().addSurfaceUpdatedListener(new SurfaceUpdatedListener(){

                            @Override
                            public final void surfaceUpdated(Object object, NativeSurface nativeSurface, long l) {
                                System.err.println(GLJPanel.getThreadName() + ": OffscreenBackend.swapBuffers - frameCount " + OffscreenBackend.this.frameCount);
                            }
                        });
                    }
                    this.flipVertical = !GLJPanel.this.skipGLOrientationVerticalFlip && this.offscreenDrawable.isGLOriented();
                    this.offscreenIsFBO = this.offscreenDrawable.getRequestedGLCapabilities().isFBO();
                    boolean bl2 = bl = this.flipVertical && this.offscreenIsFBO && GLJPanel.this.reqOffscreenCaps.getGLProfile().isGL2ES2() && USE_GLSL_TEXTURE_RASTERIZER;
                    if (this.offscreenIsFBO && !bl) {
                        ((GLFBODrawable)this.offscreenDrawable).setFBOMode(0);
                    }
                    this.offscreenContext = (GLContextImpl)this.offscreenDrawable.createContext(gLContextArray[0]);
                    this.offscreenContext.setContextCreationFlags(GLJPanel.this.additionalCtxCreationFlags);
                    if (0 < this.offscreenContext.makeCurrent()) {
                        boolean bl3;
                        GLJPanel.this.isInitialized = true;
                        GLJPanel.this.helper.setAutoSwapBufferMode(false);
                        GL gL = this.offscreenContext.getGL();
                        GLCapabilitiesImmutable gLCapabilitiesImmutable = this.offscreenDrawable.getChosenGLCapabilities();
                        boolean bl4 = !this.offscreenContext.hasRendererQuirk(12);
                        boolean bl5 = bl3 = bl && gL.isGL2ES2() && bl4;
                        if (DEBUG) {
                            System.err.println(GLJPanel.getThreadName() + ": OffscreenBackend.initialize: useGLSLFlip " + bl3 + " [flip " + this.flipVertical + ", isFBO " + this.offscreenIsFBO + ", isGL2ES2 " + gL.isGL2ES2() + ", noglsl " + !USE_GLSL_TEXTURE_RASTERIZER + ", glslNonCompliant " + !bl4 + ", isGL2ES2 " + gL.isGL2ES2() + "\n " + this.offscreenDrawable + "]");
                        }
                        if (bl3) {
                            GLFBODrawable gLFBODrawable = (GLFBODrawable)this.offscreenDrawable;
                            gLFBODrawable.setTextureUnit(GLJPanel.this.requestedTextureUnit);
                            try {
                                this.fboFlipped = new FBObject();
                                this.fboFlipped.init(gL, GLJPanel.this.panelWidth, GLJPanel.this.panelHeight, 0);
                                this.fboFlipped.attachColorbuffer(gL, 0, gLCapabilitiesImmutable.getAlphaBits() > 0);
                                gL.glClear(16384);
                                this.glslTextureRaster = new GLSLTextureRaster(gLFBODrawable.getTextureUnit(), true);
                                this.glslTextureRaster.init(gL.getGL2ES2());
                                this.glslTextureRaster.reshape(gL.getGL2ES2(), 0, 0, GLJPanel.this.panelWidth, GLJPanel.this.panelHeight);
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                                if (null != this.glslTextureRaster) {
                                    this.glslTextureRaster.dispose(gL.getGL2ES2());
                                    this.glslTextureRaster = null;
                                }
                                if (null != this.fboFlipped) {
                                    this.fboFlipped.destroy(gL);
                                    this.fboFlipped = null;
                                }
                            }
                        } else {
                            this.fboFlipped = null;
                            this.glslTextureRaster = null;
                        }
                        this.offscreenContext.release();
                    } else {
                        GLJPanel.this.isInitialized = false;
                    }
                }
                catch (GLException gLException2) {
                    gLException = gLException2;
                }
                finally {
                    if (!GLJPanel.this.isInitialized) {
                        if (null != this.offscreenContext) {
                            this.offscreenContext.destroy();
                            this.offscreenContext = null;
                        }
                        if (null != this.offscreenDrawable) {
                            this.offscreenDrawable.setRealized(false);
                            this.offscreenDrawable = null;
                        }
                    }
                    if (null == gLException) break block22;
                    throw new GLException("Caught GLException: " + gLException.getMessage(), gLException);
                }
            }
        }

        @Override
        public final void destroy() {
            Object object;
            if (DEBUG) {
                System.err.println(GLJPanel.getThreadName() + ": OffscreenBackend: destroy() - offscreenContext: " + (null != this.offscreenContext) + " - offscreenDrawable: " + (null != this.offscreenDrawable) + " - frameCount " + this.frameCount);
            }
            if (null != this.offscreenContext && this.offscreenContext.isCreated() && 0 < this.offscreenContext.makeCurrent()) {
                try {
                    object = this.offscreenContext.getGL();
                    if (null != this.glslTextureRaster) {
                        this.glslTextureRaster.dispose(object.getGL2ES2());
                    }
                    if (null != this.fboFlipped) {
                        this.fboFlipped.destroy((GL)object);
                    }
                }
                finally {
                    this.offscreenContext.destroy();
                }
            }
            this.offscreenContext = null;
            this.glslTextureRaster = null;
            this.fboFlipped = null;
            this.offscreenContext = null;
            if (this.offscreenDrawable != null) {
                object = this.offscreenDrawable.getNativeSurface().getGraphicsConfiguration().getScreen().getDevice();
                this.offscreenDrawable.setRealized(false);
                this.offscreenDrawable = null;
                if (null != object) {
                    object.close();
                }
            }
            this.offscreenIsFBO = false;
            if (null != this.readBackIntsForCPUVFlip) {
                this.readBackIntsForCPUVFlip.clear();
                this.readBackIntsForCPUVFlip = null;
            }
            if (null != this.pixelBuffer) {
                if (!this.useSingletonBuffer) {
                    this.pixelBuffer.dispose();
                }
                this.pixelBuffer = null;
            }
            this.alignedImage = null;
        }

        @Override
        public final void setOpaque(boolean bl) {
            if (bl != GLJPanel.this.isOpaque() && !this.useSingletonBuffer) {
                this.pixelBuffer.dispose();
                this.pixelBuffer = null;
                this.alignedImage = null;
            }
        }

        @Override
        public final boolean preGL(Graphics graphics) {
            return true;
        }

        @Override
        public final boolean handlesSwapBuffer() {
            return true;
        }

        @Override
        public final void swapBuffers() {
            GLDrawable gLDrawable = this.offscreenDrawable;
            if (null != gLDrawable) {
                gLDrawable.swapBuffers();
            }
        }

        @Override
        public final void postGL(Graphics graphics, boolean bl) {
            if (bl) {
                Object object;
                IntBuffer intBuffer;
                boolean bl2;
                int n;
                int n2;
                TextureState textureState;
                TextureState textureState2;
                int n3;
                if (DEBUG_FRAMES) {
                    System.err.println(GLJPanel.getThreadName() + ": GLJPanel.OffscreenBackend.postGL.0: - frameCount " + this.frameCount);
                }
                GL gL = this.offscreenContext.getGL();
                if (this.offscreenIsFBO) {
                    n3 = 33984 + ((GLFBODrawable)this.offscreenDrawable).getTextureUnit();
                    if (n3 != (textureState2 = new TextureState(gL, 3553)).getUnit()) {
                        gL.glActiveTexture(n3);
                        textureState = new TextureState(gL, n3, 3553);
                    } else {
                        textureState = textureState2;
                    }
                } else {
                    n3 = 0;
                    textureState2 = null;
                    textureState = null;
                }
                if (GLJPanel.this.autoSwapBufferMode) {
                    this.offscreenDrawable.swapBuffers();
                }
                if (GLJPanel.this.isOpaque()) {
                    n2 = 3;
                    n = 1;
                } else {
                    n2 = 4;
                    n = 4;
                }
                PixelFormat pixelFormat = this.pixelBufferProvider.getAWTPixelFormat(gL.getGLProfile(), n2);
                GLPixelBuffer.GLPixelAttributes gLPixelAttributes = this.pixelBufferProvider.getAttributes(gL, n2, true);
                if (this.useSingletonBuffer) {
                    this.pixelBuffer = (AWTGLPixelBuffer)((GLPixelBuffer.SingletonGLPixelBufferProvider)((Object)this.pixelBufferProvider)).getSingleBuffer(pixelFormat.comp, gLPixelAttributes, true);
                }
                if (null != this.pixelBuffer && this.pixelBuffer.requiresNewBuffer(gL, GLJPanel.this.panelWidth, GLJPanel.this.panelHeight, 0)) {
                    this.pixelBuffer.dispose();
                    this.pixelBuffer = null;
                    this.alignedImage = null;
                }
                if (null == this.pixelBuffer) {
                    if (0 >= GLJPanel.this.panelWidth || 0 >= GLJPanel.this.panelHeight) {
                        return;
                    }
                    this.pixelBuffer = this.pixelBufferProvider.allocate(gL, pixelFormat.comp, gLPixelAttributes, true, GLJPanel.this.panelWidth, GLJPanel.this.panelHeight, 1, 0);
                    if (DEBUG) {
                        System.err.println(GLJPanel.getThreadName() + ": GLJPanel.OffscreenBackend.postGL.0: " + GLJPanel.this.getName() + " pixelBufferProvider isSingletonBufferProvider " + this.useSingletonBuffer + ", 0x" + Integer.toHexString(this.pixelBufferProvider.hashCode()) + ", " + this.pixelBufferProvider.getClass().getSimpleName());
                        System.err.println(GLJPanel.getThreadName() + ": GLJPanel.OffscreenBackend.postGL.0: " + GLJPanel.this.getName() + " pixelBuffer 0x" + Integer.toHexString(this.pixelBuffer.hashCode()) + ", " + this.pixelBuffer + ", alignment " + n);
                        System.err.println(GLJPanel.getThreadName() + ": GLJPanel.OffscreenBackend.postGL.0: " + GLJPanel.this.getName() + " flippedVertical " + this.flipVertical + ", glslTextureRaster " + (null != this.glslTextureRaster) + ", isGL2ES3 " + gL.isGL2ES3());
                        System.err.println(GLJPanel.getThreadName() + ": GLJPanel.OffscreenBackend.postGL.0: " + GLJPanel.this.getName() + " panelSize " + GLJPanel.this.panelWidth + "x" + GLJPanel.this.panelHeight + " @ scale " + GLJPanel.this.getPixelScaleStr());
                        System.err.println(GLJPanel.getThreadName() + ": GLJPanel.OffscreenBackend.postGL.0: " + GLJPanel.this.getName() + " pixelAttribs " + gLPixelAttributes);
                        System.err.println(GLJPanel.getThreadName() + ": GLJPanel.OffscreenBackend.postGL.0: " + GLJPanel.this.getName() + " awtPixelFormat " + (Object)((Object)pixelFormat));
                        bl2 = true;
                    } else {
                        bl2 = false;
                    }
                } else {
                    bl2 = false;
                }
                if (this.offscreenDrawable.getSurfaceWidth() != GLJPanel.this.panelWidth || this.offscreenDrawable.getSurfaceHeight() != GLJPanel.this.panelHeight) {
                    throw new InternalError("OffscreenDrawable panelSize mismatch (reshape missed): panelSize " + GLJPanel.this.panelWidth + "x" + GLJPanel.this.panelHeight + " != drawable " + this.offscreenDrawable.getSurfaceWidth() + "x" + this.offscreenDrawable.getSurfaceHeight() + ", on thread " + GLJPanel.getThreadName());
                }
                if (null == this.alignedImage || GLJPanel.this.panelWidth != this.alignedImage.getWidth() || GLJPanel.this.panelHeight != this.alignedImage.getHeight() || !this.pixelBuffer.isDataBufferSource(this.alignedImage)) {
                    this.alignedImage = this.pixelBuffer.getAlignedImage(GLJPanel.this.panelWidth, GLJPanel.this.panelHeight);
                    if (DEBUG) {
                        System.err.println(GLJPanel.getThreadName() + ": GLJPanel.OffscreenBackend.postGL.0: " + GLJPanel.this.getName() + " new alignedImage " + this.alignedImage.getWidth() + "x" + this.alignedImage.getHeight() + " @ scale " + GLJPanel.this.getPixelScaleStr() + ", " + this.alignedImage + ", pixelBuffer " + this.pixelBuffer.width + "x" + this.pixelBuffer.height + ", " + this.pixelBuffer);
                    }
                }
                if (!this.flipVertical || null != this.glslTextureRaster) {
                    intBuffer = (IntBuffer)this.pixelBuffer.buffer;
                } else {
                    if (null == this.readBackIntsForCPUVFlip || this.pixelBuffer.width * this.pixelBuffer.height > this.readBackIntsForCPUVFlip.remaining()) {
                        this.readBackIntsForCPUVFlip = IntBuffer.allocate(this.pixelBuffer.width * this.pixelBuffer.height);
                    }
                    intBuffer = this.readBackIntsForCPUVFlip;
                }
                if (DEBUG_FRAMES) {
                    System.err.println(GLJPanel.getThreadName() + ": GLJPanel.OffscreenBackend.postGL.readPixels: - frameCount " + this.frameCount);
                }
                this.psm.setPackAlignment(gL, n);
                if (gL.isGL2ES3()) {
                    object = gL.getGL2ES3();
                    this.psm.setPackRowLength((GL2ES3)object, GLJPanel.this.panelWidth);
                    object.glReadBuffer(object.getDefaultReadBuffer());
                    if (bl2) {
                        System.err.println(GLJPanel.getThreadName() + ": GLJPanel.OffscreenBackend.postGL.0.0: fboDrawable " + this.offscreenDrawable);
                        System.err.println(GLJPanel.getThreadName() + ": GLJPanel.OffscreenBackend.postGL.0.0: isGL2ES3, readBuffer 0x" + Integer.toHexString(object.getDefaultReadBuffer()));
                        System.err.println(GLJPanel.getThreadName() + ": GLJPanel.OffscreenBackend.postGL.0.0: def-readBuffer 0x" + Integer.toHexString(object.getDefaultReadBuffer()));
                        System.err.println(GLJPanel.getThreadName() + ": GLJPanel.OffscreenBackend.postGL.0.0: def-readFBO    0x" + Integer.toHexString(object.getDefaultReadFramebuffer()));
                        System.err.println(GLJPanel.getThreadName() + ": GLJPanel.OffscreenBackend.postGL.0.0: bound-readFBO  0x" + Integer.toHexString(object.getBoundFramebuffer(36008)));
                    }
                }
                if (null != this.glslTextureRaster) {
                    boolean bl3;
                    int[] nArray = new int[]{0, 0, 0, 0};
                    gL.glGetIntegerv(2978, nArray, 0);
                    boolean bl4 = bl3 = 0 != nArray[0] || 0 != nArray[1] || GLJPanel.this.panelWidth != nArray[2] || GLJPanel.this.panelHeight != nArray[3];
                    if (DEBUG_VIEWPORT) {
                        System.err.println(GLJPanel.getThreadName() + ": GLJPanel.OffscreenBackend.postGL: " + GLJPanel.this.getName() + " Viewport: change " + bl3 + ", " + nArray[0] + "/" + nArray[1] + " " + nArray[2] + "x" + nArray[3] + " -> 0/0 " + GLJPanel.this.panelWidth + "x" + GLJPanel.this.panelHeight);
                    }
                    if (bl3) {
                        gL.glViewport(0, 0, GLJPanel.this.panelWidth, GLJPanel.this.panelHeight);
                    }
                    GLFBODrawable gLFBODrawable = (GLFBODrawable)this.offscreenDrawable;
                    FBObject.TextureAttachment textureAttachment = gLFBODrawable.getColorbuffer(1028).getTextureAttachment();
                    this.fboFlipped.bind(gL);
                    gL.glBindTexture(3553, textureAttachment.getName());
                    this.glslTextureRaster.display(gL.getGL2ES2());
                    if (bl2) {
                        System.err.println(GLJPanel.getThreadName() + ": GLJPanel.OffscreenBackend.postGL.0.1: fboDrawable " + gLFBODrawable);
                        System.err.println(GLJPanel.getThreadName() + ": GLJPanel.OffscreenBackend.postGL.0.1: read from fbo-rb " + this.fboFlipped.getReadFramebuffer() + ", fbo " + this.fboFlipped);
                        System.err.println(GLJPanel.getThreadName() + ": GLJPanel.OffscreenBackend.postGL.0.1: isGL2ES3, readBuffer 0x" + Integer.toHexString(gL.getDefaultReadBuffer()));
                        System.err.println(GLJPanel.getThreadName() + ": GLJPanel.OffscreenBackend.postGL.0.1: def-readBuffer 0x" + Integer.toHexString(gL.getDefaultReadBuffer()));
                        System.err.println(GLJPanel.getThreadName() + ": GLJPanel.OffscreenBackend.postGL.0.1: def-readFBO    0x" + Integer.toHexString(gL.getDefaultReadFramebuffer()));
                        System.err.println(GLJPanel.getThreadName() + ": GLJPanel.OffscreenBackend.postGL.0.1: bound-readFBO  0x" + Integer.toHexString(gL.getBoundFramebuffer(36008)));
                        System.err.println(GLJPanel.getThreadName() + ": GLJPanel.OffscreenBackend.postGL.0.1: " + GLJPanel.this.getName() + " pixelAttribs " + gLPixelAttributes);
                    }
                    gL.glReadPixels(0, 0, GLJPanel.this.panelWidth, GLJPanel.this.panelHeight, gLPixelAttributes.format, gLPixelAttributes.type, intBuffer);
                    this.fboFlipped.unbind(gL);
                    if (bl2) {
                        System.err.println(GLJPanel.getThreadName() + ": GLJPanel.OffscreenBackend.postGL.0.2: fboDrawable " + gLFBODrawable);
                        System.err.println(GLJPanel.getThreadName() + ": GLJPanel.OffscreenBackend.postGL.0.2: read from fbo-rb " + this.fboFlipped.getReadFramebuffer() + ", fbo " + this.fboFlipped);
                        System.err.println(GLJPanel.getThreadName() + ": GLJPanel.OffscreenBackend.postGL.0.2: isGL2ES3, readBuffer 0x" + Integer.toHexString(gL.getDefaultReadBuffer()));
                        System.err.println(GLJPanel.getThreadName() + ": GLJPanel.OffscreenBackend.postGL.0.2: def-readBuffer 0x" + Integer.toHexString(gL.getDefaultReadBuffer()));
                        System.err.println(GLJPanel.getThreadName() + ": GLJPanel.OffscreenBackend.postGL.0.2: def-readFBO    0x" + Integer.toHexString(gL.getDefaultReadFramebuffer()));
                        System.err.println(GLJPanel.getThreadName() + ": GLJPanel.OffscreenBackend.postGL.0.2: bound-readFBO  0x" + Integer.toHexString(gL.getBoundFramebuffer(36008)));
                    }
                    if (bl3) {
                        gL.glViewport(nArray[0], nArray[1], nArray[2], nArray[3]);
                    }
                } else {
                    gL.glReadPixels(0, 0, GLJPanel.this.panelWidth, GLJPanel.this.panelHeight, gLPixelAttributes.format, gLPixelAttributes.type, intBuffer);
                    if (this.flipVertical) {
                        object = this.alignedImage;
                        int[] nArray = intBuffer.array();
                        int[] nArray2 = ((DataBufferInt)((BufferedImage)object).getRaster().getDataBuffer()).getData();
                        int n4 = GLJPanel.this.panelWidth;
                        int n5 = 0;
                        for (int i = (GLJPanel.this.panelHeight - 1) * GLJPanel.this.panelWidth; i >= 0; i -= n4) {
                            System.arraycopy(nArray, n5, nArray2, i, n4);
                            n5 += n4;
                        }
                    }
                }
                if (0 != n3) {
                    textureState.restore(gL);
                    if (n3 != textureState2.getUnit()) {
                        textureState2.restore(gL);
                    }
                }
                this.psm.restore(gL);
            }
        }

        @Override
        public final int getTextureUnit() {
            if (null != this.glslTextureRaster && null != this.offscreenDrawable) {
                return ((GLFBODrawable)this.offscreenDrawable).getTextureUnit();
            }
            return -1;
        }

        @Override
        public final void doPaintComponent(Graphics graphics) {
            GLJPanel.this.helper.invokeGL(this.offscreenDrawable, this.offscreenContext, GLJPanel.this.updaterDisplayAction, GLJPanel.this.updaterInitAction);
            if (null != this.alignedImage) {
                if (DEBUG_FRAMES) {
                    System.err.println(GLJPanel.getThreadName() + ": GLJPanel.OffscreenBackend.doPaintComponent.drawImage: - frameCount " + this.frameCount);
                }
                graphics.drawImage(this.alignedImage, 0, 0, SurfaceScaleUtils.scaleInv(this.alignedImage.getWidth(), GLJPanel.this.hasPixelScale[0]), SurfaceScaleUtils.scaleInv(this.alignedImage.getHeight(), GLJPanel.this.hasPixelScale[1]), null);
            }
            ++this.frameCount;
        }

        @Override
        public final void doPlainPaint() {
            GLJPanel.this.helper.invokeGL(this.offscreenDrawable, this.offscreenContext, GLJPanel.this.updaterPlainDisplayAction, GLJPanel.this.updaterInitAction);
        }

        @Override
        public final boolean handleReshape() {
            GLDrawableImpl gLDrawableImpl = (GLDrawableImpl)this.offscreenDrawable;
            Object object = GLDrawableHelper.resizeOffscreenDrawable(gLDrawableImpl, this.offscreenContext, GLJPanel.this.panelWidth, GLJPanel.this.panelHeight);
            if (gLDrawableImpl != object) {
                gLDrawableImpl = object;
                this.offscreenDrawable = object;
                GLJPanel.this.updateWrappedSurfaceScale(this.offscreenDrawable);
            }
            if (DEBUG) {
                System.err.println(GLJPanel.getThreadName() + ": GLJPanel.OffscreenBackend.handleReshape: " + GLJPanel.this.panelWidth + "x" + GLJPanel.this.panelHeight + " @ scale " + GLJPanel.this.getPixelScaleStr() + " -> " + gLDrawableImpl.getSurfaceWidth() + "x" + gLDrawableImpl.getSurfaceHeight());
            }
            GLJPanel.this.panelWidth = gLDrawableImpl.getSurfaceWidth();
            GLJPanel.this.panelHeight = gLDrawableImpl.getSurfaceHeight();
            if (null != this.glslTextureRaster && 0 < this.offscreenContext.makeCurrent()) {
                try {
                    object = this.offscreenContext.getGL();
                    this.fboFlipped.reset((GL)object, GLJPanel.this.panelWidth, GLJPanel.this.panelHeight, 0);
                    this.glslTextureRaster.reshape(object.getGL2ES2(), 0, 0, GLJPanel.this.panelWidth, GLJPanel.this.panelHeight);
                }
                finally {
                    this.offscreenContext.release();
                }
            }
            return gLDrawableImpl.isRealized();
        }

        @Override
        public final GLContext createContext(GLContext gLContext) {
            return null != this.offscreenDrawable ? this.offscreenDrawable.createContext(gLContext) : null;
        }

        @Override
        public final void setContext(GLContext gLContext) {
            this.offscreenContext = (GLContextImpl)gLContext;
        }

        @Override
        public final GLContext getContext() {
            return this.offscreenContext;
        }

        @Override
        public final GLDrawable getDrawable() {
            return this.offscreenDrawable;
        }

        @Override
        public final GLCapabilitiesImmutable getChosenGLCapabilities() {
            if (this.offscreenDrawable == null) {
                return null;
            }
            return this.offscreenDrawable.getChosenGLCapabilities();
        }

        @Override
        public final GLProfile getGLProfile() {
            if (this.offscreenDrawable == null) {
                return null;
            }
            return this.offscreenDrawable.getGLProfile();
        }
    }

    static interface Backend {
        public boolean isUsingOwnLifecycle();

        public void initialize();

        public void destroy();

        public void setOpaque(boolean var1);

        public GLContext createContext(GLContext var1);

        public void setContext(GLContext var1);

        public GLContext getContext();

        public GLDrawable getDrawable();

        public int getTextureUnit();

        public GLCapabilitiesImmutable getChosenGLCapabilities();

        public GLProfile getGLProfile();

        public boolean handleReshape();

        public boolean preGL(Graphics var1);

        public boolean handlesSwapBuffer();

        public void swapBuffers();

        public void postGL(Graphics var1, boolean var2);

        public void doPaintComponent(Graphics var1);

        public void doPlainPaint();
    }

    private class DisposeGLEventListenerAction
    implements Runnable {
        GLEventListener listener;
        private final boolean remove;

        private DisposeGLEventListenerAction(GLEventListener gLEventListener, boolean bl) {
            this.listener = gLEventListener;
            this.remove = bl;
        }

        @Override
        public void run() {
            Backend backend = GLJPanel.this.backend;
            if (null != backend) {
                this.listener = GLJPanel.this.helper.disposeGLEventListener(GLJPanel.this, backend.getDrawable(), backend.getContext(), this.listener, this.remove);
            }
        }
    }

    class Updater
    implements GLEventListener {
        private Graphics g;

        Updater() {
        }

        public void setGraphics(Graphics graphics) {
            this.g = graphics;
        }

        @Override
        public void init(GLAutoDrawable gLAutoDrawable) {
            if (!GLJPanel.this.backend.preGL(this.g)) {
                return;
            }
            GLJPanel.this.helper.init(GLJPanel.this, !GLJPanel.this.sendReshape);
            GLJPanel.this.backend.postGL(this.g, false);
        }

        @Override
        public void dispose(GLAutoDrawable gLAutoDrawable) {
            GLJPanel.this.helper.disposeAllGLEventListener(GLJPanel.this, false);
        }

        @Override
        public void display(GLAutoDrawable gLAutoDrawable) {
            if (!GLJPanel.this.backend.preGL(this.g)) {
                return;
            }
            if (GLJPanel.this.sendReshape) {
                if (DEBUG) {
                    System.err.println(GLJPanel.getThreadName() + ": GLJPanel.display: reshape(" + GLJPanel.this.viewportX + "," + GLJPanel.this.viewportY + " " + GLJPanel.this.panelWidth + "x" + GLJPanel.this.panelHeight + " @ scale " + GLJPanel.this.getPixelScaleStr() + ")");
                }
                GLJPanel.this.helper.reshape(GLJPanel.this, GLJPanel.this.viewportX, GLJPanel.this.viewportY, GLJPanel.this.panelWidth, GLJPanel.this.panelHeight);
                GLJPanel.this.sendReshape = false;
            }
            GLJPanel.this.helper.display(GLJPanel.this);
            GLJPanel.this.backend.postGL(this.g, true);
        }

        public void plainPaint(GLAutoDrawable gLAutoDrawable) {
            GLJPanel.this.helper.display(GLJPanel.this);
        }

        @Override
        public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        }
    }
}

