/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl;

import com.jogamp.common.ExceptionUtils;
import com.jogamp.common.os.Platform;
import com.jogamp.gluegen.runtime.ProcAddressTable;
import com.jogamp.nativewindow.NativeWindowException;
import com.jogamp.opengl.GLDebugListener;
import com.jogamp.opengl.GLDebugMessage;
import com.jogamp.opengl.GLException;
import java.io.PrintStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import jogamp.common.os.PlatformPropsImpl;
import jogamp.opengl.Debug;
import jogamp.opengl.GLContextImpl;
import jogamp.opengl.ListenerSyncedImplStub;

public class GLDebugMessageHandler {
    private static final boolean DEBUG = Debug.debug("GLDebugMessageHandler");
    private static final int EXT_ARB = 1;
    private static final int EXT_AMD = 2;
    private final GLContextImpl ctx;
    private final ListenerSyncedImplStub<GLDebugListener> listenerImpl;
    private String extName;
    private int extType;
    private long glDebugMessageCallbackProcAddress;
    private boolean extAvailable;
    private boolean synchronous;
    private long handle;

    public GLDebugMessageHandler(GLContextImpl gLContextImpl) {
        this.ctx = gLContextImpl;
        this.listenerImpl = new ListenerSyncedImplStub();
        this.glDebugMessageCallbackProcAddress = 0L;
        this.extName = null;
        this.extType = 0;
        this.extAvailable = false;
        this.handle = 0L;
        this.synchronous = true;
    }

    public void init(boolean bl) {
        if (DEBUG) {
            System.err.println("GLDebugMessageHandler.init(" + bl + ")");
        }
        this.init();
        if (this.isAvailable()) {
            this.enableImpl(bl);
        } else if (DEBUG) {
            System.err.println("GLDebugMessageHandler.init(" + bl + ") .. n/a");
        }
    }

    private final long getAddressFor(final ProcAddressTable procAddressTable, final String string) {
        return AccessController.doPrivileged(new PrivilegedAction<Long>(){

            @Override
            public Long run() {
                try {
                    return procAddressTable.getAddressFor(string);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return 0L;
                }
            }
        });
    }

    public void init() {
        this.ctx.validateCurrent();
        if (this.isAvailable()) {
            return;
        }
        if (!this.ctx.isGLDebugEnabled()) {
            if (DEBUG) {
                System.err.println("GLDebugMessageHandler: GL DEBUG not set in ARB ctx options: " + this.ctx.getGLVersion());
            }
            return;
        }
        if (PlatformPropsImpl.OS_TYPE == Platform.OSType.WINDOWS && Platform.is32Bit()) {
            if (DEBUG) {
                System.err.println("GLDebugMessageHandler: Windows 32bit currently not supported!");
            }
            return;
        }
        if (this.ctx.isExtensionAvailable("GL_ARB_debug_output")) {
            this.extName = "GL_ARB_debug_output";
            this.extType = 1;
        } else if (this.ctx.isExtensionAvailable("GL_AMD_debug_output")) {
            this.extName = "GL_AMD_debug_output";
            this.extType = 2;
        }
        if (DEBUG) {
            System.err.println("GLDebugMessageHandler: Using extension: <" + this.extName + ">");
        }
        if (0 == this.extType) {
            if (DEBUG) {
                System.err.println("GLDebugMessageHandler: No extension available! " + this.ctx.getGLVersion());
                System.err.println("GL_EXTENSIONS  " + this.ctx.getGLExtensionCount());
                System.err.println(this.ctx.getGLExtensionsString());
            }
            return;
        }
        ProcAddressTable procAddressTable = this.ctx.getGLProcAddressTable();
        if (!this.ctx.isGLES1() && !this.ctx.isGLES2()) {
            switch (this.extType) {
                case 1: {
                    this.glDebugMessageCallbackProcAddress = this.getAddressFor(procAddressTable, "glDebugMessageCallbackARB");
                    break;
                }
                case 2: {
                    this.glDebugMessageCallbackProcAddress = this.getAddressFor(procAddressTable, "glDebugMessageCallbackAMD");
                }
            }
        } else {
            this.glDebugMessageCallbackProcAddress = 0L;
            if (DEBUG) {
                System.err.println("Non desktop context not supported");
            }
        }
        boolean bl = this.extAvailable = 0 < this.extType && null != this.extName && 0L != this.glDebugMessageCallbackProcAddress;
        if (DEBUG) {
            System.err.println("GLDebugMessageHandler: extAvailable: " + this.extAvailable + ", glDebugMessageCallback* : 0x" + Long.toHexString(this.glDebugMessageCallbackProcAddress));
        }
        if (!this.extAvailable) {
            this.glDebugMessageCallbackProcAddress = 0L;
        }
        this.handle = 0L;
    }

    public final boolean isAvailable() {
        return this.extAvailable;
    }

    public final String getExtension() {
        return this.extName;
    }

    public final boolean isExtensionARB() {
        return this.extName == "GL_ARB_debug_output";
    }

    public final boolean isExtensionAMD() {
        return this.extName == "GL_AMD_debug_output";
    }

    public final boolean isSynchronous() {
        return this.synchronous;
    }

    public final void setSynchronous(boolean bl) {
        this.synchronous = bl;
        if (this.isEnabled()) {
            this.setSynchronousImpl();
        }
    }

    private final void setSynchronousImpl() {
        if (this.isExtensionARB()) {
            if (this.synchronous) {
                this.ctx.getGL().glEnable(33346);
            } else {
                this.ctx.getGL().glDisable(33346);
            }
            if (DEBUG) {
                System.err.println("GLDebugMessageHandler: synchronous " + this.synchronous);
            }
        }
    }

    public final void enable(boolean bl) throws GLException {
        this.ctx.validateCurrent();
        if (!this.isAvailable()) {
            return;
        }
        this.enableImpl(bl);
    }

    final void enableImpl(boolean bl) throws GLException {
        if (bl) {
            if (0L == this.handle) {
                this.setSynchronousImpl();
                this.handle = this.register0(this.glDebugMessageCallbackProcAddress, this.extType);
                if (0L == this.handle) {
                    throw new GLException("Failed to register via \"glDebugMessageCallback*\" using " + this.extName);
                }
            }
        } else if (0L != this.handle) {
            this.unregister0(this.glDebugMessageCallbackProcAddress, this.handle);
            this.handle = 0L;
        }
        if (DEBUG) {
            System.err.println("GLDebugMessageHandler: enable(" + bl + ") -> 0x" + Long.toHexString(this.handle));
        }
    }

    public final boolean isEnabled() {
        return 0L != this.handle;
    }

    public final int listenerSize() {
        return this.listenerImpl.size();
    }

    public final void addListener(GLDebugListener gLDebugListener) {
        this.listenerImpl.addListener(-1, gLDebugListener);
    }

    public final void addListener(int n, GLDebugListener gLDebugListener) {
        this.listenerImpl.addListener(n, gLDebugListener);
    }

    public final void removeListener(GLDebugListener gLDebugListener) {
        this.listenerImpl.removeListener(gLDebugListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void sendMessage(GLDebugMessage gLDebugMessage) {
        ListenerSyncedImplStub<GLDebugListener> listenerSyncedImplStub = this.listenerImpl;
        synchronized (listenerSyncedImplStub) {
            if (DEBUG) {
                System.err.println("GLDebugMessageHandler: " + gLDebugMessage);
            }
            ArrayList<GLDebugListener> arrayList = this.listenerImpl.getListeners();
            for (int i = 0; i < arrayList.size(); ++i) {
                arrayList.get(i).messageSent(gLDebugMessage);
            }
        }
    }

    protected final void glDebugMessageARB(int n, int n2, int n3, int n4, String string) {
        GLDebugMessage gLDebugMessage = new GLDebugMessage(this.ctx, System.currentTimeMillis(), n, n2, n3, n4, string);
        this.sendMessage(gLDebugMessage);
    }

    protected final void glDebugMessageAMD(int n, int n2, int n3, String string) {
        GLDebugMessage gLDebugMessage = GLDebugMessage.translateAMDEvent(this.ctx, System.currentTimeMillis(), n, n2, n3, string);
        this.sendMessage(gLDebugMessage);
    }

    private static native boolean initIDs0();

    private native long register0(long var1, int var3);

    private native void unregister0(long var1, long var3);

    static {
        if (!GLDebugMessageHandler.initIDs0()) {
            throw new NativeWindowException("Failed to initialize GLDebugMessageHandler jmethodIDs");
        }
    }

    public static class StdErrGLDebugListener
    implements GLDebugListener {
        boolean threadDump;

        public StdErrGLDebugListener(boolean bl) {
            this.threadDump = bl;
        }

        @Override
        public void messageSent(GLDebugMessage gLDebugMessage) {
            System.err.println(gLDebugMessage);
            if (this.threadDump) {
                ExceptionUtils.dumpStack((PrintStream)System.err);
            }
        }
    }
}

