/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.loaders.ac3d;

import java.util.ArrayList;
import org.newdawn.loaders.ac3d.AC3DSurface;

public class AC3DObject {
    public static final int TYPE_WORLD = 0;
    public static final int TYPE_POLY = 1;
    public static final int TYPE_GROUP = 2;
    private int type;
    private String name;
    private String textureName;
    private float[] rotation;
    private float[] location;
    private float[][] verts;
    private float textureRepeatX = 1.0f;
    private float textureRepeatY = 1.0f;
    private float textureOffsetx = 0.0f;
    private float textureOffsety = 0.0f;
    private ArrayList surfaces = new ArrayList();
    private ArrayList kids = new ArrayList();

    public AC3DObject(int type, String name, String textureName, float[] rotation, float[] location, float[][] verts, float textureRepeatX, float textureRepeatY, float textureOffsetx, float textureOffsety) {
        this.type = type;
        this.name = name;
        this.textureName = textureName;
        this.rotation = rotation;
        this.location = location;
        this.verts = verts;
        this.textureRepeatX = textureRepeatX;
        this.textureRepeatY = textureRepeatY;
        this.textureOffsetx = textureOffsetx;
        this.textureOffsety = textureOffsety;
    }

    public void addSurface(AC3DSurface surface) {
        this.surfaces.add(surface);
    }

    public void addObject(AC3DObject object) {
        this.kids.add(object);
    }

    public ArrayList getSurfaces() {
        return this.surfaces;
    }

    public String getTextureName() {
        if (this.textureName != null) {
            return new String(this.textureName);
        }
        return null;
    }

    public ArrayList getKids() {
        return this.kids;
    }

    public int getType() {
        return this.type;
    }

    public String getName() {
        if (this.name == null) {
            return null;
        }
        return new String(this.name);
    }

    public float[] getRotation() {
        return this.rotation;
    }

    public float[] getLocation() {
        return this.location;
    }

    public float[][] getVerticies() {
        return this.verts;
    }

    public float getTextureRepeatX() {
        return this.textureRepeatX;
    }

    public float getTextureRepeatY() {
        return this.textureRepeatY;
    }

    public float getTextureOffsetX() {
        return this.textureOffsetx;
    }

    public float getTextureOffsetY() {
        return this.textureOffsety;
    }
}

