/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.geometry.compression;

import com.sun.j3d.internal.J3dUtilsI18N;
import javax.vecmath.Color4f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;

abstract class GeometryDecompressor {
    private static final boolean debug = false;
    private static final boolean benchmark = false;
    static final int majorVersionNumber = 1;
    static final int minorVersionNumber = 0;
    static final int minorMinorVersionNumber = 2;
    private static final int GC_VERTEX = 64;
    private static final int GC_SET_NORM = 192;
    private static final int GC_SET_COLOR = 128;
    private static final int GC_MESH_B_R = 32;
    private static final int GC_SET_STATE = 24;
    private static final int GC_SET_TABLE = 16;
    private static final int GC_PASS_THROUGH = 8;
    private static final int GC_EOS = 0;
    private static final int GC_V_NO_OP = 1;
    private static final int GC_SKIP_8 = 7;
    private HuffmanTableEntry[][] gctables;
    private MeshBufferEntry[] meshBuffer;
    private int meshIndex = 15;
    private int meshState;
    private static final int USE_MESH_NORMAL = 1;
    private static final int USE_MESH_COLOR = 2;
    private short curX;
    private short curY;
    private short curZ;
    private short curR;
    private short curG;
    private short curB;
    private short curA;
    private int curSex;
    private int curOct;
    private int curU;
    private int curV;
    private Point3f curPos = new Point3f();
    private Vector3f curNorm = new Vector3f();
    private Color4f curColor = new Color4f();
    private int repCode;
    private boolean bundlingNorm;
    private boolean bundlingColor;
    private boolean doingAlpha;
    private int currentHeader = 0;
    private int nextHeader = 0;
    private int bitBuffer = 0;
    private int bitBufferCount = 32;
    private long startTime;
    private int vertexCount;
    private static final int[] BMASK = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047, 4095, 8191, 16383, Short.MAX_VALUE, 65535, 131071, 262143, 524287, 1048575, 0x1FFFFF, 0x3FFFFF, 0x7FFFFF, 0xFFFFFF, 0x1FFFFFF, 0x3FFFFFF, 0x7FFFFFF, 0xFFFFFFF, 0x1FFFFFFF, 0x3FFFFFFF, Integer.MAX_VALUE, -1};
    private byte[] gcData;
    private int gcIndex;
    private static final double[][][] gcNormals = new double[65][65][3];
    private static final double NORMAL_MAX_Y_ANG = 0.615479709;
    private static final boolean printNormalTable = false;

    abstract void outputVertexFormat(boolean var1, boolean var2, boolean var3);

    abstract void outputVertex(Point3f var1, Vector3f var2, Color4f var3, int var4);

    abstract void outputColor(Color4f var1);

    abstract void outputNormal(Vector3f var1);

    GeometryDecompressor() {
        int n;
        this.gctables = new HuffmanTableEntry[3][64];
        for (n = 0; n < 64; ++n) {
            this.gctables[0][n] = new HuffmanTableEntry();
            this.gctables[1][n] = new HuffmanTableEntry();
            this.gctables[2][n] = new HuffmanTableEntry();
        }
        this.meshBuffer = new MeshBufferEntry[16];
        for (n = 0; n < 16; ++n) {
            this.meshBuffer[n] = new MeshBufferEntry();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean checkVersion(int n, int n2) {
        if (n < 1) return true;
        if (n != 1) return false;
        if (n2 > 0) return false;
        return true;
    }

    void decompress(int n, int n2, byte[] byArray) {
        if (n + n2 > byArray.length) {
            throw new ArrayIndexOutOfBoundsException(J3dUtilsI18N.getString("GeometryDecompressor0"));
        }
        this.gcData = byArray;
        this.gcIndex = n;
        this.bitBufferCount = 0;
        this.meshState = 0;
        this.bundlingNorm = false;
        this.bundlingColor = false;
        this.doingAlpha = false;
        this.repCode = 0;
        this.nextHeader = 1;
        while (this.gcIndex < n + n2) {
            this.processDecompression();
        }
        while (this.bitBufferCount > 0) {
            this.processDecompression();
        }
    }

    private int getBits(int n, String string) {
        int n2;
        if (n == 0) {
            return 0;
        }
        if (this.bitBufferCount == 0) {
            this.bitBuffer = (this.gcData[this.gcIndex++] & 0xFF) << 24 | (this.gcData[this.gcIndex++] & 0xFF) << 16 | (this.gcData[this.gcIndex++] & 0xFF) << 8 | this.gcData[this.gcIndex++] & 0xFF;
            this.bitBufferCount = 32;
        }
        if (this.bitBufferCount >= n) {
            n2 = this.bitBuffer >>> 32 - n & BMASK[n];
            this.bitBuffer <<= n;
            this.bitBufferCount -= n;
        } else {
            n2 = this.bitBuffer >>> 32 - n & BMASK[n];
            n2 >>>= n - this.bitBufferCount;
            n2 <<= n - this.bitBufferCount;
            this.bitBuffer = (this.gcData[this.gcIndex++] & 0xFF) << 24 | (this.gcData[this.gcIndex++] & 0xFF) << 16 | (this.gcData[this.gcIndex++] & 0xFF) << 8 | this.gcData[this.gcIndex++] & 0xFF;
            n2 |= this.bitBuffer >>> 32 - (n - this.bitBufferCount) & BMASK[n - this.bitBufferCount];
            this.bitBuffer <<= n - this.bitBufferCount;
            this.bitBufferCount = 32 - (n - this.bitBufferCount);
        }
        return n2;
    }

    private void processDecompression() {
        this.currentHeader = this.nextHeader;
        if ((this.currentHeader & 0xC0) == 64) {
            if (!this.bundlingNorm && !this.bundlingColor) {
                this.nextHeader = this.getBits(8, "header");
                int n = this.processDecompressionOpcode(0);
            } else if (this.bundlingNorm && !this.bundlingColor) {
                this.nextHeader = this.getBits(6, "normal");
                int n = this.processDecompressionOpcode(0);
                this.currentHeader = this.nextHeader | 0xC0;
                this.nextHeader = this.getBits(8, "header");
                this.processDecompressionOpcode(n);
            } else if (!this.bundlingNorm && this.bundlingColor) {
                this.nextHeader = this.getBits(6, "color");
                int n = this.processDecompressionOpcode(0);
                this.currentHeader = this.nextHeader | 0x80;
                this.nextHeader = this.getBits(8, "header");
                this.processDecompressionOpcode(n);
            } else {
                this.nextHeader = this.getBits(6, "normal");
                int n = this.processDecompressionOpcode(0);
                this.currentHeader = this.nextHeader | 0xC0;
                this.nextHeader = this.getBits(6, "color");
                this.processDecompressionOpcode(n);
                this.currentHeader = this.nextHeader | 0x80;
                this.nextHeader = this.getBits(8, "header");
                this.processDecompressionOpcode(n);
            }
            this.outputVertex(this.curPos, this.curNorm, this.curColor, this.repCode);
            this.meshState |= 1;
            this.meshState |= 2;
        } else {
            this.nextHeader = this.getBits(8, "header");
            this.processDecompressionOpcode(0);
        }
    }

    private int processDecompressionOpcode(int n) {
        if ((this.currentHeader & 0xC0) == 192) {
            this.processSetNormal(n);
        } else if ((this.currentHeader & 0xC0) == 128) {
            this.processSetColor(n);
        } else {
            if ((this.currentHeader & 0xC0) == 64) {
                return this.processVertex();
            }
            if ((this.currentHeader & 0xE0) == 32) {
                this.processMeshBR();
                this.outputVertex(this.curPos, this.curNorm, this.curColor, this.repCode);
                this.meshState |= 1;
                this.meshState |= 2;
            } else if ((this.currentHeader & 0xF8) == 24) {
                this.processSetState();
            } else if ((this.currentHeader & 0xF8) == 16) {
                this.processSetTable();
            } else if ((this.currentHeader & 0xFF) == 0) {
                this.processEos();
            } else if ((this.currentHeader & 0xFF) == 1) {
                this.processVNoop();
            } else if ((this.currentHeader & 0xFF) == 8) {
                this.processPassThrough();
            } else if ((this.currentHeader & 0xFF) == 7) {
                this.processSkip8();
            }
        }
        return 0;
    }

    private void processSetState() {
        int n = this.getBits(3, "bundling");
        this.bundlingNorm = (this.currentHeader & 1) != 0;
        this.bundlingColor = (n >>> 2 & 1) != 0;
        this.doingAlpha = (n >>> 1 & 1) != 0;
        this.outputVertexFormat(this.bundlingNorm, this.bundlingColor, this.doingAlpha);
    }

    private void processSetTable() {
        int n;
        int n2 = (this.currentHeader & 6) >>> 1;
        HuffmanTableEntry[] huffmanTableEntryArray = this.gctables[n2];
        int n3 = this.getBits(15, "set table");
        int n4 = (this.currentHeader & 1) << 6 | n3 >>> 9 & 0x3F;
        int n5 = n3 >>> 5 & 0xF;
        if (n5 == 0 && n2 != 2) {
            n5 = 16;
        }
        int n6 = n3 & 0xF;
        int n7 = n3 >>> 4 & 1;
        for (n = 6; n > 0 && n4 >> n == 0; --n) {
        }
        n4 = n4 << 6 - n & 0x3F;
        for (int i = 0; i < 1 << 6 - n; ++i) {
            huffmanTableEntryArray[n4 + i].tagLength = n;
            huffmanTableEntryArray[n4 + i].dataLength = n5;
            huffmanTableEntryArray[n4 + i].rightShift = n6;
            huffmanTableEntryArray[n4 + i].absolute = n7;
        }
    }

    private int processVertex() {
        int n;
        int n2;
        int n3;
        this.meshState = 0;
        HuffmanTableEntry huffmanTableEntry = this.gctables[0][this.currentHeader & 0x3F];
        int n4 = huffmanTableEntry.dataLength - huffmanTableEntry.rightShift;
        if (6 - 3 * n4 - huffmanTableEntry.tagLength > 0) {
            int n5 = 6 - 3 * n4 - huffmanTableEntry.tagLength;
            int n6 = this.currentHeader & BMASK[n5];
            n3 = this.getBits(3 - n5, "repcode/mbp");
            n3 |= n6 << 3 - n5;
        } else {
            n3 = this.getBits(3, "repcode/mbp");
        }
        this.repCode = n3 >>> 1;
        int n7 = n3 & 1;
        int n8 = this.currentHeader & BMASK[6 - huffmanTableEntry.tagLength];
        if (huffmanTableEntry.tagLength + n4 == 6) {
            n2 = this.getBits(n4, "y");
            n = this.getBits(n4, "z");
        } else if (huffmanTableEntry.tagLength + n4 < 6) {
            n8 >>= 6 - huffmanTableEntry.tagLength - n4;
            n2 = this.currentHeader & BMASK[6 - huffmanTableEntry.tagLength - n4];
            if (huffmanTableEntry.tagLength + 2 * n4 == 6) {
                n = this.getBits(n4, "z");
            } else if (huffmanTableEntry.tagLength + 2 * n4 < 6) {
                n2 >>= 6 - huffmanTableEntry.tagLength - 2 * n4;
                n = this.currentHeader & BMASK[6 - huffmanTableEntry.tagLength - 2 * n4];
                if (huffmanTableEntry.tagLength + 3 * n4 < 6) {
                    n >>= 6 - huffmanTableEntry.tagLength - 3 * n4;
                } else if (huffmanTableEntry.tagLength + 3 * n4 > 6) {
                    n3 = this.getBits(n4 - (6 - huffmanTableEntry.tagLength - 2 * n4), "z");
                    n = n << n4 - (6 - huffmanTableEntry.tagLength - 2 * n4) | n3;
                }
            } else {
                n3 = this.getBits(n4 - (6 - huffmanTableEntry.tagLength - n4), "y");
                n2 = n2 << n4 - (6 - huffmanTableEntry.tagLength - n4) | n3;
                n = this.getBits(n4, "z");
            }
        } else {
            n3 = this.getBits(n4 - (6 - huffmanTableEntry.tagLength), "x");
            n8 = n8 << n4 - (6 - huffmanTableEntry.tagLength) | n3;
            n2 = this.getBits(n4, "y");
            n = this.getBits(n4, "z");
        }
        n8 <<= 32 - n4;
        n2 <<= 32 - n4;
        n <<= 32 - n4;
        short s = (short)((n8 >>= 32 - n4) << huffmanTableEntry.rightShift);
        short s2 = (short)((n2 >>= 32 - n4) << huffmanTableEntry.rightShift);
        short s3 = (short)((n >>= 32 - n4) << huffmanTableEntry.rightShift);
        if (huffmanTableEntry.absolute != 0) {
            this.curX = s;
            this.curY = s2;
            this.curZ = s3;
        } else {
            this.curX = (short)(this.curX + s);
            this.curY = (short)(this.curY + s2);
            this.curZ = (short)(this.curZ + s3);
        }
        if (n7 != 0) {
            this.meshIndex = this.meshIndex + 1 & 0xF;
            this.meshBuffer[this.meshIndex].x = this.curX;
            this.meshBuffer[this.meshIndex].y = this.curY;
            this.meshBuffer[this.meshIndex].z = this.curZ;
        }
        float f = this.curX;
        f = (float)((double)f / 32768.0);
        float f2 = this.curY;
        f2 = (float)((double)f2 / 32768.0);
        float f3 = this.curZ;
        f3 = (float)((double)f3 / 32768.0);
        this.curPos.set(f, f2, f3);
        return n7;
    }

    private void processSetNormal(int n) {
        this.meshState &= 0xFFFFFFFE;
        HuffmanTableEntry huffmanTableEntry = this.gctables[2][this.currentHeader & 0x3F];
        int n2 = huffmanTableEntry.dataLength - huffmanTableEntry.rightShift;
        if (huffmanTableEntry.absolute != 0) {
            int n3 = this.currentHeader & BMASK[6 - huffmanTableEntry.tagLength];
            if (huffmanTableEntry.tagLength != 0) {
                int n4 = this.getBits(6 - (6 - huffmanTableEntry.tagLength), "sex/oct");
                n3 = n3 << 6 - (6 - huffmanTableEntry.tagLength) | n4;
            }
            this.curU = this.getBits(n2, "u");
            this.curV = this.getBits(n2, "v");
            this.curU <<= huffmanTableEntry.rightShift;
            this.curV <<= huffmanTableEntry.rightShift;
            this.curSex = n3 >> 3 & 7;
            this.curOct = n3 & 7;
        } else {
            int n5;
            int n6 = this.currentHeader & BMASK[6 - huffmanTableEntry.tagLength];
            if (huffmanTableEntry.tagLength + n2 < 6) {
                n6 >>= 6 - huffmanTableEntry.tagLength - n2;
                n5 = this.currentHeader & BMASK[6 - huffmanTableEntry.tagLength - n2];
                if (huffmanTableEntry.tagLength + 2 * n2 < 6) {
                    n5 >>= 6 - huffmanTableEntry.tagLength - 2 * n2;
                } else if (huffmanTableEntry.tagLength + 2 * n2 > 6) {
                    int n7 = this.getBits(n2 - (6 - huffmanTableEntry.tagLength - n2), "dv");
                    n5 = n5 << n2 - (6 - huffmanTableEntry.tagLength - n2) | n7;
                }
            } else if (huffmanTableEntry.tagLength + n2 > 6) {
                int n8 = this.getBits(n2 - (6 - huffmanTableEntry.tagLength), "du");
                n6 = n6 << n2 - (6 - huffmanTableEntry.tagLength) | n8;
                n5 = this.getBits(n2, "dv");
            } else {
                n5 = this.getBits(n2, "dv");
            }
            n6 <<= 32 - n2;
            n6 >>= 32 - n2;
            n5 <<= 32 - n2;
            n5 >>= 32 - n2;
            this.curU += (n6 <<= huffmanTableEntry.rightShift);
            this.curV += (n5 <<= huffmanTableEntry.rightShift);
            if (this.curU < 0 || this.curV < 0 || this.curU + this.curV > 64) {
                if (this.curU < 0 && this.curV >= 0) {
                    this.curU = -this.curU;
                    switch (this.curSex) {
                        case 0: {
                            this.curSex = 4;
                            break;
                        }
                        case 1: {
                            this.curSex = 5;
                            break;
                        }
                        case 2: {
                            this.curSex = 3;
                            break;
                        }
                        case 3: {
                            this.curSex = 2;
                            break;
                        }
                        case 4: {
                            this.curSex = 0;
                            break;
                        }
                        case 5: {
                            this.curSex = 1;
                        }
                    }
                } else if (this.curU >= 0 && this.curV < 0) {
                    this.curV = -this.curV;
                    switch (this.curSex) {
                        case 1: 
                        case 5: {
                            this.curOct ^= 4;
                            break;
                        }
                        case 0: 
                        case 4: {
                            this.curOct ^= 2;
                            break;
                        }
                        case 2: 
                        case 3: {
                            this.curOct ^= 1;
                        }
                    }
                } else if (this.curU + this.curV > 64) {
                    this.curU = 64 - this.curU;
                    this.curV = 64 - this.curV;
                    switch (this.curSex) {
                        case 0: {
                            this.curSex = 2;
                            break;
                        }
                        case 1: {
                            this.curSex = 3;
                            break;
                        }
                        case 2: {
                            this.curSex = 0;
                            break;
                        }
                        case 3: {
                            this.curSex = 1;
                            break;
                        }
                        case 4: {
                            this.curSex = 5;
                            break;
                        }
                        case 5: {
                            this.curSex = 4;
                        }
                    }
                } else {
                    throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryDecompressor1"));
                }
            }
        }
        if (n != 0) {
            this.meshBuffer[this.meshIndex].sextant = (short)this.curSex;
            this.meshBuffer[this.meshIndex].octant = (short)this.curOct;
            this.meshBuffer[this.meshIndex].u = (short)this.curU;
            this.meshBuffer[this.meshIndex].v = (short)this.curV;
        }
        this.indexNormal(this.curSex, this.curOct, this.curU, this.curV, this.curNorm);
        if (!this.bundlingNorm) {
            this.outputNormal(this.curNorm);
        }
    }

    private void indexNormal(int n, int n2, int n3, int n4, Vector3f vector3f) {
        float f;
        float f2;
        float f3;
        if (n > 5) {
            switch (n2 & 1) {
                case 0: {
                    switch ((n & 1) << 1 | (n2 & 4) >> 2) {
                        case 0: {
                            f3 = 1.0f;
                            f2 = 0.0f;
                            f = 0.0f;
                            break;
                        }
                        case 1: {
                            f = 1.0f;
                            f2 = 0.0f;
                            f3 = 0.0f;
                            break;
                        }
                        default: {
                            f2 = 1.0f;
                            f = 0.0f;
                            f3 = 0.0f;
                        }
                    }
                    n = 0;
                    n2 = (n2 & 2) >> 1;
                    n2 = n2 << 2 | n2 << 1 | n2;
                    break;
                }
                default: {
                    n2 = (n & 1) << 2 | n2 >> 1;
                    n = 0;
                    f = f2 = (float)(1.0 / Math.sqrt(3.0));
                    f3 = f2;
                }
            }
            if ((n2 & 1) != 0) {
                f2 = -f2;
            }
            if ((n2 & 2) != 0) {
                f = -f;
            }
            if ((n2 & 4) != 0) {
                f3 = -f3;
            }
        } else {
            float f4;
            f3 = (float)gcNormals[n4][n3][0];
            f = (float)gcNormals[n4][n3][1];
            f2 = (float)gcNormals[n4][n3][2];
            if ((n & 4) != 0) {
                f4 = f3;
                f3 = f2;
                f2 = f4;
            }
            if ((n & 2) != 0) {
                f4 = f;
                f = f2;
                f2 = f4;
            }
            if ((n & 1) != 0) {
                f4 = f3;
                f3 = f;
                f = f4;
            }
            if ((n2 & 1) != 0) {
                f2 = -f2;
            }
            if ((n2 & 2) != 0) {
                f = -f;
            }
            if ((n2 & 4) != 0) {
                f3 = -f3;
            }
        }
        vector3f.set(f3, f, f2);
    }

    private void processSetColor(int n) {
        int n2;
        int n3;
        this.meshState &= 0xFFFFFFFD;
        HuffmanTableEntry huffmanTableEntry = this.gctables[1][this.currentHeader & 0x3F];
        int n4 = huffmanTableEntry.dataLength - huffmanTableEntry.rightShift;
        int n5 = this.currentHeader & BMASK[6 - huffmanTableEntry.tagLength];
        int n6 = 0;
        if (huffmanTableEntry.tagLength + n4 == 6) {
            n3 = this.getBits(n4, "g");
            n2 = this.getBits(n4, "b");
            if (this.doingAlpha) {
                n6 = this.getBits(n4, "a");
            }
        } else if (huffmanTableEntry.tagLength + n4 < 6) {
            n5 >>= 6 - huffmanTableEntry.tagLength - n4;
            n3 = this.currentHeader & BMASK[6 - huffmanTableEntry.tagLength - n4];
            if (huffmanTableEntry.tagLength + 2 * n4 == 6) {
                n2 = this.getBits(n4, "b");
                if (this.doingAlpha) {
                    n6 = this.getBits(n4, "a");
                }
            } else if (huffmanTableEntry.tagLength + 2 * n4 < 6) {
                n3 >>= 6 - huffmanTableEntry.tagLength - 2 * n4;
                n2 = this.currentHeader & BMASK[6 - huffmanTableEntry.tagLength - 2 * n4];
                if (huffmanTableEntry.tagLength + 3 * n4 == 6) {
                    if (this.doingAlpha) {
                        n6 = this.getBits(n4, "a");
                    }
                } else if (huffmanTableEntry.tagLength + 3 * n4 < 6) {
                    n2 >>= 6 - huffmanTableEntry.tagLength - 3 * n4;
                    if (this.doingAlpha) {
                        n6 = this.currentHeader & BMASK[6 - huffmanTableEntry.tagLength - 4 * n4];
                        if (huffmanTableEntry.tagLength + 4 * n4 < 6) {
                            n6 >>= 6 - huffmanTableEntry.tagLength - 3 * n4;
                        } else if (huffmanTableEntry.tagLength + 4 * n4 > 6) {
                            int n7 = this.getBits(n4 - (6 - huffmanTableEntry.tagLength - 3 * n4), "a");
                            n6 = n6 << n4 - (6 - huffmanTableEntry.tagLength - 3 * n4) | n7;
                        }
                    }
                } else {
                    int n8 = this.getBits(n4 - (6 - huffmanTableEntry.tagLength - 2 * n4), "b");
                    n2 = n2 << n4 - (6 - huffmanTableEntry.tagLength - 2 * n4) | n8;
                    if (this.doingAlpha) {
                        n6 = this.getBits(n4, "a");
                    }
                }
            } else {
                int n9 = this.getBits(n4 - (6 - huffmanTableEntry.tagLength - n4), "g");
                n3 = n3 << n4 - (6 - huffmanTableEntry.tagLength - n4) | n9;
                n2 = this.getBits(n4, "b");
                if (this.doingAlpha) {
                    n6 = this.getBits(n4, "a");
                }
            }
        } else {
            int n10 = this.getBits(n4 - (6 - huffmanTableEntry.tagLength), "r");
            n5 = n5 << n4 - (6 - huffmanTableEntry.tagLength) | n10;
            n3 = this.getBits(n4, "g");
            n2 = this.getBits(n4, "b");
            if (this.doingAlpha) {
                n6 = this.getBits(n4, "a");
            }
        }
        n5 <<= 32 - n4;
        n3 <<= 32 - n4;
        n2 <<= 32 - n4;
        n6 <<= 32 - n4;
        short s = (short)((n5 >>= 32 - n4) << huffmanTableEntry.rightShift);
        short s2 = (short)((n3 >>= 32 - n4) << huffmanTableEntry.rightShift);
        short s3 = (short)((n2 >>= 32 - n4) << huffmanTableEntry.rightShift);
        short s4 = (short)((n6 >>= 32 - n4) << huffmanTableEntry.rightShift);
        if (huffmanTableEntry.absolute != 0) {
            this.curR = s;
            this.curG = s2;
            this.curB = s3;
            if (this.doingAlpha) {
                this.curA = s4;
            }
        } else {
            this.curR = (short)(this.curR + s);
            this.curG = (short)(this.curG + s2);
            this.curB = (short)(this.curB + s3);
            if (this.doingAlpha) {
                this.curA = (short)(this.curA + s4);
            }
        }
        if (n != 0) {
            this.meshBuffer[this.meshIndex].r = this.curR;
            this.meshBuffer[this.meshIndex].g = this.curG;
            this.meshBuffer[this.meshIndex].b = this.curB;
            this.meshBuffer[this.meshIndex].a = this.curA;
        }
        float f = this.curR;
        f = (float)((double)f / 32768.0);
        float f2 = this.curG;
        f2 = (float)((double)f2 / 32768.0);
        float f3 = this.curB;
        f3 = (float)((double)f3 / 32768.0);
        float f4 = this.curA;
        f4 = (float)((double)f4 / 32768.0);
        this.curColor.set(f, f2, f3, f4);
        if (!this.bundlingColor) {
            this.outputColor(this.curColor);
        }
    }

    private void processMeshBR() {
        int n = this.getBits(1, "mbr");
        int n2 = this.currentHeader >>> 1 & 0xF;
        this.repCode = (this.currentHeader & 1) << 1 | n;
        n2 = this.meshIndex - n2 & 0xF;
        MeshBufferEntry meshBufferEntry = this.meshBuffer[n2];
        this.curX = meshBufferEntry.x;
        this.curY = meshBufferEntry.y;
        this.curZ = meshBufferEntry.z;
        this.curPos.set((float)this.curX / 32768.0f, (float)this.curY / 32768.0f, (float)this.curZ / 32768.0f);
        if (this.bundlingNorm && (this.meshState & 1) != 0) {
            this.curSex = meshBufferEntry.sextant;
            this.curOct = meshBufferEntry.octant;
            this.curU = meshBufferEntry.u;
            this.curV = meshBufferEntry.v;
            int n3 = this.curSex << 15 | this.curOct << 12 | this.curU << 6 | this.curV;
            this.indexNormal(this.curSex, this.curOct, this.curU, this.curV, this.curNorm);
        }
        if (this.bundlingColor && (this.meshState & 2) != 0) {
            this.curR = meshBufferEntry.r;
            this.curG = meshBufferEntry.g;
            this.curB = meshBufferEntry.b;
            this.curColor.x = this.curR;
            this.curColor.x = (float)((double)this.curColor.x / 32768.0);
            this.curColor.y = this.curG;
            this.curColor.y = (float)((double)this.curColor.y / 32768.0);
            this.curColor.z = this.curB;
            this.curColor.z = (float)((double)this.curColor.z / 32768.0);
            if (this.doingAlpha) {
                this.curA = meshBufferEntry.a;
                this.curColor.w = this.curA;
                this.curColor.w = (float)((double)this.curColor.w / 32768.0);
            }
        }
        this.meshState = 0;
    }

    private void processEos() {
    }

    private void processVNoop() {
        int n = this.getBits(5, "noop count");
        int n2 = this.getBits(n, "noop bits");
    }

    private void processPassThrough() {
        int n = this.getBits(24, "passthrough");
        n = this.getBits(32, "passthrough");
    }

    private void processSkip8() {
        int n = this.getBits(8, "skip8");
    }

    private void benchmarkStart(int n) {
        this.vertexCount = 0;
        System.out.println(" GeometryDecompressor: decompressing " + n + " bytes...");
        this.startTime = System.currentTimeMillis();
    }

    private void benchmarkPrint(int n) {
        float f = (float)(System.currentTimeMillis() - this.startTime) / 1000.0f;
        System.out.println("  done in " + f + " sec.\n  decompressed " + this.vertexCount + " vertices at " + (float)this.vertexCount / f + " vertices/sec\n");
        System.out.print("  vertex data present: coords");
        int n2 = 12;
        if (this.bundlingNorm) {
            System.out.print(" normals");
            n2 += 12;
        }
        if (this.bundlingColor) {
            System.out.println(" colors");
            n2 += 12;
        }
        if (this.doingAlpha) {
            System.out.println(" alpha");
            n2 += 4;
        }
        System.out.println();
        System.out.println("  bytes of data in generalized strip output: " + this.vertexCount * n2 + "\n  compression ratio: " + (float)n / (float)(this.vertexCount * n2) + "\n");
    }

    static {
        for (int i = 0; i < 65; ++i) {
            for (int j = 0; j < 65; ++j) {
                if (i + j > 64) continue;
                double d = 0.615479709 * ((double)i / 64.0);
                double d2 = Math.asin(Math.tan(0.615479709 * ((double)(64 - j) / 64.0)));
                double d3 = Math.cos(d2) * Math.cos(d);
                double d4 = Math.sin(d);
                double d5 = Math.sin(d2) * Math.cos(d);
                int n = (int)(d3 *= 16384.0);
                d3 = n;
                int n2 = (int)(d4 *= 16384.0);
                d4 = n2;
                int n3 = (int)(d5 *= 16384.0);
                d5 = n3;
                GeometryDecompressor.gcNormals[i][j][0] = d3 /= 16384.0;
                GeometryDecompressor.gcNormals[i][j][1] = d4 /= 16384.0;
                GeometryDecompressor.gcNormals[i][j][2] = d5 /= 16384.0;
            }
        }
    }

    static class MeshBufferEntry {
        short x;
        short y;
        short z;
        short octant;
        short sextant;
        short u;
        short v;
        short r;
        short g;
        short b;
        short a;

        MeshBufferEntry() {
        }
    }

    static class HuffmanTableEntry {
        int tagLength;
        int dataLength;
        int rightShift;
        int absolute;

        HuffmanTableEntry() {
        }

        public String toString() {
            return " tag length: " + this.tagLength + " data length: " + this.dataLength + " shift: " + this.rightShift + " abs/rel: " + this.absolute;
        }
    }
}

