/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.j3d.loaders.md3;

import java.io.IOException;
import java.util.HashMap;
import javax.media.j3d.Transform3D;
import javax.vecmath.Matrix3f;
import javax.vecmath.Vector3f;
import org.newdawn.j3d.loaders.cio.LittleEndianDataInputStream;
import org.newdawn.j3d.loaders.md3.Util;

public class MD3Header {
    private byte[] ID = new byte[4];
    private int version;
    private String filename;
    private int boneFrameNum;
    private int tagNum;
    private int meshNum;
    private int maxSkinNum;
    private int headerLength;
    private int fileSize;
    private int tagStart;
    private int tagEnd;
    private HashMap[] tags;

    public MD3Header(LittleEndianDataInputStream in) throws IOException {
        in.readFully(this.ID);
        this.version = in.readInt();
        this.filename = Util.readString(in, 68);
        this.boneFrameNum = in.readInt();
        this.tagNum = in.readInt();
        this.meshNum = in.readInt();
        this.maxSkinNum = in.readInt();
        this.headerLength = in.readInt();
        this.tagStart = in.readInt();
        this.tagEnd = in.readInt();
        this.fileSize = in.readInt();
        in.skipBytes(this.tagStart - 108);
        int tagCount = this.tagNum;
        this.tags = new HashMap[this.boneFrameNum];
        int k = 0;
        while (k < this.boneFrameNum) {
            this.tags[k] = new HashMap();
            int i = 0;
            while (i < tagCount) {
                String tagName = Util.readString(in, 64);
                Vector3f trans = new Vector3f(in.readFloat(), in.readFloat(), in.readFloat());
                float m00 = in.readFloat();
                float m10 = in.readFloat();
                float m20 = in.readFloat();
                float m01 = in.readFloat();
                float m11 = in.readFloat();
                float m21 = in.readFloat();
                float m02 = in.readFloat();
                float m12 = in.readFloat();
                float m22 = in.readFloat();
                Matrix3f mat = new Matrix3f(m00, m10, m20, m01, m11, m21, m02, m12, m22);
                Transform3D mov = new Transform3D(mat, trans, 1.0f);
                this.tags[k].put(tagName, mov);
                ++i;
            }
            ++k;
        }
    }

    public void skipToMeshs(LittleEndianDataInputStream in) throws IOException {
        in.skipBytes(this.tagEnd);
    }

    public Transform3D getTagTransform(int frame, String tag) {
        return (Transform3D)this.tags[frame].get(tag);
    }

    public HashMap getTransformMap(int frame) {
        return this.tags[frame];
    }

    public int getMeshCount() {
        return this.meshNum;
    }

    public int getMeshStart() {
        return this.tagEnd;
    }
}

