/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.j3d.loaders.md3;

import com.sun.j3d.utils.image.TextureLoader;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.media.j3d.Appearance;
import javax.media.j3d.Texture;

public class MD3Skins {
    private HashMap map = new HashMap();

    public MD3Skins(DataInputStream in, String path) throws IOException {
        while (in.available() > 0) {
            String line = in.readLine();
            if (line == null) {
                return;
            }
            StringTokenizer tokens = new StringTokenizer(line, ",");
            if (tokens.countTokens() != 2) continue;
            String meshName = tokens.nextToken();
            String skinName = tokens.nextToken();
            URL url = ClassLoader.getSystemResource(path + "/" + skinName);
            if (url == null) {
                System.out.println("can't find: " + path + "/" + skinName);
                continue;
            }
            Texture tex = new TextureLoader(url, "RGBA", null).getTexture();
            Appearance app = new Appearance();
            app.setTexture(tex);
            this.map.put(meshName, app);
        }
    }

    public Appearance getTextureForMesh(String meshName) {
        return (Appearance)this.map.get(meshName);
    }
}

