/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.acerola3d.a3;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.imageio.ImageIO;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.GraphicsConfigTemplate3D;
import javax.media.j3d.GraphicsContext3D;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.J3DGraphics2D;
import javax.media.j3d.Light;
import javax.media.j3d.Node;
import javax.media.j3d.PhysicalBody;
import javax.media.j3d.PhysicalEnvironment;
import javax.media.j3d.Raster;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.View;
import javax.media.j3d.ViewPlatform;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Quat4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import jp.sourceforge.acerola3d.a3.A3BranchGroup;
import jp.sourceforge.acerola3d.a3.A3CanvasInterface;
import jp.sourceforge.acerola3d.a3.A3Controller;
import jp.sourceforge.acerola3d.a3.A3Listener;
import jp.sourceforge.acerola3d.a3.A3Object;
import jp.sourceforge.acerola3d.a3.A3VirtualUniverse;
import jp.sourceforge.acerola3d.a3.ChaseController;
import jp.sourceforge.acerola3d.a3.Component2D;
import jp.sourceforge.acerola3d.a3.Component2DComparator;
import jp.sourceforge.acerola3d.a3.Component2DContainerInterface;
import jp.sourceforge.acerola3d.a3.EditController;
import jp.sourceforge.acerola3d.a3.ExamController;
import jp.sourceforge.acerola3d.a3.FlyController;
import jp.sourceforge.acerola3d.a3.NoneController;
import jp.sourceforge.acerola3d.a3.PickingBehavior;
import jp.sourceforge.acerola3d.a3.ProjectionMode;
import jp.sourceforge.acerola3d.a3.SimpleController;
import jp.sourceforge.acerola3d.a3.SubCameraBehavior;
import jp.sourceforge.acerola3d.a3.WalkController;

public class A3SubCanvas
extends Canvas3D
implements A3CanvasInterface,
Component2DContainerInterface {
    private static final long serialVersionUID = 1L;
    BranchGroup viewPlatformBG;
    SubCameraBehavior subCamBehavior;
    View view;
    Transform3D t;
    TransformGroup tg;
    Light headLight;
    PickingBehavior pickingBehavior;
    A3VirtualUniverse virtualUniverse;
    Hashtable<A3Object, BranchGroup> lockedA3Hash = new Hashtable();
    BranchGroup cameraGroup;
    A3Object avatar;
    A3Controller controller = null;
    double naviSpeed = 1.0;
    A3Object.UpperDirection upperDirection = A3Object.UpperDirection.Y;
    A3CanvasInterface.NaviMode naviMode = A3CanvasInterface.NaviMode.NONE;
    long fpsStartTime;
    int fpsCounter = 0;
    int fps;
    volatile boolean check = false;
    GraphicsContext3D gc;
    Raster readRaster;
    ArrayList<Component2D> components2D = new ArrayList();

    public static A3SubCanvas createA3SubCanvas() {
        return A3SubCanvas.createA3SubCanvas(500, 500);
    }

    public static A3SubCanvas createA3SubCanvas(int w, int h) {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = ge.getDefaultScreenDevice();
        GraphicsConfiguration[] gcs = gd.getConfigurations();
        GraphicsConfigTemplate3D gct3d = new GraphicsConfigTemplate3D();
        GraphicsConfiguration gc = gct3d.getBestConfiguration(gcs);
        return A3SubCanvas.createA3SubCanvas(gc, w, h);
    }

    public static A3SubCanvas createA3SubCanvas(GraphicsConfiguration graCon) {
        return A3SubCanvas.createA3SubCanvas(graCon, 500, 500);
    }

    public static A3SubCanvas createA3SubCanvas(GraphicsConfiguration graCon, int w, int h) {
        return new A3SubCanvas(graCon, w, h);
    }

    A3SubCanvas(GraphicsConfiguration graCon, int w, int h) {
        super(graCon);
        this.setSize(w, h);
        PhysicalBody pBody = new PhysicalBody();
        PhysicalEnvironment pEnv = new PhysicalEnvironment();
        this.viewPlatformBG = new BranchGroup();
        this.t = new Transform3D();
        ViewPlatform viewPlatform = new ViewPlatform();
        this.tg = new TransformGroup(this.t);
        this.tg.setCapability(18);
        this.tg.setCapability(17);
        this.tg.addChild((Node)viewPlatform);
        this.viewPlatformBG.addChild((Node)this.tg);
        this.cameraGroup = new BranchGroup();
        this.cameraGroup.setCapability(17);
        this.cameraGroup.setCapability(12);
        this.cameraGroup.setCapability(14);
        this.cameraGroup.setCapability(13);
        this.tg.addChild((Node)this.cameraGroup);
        this.headLight = new DirectionalLight();
        this.headLight.setCapability(13);
        this.headLight.setInfluencingBounds((Bounds)new BoundingSphere(new Point3d(0.0, 0.0, 0.0), Double.MAX_VALUE));
        this.headLight.setEnable(false);
        this.tg.addChild((Node)this.headLight);
        this.view = new View();
        this.view.addCanvas3D((Canvas3D)this);
        this.view.setPhysicalBody(pBody);
        this.view.setPhysicalEnvironment(pEnv);
        this.view.attachViewPlatform(viewPlatform);
        this.subCamBehavior = new SubCameraBehavior(this.tg);
        this.viewPlatformBG.addChild((Node)this.subCamBehavior);
        this.subCamBehavior.setSchedulingBounds((Bounds)new BoundingSphere(new Point3d(0.0, 0.0, 0.0), Double.MAX_VALUE));
    }

    @Override
    public BranchGroup getBranchGroupForViewPlatform() {
        return this.viewPlatformBG;
    }

    @Override
    public void setPickingBehavior(PickingBehavior pb) {
        this.pickingBehavior = pb;
        this.viewPlatformBG.addChild((Node)pb);
    }

    @Override
    public void setVirtualUniverse(A3VirtualUniverse vu) {
        this.virtualUniverse = vu;
        this.subCamBehavior.setA3VirtualUniverse(vu);
    }

    @Override
    public void setDefaultCameraLoc(double x, double y, double z) {
        this.subCamBehavior.setDefaultCameraLoc(x, y, z);
    }

    @Override
    public void setDefaultCameraLoc(Vector3d loc) {
        this.subCamBehavior.setDefaultCameraLoc(loc);
    }

    @Override
    public void setDefaultCameraQuat(double x, double y, double z, double w) {
        this.subCamBehavior.setDefaultCameraQuat(x, y, z, w);
    }

    @Override
    public void setDefaultCameraQuat(Quat4d quat) {
        this.subCamBehavior.setDefaultCameraQuat(quat);
    }

    @Override
    public void setDefaultCameraRot(double x, double y, double z) {
        this.subCamBehavior.setDefaultCameraRot(x, y, z);
    }

    @Override
    public void setDefaultCameraRot(Vector3d rot) {
        this.subCamBehavior.setDefaultCameraRot(rot);
    }

    @Override
    public void setDefaultCameraScale(double s) {
        this.subCamBehavior.setDefaultCameraScale(s);
    }

    @Override
    public void resetCamera() {
        this.subCamBehavior.resetCamera();
    }

    @Override
    public void setCameraLoc(double x, double y, double z) {
        this.subCamBehavior.setCameraLoc(x, y, z);
    }

    @Override
    public void setCameraLoc(Vector3d loc) {
        this.subCamBehavior.setCameraLoc(loc);
    }

    @Override
    public void setCameraLocImmediately(double x, double y, double z) {
        this.subCamBehavior.setCameraLocImmediately(x, y, z);
    }

    @Override
    public void setCameraLocImmediately(Vector3d loc) {
        this.subCamBehavior.setCameraLocImmediately(loc);
    }

    @Override
    public void addCameraLoc(double x, double y, double z) {
        this.subCamBehavior.addCameraLoc(x, y, z);
    }

    @Override
    public void addCameraLoc(Vector3d loc) {
        this.subCamBehavior.addCameraLoc(loc);
    }

    @Override
    public void addCameraLocImmediately(double x, double y, double z) {
        this.subCamBehavior.addCameraLocImmediately(x, y, z);
    }

    @Override
    public void addCameraLocImmediately(Vector3d loc) {
        this.subCamBehavior.addCameraLocImmediately(loc);
    }

    @Override
    public Vector3d getCameraLoc() {
        return this.subCamBehavior.getCameraLoc();
    }

    @Override
    public Vector3d getCameraTargetLoc() {
        return this.subCamBehavior.getCameraTargetLoc();
    }

    @Override
    public void setCameraQuat(double x, double y, double z, double w) {
        this.subCamBehavior.setCameraQuat(x, y, z, w);
    }

    @Override
    public void setCameraQuat(Quat4d quat) {
        this.subCamBehavior.setCameraQuat(quat);
    }

    @Override
    public void setCameraQuatImmediately(double x, double y, double z, double w) {
        this.subCamBehavior.setCameraQuatImmediately(x, y, z, w);
    }

    @Override
    public void setCameraQuatImmediately(Quat4d quat) {
        this.subCamBehavior.setCameraQuatImmediately(quat);
    }

    @Override
    public void mulCameraQuat(double x, double y, double z, double w) {
        this.subCamBehavior.mulCameraQuat(x, y, z, w);
    }

    @Override
    public void mulCameraQuat(Quat4d quat) {
        this.subCamBehavior.mulCameraQuat(quat);
    }

    @Override
    public void mulCameraQuatImmediately(double x, double y, double z, double w) {
        this.subCamBehavior.mulCameraQuatImmediately(x, y, z, w);
    }

    @Override
    public void mulCameraQuatImmediately(Quat4d quat) {
        this.subCamBehavior.mulCameraQuatImmediately(quat);
    }

    @Override
    public Quat4d getCameraQuat() {
        return this.subCamBehavior.getCameraQuat();
    }

    @Override
    public Quat4d getCameraTargetQuat() {
        return this.subCamBehavior.getCameraTargetQuat();
    }

    @Override
    public void setCameraRot(double x, double y, double z) {
        this.subCamBehavior.setCameraRot(x, y, z);
    }

    @Override
    public void setCameraRot(Vector3d rot) {
        this.subCamBehavior.setCameraRot(rot);
    }

    @Override
    public void setCameraRotImmediately(double x, double y, double z) {
        this.subCamBehavior.setCameraRotImmediately(x, y, z);
    }

    @Override
    public void setCameraRotImmediately(Vector3d rot) {
        this.subCamBehavior.setCameraRotImmediately(rot);
    }

    @Override
    public void mulCameraRot(double x, double y, double z) {
        this.subCamBehavior.mulCameraRot(x, y, z);
    }

    @Override
    public void mulCameraRot(Vector3d rot) {
        this.subCamBehavior.mulCameraRot(rot);
    }

    @Override
    public void mulCameraRotImmediately(double x, double y, double z) {
        this.subCamBehavior.mulCameraRotImmediately(x, y, z);
    }

    @Override
    public void mulCameraRotImmediately(Vector3d rot) {
        this.subCamBehavior.setCameraRotImmediately(rot);
    }

    @Override
    public Vector3d getCameraRot() {
        return this.subCamBehavior.getCameraRot();
    }

    @Override
    public Vector3d getCameraTargetRot() {
        return this.subCamBehavior.getCameraTargetRot();
    }

    @Override
    public void setCameraScale(double s) {
        this.subCamBehavior.setCameraScale(s);
    }

    @Override
    public void setCameraScaleImmediately(double s) {
        this.subCamBehavior.setCameraScaleImmediately(s);
    }

    @Override
    public void mulCameraScale(double s) {
        this.subCamBehavior.mulCameraScale(s);
    }

    @Override
    public void mulCameraScaleImmediately(double s) {
        this.subCamBehavior.mulCameraScaleImmediately(s);
    }

    @Override
    public double getCameraScale() {
        return this.subCamBehavior.getCameraScale();
    }

    @Override
    public double getCameraTargetScale() {
        return this.subCamBehavior.getCameraTargetScale();
    }

    @Override
    public void setCameraLookAtPoint(Vector3d lookAt, Vector3d up) {
        this.subCamBehavior.setCameraLookAtPoint(lookAt, up);
    }

    @Override
    public void setCameraLookAtPointImmediately(Vector3d lookAt, Vector3d up) {
        this.subCamBehavior.setCameraLookAtPointImmediately(lookAt, up);
    }

    @Override
    public void setCameraLookAtPoint(double x, double y, double z, Vector3d up) {
        this.subCamBehavior.setCameraLookAtPoint(x, y, z, up);
    }

    @Override
    public void setCameraLookAtPointImmediately(double x, double y, double z, Vector3d up) {
        this.subCamBehavior.setCameraLookAtPointImmediately(x, y, z, up);
    }

    @Override
    public void setCameraLookAtPoint(Vector3d lookAt) {
        Vector3d up = new Vector3d();
        if (this.upperDirection == A3Object.UpperDirection.Y) {
            up.y = 1.0;
        } else if (this.upperDirection == A3Object.UpperDirection.Z) {
            up.z = 1.0;
        }
        this.subCamBehavior.setCameraLookAtPoint(lookAt, up);
    }

    @Override
    public void setCameraLookAtPoint(double x, double y, double z) {
        Vector3d up = new Vector3d();
        if (this.upperDirection == A3Object.UpperDirection.Y) {
            up.y = 1.0;
        } else if (this.upperDirection == A3Object.UpperDirection.Z) {
            up.z = 1.0;
        }
        this.subCamBehavior.setCameraLookAtPoint(x, y, z, up);
    }

    @Override
    public void setCameraLookAtPointImmediately(Vector3d lookAt) {
        Vector3d up = new Vector3d();
        if (this.upperDirection == A3Object.UpperDirection.Y) {
            up.y = 1.0;
        } else if (this.upperDirection == A3Object.UpperDirection.Z) {
            up.z = 1.0;
        }
        this.subCamBehavior.setCameraLookAtPointImmediately(lookAt, up);
    }

    @Override
    public void setCameraLookAtPointImmediately(double x, double y, double z) {
        Vector3d up = new Vector3d();
        if (this.upperDirection == A3Object.UpperDirection.Y) {
            up.y = 1.0;
        } else if (this.upperDirection == A3Object.UpperDirection.Z) {
            up.z = 1.0;
        }
        this.subCamBehavior.setCameraLookAtPointImmediately(x, y, z, up);
    }

    @Override
    public Point3d canvasToVirtualCS(int x, int y) {
        if (this.avatar == null) {
            return null;
        }
        Vector3d v1 = this.avatar.getLoc();
        Vector3d v2 = this.subCamBehavior.getCameraLoc();
        Vector3d v = new Vector3d();
        v.sub((Tuple3d)v1, (Tuple3d)v2);
        Vector3d p = this.virtualCSToPhysicalCS(v);
        return this.canvasToVirtualCS(x, y, p.z);
    }

    @Override
    public Point3d canvasToVirtualCS(int x, int y, double dis) {
        Point3d p = this.canvasToPhysicalCS(x, y, dis);
        this.tg.getTransform(this.t);
        this.t.transform(p);
        return p;
    }

    @Override
    public Point3d canvasToPhysicalCS(int x, int y) {
        if (this.avatar == null) {
            return null;
        }
        Vector3d v1 = this.avatar.getLoc();
        Vector3d v2 = this.subCamBehavior.getCameraLoc();
        Vector3d v = new Vector3d();
        v.sub((Tuple3d)v1, (Tuple3d)v2);
        Vector3d p = this.virtualCSToPhysicalCS(v);
        return this.canvasToPhysicalCS(x, y, p.z);
    }

    @Override
    public Point3d canvasToPhysicalCS(int x, int y, double dis) {
        int dw = this.getWidth();
        int dh = this.getHeight();
        double ww = this.getPhysicalWidth();
        double hh = this.getPhysicalHeight();
        double tt = this.view.getFieldOfView();
        double dx = (double)x * ww / (double)dw - ww / 2.0;
        double dy = -((double)y) * hh / (double)dh + hh / 2.0;
        double dz = -ww / 2.0 / Math.tan(tt / 2.0);
        if (this.view.getProjectionPolicy() == 0) {
            double s = this.view.getScreenScale();
            double sw = this.getScreen3D().getPhysicalScreenWidth();
            return new Point3d(dx / s * (sw / ww), dy / s * (sw / ww), -dis);
        }
        double s = dis / -dz;
        return new Point3d(s * dx, s * dy, s * dz);
    }

    @Override
    public Vector3d physicalCSToVirtualCS(Vector3d v) {
        Point3d p = new Point3d((Tuple3d)v);
        this.tg.getTransform(this.t);
        this.t.transform(p);
        return new Vector3d((Tuple3d)p);
    }

    @Override
    public Point physicalCSToCanvas(Point3d p) {
        int dw = this.getWidth();
        int dh = this.getHeight();
        double ww = this.getPhysicalWidth();
        double hh = this.getPhysicalHeight();
        double tt = this.view.getFieldOfView();
        tt = ww / 2.0 / Math.tan(tt / 2.0);
        double zz = -p.z;
        Point ret = new Point();
        if (this.view.getProjectionPolicy() == 0) {
            double s = this.view.getScreenScale();
            double sw = this.getScreen3D().getPhysicalScreenWidth();
            ret.x = (int)(p.x * ((double)dw / ww) * s * ww / sw + (double)(dw / 2));
            ret.y = (int)(-p.y * ((double)dh / hh) * s * ww / sw + (double)(dh / 2));
        } else {
            ret.x = (int)(p.x * ((double)dw / ww) / (zz / tt)) + dw / 2;
            ret.y = (int)(-p.y * ((double)dh / hh) / (zz / tt)) + dh / 2;
        }
        return ret;
    }

    @Override
    public Point virtualCSToCanvas(Point3d p) {
        this.tg.getTransform(this.t);
        this.t.invert();
        this.t.transform(p);
        return this.physicalCSToCanvas(p);
    }

    @Override
    public Vector3d virtualCSToPhysicalCS(Vector3d v) {
        Point3d p = new Point3d((Tuple3d)v);
        this.tg.getTransform(this.t);
        this.t.invert();
        this.t.transform(p);
        return new Vector3d((Tuple3d)p);
    }

    @Override
    public Vector3d getCameraUnitVecX() {
        Vector3d v = this.physicalCSToVirtualCS(new Vector3d(1.0, 0.0, 0.0));
        v.sub((Tuple3d)this.subCamBehavior.cameraNowV);
        return v;
    }

    @Override
    public Vector3d getCameraUnitVecY() {
        Vector3d v = this.physicalCSToVirtualCS(new Vector3d(0.0, 1.0, 0.0));
        v.sub((Tuple3d)this.subCamBehavior.cameraNowV);
        return v;
    }

    @Override
    public Vector3d getCameraUnitVecZ() {
        Vector3d v = this.physicalCSToVirtualCS(new Vector3d(0.0, 0.0, 1.0));
        v.sub((Tuple3d)this.subCamBehavior.cameraNowV);
        return v;
    }

    @Override
    public void setProjectionMode(ProjectionMode m) {
        if (m == ProjectionMode.PERSPECTIVE) {
            this.view.setProjectionPolicy(1);
            this.view.setScreenScalePolicy(0);
        } else if (m == ProjectionMode.PARALLEL) {
            this.view.setProjectionPolicy(0);
            this.view.setScreenScalePolicy(1);
        }
    }

    @Override
    public void setCanvasWidthInPWorld(double s) {
        double psw = this.getScreen3D().getPhysicalScreenWidth();
        this.view.setScreenScale(psw / s);
    }

    @Override
    public void setFieldOfView(double f) {
        this.view.setFieldOfView(f);
    }

    @Override
    public A3Object pickA3(int x, int y) {
        return this.pickingBehavior.pickA3(x, y);
    }

    @Override
    public Dimension getCanvasSize() {
        return this.getSize();
    }

    @Override
    public void cleanUp() {
    }

    @Override
    public TransformGroup getTransformGroupForViewPlatform() {
        return this.tg;
    }

    @Override
    public Canvas3D getCanvas3D() {
        return this;
    }

    @Override
    public void setAvatar(A3Object a3) {
        this.avatar = a3;
    }

    @Override
    public A3Object getAvatar() {
        return this.avatar;
    }

    void setA3Controller0(A3Controller c) {
        if (c != null) {
            c.setA3CanvasInterface(this);
        }
        if (this.controller != null) {
            this.removeA3Listener(this.controller);
            this.removeKeyListener(this.controller);
            this.controller.stop();
        }
        this.controller = c;
        if (this.controller != null) {
            this.addA3Listener(this.controller);
            this.addKeyListener(this.controller);
            this.controller.init();
        }
    }

    @Override
    public void setA3Controller(A3Controller c) {
        this.naviMode = A3CanvasInterface.NaviMode.USER;
        this.setA3Controller0(c);
    }

    @Override
    public void addA3Listener(A3Listener l) {
        this.pickingBehavior.addA3Listener(l);
    }

    @Override
    public double getNavigationSpeed() {
        return this.naviSpeed;
    }

    @Override
    public A3Object.UpperDirection getUpperDirection() {
        return this.upperDirection;
    }

    @Override
    public void removeA3Listener(A3Listener l) {
        this.pickingBehavior.removeA3Listener(l);
    }

    @Override
    public void setHeadLightEnable(boolean b) {
        this.headLight.setEnable(b);
    }

    @Override
    public void setNavigationMode(A3CanvasInterface.NaviMode m, Object ... params) {
        this.naviMode = m;
        if (this.naviMode == A3CanvasInterface.NaviMode.NONE) {
            this.setA3Controller0(new NoneController());
        } else if (this.naviMode == A3CanvasInterface.NaviMode.WALK) {
            this.setA3Controller0(new WalkController());
        } else if (this.naviMode == A3CanvasInterface.NaviMode.FLY) {
            this.setA3Controller0(new FlyController());
        } else if (this.naviMode == A3CanvasInterface.NaviMode.EXAMINE) {
            this.setA3Controller0(new ExamController());
        } else if (this.naviMode == A3CanvasInterface.NaviMode.EDIT) {
            this.setA3Controller0(new EditController());
        } else if (this.naviMode == A3CanvasInterface.NaviMode.SIMPLE) {
            this.setA3Controller0(new SimpleController(params));
        } else if (this.naviMode == A3CanvasInterface.NaviMode.CHASE) {
            this.setA3Controller0(new ChaseController(params));
        }
    }

    public synchronized void postRender() {
        Component2D[] cs;
        for (Component2D c : cs = this.components2D.toArray(new Component2D[0])) {
            c.calPhysicalZ(this);
        }
        Arrays.sort(cs, Component2DComparator.comparator);
        J3DGraphics2D gg = this.getGraphics2D();
        for (Component2D c : cs) {
            if (c.z > 0.0) continue;
            c.paint((Graphics2D)gg, this);
        }
        if (Component2D.advertisement != null) {
            Component2D.advertisement.paint((Graphics2D)gg, this);
        }
        gg.flush(true);
        ++this.fpsCounter;
        long l = System.currentTimeMillis() - this.fpsStartTime;
        if (l > 1000L) {
            this.fps = (int)((long)(1000 * this.fpsCounter) / l);
            this.fpsCounter = 0;
            this.fpsStartTime = System.currentTimeMillis();
        }
    }

    @Override
    public int getFPS() {
        return this.fps;
    }

    @Override
    public void setNavigationSpeed(double s) {
        this.naviSpeed = s;
    }

    @Override
    public void setUpperDirection(A3Object.UpperDirection d) {
        this.upperDirection = d;
    }

    public void postSwap() {
        super.postSwap();
        if (this.check) {
            this.gc.readRaster(this.readRaster);
            this.check = false;
        }
    }

    @Override
    public void saveImage(File file) throws IOException {
        int width = this.getWidth();
        int height = this.getHeight();
        BufferedImage bImage = new BufferedImage(width, height, 1);
        ImageComponent2D ic2d = new ImageComponent2D(1, bImage);
        this.readRaster = new Raster(new Point3f(0.0f, 0.0f, 0.0f), 1, 0, 0, width, height, ic2d, null);
        this.check = true;
        while (this.check) {
            try {
                Thread.sleep(300L);
            }
            catch (Exception e) {}
        }
        ImageComponent2D ic = this.readRaster.getImage();
        BufferedImage image = ic.getImage();
        ImageIO.write((RenderedImage)image, "png", file);
    }

    @Override
    public BufferedImage snapshot() {
        int width = this.getWidth();
        int height = this.getHeight();
        BufferedImage bImage = new BufferedImage(width, height, 1);
        ImageComponent2D ic2d = new ImageComponent2D(1, bImage);
        this.readRaster = new Raster(new Point3f(0.0f, 0.0f, 0.0f), 1, 0, 0, width, height, ic2d, null);
        this.check = true;
        while (this.check) {
            try {
                Thread.sleep(300L);
            }
            catch (Exception e) {}
        }
        ImageComponent2D ic = this.readRaster.getImage();
        BufferedImage image = ic.getImage();
        return image;
    }

    @Override
    public void addLockedA3(A3Object a) {
        if (this.lockedA3Hash.containsKey(a)) {
            return;
        }
        a.setComponent2DContainerInterface(this);
        a.lockedA3 = true;
        a.init();
        A3BranchGroup bg = a.getA3BranchGroup();
        this.cameraGroup.addChild((Node)bg);
        this.lockedA3Hash.put(a, bg);
    }

    @Override
    public void delAllLockedA3() {
        Enumeration<A3Object> e = this.lockedA3Hash.keys();
        while (e.hasMoreElements()) {
            A3Object a3 = e.nextElement();
            BranchGroup bg = this.lockedA3Hash.get(a3);
            bg.detach();
            a3.dispose();
        }
        this.lockedA3Hash.clear();
    }

    @Override
    public void delLockedA3(A3Object a) {
        BranchGroup bg = this.lockedA3Hash.get(a);
        if (bg == null) {
            return;
        }
        bg.detach();
        a.dispose();
        this.lockedA3Hash.remove(a);
    }

    @Override
    public A3VirtualUniverse getA3VirtualUniverse() {
        return this.virtualUniverse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Component2D c) {
        ArrayList<Component2D> arrayList = this.components2D;
        synchronized (arrayList) {
            if (!this.components2D.contains(c)) {
                this.components2D.add(c);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void del(Component2D c) {
        ArrayList<Component2D> arrayList = this.components2D;
        synchronized (arrayList) {
            this.components2D.remove(c);
        }
    }

    @Override
    public void setSoundGain(double g) {
        this.virtualUniverse.setSoundGain(g);
    }

    @Override
    public double getSoundGain() {
        return this.virtualUniverse.getSoundGain();
    }

    @Override
    public void add(A3Object a) {
    }

    @Override
    public void add(Component2D c, int scene) {
    }

    @Override
    public void add(A3Object a, int s) {
    }

    @Override
    public void addA3SubCanvas(A3CanvasInterface sc) {
    }

    @Override
    public void addLockedA3(A3Object a, int scene) {
    }

    @Override
    public void changeActiveScene(int s) {
    }

    @Override
    public void del(A3Object a) {
    }

    @Override
    public void del(Component2D c, int scene) {
    }

    @Override
    public void del(A3Object a, int s) {
    }

    @Override
    public void delAll() {
    }

    @Override
    public void delAll(int scene) {
    }

    @Override
    public void delAllLockedA3(int scene) {
    }

    @Override
    public void delBackground() {
    }

    @Override
    public void delBackground(int scene) {
    }

    @Override
    public void delLockedA3(A3Object a, int scene) {
    }

    @Override
    public A3Object getAvatar(int scene) {
        return null;
    }

    @Override
    public Vector3d getCameraLoc(int scene) {
        return null;
    }

    @Override
    public Quat4d getCameraQuat(int scene) {
        return null;
    }

    @Override
    public double getCameraScale(int scene) {
        return 0.0;
    }

    @Override
    public double getCameraTargetScale(int scene) {
        return 0.0;
    }

    @Override
    public double getNavigationSpeed(int scene) {
        return 0.0;
    }

    @Override
    public A3Object.UpperDirection getUpperDirection(int scene) {
        return null;
    }

    @Override
    public void prepareScene(int s) {
    }

    @Override
    public void resetCamera(int scene) {
    }

    @Override
    public void setA3Controller(A3Controller c, int scene) {
    }

    @Override
    public void setAvatar(A3Object a, int scene) {
    }

    @Override
    public void setBackground(A3Object a) {
    }

    @Override
    public void setBackground(A3Object a, int scene) {
    }

    @Override
    public void setCameraLoc(double x, double y, double z, int scene) {
    }

    @Override
    public void setCameraLoc(Vector3d loc, int scene) {
    }

    @Override
    public void setCameraLocImmediately(double x, double y, double z, int scene) {
    }

    @Override
    public void setCameraLocImmediately(Vector3d loc, int scene) {
    }

    @Override
    public void addCameraLoc(double x, double y, double z, int scene) {
    }

    @Override
    public void addCameraLoc(Vector3d loc, int scene) {
    }

    @Override
    public void addCameraLocImmediately(double x, double y, double z, int scene) {
    }

    @Override
    public void addCameraLocImmediately(Vector3d loc, int scene) {
    }

    @Override
    public Vector3d getCameraTargetLoc(int scene) {
        return null;
    }

    @Override
    public void setCameraLookAtPoint(Vector3d lookAt, int scene) {
    }

    @Override
    public void setCameraLookAtPoint(double x, double y, double z, int scene) {
    }

    @Override
    public void setCameraLookAtPoint(Vector3d lookAt, Vector3d up, int scene) {
    }

    @Override
    public void setCameraLookAtPoint(double x, double y, double z, Vector3d up, int scene) {
    }

    @Override
    public void setCameraLookAtPointImmediately(Vector3d lookAt, int scene) {
    }

    @Override
    public void setCameraLookAtPointImmediately(double x, double y, double z, int scene) {
    }

    @Override
    public void setCameraLookAtPointImmediately(Vector3d lookAt, Vector3d up, int scene) {
    }

    @Override
    public void setCameraLookAtPointImmediately(double x, double y, double z, Vector3d up, int scene) {
    }

    @Override
    public void setCameraQuat(double x, double y, double z, double w, int scene) {
    }

    @Override
    public void setCameraQuat(Quat4d quat, int scene) {
    }

    @Override
    public void setCameraQuatImmediately(double x, double y, double z, double w, int scene) {
    }

    @Override
    public void setCameraQuatImmediately(Quat4d quat, int scene) {
    }

    @Override
    public void mulCameraQuat(double x, double y, double z, double w, int scene) {
    }

    @Override
    public void mulCameraQuat(Quat4d quat, int scene) {
    }

    @Override
    public void mulCameraQuatImmediately(double x, double y, double z, double w, int scene) {
    }

    @Override
    public void mulCameraQuatImmediately(Quat4d quat, int scene) {
    }

    @Override
    public Quat4d getCameraTargetQuat(int scene) {
        return null;
    }

    @Override
    public void setCameraRot(double x, double y, double z, int scene) {
    }

    @Override
    public void setCameraRot(Vector3d rot, int scene) {
    }

    @Override
    public void setCameraRotImmediately(double x, double y, double z, int scene) {
    }

    @Override
    public void setCameraRotImmediately(Vector3d rot, int scene) {
    }

    @Override
    public void mulCameraRot(double x, double y, double z, int scene) {
    }

    @Override
    public void mulCameraRot(Vector3d rot, int scene) {
    }

    @Override
    public void mulCameraRotImmediately(double x, double y, double z, int scene) {
    }

    @Override
    public void mulCameraRotImmediately(Vector3d rot, int scene) {
    }

    @Override
    public Vector3d getCameraRot(int scene) {
        return null;
    }

    @Override
    public Vector3d getCameraTargetRot(int scene) {
        return null;
    }

    @Override
    public void setCameraScale(double s, int scene) {
    }

    @Override
    public void setCameraScaleImmediately(double s, int scene) {
    }

    @Override
    public void mulCameraScale(double s, int scene) {
    }

    @Override
    public void mulCameraScaleImmediately(double s, int scene) {
    }

    @Override
    public void setDefaultCameraLoc(double x, double y, double z, int scene) {
    }

    @Override
    public void setDefaultCameraLoc(Vector3d loc, int scene) {
    }

    @Override
    public void setDefaultCameraQuat(double x, double y, double z, double w, int scene) {
    }

    @Override
    public void setDefaultCameraQuat(Quat4d quat, int scene) {
    }

    @Override
    public void setDefaultCameraRot(double x, double y, double z, int scene) {
    }

    @Override
    public void setDefaultCameraRot(Vector3d rot, int scene) {
    }

    @Override
    public void setDefaultCameraScale(double s, int scene) {
    }

    @Override
    public void setNavigationMode(A3CanvasInterface.NaviMode m, int scene, Object ... params) {
    }

    @Override
    public void setNavigationSpeed(double s, int scene) {
    }

    @Override
    public void setUpperDirection(A3Object.UpperDirection d, int scene) {
    }

    @Override
    public void setUpdateInterval(long l) {
    }

    @Override
    public long getUpdateInterval() {
        return this.virtualUniverse.getUpdateInterval();
    }

    @Override
    public void setCameraInterpolateRatio(double ir) {
        this.subCamBehavior.setInterpolateRatio(ir);
    }

    @Override
    public void setDepthBufferFreezeTransparent(boolean b) {
        this.view.setDepthBufferFreezeTransparent(b);
    }
}

