/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.acerola3d.a3;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import javax.media.Buffer;
import javax.media.Control;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Geometry;
import javax.media.j3d.ImageComponent;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.Node;
import javax.media.j3d.QuadArray;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Texture;
import javax.media.j3d.Texture2D;
import javax.media.j3d.TextureAttributes;
import javax.media.renderer.VideoRenderer;
import javax.vecmath.Point3d;
import javax.vecmath.TexCoord2f;

class A3VideoRenderer
implements VideoRenderer {
    public static final int SS = 128;
    public static final int IW = 320;
    public static final int IH = 240;
    private static final String name = "A3VideoRenderer";
    protected RGBFormat inputFormat;
    protected RGBFormat supportedRGB;
    protected Format[] supportedFormats;
    protected Buffer lastBuffer = null;
    protected int inWidth = 0;
    protected int inHeight = 0;
    protected Component component = null;
    protected Rectangle reqBounds = null;
    protected Rectangle bounds = new Rectangle();
    protected boolean started = false;
    protected Object lastData = null;
    BranchGroup scene = null;
    Appearance app = null;
    Texture2D tex = null;
    int count = 0;
    boolean firstFrame = true;
    int btype = 0;
    int itype = 0;
    int ttype = 0;
    boolean byRef = true;

    public A3VideoRenderer() {
        this.supportedRGB = new RGBFormat(null, -1, Format.byteArray, -1.0f, 24, 3, 2, 1, 3, -1, 1, -1);
        this.supportedFormats = new VideoFormat[]{this.supportedRGB};
        String os = System.getProperty("os.name");
        System.out.println("running on " + os);
        if (os.startsWith("W") || os.startsWith("w")) {
            this.btype = 5;
            this.itype = 1;
            this.ttype = 5;
            this.byRef = true;
        } else if (os.startsWith("S") || os.startsWith("s")) {
            this.btype = 6;
            this.itype = 2;
            this.ttype = 6;
            this.byRef = true;
        } else {
            this.btype = 5;
            this.itype = 1;
            this.ttype = 5;
            this.byRef = false;
        }
    }

    public Object[] getControls() {
        return new Control[0];
    }

    public Object getControl(String controlType) {
        try {
            Class<?> cls = Class.forName(controlType);
            Object[] cs = this.getControls();
            for (int i = 0; i < cs.length; ++i) {
                if (!cls.isInstance(cs[i])) continue;
                return cs[i];
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getName() {
        return name;
    }

    public void open() throws ResourceUnavailableException {
        this.firstFrame = true;
        this.scene = this.createSceneGraph();
        this.count = 0;
    }

    public void reset() {
    }

    public synchronized void close() {
    }

    public void start() {
        this.started = true;
    }

    public void stop() {
        this.started = false;
    }

    public Format[] getSupportedInputFormats() {
        return this.supportedFormats;
    }

    public Format setInputFormat(Format format) {
        if (format != null && format instanceof RGBFormat && format.matches((Format)this.supportedRGB)) {
            this.inputFormat = (RGBFormat)format;
            Dimension size = this.inputFormat.getSize();
            this.inWidth = size.width;
            this.inHeight = size.height;
            return format;
        }
        return null;
    }

    public int process(Buffer buffer) {
        int j;
        int i;
        if (buffer.getLength() <= 0) {
            return 0;
        }
        if (this.count < 0) {
            ++this.count;
            try {
                Thread.sleep(50L);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return 0;
        }
        this.count = 0;
        byte[] rawData = (byte[])buffer.getData();
        BufferedImage bimg = new BufferedImage(128, 128, this.btype);
        byte[] byteData = ((DataBufferByte)bimg.getRaster().getDataBuffer()).getData();
        int alpha_1 = -1;
        int op = 0;
        int lineStride = 3 * this.inWidth;
        if (this.btype == 5) {
            for (i = 0; i < 128; ++i) {
                for (j = 0; j < 128; ++j) {
                    int x = this.inWidth * j >> 7;
                    int y = this.inHeight * i >> 7;
                    if (x >= this.inWidth || y >= this.inHeight) {
                        byteData[op++] = 0;
                        byteData[op++] = 0;
                        byteData[op++] = 0;
                        continue;
                    }
                    int ip = y * lineStride + x * 3;
                    byteData[op++] = rawData[ip++];
                    byteData[op++] = rawData[ip++];
                    byteData[op++] = rawData[ip++];
                }
            }
        } else {
            for (i = 0; i < 128; ++i) {
                for (j = 0; j < 128; ++j) {
                    int x = this.inWidth * j >> 7;
                    int y = this.inHeight * i >> 7;
                    if (x >= this.inWidth || y >= this.inHeight) {
                        byteData[op++] = alpha_1;
                        byteData[op++] = 0;
                        byteData[op++] = 0;
                        byteData[op++] = 0;
                        continue;
                    }
                    int ip = y * lineStride + x * 3;
                    byteData[op++] = alpha_1;
                    byteData[op++] = rawData[ip++];
                    byteData[op++] = rawData[ip++];
                    byteData[op++] = rawData[ip++];
                }
            }
        }
        ImageComponent2D imgcmp = new ImageComponent2D(this.itype, bimg, this.byRef, true);
        this.tex.setImage(0, (ImageComponent)imgcmp);
        this.app.setTexture((Texture)this.tex);
        if (this.firstFrame) {
            this.firstFrame = false;
            try {
                Thread.sleep(5500L);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            try {
                Thread.sleep(30L);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return 0;
    }

    BranchGroup createSceneGraph() {
        BranchGroup objRoot = new BranchGroup();
        this.app = new Appearance();
        this.tex = this.createTexture();
        this.app.setCapability(3);
        this.tex.setCapability(7);
        this.app.setTexture((Texture)this.tex);
        TextureAttributes texAttr = new TextureAttributes();
        texAttr.setTextureMode(2);
        this.app.setTextureAttributes(texAttr);
        Point3d[] vertices = new Point3d[]{new Point3d(-1.0, -1.0, 0.0), new Point3d(1.0, -1.0, 0.0), new Point3d(1.0, 1.0, 0.0), new Point3d(-1.0, 1.0, 0.0)};
        TexCoord2f[] txcoords = new TexCoord2f[]{new TexCoord2f(0.0f, 0.0f), new TexCoord2f(1.0f, 0.0f), new TexCoord2f(1.0f, 1.0f), new TexCoord2f(0.0f, 1.0f)};
        QuadArray geom = new QuadArray(vertices.length, 35);
        geom.setCoordinates(0, vertices);
        geom.setTextureCoordinates(0, 0, txcoords);
        Shape3D shape = new Shape3D((Geometry)geom, this.app);
        objRoot.addChild((Node)shape);
        vertices = new Point3d[]{new Point3d(1.0, -1.0, -0.1), new Point3d(-1.0, -1.0, -0.1), new Point3d(-1.0, 1.0, -0.1), new Point3d(1.0, 1.0, -0.1)};
        float[] colors = new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f};
        geom = new QuadArray(vertices.length, 5);
        geom.setCoordinates(0, vertices);
        geom.setColors(0, colors);
        shape = new Shape3D((Geometry)geom);
        objRoot.addChild((Node)shape);
        objRoot.compile();
        return objRoot;
    }

    private Texture2D createTexture() {
        int i;
        int j = 0;
        int alpha_1 = -1;
        BufferedImage bimg = new BufferedImage(128, 128, this.btype);
        byte[] byteData = ((DataBufferByte)bimg.getRaster().getDataBuffer()).getData();
        if (this.btype == 6) {
            j = 0;
            for (i = 0; i < 16384; ++i) {
                byteData[j] = alpha_1;
                byteData[j + 1] = -64;
                byteData[j + 2] = 0;
                byteData[j + 3] = -64;
                j += 4;
            }
        } else {
            j = 0;
            for (i = 0; i < 16384; ++i) {
                byteData[j] = -64;
                byteData[j + 1] = 0;
                byteData[j + 2] = -64;
                j += 3;
            }
        }
        ImageComponent2D imgcmp = new ImageComponent2D(this.itype, bimg, this.byRef, true);
        Texture2D tex1 = new Texture2D(1, this.ttype, 128, 128);
        tex1.setImage(0, (ImageComponent)imgcmp);
        return tex1;
    }

    public Component getComponent() {
        return null;
    }

    public boolean setComponent(Component comp) {
        this.component = comp;
        return true;
    }

    public void setBounds(Rectangle rect) {
        this.reqBounds = rect;
    }

    public Rectangle getBounds() {
        return this.reqBounds;
    }

    int getInWidth() {
        return this.inWidth;
    }

    int getInHeight() {
        return this.inHeight;
    }
}

