/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.acerola3d.a3;

import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.DepthComponent;
import javax.media.j3d.DepthComponentFloat;
import javax.media.j3d.GraphicsConfigTemplate3D;
import javax.media.j3d.GraphicsContext3D;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.Node;
import javax.media.j3d.PhysicalBody;
import javax.media.j3d.PhysicalEnvironment;
import javax.media.j3d.Raster;
import javax.media.j3d.Screen3D;
import javax.media.j3d.View;
import javax.media.j3d.ViewPlatform;
import javax.vecmath.Point3f;
import jp.sourceforge.acerola3d.a3.ProjectionMode;

public class A3Eye
extends BranchGroup {
    int width;
    int height;
    BufferedImage image;
    ImageComponent2D buffer;
    Canvas3D offscreen;
    View view;
    AffineTransformOp op;
    boolean useDepth = false;
    float[] depthData;
    GraphicsContext3D gc3d;
    Raster raster;

    public A3Eye(int w, int h) {
        this(w, h, false);
    }

    public A3Eye(int w, int h, boolean depth) {
        this.useDepth = depth;
        this.width = w;
        this.height = h;
        AffineTransform tx = AffineTransform.getScaleInstance(1.0, -1.0);
        tx.translate(0.0, -this.height);
        this.op = new AffineTransformOp(tx, 1);
        this.image = new BufferedImage(this.width, this.height, 1);
        this.buffer = new ImageComponent2D(1, this.image, true, true);
        this.buffer.setCapability(2);
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = ge.getDefaultScreenDevice();
        GraphicsConfiguration[] gcs = gd.getConfigurations();
        GraphicsConfigTemplate3D gct3d = new GraphicsConfigTemplate3D();
        GraphicsConfiguration gc = gct3d.getBestConfiguration(gcs);
        this.offscreen = new Canvas3D(gc, true){

            public void postSwap() {
                System.out.println("GAHA--------------------");
            }
        };
        this.offscreen.setOffScreenBuffer(this.buffer);
        Screen3D s = this.offscreen.getScreen3D();
        s.setSize(new Dimension(256, 256));
        s.setPhysicalScreenWidth(1.0);
        s.setPhysicalScreenHeight(1.0);
        if (this.useDepth) {
            this.depthData = new float[w * h];
            this.gc3d = this.offscreen.getGraphicsContext3D();
            DepthComponentFloat dcf = new DepthComponentFloat(w, h);
            dcf.setCapability(1);
            this.raster = new Raster(new Point3f(), 2, 0, 0, w, h, null, (DepthComponent)dcf);
            this.raster.setCapability(6);
            this.raster.setType(2);
        }
        ViewPlatform viewPlatform = new ViewPlatform();
        this.view = new View();
        this.view.addCanvas3D(this.offscreen);
        this.view.setPhysicalBody(new PhysicalBody());
        this.view.setPhysicalEnvironment(new PhysicalEnvironment());
        this.view.setFrontClipDistance(0.1);
        this.view.setBackClipDistance(100.0);
        this.view.setUserHeadToVworldEnable(true);
        this.view.setProjectionPolicy(1);
        this.view.setDepthBufferFreezeTransparent(true);
        this.view.attachViewPlatform(viewPlatform);
        this.addChild((Node)viewPlatform);
    }

    public void renderOffscreenBuffer(BufferedImage bi) {
        this.offscreen.renderOffScreenBuffer();
        this.offscreen.waitForOffScreenRendering();
        this.op.filter(this.image, bi);
    }

    public void setProjectionMode(ProjectionMode m) {
        if (m == ProjectionMode.PERSPECTIVE) {
            this.view.setProjectionPolicy(1);
            this.view.setScreenScalePolicy(0);
        } else if (m == ProjectionMode.PARALLEL) {
            this.view.setProjectionPolicy(0);
            this.view.setScreenScalePolicy(1);
        }
    }

    public void setCanvasWidthInPWorld(double s) {
        double psw = this.offscreen.getScreen3D().getPhysicalScreenWidth();
        this.view.setScreenScale(psw / s);
    }

    public void setFieldOfView(double f) {
        this.view.setFieldOfView(f);
    }

    public float[] getDepthData() {
        DepthComponentFloat dcf = (DepthComponentFloat)this.raster.getDepthComponent();
        dcf.getDepthData(this.depthData);
        return this.depthData;
    }
}

