/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.acerola3d.a2;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import javax.swing.JPanel;
import jp.sourceforge.acerola3d.a2.A2Event;
import jp.sourceforge.acerola3d.a2.A2Listener;
import jp.sourceforge.acerola3d.a2.A2Object;

public class A2Canvas
extends JPanel
implements KeyListener,
MouseListener,
MouseMotionListener,
Runnable {
    private static final long serialVersionUID = 1L;
    ArrayList<A2Object> a2Objects = new ArrayList();
    ArrayList<A2Listener> a2Listeners = new ArrayList();
    A2Object background = null;
    double cameraX = 0.0;
    double cameraY = 0.0;
    double cameraS = 1.0;
    double defaultX = 0.0;
    double defaultY = 0.0;
    double defaultS = 1.0;

    public static A2Canvas createA2Canvas() {
        return A2Canvas.createA2Canvas(500, 500);
    }

    public static A2Canvas createA2Canvas(int w, int h) {
        A2Canvas a = new A2Canvas(w, h);
        Thread t = new Thread(a);
        t.start();
        return a;
    }

    A2Canvas(int w, int h) {
        this.setPreferredSize(new Dimension(w, h));
    }

    public void add(A2Object a) {
        if (!this.a2Objects.contains(a)) {
            this.a2Objects.add(a);
        }
        a.setA2Canvas(this);
        a.repaint();
    }

    public void del(A2Object a) {
        this.a2Objects.remove(a);
        a.removeA2Canvas();
        this.repaint();
    }

    public void setBackground(A2Object a) {
        this.background = a;
        this.repaint();
    }

    public void addA2Listener(A2Listener l) {
        if (!this.a2Listeners.contains(l)) {
            this.a2Listeners.add(l);
        }
    }

    public void removeA2Listener(A2Listener l) {
        this.a2Listeners.remove(l);
    }

    public void setDefaultCamera(double x, double y, double s) {
        this.defaultX = x;
        this.defaultY = y;
        this.defaultS = s;
    }

    public void resetCamera() {
        this.cameraX = this.defaultX;
        this.cameraY = this.defaultY;
        this.cameraS = this.defaultS;
        this.repaint();
    }

    public void setCameraLoc(double x, double y) {
        this.cameraX = x;
        this.cameraY = y;
        this.repaint();
    }

    public void setCameraLocImmediately(double x, double y) {
        this.cameraX = x;
        this.cameraY = y;
        this.repaint();
    }

    public void setCameraScale(double s) {
        this.cameraS = s;
        this.repaint();
    }

    public void setCameraScaleImmediately(double s) {
        this.cameraS = s;
        this.repaint();
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.background != null) {
            this.background.paint(g);
        }
        for (A2Object a2 : this.a2Objects) {
            a2.paint(g);
        }
    }

    @Override
    public void keyPressed(KeyEvent ke) {
    }

    @Override
    public void keyReleased(KeyEvent ke) {
    }

    @Override
    public void keyTyped(KeyEvent ke) {
        for (A2Listener l : this.a2Listeners) {
            A2Event e = new A2Event();
            e.setKeyEvent(ke);
            l.keyTyped(e);
        }
    }

    @Override
    public void mouseClicked(MouseEvent me) {
        for (A2Listener l : this.a2Listeners) {
            A2Event e = new A2Event();
            e.setMouseEvent(me);
            l.mouseClicked(e);
        }
    }

    @Override
    public void mouseEntered(MouseEvent me) {
    }

    @Override
    public void mouseExited(MouseEvent me) {
    }

    @Override
    public void mousePressed(MouseEvent me) {
        for (A2Listener l : this.a2Listeners) {
            A2Event e = new A2Event();
            e.setMouseEvent(me);
            l.mousePressed(e);
        }
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        for (A2Listener l : this.a2Listeners) {
            A2Event e = new A2Event();
            e.setMouseEvent(me);
            l.mouseReleased(e);
        }
    }

    @Override
    public void mouseDragged(MouseEvent me) {
        for (A2Listener l : this.a2Listeners) {
            A2Event e = new A2Event();
            e.setMouseEvent(me);
            l.mouseDragged(e);
        }
    }

    @Override
    public void mouseMoved(MouseEvent me) {
    }

    public Point canvasToVirtualCS(int x, int y) {
        return null;
    }

    public A2Object pickA2(int x, int y) {
        return null;
    }

    public void saveImage(File file) throws IOException {
        int w = this.getWidth();
        int h = this.getHeight();
        BufferedImage bi = new BufferedImage(w, h, 1);
        Graphics g = bi.getGraphics();
        this.paint(g);
        ImageIO.write((RenderedImage)bi, "png", file);
    }

    @Override
    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        return super.imageUpdate(img, infoflags, x, y, width, height);
    }

    @Override
    public void run() {
        while (true) {
            boolean b = false;
            for (A2Object a : this.a2Objects) {
                if (!a.needRepaint) continue;
                b = true;
                break;
            }
            if (b) {
                this.repaint();
            }
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {
            }
        }
    }
}

