/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.acerola3d.a3;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import javax.imageio.ImageIO;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.GraphicsConfigTemplate3D;
import javax.media.j3d.GraphicsContext3D;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.Raster;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Quat4d;
import javax.vecmath.Vector3d;
import jp.sourceforge.acerola3d.a3.A3CanvasInterface;
import jp.sourceforge.acerola3d.a3.A3Controller;
import jp.sourceforge.acerola3d.a3.A3Listener;
import jp.sourceforge.acerola3d.a3.A3Object;
import jp.sourceforge.acerola3d.a3.A3VirtualUniverse;
import jp.sourceforge.acerola3d.a3.Component2D;
import jp.sourceforge.acerola3d.a3.Component2DComparator;
import jp.sourceforge.acerola3d.a3.PickingBehavior;
import jp.sourceforge.acerola3d.a3.ProjectionMode;
import jp.sourceforge.acerola3d.a3.TimerBehavior;
import jp.sourceforge.acerola3d.a3.TransCanvas3D;

public class JA3Canvas2
extends TransCanvas3D
implements A3CanvasInterface {
    private static final long serialVersionUID = 1L;
    A3VirtualUniverse universe;
    long fpsStartTime;
    int fpsCounter = 0;
    int fps;
    volatile boolean check = false;
    GraphicsContext3D gc;
    Raster readRaster;

    public static JA3Canvas2 createJA3Canvas() {
        return JA3Canvas2.createJA3Canvas(500, 500);
    }

    public static JA3Canvas2 createJA3Canvas(int w, int h) {
        GraphicsDevice gd = JA3Canvas2.createGraphicsDevice();
        GraphicsConfigTemplate3D gct3d = JA3Canvas2.createGraphicsConfigTemplate3D();
        return JA3Canvas2.createJA3Canvas(gct3d, gd, w, h);
    }

    static GraphicsDevice createGraphicsDevice() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = ge.getDefaultScreenDevice();
        return gd;
    }

    static GraphicsConfigTemplate3D createGraphicsConfigTemplate3D() {
        GraphicsConfigTemplate3D gct3d = new GraphicsConfigTemplate3D();
        return gct3d;
    }

    public static JA3Canvas2 createJA3Canvas(GraphicsConfigTemplate3D t, GraphicsDevice d, int w, int h) {
        return new JA3Canvas2(t, d, w, h);
    }

    public JA3Canvas2() {
        this(500, 500);
    }

    public JA3Canvas2(int w, int h) {
        this(JA3Canvas2.createGraphicsConfigTemplate3D(), JA3Canvas2.createGraphicsDevice(), w, h);
    }

    public JA3Canvas2(GraphicsConfigTemplate3D t, GraphicsDevice d, int w, int h) {
        super(t, d, false);
        this.setPreferredSize(new Dimension(w, h));
        this.setSize(w, h);
        this.canvasIF = this;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.universe = new A3VirtualUniverse(this);
        this.enableEvents(16L);
        this.enableEvents(32L);
        this.enableEvents(131072L);
    }

    public TimerBehavior getTimerBehavior() {
        return this.universe.getTimerBehavior();
    }

    @Override
    public void add(A3Object a) {
        this.universe.add(a);
    }

    @Override
    public void del(A3Object a) {
        this.universe.del(a);
    }

    @Override
    public void delAll() {
        this.universe.delAll();
    }

    @Override
    public void delAll(int scene) {
        this.universe.delAll(scene);
    }

    @Override
    public void setBackground(A3Object a) {
        this.universe.setBackground(a);
    }

    @Override
    public void delBackground() {
        this.universe.delBackground();
    }

    @Override
    public void setAvatar(A3Object a) {
        this.universe.setAvatar(a);
    }

    @Override
    public A3Object getAvatar() {
        return this.universe.getAvatar();
    }

    @Override
    public void addA3Listener(A3Listener l) {
        this.universe.addA3Listener(l);
    }

    @Override
    public void removeA3Listener(A3Listener l) {
        this.universe.addA3Listener(l);
    }

    @Override
    public void setDefaultCameraLoc(double x, double y, double z) {
        this.universe.setDefaultCameraLoc(x, y, z);
    }

    @Override
    public void setDefaultCameraLoc(Vector3d loc) {
        this.universe.setDefaultCameraLoc(loc);
    }

    @Override
    public void setDefaultCameraQuat(double x, double y, double z, double w) {
        this.universe.setDefaultCameraQuat(x, y, z, w);
    }

    @Override
    public void setDefaultCameraQuat(Quat4d quat) {
        this.universe.setDefaultCameraQuat(quat);
    }

    @Override
    public void setDefaultCameraRot(double x, double y, double z) {
        this.universe.setDefaultCameraRot(x, y, z);
    }

    @Override
    public void setDefaultCameraRot(Vector3d rot) {
        this.universe.setDefaultCameraRot(rot);
    }

    @Override
    public void setDefaultCameraRev(double x, double y, double z) {
        this.universe.setDefaultCameraRev(x, y, z);
    }

    @Override
    public void setDefaultCameraRev(Vector3d rev) {
        this.universe.setDefaultCameraRev(rev);
    }

    @Override
    public void setDefaultCameraScale(double s) {
        this.universe.setDefaultCameraScale(s);
    }

    @Override
    public void resetCamera() {
        this.universe.resetCamera();
    }

    @Override
    public void setCameraLoc(double x, double y, double z) {
        this.universe.setCameraLoc(x, y, z);
    }

    @Override
    public void setCameraLoc(Vector3d loc) {
        this.universe.setCameraLoc(loc);
    }

    @Override
    public void setCameraLocImmediately(double x, double y, double z) {
        this.universe.setCameraLocImmediately(x, y, z);
    }

    @Override
    public void setCameraLocImmediately(Vector3d loc) {
        this.universe.setCameraLocImmediately(loc);
    }

    @Override
    public void addCameraLoc(double x, double y, double z) {
        this.universe.addCameraLoc(x, y, z);
    }

    @Override
    public void addCameraLoc(Vector3d loc) {
        this.universe.addCameraLoc(loc);
    }

    @Override
    public void addCameraLocImmediately(double x, double y, double z) {
        this.universe.addCameraLocImmediately(x, y, z);
    }

    @Override
    public void addCameraLocImmediately(Vector3d loc) {
        this.universe.addCameraLocImmediately(loc);
    }

    @Override
    public void moveCameraForward(double l) {
        this.universe.moveCameraForward(l);
    }

    @Override
    public void moveCameraForwardImmediately(double l) {
        this.universe.moveCameraForwardImmediately(l);
    }

    @Override
    public void moveCameraBackward(double l) {
        this.universe.moveCameraBackward(l);
    }

    @Override
    public void moveCameraBackwardImmediately(double l) {
        this.universe.moveCameraBackwardImmediately(l);
    }

    @Override
    public void moveCameraRight(double l) {
        this.universe.moveCameraRight(l);
    }

    @Override
    public void moveCameraRightImmediately(double l) {
        this.universe.moveCameraRightImmediately(l);
    }

    @Override
    public void moveCameraLeft(double l) {
        this.universe.moveCameraLeft(l);
    }

    @Override
    public void moveCameraLeftImmediately(double l) {
        this.universe.moveCameraLeftImmediately(l);
    }

    @Override
    public void moveCameraUp(double l) {
        this.universe.moveCameraUp(l);
    }

    @Override
    public void moveCameraUpImmediately(double l) {
        this.universe.moveCameraUpImmediately(l);
    }

    @Override
    public void moveCameraDown(double l) {
        this.universe.moveCameraDown(l);
    }

    @Override
    public void moveCameraDownImmediately(double l) {
        this.universe.moveCameraDownImmediately(l);
    }

    @Override
    public void moveCameraTo(Vector3d v, double l) {
        this.universe.moveCameraTo(v, l);
    }

    @Override
    public void moveCameraTo(double x, double y, double z, double l) {
        this.universe.moveCameraTo(x, y, z, l);
    }

    @Override
    public void moveCameraTo(A3Object a, double l) {
        this.universe.moveCameraTo(a, l);
    }

    @Override
    public void moveCameraToImmediately(Vector3d v, double l) {
        this.universe.moveCameraToImmediately(v, l);
    }

    @Override
    public void moveCameraToImmediately(double x, double y, double z, double l) {
        this.universe.moveCameraToImmediately(x, y, z, l);
    }

    @Override
    public void moveCameraToImmediately(A3Object a, double l) {
        this.universe.moveCameraToImmediately(a, l);
    }

    @Override
    public void moveCameraForward(double l, int scene) {
        this.universe.moveCameraForward(l, scene);
    }

    @Override
    public void moveCameraForwardImmediately(double l, int scene) {
        this.universe.moveCameraForwardImmediately(l, scene);
    }

    @Override
    public void moveCameraBackward(double l, int scene) {
        this.universe.moveCameraBackward(l, scene);
    }

    @Override
    public void moveCameraBackwardImmediately(double l, int scene) {
        this.universe.moveCameraBackwardImmediately(l, scene);
    }

    @Override
    public void moveCameraRight(double l, int scene) {
        this.universe.moveCameraRight(l, scene);
    }

    @Override
    public void moveCameraRightImmediately(double l, int scene) {
        this.universe.moveCameraRightImmediately(l, scene);
    }

    @Override
    public void moveCameraLeft(double l, int scene) {
        this.universe.moveCameraLeft(l, scene);
    }

    @Override
    public void moveCameraLeftImmediately(double l, int scene) {
        this.universe.moveCameraLeftImmediately(l, scene);
    }

    @Override
    public void moveCameraUp(double l, int scene) {
        this.universe.moveCameraUp(l, scene);
    }

    @Override
    public void moveCameraUpImmediately(double l, int scene) {
        this.universe.moveCameraUpImmediately(l, scene);
    }

    @Override
    public void moveCameraDown(double l, int scene) {
        this.universe.moveCameraDown(l, scene);
    }

    @Override
    public void moveCameraDownImmediately(double l, int scene) {
        this.universe.moveCameraDownImmediately(l, scene);
    }

    @Override
    public void moveCameraTo(Vector3d v, double l, int scene) {
        this.universe.moveCameraTo(v, l, scene);
    }

    @Override
    public void moveCameraTo(double x, double y, double z, double l, int scene) {
        this.universe.moveCameraTo(x, y, z, l, scene);
    }

    @Override
    public void moveCameraTo(A3Object a, double l, int scene) {
        this.universe.moveCameraTo(a, l, scene);
    }

    @Override
    public void moveCameraToImmediately(Vector3d v, double l, int scene) {
        this.universe.moveCameraToImmediately(v, l, scene);
    }

    @Override
    public void moveCameraToImmediately(double x, double y, double z, double l, int scene) {
        this.universe.moveCameraToImmediately(x, y, z, l, scene);
    }

    @Override
    public void moveCameraToImmediately(A3Object a, double l, int scene) {
        this.universe.moveCameraToImmediately(a, l, scene);
    }

    @Override
    public Vector3d getCameraLoc() {
        return this.universe.getCameraLoc();
    }

    @Override
    public Vector3d getCameraTargetLoc() {
        return this.universe.getCameraTargetLoc();
    }

    @Override
    public void setCameraQuat(double x, double y, double z, double w) {
        this.universe.setCameraQuat(x, y, z, w);
    }

    @Override
    public void setCameraQuat(Quat4d quat) {
        this.universe.setCameraQuat(quat);
    }

    @Override
    public void setCameraQuatImmediately(double x, double y, double z, double w) {
        this.universe.setCameraQuatImmediately(x, y, z, w);
    }

    @Override
    public void setCameraQuatImmediately(Quat4d quat) {
        this.universe.setCameraQuatImmediately(quat);
    }

    @Override
    public void mulCameraQuat(double x, double y, double z, double w) {
        this.universe.mulCameraQuat(x, y, z, w);
    }

    @Override
    public void mulCameraQuat(Quat4d quat) {
        this.universe.mulCameraQuat(quat);
    }

    @Override
    public void mulCameraQuatImmediately(double x, double y, double z, double w) {
        this.universe.mulCameraQuatImmediately(x, y, z, w);
    }

    @Override
    public void mulCameraQuatImmediately(Quat4d quat) {
        this.universe.mulCameraQuatImmediately(quat);
    }

    @Override
    public Quat4d getCameraQuat() {
        return this.universe.getCameraQuat();
    }

    @Override
    public Quat4d getCameraTargetQuat() {
        return this.universe.getCameraTargetQuat();
    }

    @Override
    public void setCameraRot(double x, double y, double z) {
        this.universe.setCameraRot(x, y, z);
    }

    @Override
    public void setCameraRot(Vector3d rot) {
        this.universe.setCameraRot(rot);
    }

    @Override
    public void setCameraRotImmediately(double x, double y, double z) {
        this.universe.setCameraRotImmediately(x, y, z);
    }

    @Override
    public void setCameraRotImmediately(Vector3d rot) {
        this.universe.setCameraRotImmediately(rot);
    }

    @Override
    public void mulCameraRot(double x, double y, double z) {
        this.universe.mulCameraRot(x, y, z);
    }

    @Override
    public void mulCameraRot(Vector3d rot) {
        this.universe.mulCameraRot(rot);
    }

    @Override
    public void mulCameraRotImmediately(double x, double y, double z) {
        this.universe.mulCameraRotImmediately(x, y, z);
    }

    @Override
    public void mulCameraRotImmediately(Vector3d rot) {
        this.universe.mulCameraRotImmediately(rot);
    }

    @Override
    public Vector3d getCameraRot() {
        return this.universe.getCameraRot();
    }

    @Override
    public Vector3d getCameraTargetRot() {
        return this.universe.getCameraTargetRot();
    }

    @Override
    public void setCameraRev(double x, double y, double z) {
        this.universe.setCameraRev(x, y, z);
    }

    @Override
    public void setCameraRev(Vector3d rev) {
        this.universe.setCameraRev(rev);
    }

    @Override
    public void setCameraRevImmediately(double x, double y, double z) {
        this.universe.setCameraRevImmediately(x, y, z);
    }

    @Override
    public void setCameraRevImmediately(Vector3d rev) {
        this.universe.setCameraRevImmediately(rev);
    }

    @Override
    public void mulCameraRev(double x, double y, double z) {
        this.universe.mulCameraRev(x, y, z);
    }

    @Override
    public void mulCameraRev(Vector3d rev) {
        this.universe.mulCameraRev(rev);
    }

    @Override
    public void mulCameraRevImmediately(double x, double y, double z) {
        this.universe.mulCameraRevImmediately(x, y, z);
    }

    @Override
    public void mulCameraRevImmediately(Vector3d rev) {
        this.universe.mulCameraRevImmediately(rev);
    }

    @Override
    public Vector3d getCameraRev() {
        return this.universe.getCameraRev();
    }

    @Override
    public Vector3d getCameraTargetRev() {
        return this.universe.getCameraTargetRev();
    }

    @Override
    public void setCameraScale(double s) {
        this.universe.setCameraScale(s);
    }

    @Override
    public void setCameraScaleImmediately(double s) {
        this.universe.setCameraScaleImmediately(s);
    }

    @Override
    public void mulCameraScale(double s) {
        this.universe.mulCameraScale(s);
    }

    @Override
    public void mulCameraScaleImmediately(double s) {
        this.universe.mulCameraScaleImmediately(s);
    }

    @Override
    public double getCameraScale() {
        return this.universe.getCameraScale();
    }

    @Override
    public double getCameraTargetScale() {
        return this.universe.getCameraTargetScale();
    }

    @Override
    public void setCameraLookAtPoint(Vector3d lookAt) {
        this.universe.setCameraLookAtPoint(lookAt);
    }

    @Override
    public void setCameraLookAtPointImmediately(Vector3d lookAt) {
        this.universe.setCameraLookAtPointImmediately(lookAt);
    }

    @Override
    public void setCameraLookAtPoint(double x, double y, double z) {
        this.universe.setCameraLookAtPoint(x, y, z);
    }

    @Override
    public void setCameraLookAtPointImmediately(double x, double y, double z) {
        this.universe.setCameraLookAtPointImmediately(x, y, z);
    }

    @Override
    public void setCameraLookAtPoint(Vector3d lookAt, Vector3d up) {
        this.universe.setCameraLookAtPoint(lookAt, up);
    }

    @Override
    public void setCameraLookAtPointImmediately(Vector3d lookAt, Vector3d up) {
        this.universe.setCameraLookAtPointImmediately(lookAt, up);
    }

    @Override
    public void setCameraLookAtPoint(double x, double y, double z, Vector3d up) {
        this.universe.setCameraLookAtPoint(x, y, z, up);
    }

    @Override
    public void setCameraLookAtPointImmediately(double x, double y, double z, Vector3d up) {
        this.universe.setCameraLookAtPointImmediately(x, y, z, up);
    }

    @Override
    public void setHeadLightEnable(boolean b) {
        this.universe.setHeadLightEnable(b);
    }

    @Override
    public void setNavigationMode(A3CanvasInterface.NaviMode m, Object ... params) {
        this.universe.setNavigationMode(m, params);
    }

    @Override
    public void setNavigationSpeed(double s) {
        this.universe.setNavigationSpeed(s);
    }

    @Override
    public double getNavigationSpeed() {
        return this.universe.getNavigationSpeed();
    }

    @Override
    public void setA3Controller(A3Controller c) {
        this.universe.setA3Controller(c);
    }

    @Override
    public Point3d canvasToVirtualCS(int x, int y) {
        return this.universe.canvasToVirtualCS(x, y);
    }

    @Override
    public Point3d canvasToVirtualCS(int x, int y, double dis) {
        return this.universe.canvasToVirtualCS(x, y, dis);
    }

    @Override
    public Point3d canvasToPhysicalCS(int x, int y) {
        return this.universe.canvasToPhysicalCS(x, y);
    }

    @Override
    public Point3d canvasToPhysicalCS(int x, int y, double dis) {
        return this.universe.canvasToPhysicalCS(x, y, dis);
    }

    @Override
    public Vector3d physicalCSToVirtualCS(Vector3d v) {
        return this.universe.physicalCSToVirtualCS(v);
    }

    @Override
    public Point physicalCSToCanvas(Point3d p) {
        return this.universe.physicalCSToCanvas(p);
    }

    @Override
    public Point virtualCSToCanvas(Point3d p) {
        return this.universe.virtualCSToCanvas(p);
    }

    @Override
    public Vector3d virtualCSToPhysicalCS(Vector3d v) {
        return this.universe.virtualCSToPhysicalCS(v);
    }

    @Override
    public Vector3d getCameraUnitVecX() {
        return this.universe.getCameraUnitVecX();
    }

    @Override
    public Vector3d getCameraUnitVecY() {
        return this.universe.getCameraUnitVecY();
    }

    @Override
    public Vector3d getCameraUnitVecZ() {
        return this.universe.getCameraUnitVecZ();
    }

    @Override
    public A3Object pickA3(int x, int y) {
        return this.universe.pickingBehavior.pickA3(x, y);
    }

    @Override
    public A3Object pick(Vector3d origin, Vector3d dir) {
        return this.universe.pickingBehavior.pickA3(origin, dir);
    }

    @Override
    public void add(Component2D c) {
        this.universe.add(c);
    }

    @Override
    public void del(Component2D c) {
        this.universe.del(c);
    }

    @Override
    public void add(Component2D c, int scene) {
        this.universe.add(c, scene);
    }

    @Override
    public void del(Component2D c, int scene) {
        this.universe.del(c, scene);
    }

    @Override
    public void paintComponent(Graphics g) {
        Component2D[] cs;
        super.paintComponent(g);
        for (Component2D c : cs = this.universe.getComponents2D().toArray(new Component2D[0])) {
            c.calPhysicalZ(this);
        }
        Arrays.sort(cs, Component2DComparator.comparator);
        Graphics2D gg = (Graphics2D)g;
        for (Component2D c : cs) {
            if (c.z > 0.0) continue;
            c.paint(gg, this);
        }
        if (Component2D.advertisement != null) {
            Component2D.advertisement.paint(gg, this);
        }
        ++this.fpsCounter;
        long l = System.currentTimeMillis() - this.fpsStartTime;
        if (l > 1000L) {
            this.fps = (int)((long)(1000 * this.fpsCounter) / l);
            this.fpsCounter = 0;
            this.fpsStartTime = System.currentTimeMillis();
        }
    }

    @Override
    public int getFPS() {
        return this.fps;
    }

    @Override
    public void setUpdateInterval(long l) {
        this.universe.setUpdateInterval(l);
    }

    @Override
    public long getUpdateInterval() {
        return this.universe.getUpdateInterval();
    }

    @Override
    public void waitForUpdate(long timeout) {
        this.universe.waitForUpdate(timeout);
    }

    @Override
    public void insertTaskIntoRenderingLoop(Runnable task) {
        super.insertTaskIntoRenderingLoop(task);
    }

    @Override
    public void removeTaskFromRenderingLoop(Runnable task) {
        super.removeTaskFromRenderingLoop(task);
    }

    @Override
    public void insertTaskIntoTimerLoop(Runnable task) {
        this.universe.insertTaskIntoTimerLoop(task);
    }

    @Override
    public void removeTaskFromTimerLoop(Runnable task) {
        this.universe.removeTaskFromTimerLoop(task);
    }

    @Override
    public void setCameraInterpolateRatio(double ir) {
        this.universe.setCameraInterpolateRatio(ir);
    }

    @Override
    public void setDepthBufferFreezeTransparent(boolean b) {
        this.universe.setDepthBufferFreezeTransparent(b);
    }

    public void postSwap() {
        if (this.check) {
            this.gc.readRaster(this.readRaster);
            this.check = false;
        }
    }

    @Override
    public void saveImage(File file) throws IOException {
        int width = this.getWidth();
        int height = this.getHeight();
        BufferedImage bImage = new BufferedImage(width, height, 1);
        ImageComponent2D ic2d = new ImageComponent2D(1, bImage);
        this.readRaster = new Raster(new Point3f(0.0f, 0.0f, 0.0f), 1, 0, 0, width, height, ic2d, null);
        this.check = true;
        while (this.check) {
            try {
                Thread.sleep(300L);
            }
            catch (Exception e) {}
        }
        ImageComponent2D ic = this.readRaster.getImage();
        BufferedImage image = ic.getImage();
        ImageIO.write((RenderedImage)image, "png", file);
    }

    @Override
    public BufferedImage snapshot() {
        int width = this.getWidth();
        int height = this.getHeight();
        BufferedImage bImage = new BufferedImage(width, height, 1);
        ImageComponent2D ic2d = new ImageComponent2D(1, bImage);
        this.readRaster = new Raster(new Point3f(0.0f, 0.0f, 0.0f), 1, 0, 0, width, height, ic2d, null);
        this.check = true;
        while (this.check) {
            try {
                Thread.sleep(300L);
            }
            catch (Exception e) {}
        }
        ImageComponent2D ic = this.readRaster.getImage();
        BufferedImage image = ic.getImage();
        return image;
    }

    @Override
    public void prepareScene(int scene) {
        this.universe.prepareScene(scene);
    }

    @Override
    public void changeActiveScene(int s) {
        this.universe.changeActiveScene(s);
    }

    @Override
    public void add(A3Object a, int s) {
        this.universe.add(a, s);
    }

    @Override
    public void del(A3Object a, int s) {
        this.universe.del(a, s);
    }

    @Override
    public void setDefaultCameraLoc(double x, double y, double z, int scene) {
        this.universe.setDefaultCameraLoc(x, y, z);
    }

    @Override
    public void setDefaultCameraLoc(Vector3d loc, int scene) {
        this.universe.setDefaultCameraLoc(loc, scene);
    }

    @Override
    public void setDefaultCameraQuat(double x, double y, double z, double w, int scene) {
        this.universe.setDefaultCameraQuat(x, y, z, w, scene);
    }

    @Override
    public void setDefaultCameraQuat(Quat4d quat, int scene) {
        this.universe.setDefaultCameraQuat(quat, scene);
    }

    @Override
    public void setDefaultCameraRot(double x, double y, double z, int scene) {
        this.universe.setDefaultCameraRot(x, y, z, scene);
    }

    @Override
    public void setDefaultCameraRot(Vector3d rot, int scene) {
        this.universe.setDefaultCameraRot(rot, scene);
    }

    @Override
    public void setDefaultCameraRev(double x, double y, double z, int scene) {
        this.universe.setDefaultCameraRev(x, y, z, scene);
    }

    @Override
    public void setDefaultCameraRev(Vector3d rev, int scene) {
        this.universe.setDefaultCameraRev(rev, scene);
    }

    @Override
    public void setDefaultCameraScale(double s, int scene) {
        this.universe.setDefaultCameraScale(s, scene);
    }

    @Override
    public void resetCamera(int scene) {
        this.universe.resetCamera(scene);
    }

    @Override
    public void setCameraLoc(double x, double y, double z, int scene) {
        this.universe.setCameraLoc(x, y, z, scene);
    }

    @Override
    public void setCameraLoc(Vector3d loc, int scene) {
        this.universe.setCameraLoc(loc, scene);
    }

    @Override
    public void setCameraLocImmediately(double x, double y, double z, int scene) {
        this.universe.setCameraLocImmediately(x, y, z, scene);
    }

    @Override
    public void setCameraLocImmediately(Vector3d loc, int scene) {
        this.universe.setCameraLocImmediately(loc, scene);
    }

    @Override
    public void addCameraLoc(double x, double y, double z, int scene) {
        this.universe.addCameraLoc(x, y, z, scene);
    }

    @Override
    public void addCameraLoc(Vector3d loc, int scene) {
        this.universe.addCameraLoc(loc, scene);
    }

    @Override
    public void addCameraLocImmediately(double x, double y, double z, int scene) {
        this.universe.addCameraLocImmediately(x, y, z, scene);
    }

    @Override
    public void addCameraLocImmediately(Vector3d loc, int scene) {
        this.universe.setCameraLocImmediately(loc, scene);
    }

    @Override
    public Vector3d getCameraLoc(int scene) {
        return this.universe.getCameraLoc(scene);
    }

    @Override
    public Vector3d getCameraTargetLoc(int scene) {
        return this.universe.getCameraTargetLoc(scene);
    }

    @Override
    public void setCameraQuat(double x, double y, double z, double w, int scene) {
        this.universe.setCameraQuat(x, y, z, w, scene);
    }

    @Override
    public void setCameraQuat(Quat4d quat, int scene) {
        this.universe.setCameraQuat(quat, scene);
    }

    @Override
    public void setCameraQuatImmediately(double x, double y, double z, double w, int scene) {
        this.universe.setCameraQuatImmediately(x, y, z, w, scene);
    }

    @Override
    public void setCameraQuatImmediately(Quat4d quat, int scene) {
        this.universe.setCameraQuatImmediately(quat, scene);
    }

    @Override
    public void mulCameraQuat(double x, double y, double z, double w, int scene) {
        this.universe.mulCameraQuat(x, y, z, w, scene);
    }

    @Override
    public void mulCameraQuat(Quat4d quat, int scene) {
        this.universe.mulCameraQuat(quat, scene);
    }

    @Override
    public void mulCameraQuatImmediately(double x, double y, double z, double w, int scene) {
        this.universe.mulCameraQuatImmediately(x, y, z, w, scene);
    }

    @Override
    public void mulCameraQuatImmediately(Quat4d quat, int scene) {
        this.universe.mulCameraQuatImmediately(quat, scene);
    }

    @Override
    public Quat4d getCameraQuat(int scene) {
        return this.universe.getCameraQuat(scene);
    }

    @Override
    public Quat4d getCameraTargetQuat(int scene) {
        return this.universe.getCameraTargetQuat(scene);
    }

    @Override
    public void setCameraRot(double x, double y, double z, int scene) {
        this.universe.setCameraRot(x, y, z, scene);
    }

    @Override
    public void setCameraRot(Vector3d rot, int scene) {
        this.universe.setCameraRot(rot, scene);
    }

    @Override
    public void setCameraRotImmediately(double x, double y, double z, int scene) {
        this.universe.setCameraRotImmediately(x, y, z, scene);
    }

    @Override
    public void setCameraRotImmediately(Vector3d rot, int scene) {
        this.universe.setCameraRotImmediately(rot, scene);
    }

    @Override
    public void mulCameraRot(double x, double y, double z, int scene) {
        this.universe.mulCameraRot(x, y, z, scene);
    }

    @Override
    public void mulCameraRot(Vector3d rot, int scene) {
        this.universe.mulCameraRot(rot, scene);
    }

    @Override
    public void mulCameraRotImmediately(double x, double y, double z, int scene) {
        this.universe.mulCameraRotImmediately(x, y, z, scene);
    }

    @Override
    public void mulCameraRotImmediately(Vector3d rot, int scene) {
        this.universe.setCameraRotImmediately(rot, scene);
    }

    @Override
    public Vector3d getCameraRot(int scene) {
        return this.universe.getCameraRot();
    }

    @Override
    public Vector3d getCameraTargetRot(int scene) {
        return this.universe.getCameraTargetRot();
    }

    @Override
    public void setCameraRev(double x, double y, double z, int scene) {
        this.universe.setCameraRev(x, y, z, scene);
    }

    @Override
    public void setCameraRev(Vector3d rev, int scene) {
        this.universe.setCameraRev(rev, scene);
    }

    @Override
    public void setCameraRevImmediately(double x, double y, double z, int scene) {
        this.universe.setCameraRevImmediately(x, y, z, scene);
    }

    @Override
    public void setCameraRevImmediately(Vector3d rev, int scene) {
        this.universe.setCameraRevImmediately(rev, scene);
    }

    @Override
    public void mulCameraRev(double x, double y, double z, int scene) {
        this.universe.mulCameraRev(x, y, z, scene);
    }

    @Override
    public void mulCameraRev(Vector3d rev, int scene) {
        this.universe.mulCameraRev(rev, scene);
    }

    @Override
    public void mulCameraRevImmediately(double x, double y, double z, int scene) {
        this.universe.mulCameraRevImmediately(x, y, z, scene);
    }

    @Override
    public void mulCameraRevImmediately(Vector3d rev, int scene) {
        this.universe.setCameraRevImmediately(rev, scene);
    }

    @Override
    public Vector3d getCameraRev(int scene) {
        return this.universe.getCameraRev();
    }

    @Override
    public Vector3d getCameraTargetRev(int scene) {
        return this.universe.getCameraTargetRev();
    }

    @Override
    public void setCameraScale(double s, int scene) {
        this.universe.setCameraScale(s, scene);
    }

    @Override
    public void setCameraScaleImmediately(double s, int scene) {
        this.universe.setCameraScaleImmediately(s, scene);
    }

    @Override
    public void mulCameraScale(double s, int scene) {
        this.universe.mulCameraScale(s, scene);
    }

    @Override
    public void mulCameraScaleImmediately(double s, int scene) {
        this.universe.mulCameraScaleImmediately(s, scene);
    }

    @Override
    public double getCameraScale(int scene) {
        return this.universe.getCameraScale(scene);
    }

    @Override
    public double getCameraTargetScale(int scene) {
        return this.universe.getCameraTargetScale(scene);
    }

    @Override
    public void setCameraLookAtPoint(Vector3d lookAt, int scene) {
        this.universe.setCameraLookAtPoint(lookAt, scene);
    }

    @Override
    public void setCameraLookAtPointImmediately(Vector3d lookAt, int scene) {
        this.universe.setCameraLookAtPointImmediately(lookAt, scene);
    }

    @Override
    public void setCameraLookAtPoint(double x, double y, double z, int scene) {
        this.universe.setCameraLookAtPoint(x, y, z, scene);
    }

    @Override
    public void setCameraLookAtPointImmediately(double x, double y, double z, int scene) {
        this.universe.setCameraLookAtPointImmediately(x, y, z, scene);
    }

    @Override
    public void setCameraLookAtPoint(Vector3d lookAt, Vector3d up, int scene) {
        this.universe.setCameraLookAtPoint(lookAt, up, scene);
    }

    @Override
    public void setCameraLookAtPointImmediately(Vector3d lookAt, Vector3d up, int scene) {
        this.universe.setCameraLookAtPointImmediately(lookAt, up, scene);
    }

    @Override
    public void setCameraLookAtPoint(double x, double y, double z, Vector3d up, int scene) {
        this.universe.setCameraLookAtPoint(x, y, z, up, scene);
    }

    @Override
    public void setCameraLookAtPointImmediately(double x, double y, double z, Vector3d up, int scene) {
        this.universe.setCameraLookAtPointImmediately(x, y, z, up, scene);
    }

    @Override
    public void setNavigationMode(int scene, A3CanvasInterface.NaviMode m, Object ... params) {
        this.universe.setNavigationMode(scene, m, params);
    }

    @Override
    public void setNavigationSpeed(double s, int scene) {
        this.universe.setNavigationSpeed(s, scene);
    }

    @Override
    public double getNavigationSpeed(int scene) {
        return this.universe.getNavigationSpeed(scene);
    }

    @Override
    public void setA3Controller(A3Controller c, int scene) {
        this.universe.setA3Controller(c, scene);
    }

    @Override
    public void setBackground(A3Object a, int scene) {
        this.universe.setBackground(a, scene);
    }

    @Override
    public void delBackground(int scene) {
        this.universe.delBackground(scene);
    }

    @Override
    public void setAvatar(A3Object a, int scene) {
        this.universe.setAvatar(a, scene);
    }

    @Override
    public A3Object getAvatar(int scene) {
        return this.universe.getAvatar(scene);
    }

    @Override
    public void addLockedA3(A3Object a) {
        this.universe.addLockedA3(a);
    }

    @Override
    public void delLockedA3(A3Object a) {
        this.universe.delLockedA3(a);
    }

    @Override
    public void delAllLockedA3() {
        this.universe.delAllLockedA3();
    }

    @Override
    public void addLockedA3(A3Object a, int scene) {
        this.universe.addLockedA3(a, scene);
    }

    @Override
    public void delLockedA3(A3Object a, int scene) {
        this.universe.delLockedA3(a, scene);
    }

    @Override
    public void delAllLockedA3(int scene) {
        this.universe.delAllLockedA3(scene);
    }

    @Override
    public void setUpperDirection(A3Object.UpperDirection d) {
        this.universe.setUpperDirection(d);
    }

    @Override
    public void setUpperDirection(A3Object.UpperDirection d, int scene) {
        this.universe.setUpperDirection(d, scene);
    }

    @Override
    public A3Object.UpperDirection getUpperDirection() {
        return this.universe.getUpperDirection();
    }

    @Override
    public A3Object.UpperDirection getUpperDirection(int scene) {
        return this.universe.getUpperDirection(scene);
    }

    @Override
    public Dimension getCanvasSize() {
        return this.getSize();
    }

    @Override
    public void cleanUp() {
    }

    @Override
    public void addA3SubCanvas(A3CanvasInterface sc) {
        this.universe.addA3SubCanvas(sc);
    }

    @Override
    public void setProjectionMode(ProjectionMode m) {
        this.universe.setProjectionMode(m);
    }

    @Override
    public void setCanvasWidthInPWorld(double s) {
        this.universe.setCanvasWidthInPWorld(s);
    }

    @Override
    public void setFieldOfView(double f) {
        this.universe.setFieldOfView(f);
    }

    @Override
    public TransformGroup getTransformGroupForViewPlatform() {
        return this.universe.getTransformGroupForViewPlatform();
    }

    @Override
    public Canvas3D getCanvas3D() {
        return super.getOffscreenCanvas3D();
    }

    @Override
    public void setSoundGain(double g) {
        this.universe.setSoundGain(g);
    }

    @Override
    public double getSoundGain() {
        return this.universe.getSoundGain();
    }

    @Override
    public BranchGroup getBranchGroupForViewPlatform() {
        return null;
    }

    @Override
    public void setPickingBehavior(PickingBehavior pb) {
    }

    @Override
    public void setVirtualUniverse(A3VirtualUniverse vu) {
    }

    @Override
    public A3VirtualUniverse getVirtualUniverse() {
        return this.universe;
    }

    @Override
    public void setCameraLocNow(double x, double y, double z) {
        this.setCameraLocImmediately(x, y, z);
    }

    @Override
    public void setCameraLocNow(Vector3d loc) {
        this.setCameraLocImmediately(loc);
    }

    @Override
    public void addCameraLocNow(double x, double y, double z) {
        this.addCameraLocImmediately(x, y, z);
    }

    @Override
    public void addCameraLocNow(Vector3d loc) {
        this.addCameraLocImmediately(loc);
    }

    @Override
    public void moveCameraForwardNow(double l) {
        this.moveCameraForwardImmediately(l);
    }

    @Override
    public void moveCameraBackwardNow(double l) {
        this.moveCameraBackwardImmediately(l);
    }

    @Override
    public void moveCameraRightNow(double l) {
        this.moveCameraRightImmediately(l);
    }

    @Override
    public void moveCameraLeftNow(double l) {
        this.moveCameraLeftImmediately(l);
    }

    @Override
    public void moveCameraUpNow(double l) {
        this.moveCameraUpImmediately(l);
    }

    @Override
    public void moveCameraDownNow(double l) {
        this.moveCameraDownImmediately(l);
    }

    @Override
    public void moveCameraToNow(Vector3d v, double l) {
        this.moveCameraToImmediately(v, l);
    }

    @Override
    public void moveCameraToNow(double x, double y, double z, double l) {
        this.moveCameraToImmediately(x, y, z, l);
    }

    @Override
    public void moveCameraToNow(A3Object a, double l) {
        this.moveCameraToImmediately(a, l);
    }

    @Override
    public void moveCameraForwardNow(double l, int scene) {
        this.moveCameraForwardImmediately(l, scene);
    }

    @Override
    public void moveCameraBackwardNow(double l, int scene) {
        this.moveCameraBackwardImmediately(l, scene);
    }

    @Override
    public void moveCameraRightNow(double l, int scene) {
        this.moveCameraRightImmediately(l, scene);
    }

    @Override
    public void moveCameraLeftNow(double l, int scene) {
        this.moveCameraLeftImmediately(l, scene);
    }

    @Override
    public void moveCameraUpNow(double l, int scene) {
        this.moveCameraUpImmediately(l, scene);
    }

    @Override
    public void moveCameraDownNow(double l, int scene) {
        this.moveCameraDownImmediately(l, scene);
    }

    @Override
    public void moveCameraToNow(Vector3d v, double l, int scene) {
        this.moveCameraToImmediately(v, l, scene);
    }

    @Override
    public void moveCameraToNow(double x, double y, double z, double l, int scene) {
        this.moveCameraToImmediately(x, y, z, l, scene);
    }

    @Override
    public void moveCameraToNow(A3Object a, double l, int scene) {
        this.moveCameraToImmediately(a, l, scene);
    }

    @Override
    public void setCameraQuatNow(double x, double y, double z, double w) {
        this.setCameraQuatImmediately(x, y, z, w);
    }

    @Override
    public void setCameraQuatNow(Quat4d quat) {
        this.setCameraQuatImmediately(quat);
    }

    @Override
    public void mulCameraQuatNow(double x, double y, double z, double w) {
        this.mulCameraQuatImmediately(x, y, z, w);
    }

    @Override
    public void mulCameraQuatNow(Quat4d quat) {
        this.mulCameraQuatImmediately(quat);
    }

    @Override
    public void setCameraRotNow(double x, double y, double z) {
        this.setCameraRotImmediately(x, y, z);
    }

    @Override
    public void setCameraRotNow(Vector3d rot) {
        this.setCameraRotImmediately(rot);
    }

    @Override
    public void mulCameraRotNow(double x, double y, double z) {
        this.mulCameraRotImmediately(x, y, z);
    }

    @Override
    public void mulCameraRotNow(Vector3d rot) {
        this.mulCameraRotImmediately(rot);
    }

    @Override
    public void setCameraRevNow(double x, double y, double z) {
        this.setCameraRevImmediately(x, y, z);
    }

    @Override
    public void setCameraRevNow(Vector3d rev) {
        this.setCameraRevImmediately(rev);
    }

    @Override
    public void mulCameraRevNow(double x, double y, double z) {
        this.mulCameraRevImmediately(x, y, z);
    }

    @Override
    public void mulCameraRevNow(Vector3d rev) {
        this.mulCameraRevImmediately(rev);
    }

    @Override
    public void setCameraScaleNow(double s) {
        this.setCameraScaleImmediately(s);
    }

    @Override
    public void mulCameraScaleNow(double s) {
        this.mulCameraScaleImmediately(s);
    }

    @Override
    public void setCameraLookAtPointNow(Vector3d lookAt) {
        this.setCameraLookAtPointImmediately(lookAt);
    }

    @Override
    public void setCameraLookAtPointNow(double x, double y, double z) {
        this.setCameraLookAtPointImmediately(x, y, z);
    }

    @Override
    public void setCameraLookAtPointNow(Vector3d lookAt, Vector3d up) {
        this.setCameraLookAtPointImmediately(lookAt, up);
    }

    @Override
    public void setCameraLookAtPointNow(double x, double y, double z, Vector3d up) {
        this.setCameraLookAtPointImmediately(x, y, z, up);
    }

    @Override
    public void setCameraLocNow(double x, double y, double z, int scene) {
        this.setCameraLocImmediately(x, y, z, scene);
    }

    @Override
    public void setCameraLocNow(Vector3d loc, int scene) {
        this.setCameraLocImmediately(loc, scene);
    }

    @Override
    public void addCameraLocNow(double x, double y, double z, int scene) {
        this.addCameraLocImmediately(x, y, z, scene);
    }

    @Override
    public void addCameraLocNow(Vector3d loc, int scene) {
        this.addCameraLocImmediately(loc, scene);
    }

    @Override
    public void setCameraQuatNow(double x, double y, double z, double w, int scene) {
        this.setCameraQuatImmediately(x, y, z, w, scene);
    }

    @Override
    public void setCameraQuatNow(Quat4d quat, int scene) {
        this.setCameraQuatImmediately(quat, scene);
    }

    @Override
    public void mulCameraQuatNow(double x, double y, double z, double w, int scene) {
        this.mulCameraQuatImmediately(x, y, z, w, scene);
    }

    @Override
    public void mulCameraQuatNow(Quat4d quat, int scene) {
        this.mulCameraQuatImmediately(quat, scene);
    }

    @Override
    public void setCameraRotNow(double x, double y, double z, int scene) {
        this.setCameraRotImmediately(x, y, z, scene);
    }

    @Override
    public void setCameraRotNow(Vector3d rot, int scene) {
        this.setCameraRotImmediately(rot, scene);
    }

    @Override
    public void mulCameraRotNow(double x, double y, double z, int scene) {
        this.mulCameraRotImmediately(x, y, z, scene);
    }

    @Override
    public void mulCameraRotNow(Vector3d rot, int scene) {
        this.mulCameraRotImmediately(rot, scene);
    }

    @Override
    public void setCameraRevNow(double x, double y, double z, int scene) {
        this.setCameraRevImmediately(x, y, z, scene);
    }

    @Override
    public void setCameraRevNow(Vector3d rev, int scene) {
        this.setCameraRevImmediately(rev, scene);
    }

    @Override
    public void mulCameraRevNow(double x, double y, double z, int scene) {
        this.mulCameraRevImmediately(x, y, z, scene);
    }

    @Override
    public void mulCameraRevNow(Vector3d rev, int scene) {
        this.mulCameraRevImmediately(rev, scene);
    }

    @Override
    public void setCameraScaleNow(double s, int scene) {
        this.setCameraScaleImmediately(s, scene);
    }

    @Override
    public void mulCameraScaleNow(double s, int scene) {
        this.mulCameraScaleImmediately(s, scene);
    }

    @Override
    public void setCameraLookAtPointNow(Vector3d lookAt, int scene) {
        this.setCameraLookAtPointImmediately(lookAt, scene);
    }

    @Override
    public void setCameraLookAtPointNow(double x, double y, double z, int scene) {
        this.setCameraLookAtPointImmediately(x, y, z, scene);
    }

    @Override
    public void setCameraLookAtPointNow(Vector3d lookAt, Vector3d up, int scene) {
        this.setCameraLookAtPointImmediately(lookAt, up, scene);
    }

    @Override
    public void setCameraLookAtPointNow(double x, double y, double z, Vector3d up, int scene) {
        this.setCameraLookAtPointImmediately(x, y, z, up, scene);
    }
}

