<?php
// $Id: dbListPage.inc,v 1.1 2005/09/20 06:16:36 atsushifx Exp $
//
/**
 * ڡ󥰥饹
 *
 * ڡSQL
 *
 * @package jp.sf.aglib.DB
 *
 * @copyright Copyright &copy; 2004-2005 <a href="http://aglib.sourceforge.jp/">aglib Project</a>
 * @licence http://www.opensource.org/licenses/bsd-license.php
 * @license http://www.jp.freebsd.org/www.freebsd.org/ja/copyright/freebsd-license.html
 *
 * @version $Revision: 1.1 $
 * @since   1.00
 * @create  2005-09-02
 *
 * @author  Furukawa Atsushi <atsushifx@aglabo.com>
 */
require_once 'aglib.inc';
// aglib
require_once 'DB/dbList.inc';

/**
 * ڡɽ
 *
 * ꤷڡΰɽSQL
 *
 * @version 1.10
 * @author  Furukaw Atsushi <atsushifx@aglabo.com>
 * @since   1.00
 * @create  2004-05-05
 */
class dbListPage extends dbList {
    /**
     * @access private
     * @var int ڡ(1ڡɽԿ)
     */
    var $_pagesize = 0;

    /**
    * @access private
    * @var int ơ֥Կ
    */
    var $_rowmax = 0;

    /**
     * @access private
     * @var int ڡ
     */
    var $_pagemax = 0;

    /**
     * @var int ڡֹ
     */
    var $pageno = 1;

    /**
     * 󥹥ȥ饯
     *
     * @param string            ơ֥̾
     * @param int(&optional)    ڡ(1ԤɽԿ)
     */
    function dbListPage($tables, $orderby="", $columns="", $connectors="")
    {
        global $ag_dbl_Pagesize;

        $this->dbList($tables, $orderby, $columns, $connectors);
        $this->setPagesize($ag_dbl_Pagesize);
    }

    /**
     * Version
     *
     * @param void
     * @return string   СNo
     */
    function version()
    {
        return '1.00';
    }

    /**
     * ڡ
     *
     * @param int ڡ(1ڡɽԿ)
     * @return int ڡ
     */
    function setPagesize($pagesize)
    {
        if ($pagesize > 0) {
            $this->_pagesize = $pagesize;
        }
        return $this->_pagesize;
    }

    /**
     * ڡֹ
     *
     * @param int ڡ(1ڡɽԿ)
     * @return int ڡ
     */
    function setPageno($pageno)
    {
        if ($pageno >= 0) {
            $this->pageno = $this->_regPage($pageno);
        }
        return $this->pageno;
    }

    /**
     * ڡ򻻽Ф
     *
     * @return Фڡ
     */
    function pageCalc()
    {
        $pagemax = intval(($this->_rowmax + $this->_pagesize - 1) / $this->_pagesize);
        if ($pagemax <= 0) { $pagemax = 1; }
        $this->_pagemax = $pagemax;
        return $this->_pagemax;
    }

    /**
     * ڡֹꤹ
     *
     * @access private
     * @param int ڡֹ
     * @return ڡֹ
     */
    function _regPage($pageno)
    {
        $this->pageCalc();
        if ($pageno < 1)                $pageno = 1;
        if ($pageno > $this->_pagemax)  $pageno = $this->_pagemax;
        return $pageno;
    }

    /**
     * ڡ鳫ϹԤ
     *
     * @param int   ڡֹ
     * @return int  Ϲ
     */
    function pageStart()
    {
        $pageno = $this->_regPage($this->pageno);
        $start = ($pageno - 1) * $this->_pagesize;
        return $start;
    }

    /**
     * ڡ뤫å
     *
     * @param int ڡֹ
     * @return bool true:ڡ꡿false:ڡʤ
     */
    function hasPrev($pageno = false)
    {
        if ($pageno === false){ $pageno = $this->pageno; }
        $pageno = $this->_regPage($pageno);
        return ($pageno > 1);
    }

    /**
     * ڡ뤫å
     *
     * @param int ڡֹ
     * @return bool true:ڡ꡿false:ڡʤ
     */
    function hasNext($pageno = false)
    {
        if ($pageno == false){ $pageno = $this->pageno; }
        $pageno = $this->_regPage($pageno);
        return ($pageno < $this->_pagemax);
    }

    /**
     * ڡɽϰϤ
     *
     * @param int       ڡϰ
     * @return int[]    ڡ,ǽڡ
     */
    function pageList($range)
    {
        $er = $this->pageCalc();
        $st = $this->pageno - intval($range / 2);
        if ($st < 1){ $st = 1; }
        $ed = $st + ($range - 1);
        if ($ed >= $this->_pagemax){ $ed = $this->_pagemax; }
        $st = $ed -  ($range - 1);
        if ($st < 1){ $st = 1; }
        return array($st, $ed);
    }

    /**
     * ڡιԤSQLȯԤ
     * @param [string]   ѥѥ᡼
     * @return DB_Result SQL¹Է
     */
    function pageQuery($param = null)
    {
        $count = $this->count();        // Կ
        if (aglib::isError($count))     return $count;

        $start = $this->pageStart();
        $sql = $this->_makeSql();
        if (aglib::isError($sql))       return $sql;
        $er = $this->connect();
        if (aglib::isError($er))        return $er;

        $result = $this->_db->limitQuery($sql, $start, $this->_pagesize);
        return $result;
    }
}
?>
