<?php
//ͭ
// $Id: dbWhere.inc,v 1.1 2005/09/20 06:16:36 atsushifx Exp $
/**
 * Where饹Υƥ
 *
 * ʣåѤWhere륯饹UnitTest
 *
 * @package jp.sf.aglib.DB
 * @licence http://www.opensource.org/licenses/bsd-license.php
 * @license http://www.jp.freebsd.org/www.freebsd.org/ja/copyright/freebsd-license.html
 *
 * @copyright Copyright &copy; 2005 <a href="http://www.aglabo.com/">A.G.Labo</a>
 *
 * @since   1.00
 * @version $Revision: 1.1 $
 * @create  2005-08-08
 *
 * @author  Furukawa Atsushi <atsushifx@aglabo.com>
 */
// PEAR
// aglib
require_once 'DB/dbBase.inc';

// 
define('AGDB_WH_FMT_DATE', 'Y-m-d');
define('AGDB_WH_FMT_TIME', 'H:i:s');
define('AGDB_WH_FMT_DATETIME', 'Y-m-d H:i:s');

/**
 * dbWhere -- Where⥸塼
 *
 * ꤷơ֥ιܤѤWhere
 *
 * @since   0.01
 * @version $Revision: 1.1 $
 * @create  2005-08-08
 *
 * @author  Furukawa Atsushi <atsushifx@aglabo.com>
 */
class dbWhere {
    /**
     * @access private
     * @var string 򤹤ơ֥
     */
    var $_table;

    /**
     * @access private
     * @var dao եɼDAO
     */
    var $_db;

    /**
     * @access private
     * @var string[]    եɰ
     */
    var $_fields;

    /**
     * 󥹥ȥ饯
     *
     * @param string ơ֥̾
     */
    function dbWhere($table = '')
    {
        $this->_table = $table;
        $this->_db = new dbBase();
        $this->_fields = array();
    }

    // Where³
    /**
     * whereɲ(and)
     *
     * Хåե˺Whereɲä
     * Where礬ǤˤȤ and ǤĤʤ
     *
     * @param string whereХåե
     * @param string ɲäWhere
     * @return string ɲäWhere
     */
    function add($where, $add)
    {
        if ($add != "") {
            if ($where != "") { $where .= " and\n  "; }
            $where .= $add;
        }
        return $where;
    }



    // Where
    /**
     * Equal
     *
     * ͤåWhere
     *
     * @parma string ̾
     * @param string 
     * @return string Where
     */
    function whEqual($item, $value)
    {
        $type = $this->getType($item);
        if (aglib::isError($type))              return NULL;
        if (is_null($value))                    return NULL;
        if ($value==='' && $type=='integer')    return NULL;
        $buff = $item . " = " . $this->quote($value, $type);
        return $buff;
    }

    /**
     * Not Equal
     *
     * ͤʤåWhere
     *
     * @parma string ̾
     * @param string 
     * @return string Where
     */
    function whNotEqual($item, $value)
    {
        $type = $this->getType($item);
        if (aglib::isError($type))  return NULL;
        if (is_null($value))        return NULL;
        $buff = $item . " <> " . $this->quote($value, $type);
        return $buff;
    }

    /**
     * ֡ϰϻWhere
     *
     * ϰ򸡺Where
     *
     * @param string    ̾
     * @param mixed     
     * @param [mixed]   λ
     * @return string   Where
     */
    function whRange($item, $st, $ed = null)
    {
        $item = trim($item);
        if ($item=='')                      return NULL;
        $type = $this->getType($item);
        if (aglib::isError($type))          return NULL;
        if ($st == '') {
            if ($ed == '') {
                $where = NULL;
            } else {
                $where = $item . " <= " . $this->quote($ed, $type);
            }
        } else {
            if ($ed == '') {
                $where = $item . " >= " . $this->quote($st, $type);
            } else {
                $where = $item . " between " . $this->quote($st, $type) ." and " . $this->quote($ed, $type);
            }
        }
        return $where;
    }

    /**
     * ɸWhere
     *
     * likeˤʬ׸Where
     *
     * @parma string ̾
     * @param string 
     * @return string Where
     */
    function whKeyword($item, $keyword)
    {
        $type = $this->getType($item);
        if (aglib::isError($type))  return "";
        if ($keyword == '')         return "";
        $where = $item . " like '%" . $this->likeEscape($keyword) . "%'";
        return $where;
    }

    /**
     * ꥹȸWhere
     *
     * ꥹȤǻꤵ줿ܤ򸡺Where
     *
     * @parma string    ̾
     * @param string[]  ͥꥹ
     * @return string Where
     */
    function whIn($item, $in)
    {
        $item = trim($item);
        if ($item == '')            return NULL;
        $type = $this->getType($item);
        if (aglib::isError($type))  return NULL;
        if ($in == '')              return NULL;
        if (!is_array($in))         return $this->whEqual($item, $in);
        if (count($in) == 1)        return $this->whEqual($item, $in[0]);
        $values = "";
        foreach ($in as $v) {
            if ($values != ''){ $values .= ", "; }
            $values .= $this->Quote($v, $type);
        }
        $where = $item . " in (" . $values . ")";
        return $where;
    }

    // Whereѥ桼ƥƥ
    /**
     * 
     *
     * ̾б
     *
     * @param string ̾
     * @return string   ̾agError
     *      - ܤ¸ߤʤ
     */
    function getType($item)
    {
        $item = trim($item);
        $item = preg_replace('/^(\w+\.)/', '', $item);
        $ret = "";
        if ($item == "") {
            $ret = aglib::raiseError('AGERR_DB_FIELDCANTGET');
        } else {
            if ($this->_fields == array()) {
                $fields = $this->_db->getFields($this->_table);
                if (aglib::isError($fields))    return $fields;
                $this->_fields = $fields;
            }
            if (isset($this->_fields[$item])) {
                $ret = $this->_fields[$item];
            } else {
                $ret = aglib::raiseError('AGERR_DB_FIELDCANTGET');
            }
        }
        return $ret;
    }

    /**
     * ʸEscape
     *
     * ʸEscape
     *
     * @param string    ʸ
     * @return string   Escapeʸ
     */
    function escape($str)
    {
        return $this->_db->escape($str);
    }

    /**
     * ʸEscape
     *
     * Like黻ҤWildCard򥨥פ
     *
     * @param string    ʸ
     * @return string   Escapeʸ
     */
    function likeEscape($str)
    {
        return $this->_db->likeEscape($str);
    }

    /**
     * Quote
     *
     * SQLѤͤQuote
     *
     * @param miexd 
     * @param string ͤη
     * @return string Quote
     */
    function quote($value, $type = '')
    {
        $typelist = array(
            AGDB_TYPE_STRING,
            AGDB_TYPE_BOOL,
            AGDB_TYPE_INT,
            AGDB_TYPE_REAL,
            AGDB_TYPE_CURRENCY,
            AGDB_TYPE_DATE,
            AGDB_TYPE_TIME,
            AGDB_TYPE_DATETIME,
            );
        if (aglib::isError($type))  return $type;
        if ($type == ''){ $type = AGDB_TYPE_STRING; }
        $type = strtolower($type);
        if (!in_array($type, $typelist)) { return aglib::raiseError('AGERR_DB_TYPEUNDEF'); }

        if (is_null($value)) {
            $ret = 'NULL';
        } else {
            switch ($type) {
            case AGDB_TYPE_BOOL:
                $ret = ($value ? 'true' : 'false');
                break;
            case AGDB_TYPE_INT:
            case AGDB_TYPE_REAL:
            case AGDB_TYPE_CURRENCY:
                if (is_numeric($value)) {
                    $ret = $value;
                } else {
                    $ret = "'" . $this->escape($value) . "'";
                }
                break;

            case AGDB_TYPE_DATE:
            case AGDB_TYPE_TIME:
            case AGDB_TYPE_DATETIME:
                if ($value === '') {
                    $ret = "''";
                } else {
                    $date = strtotime($value);
                    if ($date < 0) {    // invalid date
                        $ret = "'" . $this->escape($value) . "'";
                    } else {
                        if ($type == 'date') {
                            $format = AGDB_WH_FMT_DATE;
                        } elseif ($type == "time") {
                            $format = AGDB_WH_FMT_TIME;
                        } else {
                            $format = AGDB_WH_FMT_DATETIME;
                        }
                        $ret = "'" . date($format, $date) . "'";
                    }
                }
                break;

            default:
                $ret = "'" . $this->escape($value) . "'";
                break;
            }
        }
        return $ret;
    }
}
?>
