<?php
// $Id: dbBase.inc,v 1.13 2004/04/30 08:25:04 atsushifx Exp $
require_once 'aglib.inc';
require_once 'DB.php'; // PEAR DB

/**
* DBBase
* DB³Ѵܥ饹
*
* @author Furukaw Atsushi <atsushifx@aglabo.com>
* @version $Revision: 1.13 $
* @package com.aglabo.aglib.dbobject
* @licence http://www.opensource.org/licenses/bsd-license.php
* @since 1.00
*/
// Database³
if (!defined("DBO_DATABASE")) {
	define("DBO_DATABASE", "mysql");
	define("DBO_USER",		 "nobody");
	define("DBO_PASSWORD", "nobody");
	define("DBO_HOST",		 "localhost");
	define("DBO_DBDB",		 "aglib");
}

/**
* DBBase
* DB³Ѵܥ饹
* @author Furukaw Atsushi <atsushifx@aglabo.com>
* @version $Revision: 1.13 $
* @package aglib
* @licence http://www.opensource.org/licenses/bsd-license.php
* @since 2004-01-26
*/
class dbBase {
	/**
	* @var stirng ³ǡ١
	*/
	var $database = DBO_DATABASE;

	/**
	* @access private
	* @var string 桼̾
	*/
	var $_user    = DBO_USER;

	/**
	* @access private
	* @var string ѥ
	*/
	var $_password = DBO_PASSWORD;

	/**
	* @access private
	* @var string ۥ̾
	*/
	var $_host     = DBO_HOST;

	/**
	* @access private
	* @var string DB̾
	*/
	var $_dbdb     = DBO_DBDB;

	/**
	* @var DB DB³
	* @access private
	*/
	var $_db = null;

	/**
	* @var DBO_xxx DBManager
	* @access pricate
	*/
	var $_dbo = null;

	function dbBase()
	{
		$this->_db = null;
	}

	/**
	* Version
	*/
	function version()
	{
		return 1.00;
	}


	/**
	* ꤫DSN
	* @access private
	* @return string DSN
	*/
	function _getDSN_()
	{
		$database = $this->database;
		$user = $this->_user;
		$password = $this->_password;
		$host = $this->_host;
		$db = $this->_dbdb;

		$dsn =$database . "://" . $user;
		if ($password != '')  $dsn .= ':' . $password;

		if ($database=='pgsql' && $host=='localhost')  $host = '';
		$dsn .= '@' . $host . '/' . $db;
		return $dsn;
	}

	/**
	* ³ǡ١
	*/
	function setDatabase($dbase)
	{
		if ($dbase == "") return false;
		$this->database = $dbase;
		return true;
	}

	/**
	* DBO
	* @param DBOѤΥǡ١
	* @return DBO
	*/
	function &dboFactory($database = "")
	{
		if ($database == "") {
			$database = $this->database;
		}
		$class = "dbo_" . $database;
		@include_once "aglib/dbo/$class.inc";
		if (!class_exists($class)) {
			return null;
		}
		$dbo = new $class();
		return $dbo;
	}

	/**
	* DB³Ƥ뤫å
	* @return true:³Ƥ롿false:³Ƥʤ
	*/
	function isConnected()
	{
		$db = $this->_db;
		return (is_object($db) && is_subclass_of($db, 'db_common'));
	}


	/**
	* DB³
	* @return true:³false:³
	*/
	function connect()
	{
		if ($this->isConnected()) return true;
		$dsn = $this->_getDSN_();
		$db = DB::connect($dsn);
		if (DB::isError($db))     return false;
		$db->autoCommit(false);
		$this->_db = $db;
		$this->_dbo = $this->dboFactory();
		return true;
	}

	/**
	* DBߥå
	*/
	function commit()
	{
		return	$this->_db->commit();
	}

	/**
	* DBХå
	*/
	function rollback()
	{
		return $this->_db->rollback();
	}

	/**
	* ꤷơ֥Υե
	* @param string	 ơ֥̾
	* @return string[] ե
	*/
	function getFields($table)
	{
		if (!$this->connect())  return false;
		$list = $this->_dbo->getFields($this->_db, $table);
		return $list;
	}
}

/**
* dbObjectѥ顼ϥɥ󥰥饹
*
* @version $Revision$
* @author Furukawa Atsushi <atsushifx@aglabo.com>
* @package com.aglabo.aglib.dbobject
* @licence http://www.opensource.org/licenses/bsd-license.php
* @since 1.00
*/
class dbObject_Error extends agError {
	/**
	* @var string[] 顼åɲѡ
	*/
	var $add_message = array(
		'AGERR_DB0101' => 'illegal db',
		'AGERR_DB0102' => "illegal field",
		'AGERR_DB0110' => "can't get field define",
		'AGERR_DB0111' => "type undefined",
	);
}
?>
