/*
 * byteorder header
 *
 * $Id: byteorder.c,v 1.1 2001/08/10 18:08:51 taka Exp $
 */
#include "byteorder.h"

unsigned int
get8 (unsigned char* data, int type)
{
	return *data;
}
unsigned int
get16 (unsigned char* data, int type)
{
	if (type == BYTE_ORDER_MSB_FIRST) {
		return (data[0] << 8) + data[1];
	} else {
		return (data[1] << 8) + data[0];
	}
}
unsigned int
get32 (unsigned char* data, int type)
{
	if (type == BYTE_ORDER_MSB_FIRST) {
		return 	  (data[0] << 24) + (data[1] << 16)
			+ (data[2] << 8)  +  data[3];
	} else {
		return 	  (data[3] << 24) + (data[2] << 16)
			+ (data[1] << 8)  +  data[0];
	}
}

void
put8 (unsigned char* buffer, unsigned int data, int type)
{
	buffer[0] = data;
}
void
put16 (unsigned char* buffer, unsigned int data, int type)
{
	if (type == BYTE_ORDER_MSB_FIRST) {
		buffer[0] = (data >> 8) & 0xff;
		buffer[1] = (data     ) & 0xff;
	} else {
		buffer[0] = (data     ) & 0xff;
		buffer[1] = (data >> 8) & 0xff;
	}
}
void
put32 (unsigned char* buffer, unsigned int data, int type)
{
	if (type == BYTE_ORDER_MSB_FIRST) {
		buffer[0] = (data >> 24) & 0xff;
		buffer[1] = (data >> 16) & 0xff;
		buffer[2] = (data >>  8) & 0xff;
		buffer[3] = (data      ) & 0xff;
	} else {
		buffer[0] = (data      ) & 0xff;
		buffer[1] = (data >>  8) & 0xff;
		buffer[2] = (data >> 16) & 0xff;
		buffer[3] = (data >> 24) & 0xff;
	}
}
